/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.Breadcrumb;

class CustomBreadcrumb
implements Breadcrumb {
    private static final int BREADCRUMB_MESSAGE_MAX_LENGTH = 256;
    @SerializedName(value="m")
    final String message;
    @SerializedName(value="ts")
    private final long timestamp;

    CustomBreadcrumb(String message, long timestamp) {
        this.timestamp = timestamp;
        this.message = CustomBreadcrumb.ellipsizeBreadcrumbMessage(message);
    }

    private static String ellipsizeBreadcrumbMessage(String input) {
        if (input == null || input.length() < 256) {
            return input;
        }
        return input.substring(0, 253) + "...";
    }

    @Override
    public long getStartTime() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomBreadcrumb that = (CustomBreadcrumb)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        return this.message != null ? this.message.equals(that.message) : that.message == null;
    }

    public int hashCode() {
        int result2 = this.message != null ? this.message.hashCode() : 0;
        result2 = 31 * result2 + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result2;
    }
}

