/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.PropertyUtils;
import io.embrace.android.embracesdk.Uuid;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

abstract class CustomFlow {
    protected static final String PROP_MOMENT_ID = "moment-id";
    protected static final String PROP_MOMENT_NAME = "moment-name";
    protected static final String PROP_MESSAGE = "message";
    private static final String ERROR_BLANK_NAME = "Moment name is null or blank.";
    protected final Map<String, Map<String, Moment>> customMoments = new HashMap<String, Map<String, Moment>>();
    private final EventService eventService = Embrace.getImpl().getEventService();
    private final EmbraceRemoteLogger embraceRemoteLogger = Embrace.getImpl().getRemoteLogger();

    @VisibleForTesting
    Set<String> getCustomMomentInstances(String customMomentName) {
        if (this.customMoments.get(customMomentName) != null) {
            return Objects.requireNonNull(this.customMoments.get(customMomentName)).keySet();
        }
        return null;
    }

    protected CustomFlow() {
    }

    public String momentStart(String momentName, boolean doesAllowScreenshot, Map<String, Object> properties) {
        if (!this.validateMomentName(momentName)) {
            return null;
        }
        if (this.customMoments.get(momentName) == null) {
            this.customMoments.put(momentName, new HashMap());
        }
        String momentId = Uuid.getEmbUuid();
        Map<String, Moment> moments = this.customMoments.get(momentName);
        this.sendMomentStartEvent(momentName, momentId, doesAllowScreenshot, PropertyUtils.sanitizeProperties(properties));
        moments.put(momentId, new Moment(momentName, momentId, doesAllowScreenshot, properties));
        return momentId;
    }

    private boolean validateMomentName(String momentName) {
        if (TextUtils.isEmpty((CharSequence)momentName)) {
            this.sendLogError(ERROR_BLANK_NAME, false, null);
            return false;
        }
        if (momentName.startsWith("_")) {
            this.sendLogError("Moment name may not start with '_'.", false, null);
            return false;
        }
        return true;
    }

    public boolean momentComplete(String momentName) {
        return this.momentComplete(momentName, null);
    }

    public boolean momentComplete(String momentName, String momentId) {
        return this.momentComplete(momentName, momentId, null);
    }

    public boolean momentComplete(String momentName, String momentId, Map<String, Object> properties) {
        if (TextUtils.isEmpty((CharSequence)momentName)) {
            this.sendLogError(ERROR_BLANK_NAME, false, null);
            return false;
        }
        Map<String, Moment> moments = this.customMoments.get(momentName);
        if (moments == null) {
            InternalStaticEmbraceLogger.logError("Cannot fail " + momentName + " because moment name is not recognized.");
            return false;
        }
        if (momentId == null) {
            for (Map.Entry<String, Moment> entry : moments.entrySet()) {
                this.sendMomentEndEvent(momentName, entry.getKey(), properties);
            }
            moments.clear();
        } else {
            Moment moment = moments.get(momentId);
            if (moment == null) {
                InternalStaticEmbraceLogger.logError("Cannot fail " + momentName + " because moment identifier is not recognized.");
                return false;
            }
            this.sendMomentEndEvent(momentName, momentId, properties);
            moments.remove(momentId);
        }
        if (moments.isEmpty()) {
            this.customMoments.remove(momentName);
        }
        return true;
    }

    public boolean momentFail(String momentName, String msg) {
        return this.momentFail(momentName, null, msg);
    }

    public boolean momentFail(String momentName, String momentId, String msg) {
        return this.momentFail(momentName, momentId, msg, null);
    }

    public boolean momentFail(String momentName, String momentId, String msg, Map<String, Object> properties) {
        if (!this.isValidMoment(momentName)) {
            return false;
        }
        Map<String, Moment> moments = this.customMoments.get(momentName);
        if (moments == null) {
            InternalStaticEmbraceLogger.logError("Cannot fail " + momentName + " because moment name is not recognized.");
            return false;
        }
        String errorLogMsg = this.getErrorLogMessage(msg, momentName);
        if (momentId == null) {
            this.failsAllMomentInstances(moments, momentName, msg, properties, errorLogMsg);
        } else {
            if (!this.isValidMomentId(moments, momentId, momentName)) {
                return false;
            }
            this.failsSingleMomentInstances(moments, moments.get(momentId), momentName, msg, properties, errorLogMsg);
        }
        if (moments.isEmpty()) {
            this.customMoments.remove(momentName);
        }
        return true;
    }

    private boolean isValidMomentId(Map<String, Moment> moments, String momentId, String momentName) {
        if (momentId != null && moments.get(momentId) == null) {
            InternalStaticEmbraceLogger.logError("Cannot fail " + momentName + " because moment identifier is not recognized.");
            return false;
        }
        return true;
    }

    private boolean isValidMoment(String momentName) {
        if (TextUtils.isEmpty((CharSequence)momentName)) {
            this.sendLogError(ERROR_BLANK_NAME, false, null);
            return false;
        }
        return true;
    }

    private String getErrorLogMessage(String msg, String momentName) {
        String errorLogMsg = TextUtils.isEmpty((CharSequence)msg) ? "A failure occurred during the " + momentName + " moment." : "A failure occurred during the " + momentName + " moment: " + msg;
        return errorLogMsg;
    }

    private void failsAllMomentInstances(Map<String, Moment> moments, String momentName, String msg, Map<String, Object> properties, String errorLogMsg) {
        for (Map.Entry<String, Moment> entry : moments.entrySet()) {
            this.momentInstanceFail(moments, entry.getValue(), momentName, msg, properties, errorLogMsg);
        }
        moments.clear();
    }

    private void failsSingleMomentInstances(Map<String, Moment> moments, Moment moment, String momentName, String msg, Map<String, Object> properties, String errorLogMsg) {
        this.momentInstanceFail(moments, moment, momentName, msg, properties, errorLogMsg);
        moments.remove(moment.id);
    }

    private void momentInstanceFail(Map<String, Moment> moments, Moment moment, String momentName, String msg, Map<String, Object> properties, String errorLogMsg) {
        this.addMessage(moment, msg);
        this.sendMomentEndEvent(momentName, moment.id, properties);
        this.sendLogError(errorLogMsg, moment.doesAllowScreenshot, moment.properties);
    }

    private void addMessage(Moment moment, String msg) {
        if (msg != null) {
            if (moment.properties == null) {
                moment.properties = new HashMap<String, Object>();
            }
            moment.properties.put(PROP_MESSAGE, msg);
        }
    }

    protected void sendMomentStartEvent(String momentName, String momentId, boolean doesAllowScreenshot, Map<String, Object> properties) {
        try {
            if (this.eventService == null) {
                throw new Exception("Event service is null. Embrace SDK might not be started.");
            }
            this.eventService.startEvent(momentName, momentId, doesAllowScreenshot, properties);
        }
        catch (Exception e) {
            InternalStaticEmbraceLogger.logError("An error occurred trying to start moment: " + momentName + " - " + momentId + ".", e);
        }
    }

    protected void sendMomentEndEvent(String momentName, String momentId, Map<String, Object> properties) {
        try {
            if (this.eventService == null) {
                throw new Exception("Event service is null. Embrace SDK might not be started.");
            }
            this.eventService.endEvent(momentName, momentId, properties);
        }
        catch (Exception e) {
            InternalStaticEmbraceLogger.logError("An error occurred trying to end moment: " + momentName + " - " + momentId + ".", e);
        }
    }

    protected void sendLogInfo(String msg, Map<String, Object> properties) {
        try {
            if (this.embraceRemoteLogger == null) {
                throw new Exception("Remote Logger is null. Embrace SDK might not be started.");
            }
            this.embraceRemoteLogger.log(msg, EmbraceEvent.Type.INFO_LOG, false, properties);
        }
        catch (Exception e) {
            InternalStaticEmbraceLogger.logError("An error occurred sending log info message: " + msg + ".", e);
        }
    }

    protected void sendLogError(String msg, boolean doesAllowScreenshot, Map<String, Object> properties) {
        try {
            if (this.embraceRemoteLogger == null) {
                throw new Exception("Remote Logger is null. Embrace SDK might not be started.");
            }
            this.embraceRemoteLogger.log(msg, EmbraceEvent.Type.ERROR_LOG, doesAllowScreenshot, properties);
        }
        catch (Exception e) {
            InternalStaticEmbraceLogger.logError("An error occurred sending log error message: " + msg + ".", e);
        }
    }

    private static class Moment {
        final String name;
        final String id;
        final boolean doesAllowScreenshot;
        Map<String, Object> properties;

        Moment(String name, String id, boolean doesAllowScreenshot, Map<String, Object> properties) {
            this.name = name;
            this.id = id;
            this.doesAllowScreenshot = doesAllowScreenshot;
            this.properties = properties != null ? new HashMap<String, Object>(properties) : null;
        }
    }
}

