/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.webkit.ConsoleMessage;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.ConnectionQualityListener;
import io.embrace.android.embracesdk.EmbraceAndroidApi;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceImpl;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSamples;
import io.embrace.android.embracesdk.FlutterInternalInterface;
import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.LogExceptionType;
import io.embrace.android.embracesdk.LogType;
import io.embrace.android.embracesdk.PushNotificationBreadcrumb;
import io.embrace.android.embracesdk.ReactNativeInternalInterface;
import io.embrace.android.embracesdk.UnityInternalInterface;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.utils.ThrowableUtilsKt;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.network.EmbraceNetworkRequest;
import io.embrace.android.embracesdk.network.EmbraceNetworkRequestV2;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.network.http.NetworkCaptureData;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Embrace
implements EmbraceAndroidApi {
    private static final Embrace embrace = new Embrace();
    private static EmbraceImpl impl = new EmbraceImpl();

    @NonNull
    public static Embrace getInstance() {
        return embrace;
    }

    @NonNull
    static EmbraceImpl getImpl() {
        return impl;
    }

    static void setImpl(@Nullable EmbraceImpl instance) {
        impl = instance;
    }

    @Deprecated
    public static void enableStartupTracing(@NonNull Context context2) {
    }

    @Deprecated
    public static void enableEarlyAnrCapture(@NonNull Context context2) {
    }

    @Override
    public void start(@NonNull Context context2) {
        this.start(context2, true, AppFramework.NATIVE);
    }

    @Override
    public void start(@NonNull Context context2, boolean enableIntegrationTesting) {
        this.start(context2, enableIntegrationTesting, AppFramework.NATIVE);
    }

    @Override
    public void start(@NonNull Context context2, boolean enableIntegrationTesting, @NonNull AppFramework appFramework) {
        impl.start(context2, enableIntegrationTesting, appFramework);
    }

    public boolean isStarted() {
        return impl.isStarted();
    }

    public boolean setAppId(@NonNull String appId2) {
        return impl.setAppId(appId2);
    }

    @Deprecated
    public void setLogLevel(@NonNull EmbraceLogger.Severity severity) {
    }

    @Deprecated
    public void enableDebugLogging() {
    }

    @Deprecated
    public void disableDebugLogging() {
    }

    @Override
    public void setUserIdentifier(@Nullable String userId) {
        impl.setUserIdentifier(userId);
    }

    @Override
    public void clearUserIdentifier() {
        impl.clearUserIdentifier();
    }

    @Override
    public void setUserEmail(@Nullable String email) {
        impl.setUserEmail(email);
    }

    @Override
    public void clearUserEmail() {
        impl.clearUserEmail();
    }

    @Override
    public void setUserAsPayer() {
        impl.setUserAsPayer();
    }

    @Override
    public void clearUserAsPayer() {
        impl.clearUserAsPayer();
    }

    @Override
    public void setUserPersona(@NonNull String persona) {
        impl.setUserPersona(persona);
    }

    @Override
    public void clearUserPersona(@NonNull String persona) {
        impl.clearUserPersona(persona);
    }

    @Override
    public void clearAllUserPersonas() {
        impl.clearAllUserPersonas();
    }

    @Override
    public boolean addSessionProperty(@NonNull String key, @NonNull String value, boolean permanent) {
        return impl.addSessionProperty(key, value, permanent);
    }

    @Override
    public boolean removeSessionProperty(@NonNull String key) {
        return impl.removeSessionProperty(key);
    }

    @Override
    @Nullable
    public Map<String, String> getSessionProperties() {
        return impl.getSessionProperties();
    }

    @Override
    public void setUsername(@Nullable String username) {
        impl.setUsername(username);
    }

    @Override
    public void clearUsername() {
        impl.clearUsername();
    }

    @Override
    public void startEvent(@NonNull String name) {
        this.startEvent(name, null, false, null);
    }

    @Override
    public void startEvent(@NonNull String name, @Nullable String identifier) {
        this.startEvent(name, identifier, false, null);
    }

    @Override
    public void startEvent(@NonNull String name, @Nullable String identifier, boolean allowScreenshot) {
        this.startEvent(name, identifier, allowScreenshot, null);
    }

    @Override
    public void startEvent(@NonNull String name, @Nullable String identifier, @Nullable Map<String, Object> properties) {
        this.startEvent(name, identifier, false, properties);
    }

    @Override
    public void startEvent(@NonNull String name, @Nullable String identifier, boolean allowScreenshot, @Nullable Map<String, Object> properties) {
        impl.startEvent(name, identifier, allowScreenshot, properties);
    }

    @Override
    public void endEvent(@NonNull String name) {
        this.endEvent(name, null, null);
    }

    @Override
    public void endEvent(@NonNull String name, @Nullable String identifier) {
        this.endEvent(name, identifier, null);
    }

    @Override
    public void endEvent(@NonNull String name, @Nullable Map<String, Object> properties) {
        this.endEvent(name, null, properties);
    }

    @Override
    public void endEvent(@NonNull String name, @Nullable String identifier, @Nullable Map<String, Object> properties) {
        impl.endEvent(name, identifier, properties);
    }

    @Override
    public void endAppStartup() {
        impl.endAppStartup(null);
    }

    @Override
    public void endAppStartup(@NonNull Map<String, Object> properties) {
        impl.endAppStartup(properties);
    }

    @NonNull
    public String getTraceIdHeader() {
        return impl.getTraceIdHeader();
    }

    public void logNetworkRequest(@NonNull String url2, int httpMethod, long startTime, long endTime, int bytesSent, int bytesReceived, int statusCode, @Nullable String error) {
        impl.logNetworkRequest(url2, httpMethod, startTime, endTime, bytesSent, bytesReceived, statusCode, error);
    }

    public void logNetworkRequest(@NonNull EmbraceNetworkRequestV2 request) {
        impl.logNetworkRequest(request);
    }

    public void logNetworkRequest(@NonNull EmbraceNetworkRequest request) {
        impl.logNetworkRequest(request);
    }

    public void logNetworkCall(@NonNull String url2, @NonNull HttpMethod httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived) {
        this.logNetworkCall(url2, httpMethod, statusCode, startTime, endTime, bytesSent, bytesReceived, null, null);
    }

    @Override
    public void logNetworkCall(@NonNull String url2, @NonNull HttpMethod httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived, @Nullable String traceId) {
        impl.logNetworkCall(url2, httpMethod, statusCode, startTime, endTime, bytesSent, bytesReceived, traceId, null);
    }

    @Override
    public void logNetworkCall(@NonNull String url2, @NonNull HttpMethod httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived, @Nullable String traceId, @Nullable NetworkCaptureData networkCaptureData) {
        impl.logNetworkCall(url2, httpMethod, statusCode, startTime, endTime, bytesSent, bytesReceived, traceId, networkCaptureData);
    }

    public void logNetworkClientError(@NonNull String url2, @NonNull HttpMethod httpMethod, long startTime, long endTime, @NonNull String errorType, @NonNull String errorMessage) {
        this.logNetworkClientError(url2, httpMethod, startTime, endTime, errorType, errorMessage, null, null);
    }

    @Override
    public void logNetworkClientError(@NonNull String url2, @NonNull HttpMethod httpMethod, long startTime, long endTime, @NonNull String errorType, @NonNull String errorMessage, @Nullable String traceId) {
        impl.logNetworkClientError(url2, httpMethod, startTime, endTime, errorType, errorMessage, traceId, null);
    }

    @Override
    public void logNetworkClientError(@NonNull String url2, @NonNull HttpMethod httpMethod, long startTime, long endTime, @NonNull String errorType, @NonNull String errorMessage, @Nullable String traceId, @Nullable NetworkCaptureData networkCaptureData) {
        impl.logNetworkClientError(url2, httpMethod, startTime, endTime, errorType, errorMessage, traceId, networkCaptureData);
    }

    @Override
    public void logInfo(@NonNull String message) {
        this.logInfo(message, null);
    }

    @Override
    public void logInfo(@NonNull String message, @Nullable Map<String, Object> properties) {
        impl.logMessage(EmbraceEvent.Type.INFO_LOG, message, properties, false, null, null, LogExceptionType.NONE, null, null);
    }

    @Override
    public void logWarning(@NonNull String message) {
        this.logWarning(message, null, false, null);
    }

    @Override
    public void logWarning(@NonNull String message, @Nullable Map<String, Object> properties) {
        this.logWarning(message, properties, false, null);
    }

    @Override
    public void logWarning(@NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot) {
        this.logWarning(message, properties, allowScreenshot, null);
    }

    @Override
    public void logWarning(@NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot, @Nullable String javascriptStackTrace) {
        impl.logMessage(EmbraceEvent.Type.WARNING_LOG, message, properties, allowScreenshot, null, javascriptStackTrace, LogExceptionType.NONE, null, null);
    }

    @Override
    public void logError(@NonNull String message) {
        this.logError(message, null, true, null);
    }

    @Override
    public void logError(@NonNull String message, @Nullable Map<String, Object> properties) {
        this.logError(message, properties, true, null);
    }

    @Override
    public void logError(@NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot) {
        this.logError(message, properties, allowScreenshot, null);
    }

    @Override
    public void logError(@NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot, @Nullable String javascriptStackTrace) {
        impl.logMessage(EmbraceEvent.Type.ERROR_LOG, message, properties, allowScreenshot, null, javascriptStackTrace, LogExceptionType.NONE, null, null);
    }

    @Override
    public void logError(@NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot, @Nullable String javascriptStackTrace, boolean isException) {
        impl.logMessage(EmbraceEvent.Type.ERROR_LOG, message, properties, allowScreenshot, null, javascriptStackTrace, LogExceptionType.NONE, null, null);
    }

    @Override
    public void logError(@NonNull Throwable e) {
        this.logError(e, null, false);
    }

    @Override
    public void logError(@NonNull Throwable e, @Nullable Map<String, Object> properties) {
        this.logError(e, properties, false);
    }

    @Override
    public void logError(@NonNull Throwable e, @Nullable Map<String, Object> properties, boolean allowScreenshot) {
        this.logError(e, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", properties, allowScreenshot);
    }

    @Override
    public void logError(@NonNull Throwable e, @NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot) {
        impl.logMessage(EmbraceEvent.Type.ERROR_LOG, message, properties, allowScreenshot, ThrowableUtilsKt.getSafeStackTrace(e), null, LogExceptionType.NONE, null, null, e.getClass().getSimpleName(), e.getMessage());
    }

    public void logRnAction(@NonNull String name, long startTime, long endTime, @NonNull Map<String, Object> properties, int bytesSent, @NonNull String output) {
        impl.logRnAction(name, startTime, endTime, properties, bytesSent, output);
    }

    @Override
    public void logBreadcrumb(@NonNull String message) {
        impl.logBreadcrumb(message);
    }

    @Override
    public void logHandledException(@NonNull Throwable throwable, @NonNull LogType type2) {
        this.logHandledException(throwable, type2, null, null, false);
    }

    @Override
    public void logHandledException(@NonNull Throwable throwable, @NonNull LogType type2, @NonNull StackTraceElement[] customStackTrace) {
        this.logHandledException(throwable, type2, null, customStackTrace, false);
    }

    @Override
    public void logHandledException(@NonNull Throwable throwable, @NonNull LogType type2, @NonNull Map<String, Object> properties) {
        this.logHandledException(throwable, type2, properties, null, false);
    }

    @Override
    public void logHandledException(@NonNull Throwable throwable, @NonNull LogType type2, @Nullable Map<String, Object> properties, @Nullable StackTraceElement[] customStackTrace, boolean takeScreenshot) {
        if (throwable == null) {
            InternalStaticEmbraceLogger.logWarning("Throwable must not be null.");
        }
        if (type2 == null) {
            InternalStaticEmbraceLogger.logWarning("Type must not be null.");
        }
        EmbraceEvent.Type eventType = type2.toEventType();
        impl.logMessage(eventType, throwable.getMessage() != null ? throwable.getMessage() : "", properties, takeScreenshot, customStackTrace != null ? customStackTrace : throwable.getStackTrace(), null, LogExceptionType.NONE, null, null, throwable.getClass().getSimpleName(), throwable.getMessage());
    }

    @InternalApi
    @Deprecated
    public void logUnhandledJsException(@NonNull String name, @NonNull String message, @Nullable String type2, @Nullable String stacktrace) {
        impl.logUnhandledJsException(name, message, type2, stacktrace);
    }

    @InternalApi
    @Deprecated
    public void logUnhandledUnityException(@NonNull String message, @Nullable String stacktrace) {
        impl.logUnityException(null, message, stacktrace, LogExceptionType.UNHANDLED);
    }

    @InternalApi
    public void logUnhandledUnityException(@NonNull String name, @NonNull String message, @Nullable String stacktrace) {
        impl.logUnityException(name, message, stacktrace, LogExceptionType.UNHANDLED);
    }

    @InternalApi
    public void logHandledUnityException(@NonNull String name, @NonNull String message, @Nullable String stacktrace) {
        impl.logUnityException(name, message, stacktrace, LogExceptionType.HANDLED);
    }

    @Deprecated
    public void setReactNativeVersionNumber(@NonNull String version) {
        impl.setReactNativeVersionNumber(version);
    }

    @Deprecated
    public void setJavaScriptPatchNumber(@NonNull String number) {
        impl.setJavaScriptPatchNumber(number);
    }

    public void setReactNativeSdkVersion(@NonNull String version) {
        impl.setReactNativeSdkVersion(version);
    }

    @Deprecated
    public void setJavaScriptBundleURL(@NonNull String url2) {
        impl.setJavaScriptBundleURL(url2);
    }

    @InternalApi
    @Deprecated
    public void setUnityMetaData(@NonNull String unityVersion, @NonNull String buildGuid) {
        this.setUnityMetaData(unityVersion, buildGuid, null);
    }

    @InternalApi
    @Deprecated
    public void setUnityMetaData(@NonNull String unityVersion, @NonNull String buildGuid, @Nullable String unitySdkVersion) {
        impl.setUnityMetaData(unityVersion, buildGuid, unitySdkVersion);
    }

    @InternalApi
    public void logInternalError(@Nullable String message, @Nullable String details) {
        impl.logInternalError(message, details);
    }

    @InternalApi
    @Deprecated
    public void logDartError(@Nullable String stack, @Nullable String message, @Nullable String context2, @Nullable String library) {
        impl.logDartError(stack, null, message, context2, library, LogExceptionType.UNHANDLED);
    }

    @InternalApi
    @Deprecated
    public void logDartErrorWithType(@Nullable String stack, @Nullable String message, @Nullable String context2, @Nullable String library, @Nullable String errorType) {
        impl.logDartError(stack, errorType, message, context2, library, LogExceptionType.UNHANDLED);
    }

    @InternalApi
    public void logHandledDartError(@Nullable String stack, @Nullable String name, @Nullable String message, @Nullable String context2, @Nullable String library) {
        impl.logDartError(stack, name, message, context2, library, LogExceptionType.HANDLED);
    }

    @InternalApi
    public void logUnhandledDartError(@Nullable String stack, @Nullable String name, @Nullable String message, @Nullable String context2, @Nullable String library) {
        impl.logDartError(stack, name, message, context2, library, LogExceptionType.UNHANDLED);
    }

    @InternalApi
    @Deprecated
    public void setEmbraceFlutterSdkVersion(@Nullable String version) {
        impl.setEmbraceFlutterSdkVersion(version);
    }

    @InternalApi
    @Deprecated
    public void setDartVersion(@Nullable String version) {
        impl.setDartVersion(version);
    }

    @Deprecated
    public void addConnectionQualityListener(@NonNull ConnectionQualityListener listener) {
        impl.addConnectionQualityListener(listener);
    }

    @Deprecated
    public void removeConnectionQualityListener(@NonNull ConnectionQualityListener listener) {
        impl.removeConnectionQualityListener(listener);
    }

    @Override
    public synchronized void endSession() {
        this.endSession(false);
    }

    @Override
    public synchronized void endSession(boolean clearUserInfo) {
        impl.endSession(clearUserInfo);
    }

    @Override
    @NonNull
    public String getDeviceId() {
        return impl.getDeviceId();
    }

    public void throwException() {
        impl.throwException();
    }

    @Override
    public boolean startFragment(@NonNull String name) {
        return impl.startFragment(name);
    }

    @Override
    public boolean endFragment(@NonNull String name) {
        return impl.endFragment(name);
    }

    @InternalApi
    public void logRnView(@NonNull String screen) {
        impl.logRnView(screen);
    }

    @InternalApi
    @Nullable
    public ConfigService getConfigService() {
        return impl.getConfigService();
    }

    @InternalApi
    void installUnityThreadSampler() {
        Embrace.getImpl().installUnityThreadSampler();
    }

    @InternalApi
    @Nullable
    public ReactNativeInternalInterface getReactNativeInternalInterface() {
        return impl.getReactNativeInternalInterface();
    }

    @InternalApi
    @Nullable
    public UnityInternalInterface getUnityInternalInterface() {
        return impl.getUnityInternalInterface();
    }

    @InternalApi
    @Nullable
    public FlutterInternalInterface getFlutterInternalInterface() {
        return impl.getFlutterInternalInterface();
    }

    @InternalApi
    public void sampleCurrentThreadDuringAnrs() {
        impl.sampleCurrentThreadDuringAnrs();
    }

    void verifyUnityIntegration() {
        EmbraceSamples.verifyIntegration();
    }

    public void logPushNotification(@Nullable String title, @Nullable String body, @Nullable String topic, @Nullable String id, @Nullable Integer notificationPriority, @NotNull Integer messageDeliveredPriority, @NotNull Boolean isNotification, @NotNull Boolean hasData) {
        impl.logPushNotification(title, body, topic, id, notificationPriority, messageDeliveredPriority, PushNotificationBreadcrumb.NotificationType.Builder.notificationTypeFor(hasData, isNotification));
    }

    @InternalApi
    @Deprecated
    public void logPushNotification(@Nullable String title, @Nullable String body, @Nullable String topic, @Nullable String id, @Nullable Integer notificationPriority, @NotNull Integer messageDeliveredPriority, @NotNull PushNotificationBreadcrumb.NotificationType notificationType) {
        impl.logPushNotification(title, body, topic, id, notificationPriority, messageDeliveredPriority, notificationType);
    }

    @InternalApi
    public boolean shouldCaptureNetworkBody(@NonNull String url2, @NonNull String method) {
        if (this.isStarted()) {
            return impl.shouldCaptureNetworkCall(url2, method);
        }
        EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot check for capture rules.");
        return false;
    }

    @InternalApi
    public void setProcessStartedByNotification() {
        impl.setProcessStartedByNotification();
    }

    public void trackWebViewPerformance(@NonNull String tag, @NonNull ConsoleMessage consoleMessage) {
        if (consoleMessage.message() != null) {
            this.trackWebViewPerformance(tag, consoleMessage.message());
        } else {
            InternalStaticEmbraceLogger.logger.logDebug("Empty WebView console message.");
        }
    }

    public void trackWebViewPerformance(@NonNull String tag, @NonNull String message) {
        impl.trackWebViewPerformance(tag, message);
    }

    @Override
    @NonNull
    public LastRunEndState getLastRunEndState() {
        return impl.getLastRunEndState();
    }

    public static enum LastRunEndState {
        INVALID(0),
        CRASH(1),
        CLEAN_EXIT(2);

        private final int value;

        private LastRunEndState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum AppFramework {
        NATIVE(1),
        REACT_NATIVE(2),
        UNITY(3),
        FLUTTER(4);

        private final int value;

        private AppFramework(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

