/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.SessionService;
import io.embrace.android.embracesdk.annotation.StartupActivity;
import io.embrace.android.embracesdk.capture.memory.MemoryService;
import io.embrace.android.embracesdk.capture.orientation.OrientationService;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.utils.ThreadUtils;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0001;B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020 H\u0016J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010&\u001a\u00020 2\u0006\u0010%\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010%\u001a\u00020\rH\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010%\u001a\u00020\rH\u0016J\u0010\u0010+\u001a\u00020 2\u0006\u0010%\u001a\u00020\rH\u0016J\u0018\u0010,\u001a\u00020 2\u0006\u0010%\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010-\u001a\u00020 2\u0006\u0010%\u001a\u00020\rH\u0016J\u0010\u0010.\u001a\u00020 2\u0006\u0010%\u001a\u00020\rH\u0016J\b\u0010/\u001a\u00020 H\u0007J\u0010\u00100\u001a\u00020 2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020 H\u0007J\b\u00104\u001a\u00020 H\u0016J\u0010\u00105\u001a\u00020 2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020 2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u00109\u001a\u00020 2\u0006\u0010%\u001a\u00020\rH\u0002J\u0012\u0010:\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lio/embrace/android/embracesdk/EmbraceActivityService;", "Lio/embrace/android/embracesdk/ActivityService;", "application", "Landroid/app/Application;", "orientationService", "Lio/embrace/android/embracesdk/capture/orientation/OrientationService;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "(Landroid/app/Application;Lio/embrace/android/embracesdk/capture/orientation/OrientationService;Lio/embrace/android/embracesdk/clock/Clock;)V", "coldStart", "", "currentActivity", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "foregroundActivity", "getForegroundActivity", "()Landroid/app/Activity;", "<set-?>", "isInBackground", "()Z", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lio/embrace/android/embracesdk/ActivityListener;", "getListeners$annotations", "()V", "getListeners", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "memoryService", "Lio/embrace/android/embracesdk/capture/memory/MemoryService;", "startTime", "", "addListener", "", "listener", "close", "getActivityName", "", "activity", "onActivityCreated", "bundle", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "onActivityStarted", "onActivityStopped", "onBackground", "onConfigurationChanged", "configuration", "Landroid/content/res/Configuration;", "onForeground", "onLowMemory", "onTrimMemory", "trimLevel", "", "setMemoryService", "updateOrientationWithActivity", "updateStateWithActivity", "Companion", "embrace-android-sdk_release"})
public final class EmbraceActivityService
implements ActivityService {
    private MemoryService memoryService;
    @NotNull
    private final CopyOnWriteArrayList<ActivityListener> listeners;
    private volatile WeakReference<Activity> currentActivity;
    private volatile boolean coldStart;
    private final long startTime;
    private volatile boolean isInBackground;
    private final Application application;
    private final OrientationService orientationService;
    private final Clock clock;
    private static final String ERROR_FAILED_TO_NOTIFY = "Failed to notify EmbraceActivityService listener";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void getListeners$annotations() {
    }

    @NotNull
    public final CopyOnWriteArrayList<ActivityListener> getListeners() {
        return this.listeners;
    }

    @Override
    public boolean isInBackground() {
        return this.isInBackground;
    }

    /*
     * WARNING - void declaration
     */
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
        void className$iv;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string = "EmbraceActivityService";
        String msg$iv = "Activity created: " + this.getActivityName(activity);
        boolean $i$f$logDeveloper = false;
        companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        this.updateStateWithActivity(activity);
        this.updateOrientationWithActivity(activity);
        Collection collection$iv = this.listeners;
        boolean $i$f$stream = false;
        Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ActivityListener listener = (ActivityListener)element$iv$iv;
            boolean bl = false;
            try {
                listener.onActivityCreated(activity, bundle);
            }
            catch (Exception ex) {
                InternalStaticEmbraceLogger.Companion companion2 = InternalStaticEmbraceLogger.Companion;
                String msg$iv2 = ERROR_FAILED_TO_NOTIFY;
                boolean $i$f$logDebug = false;
                companion2.log(msg$iv2, EmbraceLogger.Severity.DEBUG, ex, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onActivityStarted(@NotNull Activity activity) {
        void className$iv;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string = "EmbraceActivityService";
        String msg$iv = "Activity started: " + this.getActivityName(activity);
        boolean $i$f$logDeveloper = false;
        companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        this.updateStateWithActivity(activity);
        Collection collection$iv = this.listeners;
        boolean $i$f$stream = false;
        Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ActivityListener listener = (ActivityListener)element$iv$iv;
            boolean bl = false;
            try {
                listener.onView(activity);
            }
            catch (Exception ex) {
                InternalStaticEmbraceLogger.Companion companion2 = InternalStaticEmbraceLogger.Companion;
                String msg$iv2 = ERROR_FAILED_TO_NOTIFY;
                boolean $i$f$logDebug = false;
                companion2.log(msg$iv2, EmbraceLogger.Severity.DEBUG, ex, true);
            }
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Object $this$forEach$iv$iv;
        String className$iv;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string = "EmbraceActivityService";
        String msg$iv = "Activity resumed: " + this.getActivityName(activity);
        boolean $i$f$logDeveloper = false;
        companion.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        if (!activity.getClass().isAnnotationPresent(StartupActivity.class)) {
            companion = InternalStaticEmbraceLogger.Companion;
            className$iv = "EmbraceActivityService";
            msg$iv = "Activity resumed: " + this.getActivityName(activity);
            $i$f$logDeveloper = false;
            companion.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            Collection collection$iv = this.listeners;
            boolean $i$f$stream = false;
            $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                ActivityListener listener = (ActivityListener)element$iv$iv;
                boolean bl = false;
                try {
                    listener.applicationStartupComplete();
                }
                catch (Exception ex) {
                    InternalStaticEmbraceLogger.Companion companion2 = InternalStaticEmbraceLogger.Companion;
                    String msg$iv2 = ERROR_FAILED_TO_NOTIFY;
                    boolean $i$f$logDebug = false;
                    companion2.log(msg$iv2, EmbraceLogger.Severity.DEBUG, ex, true);
                }
            }
        } else {
            companion = InternalStaticEmbraceLogger.Companion;
            String $i$f$stream = "EmbraceActivityService";
            $this$forEach$iv$iv = this.getActivityName(activity) + " is @StartupActivity";
            $i$f$logDeveloper = false;
            companion.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    /*
     * WARNING - void declaration
     */
    public void onActivityStopped(@NotNull Activity activity) {
        void className$iv;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string = "EmbraceActivityService";
        String msg$iv = "Activity stopped: " + this.getActivityName(activity);
        boolean $i$f$logDeveloper = false;
        companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        Collection collection$iv = this.listeners;
        boolean $i$f$stream = false;
        Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ActivityListener listener = (ActivityListener)element$iv$iv;
            boolean bl = false;
            try {
                listener.onViewClose(activity);
            }
            catch (Exception ex) {
                InternalStaticEmbraceLogger.Companion companion2 = InternalStaticEmbraceLogger.Companion;
                String msg$iv2 = ERROR_FAILED_TO_NOTIFY;
                boolean $i$f$logDebug = false;
                companion2.log(msg$iv2, EmbraceLogger.Severity.DEBUG, ex, true);
            }
        }
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final synchronized void updateStateWithActivity(@Nullable Activity activity) {
        void className$iv;
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string = "EmbraceActivityService";
        String msg$iv = "Current activity: " + this.getActivityName(activity);
        boolean $i$f$logDeveloper = false;
        companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        this.currentActivity = new WeakReference<Activity>(activity);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateOrientationWithActivity(Activity activity) {
        if (this.orientationService != null) {
            try {
                void msg$iv;
                void className$iv;
                InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                String string = "EmbraceActivityService";
                StringBuilder stringBuilder = new StringBuilder().append("Updated orientation: ");
                Resources resources2 = activity.getResources();
                Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"activity.resources");
                String string2 = stringBuilder.append(resources2.getConfiguration().orientation).toString();
                boolean $i$f$logDeveloper = false;
                companion.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                Resources resources3 = activity.getResources();
                Intrinsics.checkNotNullExpressionValue((Object)resources3, (String)"activity.resources");
                this.orientationService.onOrientationChanged(resources3.getConfiguration().orientation);
            }
            catch (Exception ex) {
                InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                String msg$iv = "Failed to register an orientation change";
                boolean $i$f$logDebug = false;
                companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, ex, true);
            }
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public final void onForeground() {
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String msg$iv = "AppState: App entered foreground.";
        Throwable throwable$iv = null;
        boolean $i$f$logDebug = false;
        companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
        this.isInBackground = false;
        long timestamp = this.clock.now();
        Collection collection$iv = this.listeners;
        boolean $i$f$stream = false;
        Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ActivityListener listener = (ActivityListener)element$iv$iv;
            boolean bl = false;
            try {
                listener.onForeground(this.coldStart, this.startTime, timestamp);
            }
            catch (Exception ex) {
                InternalStaticEmbraceLogger.Companion companion2 = InternalStaticEmbraceLogger.Companion;
                String msg$iv2 = ERROR_FAILED_TO_NOTIFY;
                boolean $i$f$logDebug2 = false;
                companion2.log(msg$iv2, EmbraceLogger.Severity.DEBUG, ex, true);
            }
        }
        this.coldStart = false;
    }

    /*
     * WARNING - void declaration
     */
    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public final void onBackground() {
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String msg$iv = "AppState: App entered background";
        Throwable throwable$iv = null;
        boolean $i$f$logDebug = false;
        companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
        this.updateStateWithActivity(null);
        this.isInBackground = true;
        long timestamp = this.clock.now();
        Collection collection$iv = this.listeners;
        boolean $i$f$stream = false;
        Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ActivityListener listener = (ActivityListener)element$iv$iv;
            boolean bl = false;
            try {
                void this_$iv;
                InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
                String msg$iv2 = "onBackground() listener: " + listener;
                Throwable throwable$iv2 = null;
                boolean logStacktrace$iv = false;
                boolean $i$f$logWarning = false;
                this_$iv.log(msg$iv2, EmbraceLogger.Severity.WARNING, throwable$iv2, logStacktrace$iv);
                listener.onBackground(timestamp);
            }
            catch (Exception ex) {
                InternalStaticEmbraceLogger.Companion companion2 = InternalStaticEmbraceLogger.Companion;
                String msg$iv3 = ERROR_FAILED_TO_NOTIFY;
                boolean $i$f$logDebug2 = false;
                companion2.log(msg$iv3, EmbraceLogger.Severity.DEBUG, ex, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onTrimMemory(int trimLevel) {
        void className$iv;
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        Object object = "EmbraceActivityService";
        String msg$iv = "onTrimMemory(). TrimLevel: " + trimLevel;
        boolean $i$f$logDeveloper = false;
        companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        if (trimLevel == 10) {
            try {
                MemoryService memoryService2 = this.memoryService;
                if (memoryService2 != null) {
                    memoryService2.onMemoryWarning();
                }
            }
            catch (Exception ex) {
                object = InternalStaticEmbraceLogger.Companion;
                msg$iv = "Failed to handle onTrimMemory (low memory) event";
                boolean $i$f$logDebug = false;
                ((InternalStaticEmbraceLogger.Companion)object).log(msg$iv, EmbraceLogger.Severity.DEBUG, ex, true);
            }
        }
    }

    public final void setMemoryService(@Nullable MemoryService memoryService2) {
        this.memoryService = memoryService2;
    }

    public void onConfigurationChanged(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
    }

    public void onLowMemory() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Activity getForegroundActivity() {
        Activity foregroundActivity = (Activity)this.currentActivity.get();
        if (foregroundActivity == null || foregroundActivity.isFinishing()) {
            void className$iv;
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String string = "EmbraceActivityService";
            String msg$iv = "Foreground activity not present";
            boolean $i$f$logDeveloper = false;
            companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            return null;
        }
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String className$iv = "EmbraceActivityService";
        String msg$iv = "Foreground activity name: " + this.getActivityName(foregroundActivity);
        boolean $i$f$logDeveloper = false;
        companion.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        return foregroundActivity;
    }

    @Override
    public void addListener(@NotNull ActivityListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        boolean priority = listener instanceof SessionService;
        if (!this.listeners.contains(listener)) {
            if (priority) {
                this.listeners.add(0, listener);
            } else {
                this.listeners.addIfAbsent(listener);
            }
        }
    }

    @Override
    public void close() {
        try {
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "Shutting down EmbraceActivityService";
            Throwable throwable$iv = null;
            boolean $i$f$logDebug = false;
            companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
            this.application.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this);
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.listeners.clear();
        }
        catch (Exception ex) {
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "Error when closing EmbraceActivityService";
            boolean $i$f$logDebug = false;
            companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, ex, true);
        }
    }

    private final String getActivityName(Activity activity) {
        Object object = activity;
        if (object == null || (object = object.getLocalClassName()) == null) {
            object = "Null";
        }
        return object;
    }

    public EmbraceActivityService(@NotNull Application application2, @Nullable OrientationService orientationService2, @NotNull Clock clock2) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        this.application = application2;
        this.orientationService = orientationService2;
        this.clock = clock2;
        this.listeners = new CopyOnWriteArrayList();
        this.currentActivity = new WeakReference<Object>(null);
        this.coldStart = true;
        this.startTime = this.clock.now();
        this.isInBackground = true;
        this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.application.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this);
        ThreadUtils.INSTANCE.runOnMainThread(new Runnable(){

            @Override
            public final void run() {
                LifecycleOwner lifecycleOwner = ProcessLifecycleOwner.get();
                Intrinsics.checkNotNullExpressionValue((Object)lifecycleOwner, (String)"ProcessLifecycleOwner.get()");
                lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this);
            }
        });
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/EmbraceActivityService$Companion;", "", "()V", "ERROR_FAILED_TO_NOTIFY", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

