/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.AutomaticVerificationChecker;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceAutomaticVerification;
import io.embrace.android.embracesdk.EmbraceImpl;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.R;
import io.embrace.android.embracesdk.VerificationActions;
import io.embrace.android.embracesdk.VerifyIntegrationException;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u0000 <2\u00020\u0001:\u0001<B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002J \u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J\u0006\u0010+\u001a\u00020!J\b\u0010,\u001a\u00020!H\u0007J\b\u0010-\u001a\u00020!H\u0002J\u0018\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u0002002\u0006\u0010%\u001a\u00020$H\u0002J\b\u00101\u001a\u00020!H\u0007J\u0019\u00102\u001a\u00020!2\n\b\u0002\u0010%\u001a\u0004\u0018\u000103H\u0002\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u00020!H\u0002J\u0018\u00106\u001a\u00020!2\u0006\u0010/\u001a\u0002002\u0006\u00107\u001a\u00020$H\u0002J\b\u00108\u001a\u00020!H\u0007J\b\u00109\u001a\u00020\u0015H\u0002J\u0006\u0010:\u001a\u00020!J\b\u0010;\u001a\u00020!H\u0002R$\u0010\u0005\u001a\u00020\u00068\u0000@\u0000X\u0081.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\b\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001b\u0010\b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lio/embrace/android/embracesdk/EmbraceAutomaticVerification;", "Lio/embrace/android/embracesdk/ActivityListener;", "worker", "Ljava/util/concurrent/ScheduledExecutorService;", "(Ljava/util/concurrent/ScheduledExecutorService;)V", "activityService", "Lio/embrace/android/embracesdk/ActivityService;", "getActivityService$embrace_android_sdk_release$annotations", "()V", "getActivityService$embrace_android_sdk_release", "()Lio/embrace/android/embracesdk/ActivityService;", "setActivityService$embrace_android_sdk_release", "(Lio/embrace/android/embracesdk/ActivityService;)V", "automaticVerificationChecker", "Lio/embrace/android/embracesdk/AutomaticVerificationChecker;", "getAutomaticVerificationChecker$annotations", "getAutomaticVerificationChecker", "()Lio/embrace/android/embracesdk/AutomaticVerificationChecker;", "setAutomaticVerificationChecker", "(Lio/embrace/android/embracesdk/AutomaticVerificationChecker;)V", "foregroundEventTriggered", "", "handler", "Landroid/os/Handler;", "isResultDisplayed", "verificationActions", "Lio/embrace/android/embracesdk/VerificationActions;", "getVerificationActions$annotations", "getVerificationActions", "()Lio/embrace/android/embracesdk/VerificationActions;", "setVerificationActions", "(Lio/embrace/android/embracesdk/VerificationActions;)V", "clearUserData", "", "displayResult", "generateErrorLog", "", "errorMessage", "onForeground", "coldStart", "startupTime", "", "timestamp", "restartAppFromPendingIntent", "runEndSession", "runVerifyIntegration", "sendErrorLog", "activity", "Landroid/app/Activity;", "setActivityListener", "showDialogWithError", "", "(Ljava/lang/Integer;)V", "showSuccessDialog", "showToast", "message", "startVerification", "verifyIfInitializerIsDisabled", "verifyIntegration", "verifyLifecycle", "Companion", "embrace-android-sdk_release"})
public final class EmbraceAutomaticVerification
implements ActivityListener {
    private final Handler handler;
    private boolean foregroundEventTriggered;
    public ActivityService activityService;
    @NotNull
    private AutomaticVerificationChecker automaticVerificationChecker;
    @NotNull
    private VerificationActions verificationActions;
    private boolean isResultDisplayed;
    private final ScheduledExecutorService worker;
    @NotNull
    public static final String TAG = "[EmbraceVerification]";
    private static final long ON_FOREGROUND_DELAY = 5000L;
    private static final String EMBRACE_CONTACT_EMAIL = "support@embrace.io";
    private static final long VERIFY_INTEGRATION_DELAY = 200L;
    private static final long ON_FOREGROUND_TIMEOUT = 5000L;
    @NotNull
    private static final EmbraceAutomaticVerification instance;
    @NotNull
    public static final Companion Companion;

    @VisibleForTesting
    public static /* synthetic */ void getActivityService$embrace_android_sdk_release$annotations() {
    }

    @NotNull
    public final ActivityService getActivityService$embrace_android_sdk_release() {
        ActivityService activityService2 = this.activityService;
        if (activityService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityService");
        }
        return activityService2;
    }

    public final void setActivityService$embrace_android_sdk_release(@NotNull ActivityService activityService2) {
        Intrinsics.checkNotNullParameter((Object)activityService2, (String)"<set-?>");
        this.activityService = activityService2;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAutomaticVerificationChecker$annotations() {
    }

    @NotNull
    public final AutomaticVerificationChecker getAutomaticVerificationChecker() {
        return this.automaticVerificationChecker;
    }

    public final void setAutomaticVerificationChecker(@NotNull AutomaticVerificationChecker automaticVerificationChecker) {
        Intrinsics.checkNotNullParameter((Object)automaticVerificationChecker, (String)"<set-?>");
        this.automaticVerificationChecker = automaticVerificationChecker;
    }

    @VisibleForTesting
    public static /* synthetic */ void getVerificationActions$annotations() {
    }

    @NotNull
    public final VerificationActions getVerificationActions() {
        return this.verificationActions;
    }

    public final void setVerificationActions(@NotNull VerificationActions verificationActions) {
        Intrinsics.checkNotNullParameter((Object)verificationActions, (String)"<set-?>");
        this.verificationActions = verificationActions;
    }

    public final void verifyIntegration() {
        instance.setActivityListener();
        instance.runVerifyIntegration();
    }

    @VisibleForTesting
    public final void setActivityListener() {
        if (this.activityService == null) {
            EmbraceImpl embraceImpl = Embrace.getImpl();
            Intrinsics.checkNotNullExpressionValue((Object)embraceImpl, (String)"Embrace.getImpl()");
            ActivityService activityService2 = embraceImpl.getActivityService();
            Intrinsics.checkNotNullExpressionValue((Object)activityService2, (String)"Embrace.getImpl().activityService");
            this.activityService = activityService2;
        }
        ActivityService activityService3 = this.activityService;
        if (activityService3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityService");
        }
        activityService3.addListener(this);
    }

    /*
     * WARNING - void declaration
     */
    private final void runVerifyIntegration() {
        try {
            this.worker.schedule(new Runnable(this){
                final /* synthetic */ EmbraceAutomaticVerification this$0;

                public final void run() {
                    this.this$0.startVerification();
                }
                {
                    this.this$0 = embraceAutomaticVerification;
                }
            }, 200L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
            String msg$iv = "[EmbraceVerification] - Start verification rejected";
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void startVerification() {
        block6: {
            Activity activity;
            ActivityService activityService2 = this.activityService;
            if (activityService2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"activityService");
            }
            if ((activity = activityService2.getForegroundActivity()) != null) {
                try {
                    void this_$iv;
                    if (this.automaticVerificationChecker.createFile(activity)) {
                        String string2 = activity.getString(R.string.automatic_verification_started);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activity.getString(R.str\u2026tic_verification_started)");
                        this.showToast(activity, string2);
                        this.verificationActions.runActions();
                        break block6;
                    }
                    InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
                    String msg$iv = "[EmbraceVerification] Verification almost ready...";
                    boolean $i$f$logInfo = false;
                    this_$iv.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
                    this.handler.postDelayed(new Runnable(this){
                        final /* synthetic */ EmbraceAutomaticVerification this$0;

                        public final void run() {
                            EmbraceAutomaticVerification.access$verifyLifecycle(this.this$0);
                        }
                        {
                            this.this$0 = embraceAutomaticVerification;
                        }
                    }, 5000L);
                }
                catch (IOException e) {
                    void this_$iv;
                    InternalEmbraceLogger msg$iv = InternalStaticEmbraceLogger.logger;
                    String msg$iv2 = "[EmbraceVerification] Embrace SDK cannot run the verification in this moment";
                    boolean logStacktrace$iv = false;
                    boolean $i$f$logError = false;
                    this_$iv.log(msg$iv2, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
                    String string3 = activity.getString(R.string.automatic_verification_not_started);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"activity.getString(R.str\u2026verification_not_started)");
                    this.showToast(activity, string3);
                }
            } else {
                void this_$iv;
                InternalEmbraceLogger e = InternalStaticEmbraceLogger.logger;
                String msg$iv = "[EmbraceVerification] Embrace SDK cannot run the verification in this moment, Activity is not present";
                Throwable throwable$iv = null;
                boolean logStacktrace$iv = false;
                boolean $i$f$logError = false;
                this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyLifecycle() {
        if (!this.foregroundEventTriggered) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
            String msg$iv = "[EmbraceVerification] OnForeground event was not triggered";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            if (this.verifyIfInitializerIsDisabled()) {
                EmbraceImpl embraceImpl = Embrace.getImpl();
                Intrinsics.checkNotNullExpressionValue((Object)embraceImpl, (String)"Embrace.getImpl()");
                embraceImpl.getExceptionsService().handleInternalError(new VerifyIntegrationException("ProcessLifecycleInitializer disabled"));
                this.showDialogWithError(R.string.automatic_verification_no_initializer_message);
            } else {
                EmbraceImpl embraceImpl = Embrace.getImpl();
                Intrinsics.checkNotNullExpressionValue((Object)embraceImpl, (String)"Embrace.getImpl()");
                embraceImpl.getExceptionsService().handleInternalError(new VerifyIntegrationException("onForeground not invoked"));
                this.showDialogWithError(R.string.automatic_verification_lifecycle_error_message);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void runEndSession() {
        void this_$iv;
        Embrace.getInstance().endSession();
        InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
        String msg$iv = "[EmbraceVerification] End session manually";
        boolean $i$f$logInfo = false;
        this_$iv.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean verifyIfInitializerIsDisabled() {
        Object cnfe2;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
        String msg$iv = "Trying to verify lifecycle annotations";
        boolean $i$f$logInfo2 = false;
        this_$iv.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
        try {
            void msg$iv2;
            void className$iv;
            void this_$iv2;
            boolean this_$iv32;
            Class<?> appInitializerClass = null;
            try {
                appInitializerClass = Class.forName("androidx.startup.AppInitializer");
            }
            catch (ClassNotFoundException cnfe2) {
                void msg$iv3;
                void className$iv2;
                void this_$iv32;
                InternalEmbraceLogger $i$f$logInfo2 = InternalStaticEmbraceLogger.logger;
                String string2 = "EmbraceAutomaticVerification";
                String string3 = "AppInitializer not found. Assuming that appCompat < 1.4.1";
                Throwable throwable$iv = null;
                boolean $i$f$logDeveloper = false;
                this_$iv32.log('[' + (String)className$iv2 + "] " + (String)msg$iv3, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                return false;
            }
            EmbraceImpl embraceImpl = Embrace.getImpl();
            Intrinsics.checkNotNullExpressionValue((Object)embraceImpl, (String)"Embrace.getImpl()");
            Application application2 = embraceImpl.getApplication();
            if (application2 != null) {
                cnfe2 = application2;
                this_$iv32 = false;
                boolean className$iv2 = false;
                Object app = cnfe2;
                boolean bl = false;
                Method getInstance = appInitializerClass.getMethod("getInstance", Context.class);
                Method isEagerlyInitialized = appInitializerClass.getMethod("isEagerlyInitialized", Class.class);
                Class<?> lifecycleInitializerClass = Class.forName("androidx.lifecycle.ProcessLifecycleInitializer");
                Object appInitializer = getInstance.invoke(null, app);
                Object object = isEagerlyInitialized.invoke(appInitializer, lifecycleInitializerClass);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                boolean result2 = (Boolean)object;
                return !result2;
            }
            cnfe2 = this;
            this_$iv32 = false;
            boolean className$iv2 = false;
            EmbraceAutomaticVerification $this$run = (EmbraceAutomaticVerification)cnfe2;
            boolean bl = false;
            InternalEmbraceLogger getInstance = InternalStaticEmbraceLogger.logger;
            String isEagerlyInitialized = "EmbraceAutomaticVerification";
            String lifecycleInitializerClass = "Null application object, can not verify lifecycle annotations";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv2.log('[' + (String)className$iv + "] " + (String)msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            return false;
        }
        catch (Exception e) {
            void this_$iv4;
            cnfe2 = InternalStaticEmbraceLogger.logger;
            String msg$iv4 = "[EmbraceVerification] Could not verify if lifecycle annotations are working: " + e;
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv4.log(msg$iv4, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void restartAppFromPendingIntent() {
        void this_$iv;
        Activity activity;
        int exitStatus = 2;
        ActivityService activityService2 = this.activityService;
        if (activityService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityService");
        }
        if ((activity = activityService2.getForegroundActivity()) != null) {
            Intent intent = activity.getIntent();
            intent.addFlags(0x10008000);
            intent.putExtra("from_verification", true);
            boolean bl = false;
            boolean bl2 = false;
            Activity $this$with = activity;
            boolean bl3 = false;
            $this$with.finish();
            $this$with.startActivity(intent);
            bl = false;
            System.exit(exitStatus);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        InternalEmbraceLogger intent = InternalStaticEmbraceLogger.logger;
        String msg$iv = "Cannot restart app, activity is not present";
        Throwable throwable$iv = null;
        boolean logStacktrace$iv = false;
        boolean $i$f$logError = false;
        this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onForeground(boolean coldStart, long startupTime, long timestamp) {
        Activity activity;
        this.foregroundEventTriggered = true;
        ActivityService activityService2 = this.activityService;
        if (activityService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityService");
        }
        if ((activity = activityService2.getForegroundActivity()) != null) {
            boolean fromVerification = activity.getIntent().getBooleanExtra("from_verification", false);
            if (!fromVerification) {
                return;
            }
            if (this.isResultDisplayed) {
                void this_$iv;
                InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
                String msg$iv = "onForeground called but the result was already displayed";
                Throwable throwable$iv = null;
                boolean $i$f$logDebug = false;
                this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
                return;
            }
            this.handler.postDelayed(new Runnable(this){
                final /* synthetic */ EmbraceAutomaticVerification this$0;

                public final void run() {
                    this.this$0.runEndSession();
                    EmbraceAutomaticVerification.access$displayResult(this.this$0);
                    EmbraceAutomaticVerification.access$clearUserData(this.this$0);
                    this.this$0.getAutomaticVerificationChecker().deleteFile();
                }
                {
                    this.this$0 = embraceAutomaticVerification;
                }
            }, 5000L);
        } else {
            void this_$iv;
            InternalEmbraceLogger fromVerification = InternalStaticEmbraceLogger.logger;
            String msg$iv = "Cannot restart app, activity is not present";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
        }
    }

    private final void clearUserData() {
        Embrace.getInstance().clearUserEmail();
        Embrace.getInstance().clearUsername();
        Embrace.getInstance().clearAllUserPersonas();
        Embrace.getInstance().clearUserIdentifier();
        Embrace.getInstance().clearUserAsPayer();
    }

    /*
     * WARNING - void declaration
     */
    private final void displayResult() {
        block6: {
            void this_$iv;
            Object object;
            Object object2;
            block5: {
                this.isResultDisplayed = true;
                object2 = this.automaticVerificationChecker.isVerificationCorrect();
                if (object2 == null) break block5;
                object = object2;
                boolean bl = false;
                boolean bl2 = false;
                boolean isCorrect = (Boolean)object;
                boolean bl3 = false;
                if (isCorrect) {
                    void this_$iv2;
                    InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
                    String msg$iv = "[EmbraceVerification] Successful - Embrace is ready to go! \ud83c\udf89";
                    boolean $i$f$logInfo = false;
                    this_$iv2.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
                    this.showSuccessDialog();
                } else {
                    InternalEmbraceLogger this_$iv2 = InternalStaticEmbraceLogger.logger;
                    String msg$iv = "[EmbraceVerification] Error - Something is wrong with the Embrace Configuration \u26a0\ufe0f";
                    boolean $i$f$logInfo = false;
                    this_$iv2.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
                    EmbraceAutomaticVerification.showDialogWithError$default(this, null, 1, null);
                }
                if ((object2 = object) != null) break block6;
            }
            object = InternalStaticEmbraceLogger.logger;
            String msg$iv = "Cannot display end message";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            object2 = Unit.INSTANCE;
        }
    }

    private final void showToast(Activity activity, String message) {
        activity.runOnUiThread(new Runnable(activity, message){
            final /* synthetic */ Activity $activity;
            final /* synthetic */ String $message;

            public final void run() {
                Toast.makeText((Context)((Context)this.$activity), (CharSequence)this.$message, (int)1).show();
            }
            {
                this.$activity = activity;
                this.$message = string2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void showSuccessDialog() {
        Activity activity;
        ActivityService activityService2 = this.activityService;
        if (activityService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityService");
        }
        if ((activity = activityService2.getForegroundActivity()) != null) {
            AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)activity);
            dialogBuilder.setTitle((CharSequence)activity.getString(R.string.automatic_verification_success_title)).setMessage((CharSequence)activity.getString(R.string.automatic_verification_success_message)).setCancelable(true).setPositiveButton((CharSequence)activity.getString(R.string.got_it), (DialogInterface.OnClickListener)showSuccessDialog.1.INSTANCE);
            dialogBuilder.create().show();
        } else {
            void this_$iv;
            InternalEmbraceLogger dialogBuilder = InternalStaticEmbraceLogger.logger;
            String msg$iv = "Verification success! - Cannot display popup";
            boolean $i$f$logInfo = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showDialogWithError(Integer errorMessage) {
        Activity activity;
        ActivityService activityService2 = this.activityService;
        if (activityService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityService");
        }
        if ((activity = activityService2.getForegroundActivity()) != null) {
            String string2;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = this.automaticVerificationChecker.getExceptions();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Throwable throwable = (Throwable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string3 = it.getMessage();
                collection.add(string3);
            }
            List exceptions = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            if (errorMessage != null) {
                exceptions.add(activity.getString(errorMessage.intValue()));
            }
            Collection $i$f$map22 = exceptions;
            boolean $this$mapTo$iv$iv2 = false;
            if (!$i$f$map22.isEmpty()) {
                String string4 = activity.getString(R.string.embrace_verification_errors);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"activity.getString(R.str\u2026race_verification_errors)");
                string2 = StringsKt.replace$default((String)string4, (String)"[X]", (String)CollectionsKt.joinToString$default((Iterable)exceptions, (CharSequence)"\n\ud83d\udc49 ", (CharSequence)"\ud83d\udc49 ", null, (int)0, null, null, (int)60, null), (boolean)false, (int)4, null);
            } else {
                String string5 = activity.getString(R.string.automatic_verification_default_error_message);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"activity.getString(R.str\u2026on_default_error_message)");
            }
            String errorString = string2;
            AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)activity);
            dialogBuilder.setTitle((CharSequence)activity.getString(R.string.automatic_verification_error_title)).setMessage((CharSequence)errorString).setCancelable(true).setNegativeButton((CharSequence)activity.getString(R.string.send_error_log), new DialogInterface.OnClickListener(this, activity, errorString){
                final /* synthetic */ EmbraceAutomaticVerification this$0;
                final /* synthetic */ Activity $activity;
                final /* synthetic */ String $errorString;

                public final void onClick(DialogInterface dialog, int $noName_1) {
                    EmbraceAutomaticVerification.access$sendErrorLog(this.this$0, this.$activity, this.$errorString);
                    dialog.dismiss();
                }
                {
                    this.this$0 = embraceAutomaticVerification;
                    this.$activity = activity;
                    this.$errorString = string2;
                }
            }).setPositiveButton((CharSequence)activity.getString(R.string.close), (DialogInterface.OnClickListener)showDialogWithError.2.INSTANCE);
            dialogBuilder.create().show();
        } else {
            void this_$iv;
            InternalEmbraceLogger exceptions = InternalStaticEmbraceLogger.logger;
            String msg$iv = "Verification error - Cannot display popup";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
        }
    }

    static /* synthetic */ void showDialogWithError$default(EmbraceAutomaticVerification embraceAutomaticVerification, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        embraceAutomaticVerification.showDialogWithError(n);
    }

    private final void sendErrorLog(Activity activity, String errorMessage) {
        String errorLog = this.generateErrorLog(errorMessage);
        Intent intent = new Intent("android.intent.action.SENDTO").setData(Uri.parse((String)"mailto:support@embrace.io"));
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(Intent.ACTION_SEN\u2026$EMBRACE_CONTACT_EMAIL\"))");
        Intent selectorIntent = intent;
        Intent intent2 = new Intent("android.intent.action.SEND");
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent2;
        boolean bl3 = false;
        $this$apply.putExtra("android.intent.extra.EMAIL", new String[]{EMBRACE_CONTACT_EMAIL});
        $this$apply.putExtra("android.intent.extra.SUBJECT", "Android Verification Log");
        $this$apply.putExtra("android.intent.extra.TEXT", errorLog);
        $this$apply.setSelector(selectorIntent);
        Intent emailIntent = intent2;
        activity.startActivity(Intent.createChooser((Intent)emailIntent, (CharSequence)"Send Email"));
    }

    private final String generateErrorLog(String errorMessage) {
        StringBuilder stringBuilder = new StringBuilder().append("App ID: ");
        EmbraceImpl embraceImpl = Embrace.getImpl();
        Intrinsics.checkNotNullExpressionValue((Object)embraceImpl, (String)"Embrace.getImpl()");
        StringBuilder stringBuilder2 = stringBuilder.append(embraceImpl.getMetadataService().getAppId()).append('\n').append("App Version: ");
        EmbraceImpl embraceImpl2 = Embrace.getImpl();
        Intrinsics.checkNotNullExpressionValue((Object)embraceImpl2, (String)"Embrace.getImpl()");
        String errorLog = stringBuilder2.append(embraceImpl2.getMetadataService().getAppVersionName()).toString();
        errorLog = errorLog + "\n\n-----------------\n\n";
        errorLog = errorLog + errorMessage;
        return errorLog;
    }

    public EmbraceAutomaticVerification(@NotNull ScheduledExecutorService worker) {
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        this.worker = worker;
        this.handler = new Handler(Looper.getMainLooper());
        this.automaticVerificationChecker = new AutomaticVerificationChecker();
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        this.verificationActions = new VerificationActions(embrace, this.automaticVerificationChecker);
    }

    public /* synthetic */ EmbraceAutomaticVerification(ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"Executors.newSingleThreadScheduledExecutor()");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(scheduledExecutorService);
    }

    public EmbraceAutomaticVerification() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        instance = new EmbraceAutomaticVerification(null, 1, null);
    }

    @Override
    public void onBackground(long timestamp) {
        ActivityListener.DefaultImpls.onBackground(this, timestamp);
    }

    @Override
    public void applicationStartupComplete() {
        ActivityListener.DefaultImpls.applicationStartupComplete(this);
    }

    @Override
    public void onView(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onView(this, activity);
    }

    @Override
    public void onViewClose(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onViewClose(this, activity);
    }

    @Override
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onActivityCreated(this, activity, bundle);
    }

    public static final /* synthetic */ void access$verifyLifecycle(EmbraceAutomaticVerification $this) {
        $this.verifyLifecycle();
    }

    public static final /* synthetic */ void access$displayResult(EmbraceAutomaticVerification $this) {
        $this.displayResult();
    }

    public static final /* synthetic */ void access$clearUserData(EmbraceAutomaticVerification $this) {
        $this.clearUserData();
    }

    public static final /* synthetic */ void access$sendErrorLog(EmbraceAutomaticVerification $this, Activity activity, String errorMessage) {
        $this.sendErrorLog(activity, errorMessage);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/embrace/android/embracesdk/EmbraceAutomaticVerification$Companion;", "", "()V", "EMBRACE_CONTACT_EMAIL", "", "ON_FOREGROUND_DELAY", "", "ON_FOREGROUND_TIMEOUT", "TAG", "VERIFY_INTEGRATION_DELAY", "instance", "Lio/embrace/android/embracesdk/EmbraceAutomaticVerification;", "getInstance$embrace_android_sdk_release", "()Lio/embrace/android/embracesdk/EmbraceAutomaticVerification;", "embrace-android-sdk_release"})
    public static final class Companion {
        @NotNull
        public final EmbraceAutomaticVerification getInstance$embrace_android_sdk_release() {
            return instance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

