/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.BackgroundActivity;
import io.embrace.android.embracesdk.BackgroundActivityMessage;
import io.embrace.android.embracesdk.BackgroundActivityService;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.EmbraceInternalErrorService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.NdkService;
import io.embrace.android.embracesdk.Uuid;
import io.embrace.android.embracesdk.capture.PerformanceInfoService;
import io.embrace.android.embracesdk.capture.user.UserService;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.comms.delivery.DeliveryService;
import io.embrace.android.embracesdk.config.ConfigListener;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.config.behavior.BackgroundActivityBehavior;
import io.embrace.android.embracesdk.internal.spans.EmbraceAttributes;
import io.embrace.android.embracesdk.internal.spans.SpansService;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;

final class EmbraceBackgroundActivityService
implements BackgroundActivityService,
ActivityListener,
ConfigListener {
    private static final String APPLICATION_STATE_BACKGROUND = "background";
    private static final String MESSAGE_TYPE_END = "en";
    private static final long MIN_INTERVAL_BETWEEN_SAVES = 5000L;
    private final Clock clock;
    private final PerformanceInfoService performanceInfoService;
    private final MetadataService metadataService;
    private final BreadcrumbService breadcrumbService;
    private final EventService eventService;
    private final EmbraceRemoteLogger remoteLogger;
    private final UserService userService;
    private final EmbraceInternalErrorService exceptionService;
    private final DeliveryService deliveryService;
    private final ConfigService configService;
    private final NdkService ndkService;
    private final SpansService spansService;
    private final Lazy<BackgroundWorker> workerSupplier;
    private BackgroundWorker backgroundActivityCacheWorker;
    private long lastSaved;
    private boolean willBeSaved = false;
    @VisibleForTesting
    volatile BackgroundActivity backgroundActivity;
    private final AtomicInteger manualBkgSessionsSent = new AtomicInteger(0);
    @VisibleForTesting
    long lastSendAttempt;
    private boolean isEnabled = true;

    public EmbraceBackgroundActivityService(@NonNull PerformanceInfoService performanceInfoService2, @NonNull MetadataService metadataService2, @NonNull BreadcrumbService breadcrumbService2, @NonNull ActivityService activityService2, @NonNull EventService eventService2, @NonNull EmbraceRemoteLogger remoteLogger2, @NonNull UserService userService2, @NonNull EmbraceInternalErrorService exceptionService2, @NonNull DeliveryService deliveryService2, @NonNull ConfigService configService2, @NonNull NdkService ndkService2, @NonNull Clock clock2, @NonNull SpansService spansService2, @NonNull Lazy<BackgroundWorker> workerSupplier) {
        this.clock = clock2;
        this.performanceInfoService = performanceInfoService2;
        this.metadataService = metadataService2;
        this.breadcrumbService = breadcrumbService2;
        this.eventService = eventService2;
        this.remoteLogger = remoteLogger2;
        this.userService = userService2;
        this.exceptionService = exceptionService2;
        this.deliveryService = deliveryService2;
        this.configService = configService2;
        this.ndkService = ndkService2;
        this.spansService = spansService2;
        this.workerSupplier = workerSupplier;
        activityService2.addListener(this);
        this.lastSendAttempt = clock2.now();
        configService2.addListener(this);
        if (activityService2.isInBackground()) {
            this.startBackgroundActivityCapture(clock2.now(), true, BackgroundActivity.LifeEventType.BKGND_STATE);
        }
    }

    @Override
    public void sendBackgroundActivity() {
        if (!this.isEnabled || !this.verifyManualSendThresholds()) {
            return;
        }
        long now = this.clock.now();
        BackgroundActivityMessage backgroundActivityMessage = this.stopBackgroundActivityCapture(now, BackgroundActivity.LifeEventType.BKGND_MANUAL, null);
        this.startBackgroundActivityCapture(this.clock.now(), false, BackgroundActivity.LifeEventType.BKGND_MANUAL);
        if (backgroundActivityMessage != null) {
            this.deliveryService.sendBackgroundActivity(backgroundActivityMessage);
        }
    }

    @Override
    public void handleCrash(@NonNull String crashId) {
        if (this.isEnabled && this.backgroundActivity != null) {
            long now = this.clock.now();
            BackgroundActivityMessage backgroundActivityMessage = this.stopBackgroundActivityCapture(now, BackgroundActivity.LifeEventType.BKGND_STATE, crashId);
            if (backgroundActivityMessage != null) {
                this.deliveryService.saveBackgroundActivity(backgroundActivityMessage);
            }
            this.startBackgroundActivityCapture(this.clock.now(), false, BackgroundActivity.LifeEventType.BKGND_STATE);
        }
    }

    @Override
    public void onForeground(boolean coldStart, long startupTime, long timestamp) {
        if (this.isEnabled) {
            BackgroundActivityMessage backgroundActivityMessage = this.stopBackgroundActivityCapture(timestamp - 1L, BackgroundActivity.LifeEventType.BKGND_STATE, null);
            if (backgroundActivityMessage != null) {
                this.deliveryService.saveBackgroundActivity(backgroundActivityMessage);
            }
            this.deliveryService.sendBackgroundActivities();
        }
    }

    @Override
    public void onBackground(long timestamp) {
        if (this.isEnabled) {
            this.startBackgroundActivityCapture(timestamp + 1L, false, BackgroundActivity.LifeEventType.BKGND_STATE);
        }
    }

    @Override
    public void onConfigChange(@NonNull ConfigService configService2) {
        if (this.isEnabled && !configService2.isBackgroundActivityCaptureEnabled()) {
            this.disableService();
        } else if (!this.isEnabled && configService2.isBackgroundActivityCaptureEnabled()) {
            this.enableService();
        }
    }

    @Override
    public void save() {
        if (this.isEnabled && this.backgroundActivity != null) {
            if (this.clock.now() - this.lastSaved > 5000L) {
                this.saveNow();
            } else if (!this.willBeSaved) {
                this.willBeSaved = true;
                this.saveLater();
            }
        }
    }

    private void saveNow() {
        this.getCacheWorker().submitSafe(() -> {
            this.cacheBackgroundActivity();
            return null;
        });
        this.willBeSaved = false;
    }

    private void saveLater() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(this::saveNow, 5000L);
    }

    private void disableService() {
        this.isEnabled = false;
    }

    private void enableService() {
        this.isEnabled = true;
    }

    private void startBackgroundActivityCapture(long startTime, boolean coldStart, BackgroundActivity.LifeEventType startType) {
        this.backgroundActivity = BackgroundActivity.createStartMessage(Uuid.getEmbUuid(), startTime, coldStart, startType, APPLICATION_STATE_BACKGROUND, this.userService.loadUserInfoFromDisk());
        this.metadataService.setActiveSessionId(this.backgroundActivity.getSessionId());
        if (this.configService.getAutoDataCaptureBehavior().isNdkEnabled()) {
            this.ndkService.updateSessionId(this.backgroundActivity.getSessionId());
        }
        this.saveNow();
    }

    private synchronized BackgroundActivityMessage stopBackgroundActivityCapture(long endTime, BackgroundActivity.LifeEventType endType, String crashId) {
        if (this.backgroundActivity == null) {
            EmbraceLogger.logError("No background activity to report");
            return null;
        }
        long startTime = this.backgroundActivity.getStartTime() != null ? this.backgroundActivity.getStartTime() : 0L;
        BackgroundActivity sendBackgroundActivity2 = BackgroundActivity.createStopMessage(this.backgroundActivity, APPLICATION_STATE_BACKGROUND, MESSAGE_TYPE_END, endTime, this.eventService.findEventIdsForSession(startTime, endTime), this.remoteLogger.findInfoLogIds(startTime, endTime), this.remoteLogger.findWarningLogIds(startTime, endTime), this.remoteLogger.findErrorLogIds(startTime, endTime), this.remoteLogger.getInfoLogsAttemptedToSend(), this.remoteLogger.getWarnLogsAttemptedToSend(), this.remoteLogger.getErrorLogsAttemptedToSend(), this.exceptionService.getCurrentExceptionError(), endTime, endType, this.remoteLogger.getUnhandledExceptionsSent(), crashId);
        this.backgroundActivity = null;
        return this.buildBackgroundActivityMessage(sendBackgroundActivity2, true);
    }

    private boolean verifyManualSendThresholds() {
        BackgroundActivityBehavior behavior = this.configService.getBackgroundActivityBehavior();
        int manualBackgroundActivityLimit = behavior.getManualBackgroundActivityLimit();
        long minBackgroundActivityDuration = behavior.getMinBackgroundActivityDuration();
        if (this.manualBkgSessionsSent.getAndIncrement() >= manualBackgroundActivityLimit) {
            EmbraceLogger.logWarning("Warning, failed to send background activity. The amount of background activity that can be sent reached the limit..");
            return false;
        }
        if (this.lastSendAttempt < minBackgroundActivityDuration) {
            EmbraceLogger.logWarning("Warning, failed to send background activity. The last attempt to send background activity was less than 5 seconds ago.");
            return false;
        }
        return true;
    }

    private BackgroundActivityMessage buildBackgroundActivityMessage(BackgroundActivity backgroundActivity, boolean isBackgroundActivityEnd) {
        if (backgroundActivity != null) {
            long startTime = backgroundActivity.getStartTime() != null ? backgroundActivity.getStartTime() : 0L;
            long endTime = backgroundActivity.getEndTime() != null ? backgroundActivity.getEndTime().longValue() : this.clock.now();
            boolean isCrash = backgroundActivity.getCrashReportId() != null;
            return new BackgroundActivityMessage(backgroundActivity, backgroundActivity.getUser(), this.metadataService.getAppInfo(), this.metadataService.getDeviceInfo(), this.performanceInfoService.getSessionPerformanceInfo(startTime, endTime, Boolean.TRUE.equals(backgroundActivity.isColdStart()), null, false), this.breadcrumbService.getBreadcrumbs(startTime, endTime), isBackgroundActivityEnd ? this.spansService.flushSpans(isCrash ? EmbraceAttributes.AppTerminationCause.CRASH : null) : this.spansService.completedSpans());
        }
        return null;
    }

    private void cacheBackgroundActivity() {
        try {
            if (this.backgroundActivity != null) {
                long endTime;
                this.lastSaved = this.clock.now();
                long startTime = this.backgroundActivity.getStartTime() != null ? this.backgroundActivity.getStartTime() : 0L;
                BackgroundActivity cachedActivity = BackgroundActivity.createStopMessage(this.backgroundActivity, APPLICATION_STATE_BACKGROUND, MESSAGE_TYPE_END, null, this.eventService.findEventIdsForSession(startTime, endTime = this.backgroundActivity.getEndTime() != null ? this.backgroundActivity.getEndTime().longValue() : this.clock.now()), this.remoteLogger.findInfoLogIds(startTime, endTime), this.remoteLogger.findWarningLogIds(startTime, endTime), this.remoteLogger.findErrorLogIds(startTime, endTime), this.remoteLogger.getInfoLogsAttemptedToSend(), this.remoteLogger.getWarnLogsAttemptedToSend(), this.remoteLogger.getErrorLogsAttemptedToSend(), this.exceptionService.getCurrentExceptionError(), this.clock.now(), null, this.remoteLogger.getUnhandledExceptionsSent(), null);
                BackgroundActivityMessage message = this.buildBackgroundActivityMessage(cachedActivity, false);
                if (message == null) {
                    EmbraceLogger.logDebug("Failed to cache background activity message.");
                    return;
                }
                this.deliveryService.saveBackgroundActivity(message);
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Error while caching active session", ex);
        }
    }

    private synchronized BackgroundWorker getCacheWorker() {
        if (this.backgroundActivityCacheWorker == null) {
            this.backgroundActivityCacheWorker = (BackgroundWorker)this.workerSupplier.getValue();
        }
        return this.backgroundActivityCacheWorker;
    }

    @Override
    public void applicationStartupComplete() {
    }

    @Override
    public void onView(@NonNull Activity activity) {
    }

    @Override
    public void onViewClose(@NonNull Activity activity) {
    }

    @Override
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle bundle) {
    }
}

