/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceCrashSamplesNdkDelegateImpl;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSampleCodeException;
import io.embrace.android.embracesdk.config.behavior.AnrBehavior;
import io.embrace.android.embracesdk.config.behavior.AutoDataCaptureBehavior;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0007J\b\u0010\u0011\u001a\u00020\u000fH\u0007J\b\u0010\u0012\u001a\u00020\u000fH\u0007J\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u000fJ\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000fJ\u0006\u0010\u0018\u001a\u00020\u000fJ\u0006\u0010\u0019\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lio/embrace/android/embracesdk/EmbraceCrashSamples;", "", "()V", "LONG_ANR_LENGTH", "", "SHORT_ANR_4_SEC", "", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "ndkCrashSamplesNdkDelegate", "Lio/embrace/android/embracesdk/EmbraceCrashSamplesNdkDelegateImpl;", "getNdkCrashSamplesNdkDelegate$annotations", "getNdkCrashSamplesNdkDelegate", "()Lio/embrace/android/embracesdk/EmbraceCrashSamplesNdkDelegateImpl;", "blockMainThreadForShortInterval", "", "checkAnrDetectionEnabled", "checkNdkDetectionEnabled", "isSdkStarted", "throwJvmException", "triggerLongAnr", "triggerNdkSigAbort", "triggerNdkSigIllegalInstruction", "triggerNdkSigfpe", "triggerNdkSigsegv", "triggerNdkThrowCppException", "embrace-android-sdk_release"})
public final class EmbraceCrashSamples {
    private static final InternalEmbraceLogger logger;
    @NotNull
    private static final EmbraceCrashSamplesNdkDelegateImpl ndkCrashSamplesNdkDelegate;
    private static final int LONG_ANR_LENGTH = 30000;
    private static final long SHORT_ANR_4_SEC = 4000L;
    @NotNull
    public static final EmbraceCrashSamples INSTANCE;

    @VisibleForTesting
    public static /* synthetic */ void getNdkCrashSamplesNdkDelegate$annotations() {
    }

    @NotNull
    public final EmbraceCrashSamplesNdkDelegateImpl getNdkCrashSamplesNdkDelegate() {
        return ndkCrashSamplesNdkDelegate;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void isSdkStarted() {
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        if (!embrace.isStarted()) {
            void this_$iv;
            EmbraceSampleCodeException e = new EmbraceSampleCodeException("Embrace SDK not initialized. Please ensure you have included Embrace.getInstance().start(this) in Application#onCreate()\nand then trigger these crash samples via a button press once the app has loaded.");
            InternalEmbraceLogger internalEmbraceLogger = logger;
            String msg$iv = "Embrace SDK is not initialized";
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void checkAnrDetectionEnabled() {
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        Object object = embrace.getConfigService();
        if (object != null && (object = object.getAnrBehavior()) != null) {
            if (!((AnrBehavior)object).isAnrCaptureEnabled()) {
                void this_$iv;
                EmbraceSampleCodeException e = new EmbraceSampleCodeException("ANR capture disabled - you need to enable it to test Embrace's ANR functionality:\n - add [\"anr\":{\"pct_enabled\": 100 }] inside the configuration file to enable ANR detection");
                InternalEmbraceLogger internalEmbraceLogger = logger;
                String msg$iv = "ANR detection disabled";
                boolean logStacktrace$iv = false;
                boolean $i$f$logError = false;
                this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
                throw (Throwable)e;
            }
        }
    }

    public final void throwJvmException() {
        this.isSdkStarted();
        throw (Throwable)new EmbraceSampleCodeException("Custom JVM Exception");
    }

    /*
     * WARNING - void declaration
     */
    public final void blockMainThreadForShortInterval() {
        this.isSdkStarted();
        this.checkAnrDetectionEnabled();
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = logger;
            String msg$iv = "Short ANR failed";
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
        }
    }

    public final void triggerLongAnr() {
        this.isSdkStarted();
        this.checkAnrDetectionEnabled();
        long start2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - start2 < (long)30000) {
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void checkNdkDetectionEnabled() {
        this.isSdkStarted();
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        Object object = embrace.getConfigService();
        if (object == null || (object = object.getAutoDataCaptureBehavior()) == null || !((AutoDataCaptureBehavior)object).isNdkEnabled()) {
            void this_$iv;
            EmbraceSampleCodeException e = new EmbraceSampleCodeException("NDK crash capture is disabled - you need to enable it to test Embrace's NDK functionality - To enable it, add [\"ndk_enabled\": true] inside the configuration file");
            InternalEmbraceLogger internalEmbraceLogger = logger;
            String msg$iv = "NDK detection disabled";
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
            throw (Throwable)e;
        }
    }

    public final void triggerNdkSigIllegalInstruction() {
        this.checkNdkDetectionEnabled();
        ndkCrashSamplesNdkDelegate.sigIllegalInstruction();
    }

    public final void triggerNdkThrowCppException() {
        this.checkNdkDetectionEnabled();
        ndkCrashSamplesNdkDelegate.throwException();
    }

    public final void triggerNdkSigAbort() {
        this.checkNdkDetectionEnabled();
        ndkCrashSamplesNdkDelegate.sigAbort();
    }

    public final void triggerNdkSigfpe() {
        this.checkNdkDetectionEnabled();
        ndkCrashSamplesNdkDelegate.sigfpe();
    }

    public final void triggerNdkSigsegv() {
        this.checkNdkDetectionEnabled();
        ndkCrashSamplesNdkDelegate.sigsegv();
    }

    private EmbraceCrashSamples() {
    }

    static {
        EmbraceCrashSamples embraceCrashSamples;
        INSTANCE = embraceCrashSamples = new EmbraceCrashSamples();
        logger = new InternalEmbraceLogger();
        ndkCrashSamplesNdkDelegate = new EmbraceCrashSamplesNdkDelegateImpl();
    }
}

