/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.BackgroundActivityMessage;
import io.embrace.android.embracesdk.DeliveryNetworkManager;
import io.embrace.android.embracesdk.EmbraceDeliveryService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.InternalErrorLogger;
import io.embrace.android.embracesdk.NativeCrashData;
import io.embrace.android.embracesdk.NdkService;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SessionMessage;
import io.embrace.android.embracesdk.comms.delivery.DeliveryCacheManager;
import io.embrace.android.embracesdk.comms.delivery.DeliveryService;
import io.embrace.android.embracesdk.comms.delivery.DeliveryServiceNetwork;
import io.embrace.android.embracesdk.comms.delivery.SessionMessageState;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.payload.NetworkEvent;
import io.embrace.android.embracesdk.payload.NetworkRequests;
import io.embrace.android.embracesdk.payload.NetworkSessionV2;
import io.embrace.android.embracesdk.payload.PerformanceInfo;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0001FB5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010$\u001a\u00020\u0017H\u0016J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020\u0017H\u0002J\"\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0011H\u0016J \u0010'\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110.2\b\u0010,\u001a\u0004\u0018\u00010\u0011H\u0002J\u001a\u0010/\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u00100\u001a\u00020\u00172\b\u0010,\u001a\u0004\u0018\u00010\u0011H\u0002J\u0011\u00101\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0096\u0001J\u0011\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\"H\u0096\u0001J\u0011\u00104\u001a\u00020\u00172\u0006\u00103\u001a\u00020\"H\u0096\u0001J\u0010\u00105\u001a\u00020\u00172\u0006\u00103\u001a\u00020\"H\u0016J\u0019\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010:\u001a\u00020\u00172\u0006\u00103\u001a\u00020\"H\u0096\u0001J\u0019\u0010;\u001a\u00020\u00172\u0006\u00107\u001a\u0002082\u0006\u0010<\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020?H\u0096\u0001J\u0018\u0010@\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010D\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0018\u0010E\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002R!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lio/embrace/android/embracesdk/EmbraceDeliveryService;", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryServiceNetwork;", "cacheManager", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryCacheManager;", "networkManager", "Lio/embrace/android/embracesdk/DeliveryNetworkManager;", "cachedSessionsBackgroundWorker", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "sendSessionsBackgroundWorker", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "(Lio/embrace/android/embracesdk/comms/delivery/DeliveryCacheManager;Lio/embrace/android/embracesdk/DeliveryNetworkManager;Lio/embrace/android/embracesdk/worker/BackgroundWorker;Lio/embrace/android/embracesdk/worker/BackgroundWorker;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;Lio/embrace/android/embracesdk/config/ConfigService;)V", "backgroundActivities", "", "", "getBackgroundActivities", "()Ljava/util/Set;", "backgroundActivities$delegate", "Lkotlin/Lazy;", "addCrashDataToCachedSession", "", "nativeCrashData", "Lio/embrace/android/embracesdk/NativeCrashData;", "attachCrashToSession", "Lio/embrace/android/embracesdk/SessionMessage;", "sessionMessage", "saveBackgroundActivity", "backgroundActivityMessage", "Lio/embrace/android/embracesdk/BackgroundActivityMessage;", "saveCrash", "crash", "Lio/embrace/android/embracesdk/EventMessage;", "saveSession", "sendBackgroundActivities", "sendBackgroundActivity", "sendCachedCrash", "sendCachedSessions", "isNdkEnabled", "", "ndkService", "Lio/embrace/android/embracesdk/NdkService;", "currentSession", "ids", "", "sendCachedSessionsWithNdk", "sendCachedSessionsWithoutNdk", "sendCrash", "sendEvent", "eventMessage", "sendEventAndWait", "sendEventAsync", "sendLogScreenshot", "screenshot", "", "logId", "sendLogs", "sendMomentScreenshot", "eventId", "sendNetworkCall", "networkEvent", "Lio/embrace/android/embracesdk/payload/NetworkEvent;", "sendSession", "state", "Lio/embrace/android/embracesdk/comms/delivery/SessionMessageState;", "validateNetworkCalls", "validateSessionTimestamps", "verifyCrashTimeStamp", "Companion", "embrace-android-sdk_release"})
public final class EmbraceDeliveryService
implements DeliveryService,
DeliveryServiceNetwork {
    private final Lazy backgroundActivities$delegate;
    private final DeliveryCacheManager cacheManager;
    private final DeliveryNetworkManager networkManager;
    private final BackgroundWorker cachedSessionsBackgroundWorker;
    private final BackgroundWorker sendSessionsBackgroundWorker;
    private final InternalEmbraceLogger logger;
    private final ConfigService configService;
    private static final String TAG = "EmbraceDeliveryService";
    private static final long SEND_SESSION_TIMEOUT = 1L;
    private static final int CRASH_MAX_DIFF_WITH_SESSION_END = 7000;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final Set<String> getBackgroundActivities() {
        Lazy lazy = this.backgroundActivities$delegate;
        EmbraceDeliveryService embraceDeliveryService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Set)lazy.getValue();
    }

    @Override
    public void saveSession(@NotNull SessionMessage sessionMessage2) {
        Intrinsics.checkNotNullParameter((Object)sessionMessage2, (String)"sessionMessage");
        this.cacheManager.saveSession(sessionMessage2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendSession(@NotNull SessionMessage sessionMessage2, @NotNull SessionMessageState state2) {
        void className$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)sessionMessage2, (String)"sessionMessage");
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String msg$iv = "Sending session message";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        this.sendSessionsBackgroundWorker.submit((Callable)new Callable<byte[]>(this, sessionMessage2, state2){
            final /* synthetic */ EmbraceDeliveryService this$0;
            final /* synthetic */ SessionMessage $sessionMessage;
            final /* synthetic */ SessionMessageState $state;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final byte[] call() {
                Object object;
                void className$iv;
                void this_$iv;
                InternalEmbraceLogger internalEmbraceLogger = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                Object object2 = "EmbraceDeliveryService";
                String msg$iv = "Sending session message - Worker started";
                Throwable throwable$iv = null;
                boolean $i$f$logDeveloper = false;
                this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                byte[] sessionBytes = EmbraceDeliveryService.access$getCacheManager$p(this.this$0).saveSession(this.$sessionMessage);
                if (sessionBytes != null) {
                    String className$iv2;
                    InternalEmbraceLogger this_$iv2;
                    InternalEmbraceLogger className$iv3;
                    void this_$iv3;
                    object2 = sessionBytes;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object session2 = object2;
                    boolean bl3 = false;
                    InternalEmbraceLogger internalEmbraceLogger2 = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                    String string2 = "EmbraceDeliveryService";
                    String msg$iv2 = "Serialized session message ready to be sent";
                    Throwable throwable$iv2 = null;
                    boolean $i$f$logDeveloper2 = false;
                    this_$iv3.log('[' + (String)((Object)className$iv3) + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
                    try {
                        boolean $i$f$logDeveloper3;
                        Throwable throwable$iv3;
                        String msg$iv3;
                        Function0 onFinish = null;
                        if (this.$state == SessionMessageState.END || this.$state == SessionMessageState.END_WITH_CRASH) {
                            onFinish = (Function0)new Function0<Unit>(this){
                                final /* synthetic */ sendSession.1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }

                                public final void invoke() {
                                    EmbraceDeliveryService.access$getCacheManager$p(this.this$0.this$0).deleteSession(this.this$0.$sessionMessage.getSession().getSessionId());
                                }
                            };
                            if (EmbraceDeliveryService.access$getConfigService$p(this.this$0).getSdkModeBehavior().isIntegrationModeEnabled()) {
                                EmbraceDeliveryService.access$validateNetworkCalls(this.this$0, this.$sessionMessage);
                                EmbraceDeliveryService.access$validateSessionTimestamps(this.this$0, this.$sessionMessage);
                            }
                        }
                        if (this.$state == SessionMessageState.END_WITH_CRASH) {
                            EmbraceDeliveryService.access$getNetworkManager$p(this.this$0).sendSession((byte[])session2, (Function0<Unit>)onFinish).get(1L, TimeUnit.SECONDS);
                            className$iv3 = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                            msg$iv2 = "EmbraceDeliveryService";
                            msg$iv3 = "Session message sent.";
                            throwable$iv3 = null;
                            $i$f$logDeveloper3 = false;
                            this_$iv2.log('[' + className$iv2 + "] " + msg$iv3, EmbraceLogger.Severity.DEVELOPER, throwable$iv3, true);
                        } else {
                            EmbraceDeliveryService.access$getNetworkManager$p(this.this$0).sendSession((byte[])session2, (Function0<Unit>)onFinish);
                            this_$iv2 = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                            className$iv2 = "EmbraceDeliveryService";
                            msg$iv3 = "Session message queued to be sent.";
                            throwable$iv3 = null;
                            $i$f$logDeveloper3 = false;
                            this_$iv2.log('[' + className$iv2 + "] " + msg$iv3, EmbraceLogger.Severity.DEVELOPER, throwable$iv3, true);
                        }
                        this_$iv2 = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                        className$iv2 = "EmbraceDeliveryService";
                        msg$iv3 = "Current session has been successfully removed from cache.";
                        throwable$iv3 = null;
                        $i$f$logDeveloper3 = false;
                        this_$iv2.log('[' + className$iv2 + "] " + msg$iv3, EmbraceLogger.Severity.DEVELOPER, throwable$iv3, true);
                    }
                    catch (Exception ex) {
                        this_$iv2 = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                        className$iv2 = "Failed to send session end message. Embrace will store the session message and attempt to deliver it at a future date.";
                        boolean $i$f$logInfo = false;
                        this_$iv2.log(msg$iv2, EmbraceLogger.Severity.INFO, null, true);
                    }
                    object = object2;
                } else {
                    object = null;
                }
                return object;
            }
            {
                this.this$0 = embraceDeliveryService;
                this.$sessionMessage = sessionMessage2;
                this.$state = sessionMessageState;
            }
        });
    }

    @Override
    public void saveBackgroundActivity(@NotNull BackgroundActivityMessage backgroundActivityMessage) {
        Intrinsics.checkNotNullParameter((Object)backgroundActivityMessage, (String)"backgroundActivityMessage");
        this.getBackgroundActivities().add(backgroundActivityMessage.getBackgroundActivity().getSessionId());
        this.cacheManager.saveBackgroundActivity(backgroundActivityMessage);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendBackgroundActivity(@NotNull BackgroundActivityMessage backgroundActivityMessage) {
        void className$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)backgroundActivityMessage, (String)"backgroundActivityMessage");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String msg$iv = "Sending background activity message";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        this.sendSessionsBackgroundWorker.submit((Callable)new Callable<byte[]>(this, backgroundActivityMessage){
            final /* synthetic */ EmbraceDeliveryService this$0;
            final /* synthetic */ BackgroundActivityMessage $backgroundActivityMessage;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final byte[] call() {
                Object object;
                void className$iv;
                void this_$iv;
                InternalEmbraceLogger internalEmbraceLogger = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                Object object2 = "EmbraceDeliveryService";
                String msg$iv = "Sending background activity message - Worker started";
                Throwable throwable$iv = null;
                boolean $i$f$logDeveloper = false;
                this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                byte[] baBytes = EmbraceDeliveryService.access$getCacheManager$p(this.this$0).saveBackgroundActivity(this.$backgroundActivityMessage);
                if (baBytes != null) {
                    String className$iv2;
                    InternalEmbraceLogger this_$iv2;
                    InternalEmbraceLogger className$iv3;
                    void this_$iv3;
                    object2 = baBytes;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object backgroundActivity = object2;
                    boolean bl3 = false;
                    InternalEmbraceLogger internalEmbraceLogger2 = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                    String string2 = "EmbraceDeliveryService";
                    String msg$iv2 = "Serialized session message ready to be sent";
                    Throwable throwable$iv2 = null;
                    boolean $i$f$logDeveloper2 = false;
                    this_$iv3.log('[' + (String)((Object)className$iv3) + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
                    try {
                        Function0 onFinish = (Function0)new Function0<Unit>(this){
                            final /* synthetic */ sendBackgroundActivity.1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }

                            public final void invoke() {
                                EmbraceDeliveryService.access$getCacheManager$p(this.this$0.this$0).deleteSession(this.this$0.$backgroundActivityMessage.getBackgroundActivity().getSessionId());
                            }
                        };
                        EmbraceDeliveryService.access$getNetworkManager$p(this.this$0).sendSession((byte[])backgroundActivity, (Function0<Unit>)onFinish);
                        className$iv3 = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                        msg$iv2 = "EmbraceDeliveryService";
                        String msg$iv3 = "Session message queued to be sent.";
                        Throwable throwable$iv3 = null;
                        boolean $i$f$logDeveloper3 = false;
                        this_$iv2.log('[' + className$iv2 + "] " + msg$iv3, EmbraceLogger.Severity.DEVELOPER, throwable$iv3, true);
                    }
                    catch (Exception ex) {
                        this_$iv2 = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                        className$iv2 = "Failed to send background activity message. Embrace will attempt to deliver it at a future date.";
                        boolean $i$f$logInfo = false;
                        this_$iv2.log(msg$iv2, EmbraceLogger.Severity.INFO, null, true);
                    }
                    object = object2;
                } else {
                    object = null;
                }
                return object;
            }
            {
                this.this$0 = embraceDeliveryService;
                this.$backgroundActivityMessage = backgroundActivityMessage;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendBackgroundActivities() {
        void className$iv;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String msg$iv = "Sending background activity message";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        this.sendSessionsBackgroundWorker.submit((Callable)new Callable<Unit>(this){
            final /* synthetic */ EmbraceDeliveryService this$0;

            /*
             * WARNING - void declaration
             */
            public final void call() {
                Iterable $this$forEach$iv = EmbraceDeliveryService.access$getBackgroundActivities$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String className$iv;
                    InternalEmbraceLogger this_$iv;
                    InternalEmbraceLogger className$iv2;
                    void this_$iv2;
                    void className$iv3;
                    void this_$iv3;
                    String backgroundActivityId = (String)element$iv;
                    boolean bl = false;
                    InternalEmbraceLogger internalEmbraceLogger = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                    Object object = "EmbraceDeliveryService";
                    String msg$iv = "Sending background activity message - Worker started";
                    Throwable throwable$iv = null;
                    boolean $i$f$logDeveloper = false;
                    this_$iv3.log('[' + (String)className$iv3 + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                    byte[] baBytes = EmbraceDeliveryService.access$getCacheManager$p(this.this$0).loadBackgroundActivity(backgroundActivityId);
                    if (baBytes == null) continue;
                    object = baBytes;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object backgroundActivity = object;
                    boolean bl4 = false;
                    InternalEmbraceLogger internalEmbraceLogger2 = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                    String string2 = "EmbraceDeliveryService";
                    String msg$iv2 = "Serialized session message ready to be sent";
                    Throwable throwable$iv2 = null;
                    boolean $i$f$logDeveloper2 = false;
                    this_$iv2.log('[' + (String)((Object)className$iv2) + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
                    try {
                        Function0 onFinish = (Function0)new Function0<Unit>(backgroundActivityId, this){
                            final /* synthetic */ String $backgroundActivityId$inlined;
                            final /* synthetic */ sendBackgroundActivities.1 this$0;
                            {
                                this.$backgroundActivityId$inlined = string2;
                                this.this$0 = var2_2;
                                super(0);
                            }

                            public final void invoke() {
                                EmbraceDeliveryService.access$getCacheManager$p(this.this$0.this$0).deleteSession(this.$backgroundActivityId$inlined);
                            }
                        };
                        EmbraceDeliveryService.access$getNetworkManager$p(this.this$0).sendSession((byte[])backgroundActivity, (Function0<Unit>)onFinish);
                        className$iv2 = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                        msg$iv2 = "EmbraceDeliveryService";
                        String msg$iv3 = "Session message queued to be sent.";
                        Throwable throwable$iv3 = null;
                        boolean $i$f$logDeveloper3 = false;
                        this_$iv.log('[' + className$iv + "] " + msg$iv3, EmbraceLogger.Severity.DEVELOPER, throwable$iv3, true);
                    }
                    catch (Exception ex) {
                        this_$iv = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                        className$iv = "Failed to send background activity message. Embrace will attempt to deliver it at a future date.";
                        boolean $i$f$logInfo = false;
                        this_$iv.log(msg$iv2, EmbraceLogger.Severity.INFO, null, true);
                    }
                }
            }
            {
                this.this$0 = embraceDeliveryService;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void validateSessionTimestamps(SessionMessage sessionMessage2) {
        long endTime;
        Long l = sessionMessage2.getSession().getEndTime();
        long l2 = endTime = l != null ? l : 0L;
        if (endTime <= sessionMessage2.getSession().getStartTime()) {
            void throwable$iv;
            void msg$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "Session end time less or equal to start time";
            Throwable throwable = new InternalErrorLogger.IntegrationModeException("wrong session start/end time");
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.ERROR, (Throwable)throwable$iv, logStacktrace$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateNetworkCalls(SessionMessage sessionMessage2) {
        PerformanceInfo p;
        PerformanceInfo performanceInfo2 = p = sessionMessage2.getPerformanceInfo();
        NetworkRequests networkRequests = performanceInfo2 != null ? performanceInfo2.getNetworkRequests() : null;
        Object object = networkRequests;
        if (object != null && (object = ((NetworkRequests)object).getNetworkSessionV2()) != null && (object = ((NetworkSessionV2)object).getRequestCounts()) != null) {
            if (object.isEmpty()) {
                void throwable$iv;
                void msg$iv;
                void this_$iv;
                InternalEmbraceLogger internalEmbraceLogger = this.logger;
                String string2 = "Session with no network calls";
                Throwable throwable = new InternalErrorLogger.IntegrationModeException("No network calls");
                boolean logStacktrace$iv = false;
                boolean $i$f$logError = false;
                this_$iv.log((String)msg$iv, EmbraceLogger.Severity.ERROR, (Throwable)throwable$iv, logStacktrace$iv);
            }
        }
    }

    @Override
    public void sendCachedSessions(boolean isNdkEnabled, @NotNull NdkService ndkService2, @Nullable String currentSession) {
        Intrinsics.checkNotNullParameter((Object)ndkService2, (String)"ndkService");
        this.sendCachedCrash();
        if (isNdkEnabled) {
            this.sendCachedSessionsWithNdk(ndkService2, currentSession);
        } else {
            this.sendCachedSessionsWithoutNdk(currentSession);
        }
    }

    @Override
    public void saveCrash(@NotNull EventMessage crash) {
        Intrinsics.checkNotNullParameter((Object)crash, (String)"crash");
        this.cacheManager.saveCrash(crash);
    }

    private final void sendCachedCrash() {
        block0: {
            EventMessage crash;
            EventMessage eventMessage = crash = this.cacheManager.loadCrash();
            if (eventMessage == null) break block0;
            EventMessage eventMessage2 = eventMessage;
            boolean bl = false;
            boolean bl2 = false;
            EventMessage it = eventMessage2;
            boolean bl3 = false;
            this.networkManager.sendCrash(it);
        }
    }

    private final void sendCachedSessionsWithoutNdk(String currentSession) {
        this.cachedSessionsBackgroundWorker.submit((Callable)new Callable<Unit>(this, currentSession){
            final /* synthetic */ EmbraceDeliveryService this$0;
            final /* synthetic */ String $currentSession;

            public final void call() {
                EmbraceDeliveryService.access$sendCachedSessions(this.this$0, EmbraceDeliveryService.access$getCacheManager$p(this.this$0).getAllCachedSessionIds(), this.$currentSession);
            }
            {
                this.this$0 = embraceDeliveryService;
                this.$currentSession = string2;
            }
        });
    }

    private final void sendCachedSessionsWithNdk(NdkService ndkService2, String currentSession) {
        this.cachedSessionsBackgroundWorker.submit((Callable)new Callable<Unit>(this, ndkService2, currentSession){
            final /* synthetic */ EmbraceDeliveryService this$0;
            final /* synthetic */ NdkService $ndkService;
            final /* synthetic */ String $currentSession;

            /*
             * WARNING - void declaration
             */
            public final void call() {
                void className$iv;
                void this_$iv;
                List<String> allSessions = EmbraceDeliveryService.access$getCacheManager$p(this.this$0).getAllCachedSessionIds();
                InternalEmbraceLogger internalEmbraceLogger = EmbraceDeliveryService.access$getLogger$p(this.this$0);
                String string2 = "EmbraceDeliveryService";
                String msg$iv = "NDK enabled, checking for native crashes";
                Throwable throwable$iv = null;
                boolean $i$f$logDeveloper = false;
                this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                NativeCrashData nativeCrashData = this.$ndkService.checkForNativeCrash();
                if (nativeCrashData != null) {
                    EmbraceDeliveryService.access$addCrashDataToCachedSession(this.this$0, nativeCrashData);
                }
                EmbraceDeliveryService.access$sendCachedSessions(this.this$0, allSessions, this.$currentSession);
            }
            {
                this.this$0 = embraceDeliveryService;
                this.$ndkService = ndkService2;
                this.$currentSession = string2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void addCrashDataToCachedSession(NativeCrashData nativeCrashData) {
        block3: {
            void msg$iv;
            void this_$iv;
            Object newSessionMessage;
            boolean bl;
            boolean bl2;
            Object object;
            Object object2;
            block2: {
                String string2 = nativeCrashData.getSessionId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nativeCrashData.sessionId");
                object2 = this.cacheManager.loadSession(string2);
                if (object2 == null) break block2;
                object = object2;
                bl2 = false;
                bl = false;
                Object sessionMessage2 = object;
                boolean bl3 = false;
                newSessionMessage = this.attachCrashToSession(nativeCrashData, (SessionMessage)sessionMessage2);
                this.cacheManager.saveSession((SessionMessage)newSessionMessage);
                object2 = object;
                if (object2 != null) break block3;
            }
            object = this;
            bl2 = false;
            bl = false;
            EmbraceDeliveryService $this$run = (EmbraceDeliveryService)object;
            boolean bl4 = false;
            newSessionMessage = $this$run.logger;
            String string3 = "Could not find session with id " + nativeCrashData.getSessionId() + " to " + "add native crash";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            object2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SessionMessage attachCrashToSession(NativeCrashData nativeCrashData, SessionMessage sessionMessage2) {
        void msg$iv;
        void className$iv;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String string3 = "Attaching native crash " + nativeCrashData.getNativeCrashId() + " to session " + sessionMessage2.getSession().getSessionId();
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        if (this.configService.getSdkModeBehavior().isIntegrationModeEnabled()) {
            this.verifyCrashTimeStamp(nativeCrashData, sessionMessage2);
        }
        Session session2 = Session.copy$default(sessionMessage2.getSession(), null, 0L, 0, null, null, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, nativeCrashData.getNativeCrashId(), null, null, null, null, null, null, null, null, null, null, null, null, -1048577, 1, null);
        return SessionMessage.copy$default(sessionMessage2, session2, null, null, null, null, null, null, 0, 254, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyCrashTimeStamp(NativeCrashData nativeCrashData, SessionMessage sessionMessage2) {
        Long l = sessionMessage2.getSession().getEndTime();
        long endTime = l != null ? l : 0L;
        long l2 = nativeCrashData.getTimestamp() - endTime;
        boolean bl = false;
        if (Math.abs(l2) >= (long)7000) {
            void throwable$iv;
            void msg$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "Crash " + nativeCrashData.getNativeCrashId() + " happened outside 7 seconds of session end";
            Throwable throwable = new InternalErrorLogger.IntegrationModeException(nativeCrashData.getNativeCrashId() + " outside 7 secs range");
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.ERROR, (Throwable)throwable$iv, logStacktrace$iv);
        }
    }

    private final void sendCachedSessions(List<String> ids, String currentSession) {
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Throwable throwable$iv;
            String msg$iv;
            InternalEmbraceLogger this_$iv;
            boolean $i$f$logError;
            boolean logStacktrace$iv;
            String id = (String)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)id, (Object)currentSession) ^ true)) continue;
            try {
                byte[] payload = this.cacheManager.loadSessionBytes(id);
                if (payload != null) {
                    if (this.configService.getSdkModeBehavior().isIntegrationModeEnabled()) {
                        InternalEmbraceLogger internalEmbraceLogger = this.logger;
                        String string2 = "send cached sessions";
                        Throwable throwable = new InternalErrorLogger.IntegrationModeException("Found cached session " + id);
                        logStacktrace$iv = false;
                        $i$f$logError = false;
                        this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
                    }
                    this.networkManager.sendSession(payload, (Function0<Unit>)((Function0)new Function0<Unit>(id, this, currentSession){
                        final /* synthetic */ String $id;
                        final /* synthetic */ EmbraceDeliveryService this$0;
                        final /* synthetic */ String $currentSession$inlined;
                        {
                            this.$id = string2;
                            this.this$0 = embraceDeliveryService;
                            this.$currentSession$inlined = string3;
                            super(0);
                        }

                        public final void invoke() {
                            EmbraceDeliveryService.access$getCacheManager$p(this.this$0).deleteSession(this.$id);
                        }
                    }));
                    continue;
                }
                this_$iv = this.logger;
                msg$iv = "Session " + id + " not found";
                throwable$iv = null;
                logStacktrace$iv = false;
                $i$f$logError = false;
                this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            }
            catch (Exception ex) {
                this_$iv = this.logger;
                msg$iv = "Could not send cached session " + id;
                throwable$iv = null;
                logStacktrace$iv = false;
                $i$f$logError = false;
                this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            }
        }
    }

    @Override
    public void sendEventAsync(@NotNull EventMessage eventMessage) {
        Intrinsics.checkNotNullParameter((Object)eventMessage, (String)"eventMessage");
        this.sendSessionsBackgroundWorker.submit((Callable)new Callable<Unit>(this, eventMessage){
            final /* synthetic */ EmbraceDeliveryService this$0;
            final /* synthetic */ EventMessage $eventMessage;

            public final void call() {
                EmbraceDeliveryService.access$getNetworkManager$p(this.this$0).sendEvent(this.$eventMessage);
            }
            {
                this.this$0 = embraceDeliveryService;
                this.$eventMessage = eventMessage;
            }
        });
    }

    public EmbraceDeliveryService(@NotNull DeliveryCacheManager cacheManager, @NotNull DeliveryNetworkManager networkManager, @NotNull BackgroundWorker cachedSessionsBackgroundWorker, @NotNull BackgroundWorker sendSessionsBackgroundWorker, @NotNull InternalEmbraceLogger logger, @NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)networkManager, (String)"networkManager");
        Intrinsics.checkNotNullParameter((Object)cachedSessionsBackgroundWorker, (String)"cachedSessionsBackgroundWorker");
        Intrinsics.checkNotNullParameter((Object)sendSessionsBackgroundWorker, (String)"sendSessionsBackgroundWorker");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        this.cacheManager = cacheManager;
        this.networkManager = networkManager;
        this.cachedSessionsBackgroundWorker = cachedSessionsBackgroundWorker;
        this.sendSessionsBackgroundWorker = sendSessionsBackgroundWorker;
        this.logger = logger;
        this.configService = configService2;
        this.backgroundActivities$delegate = LazyKt.lazy((Function0)backgroundActivities.2.INSTANCE);
    }

    @Override
    public void sendCrash(@NotNull EventMessage crash) {
        Intrinsics.checkNotNullParameter((Object)crash, (String)"crash");
        this.networkManager.sendCrash(crash);
    }

    @Override
    public void sendEvent(@NotNull EventMessage eventMessage) {
        Intrinsics.checkNotNullParameter((Object)eventMessage, (String)"eventMessage");
        this.networkManager.sendEvent(eventMessage);
    }

    @Override
    public void sendEventAndWait(@NotNull EventMessage eventMessage) {
        Intrinsics.checkNotNullParameter((Object)eventMessage, (String)"eventMessage");
        this.networkManager.sendEventAndWait(eventMessage);
    }

    @Override
    public void sendLogScreenshot(@NotNull byte[] screenshot, @NotNull String logId) {
        Intrinsics.checkNotNullParameter((Object)screenshot, (String)"screenshot");
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        this.networkManager.sendLogScreenshot(screenshot, logId);
    }

    @Override
    public void sendLogs(@NotNull EventMessage eventMessage) {
        Intrinsics.checkNotNullParameter((Object)eventMessage, (String)"eventMessage");
        this.networkManager.sendLogs(eventMessage);
    }

    @Override
    public void sendMomentScreenshot(@NotNull byte[] screenshot, @NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)screenshot, (String)"screenshot");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        this.networkManager.sendMomentScreenshot(screenshot, eventId);
    }

    @Override
    public void sendNetworkCall(@NotNull NetworkEvent networkEvent) {
        Intrinsics.checkNotNullParameter((Object)networkEvent, (String)"networkEvent");
        this.networkManager.sendNetworkCall(networkEvent);
    }

    public static final /* synthetic */ InternalEmbraceLogger access$getLogger$p(EmbraceDeliveryService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ DeliveryCacheManager access$getCacheManager$p(EmbraceDeliveryService $this) {
        return $this.cacheManager;
    }

    public static final /* synthetic */ ConfigService access$getConfigService$p(EmbraceDeliveryService $this) {
        return $this.configService;
    }

    public static final /* synthetic */ void access$validateNetworkCalls(EmbraceDeliveryService $this, SessionMessage sessionMessage2) {
        $this.validateNetworkCalls(sessionMessage2);
    }

    public static final /* synthetic */ void access$validateSessionTimestamps(EmbraceDeliveryService $this, SessionMessage sessionMessage2) {
        $this.validateSessionTimestamps(sessionMessage2);
    }

    public static final /* synthetic */ DeliveryNetworkManager access$getNetworkManager$p(EmbraceDeliveryService $this) {
        return $this.networkManager;
    }

    public static final /* synthetic */ Set access$getBackgroundActivities$p(EmbraceDeliveryService $this) {
        return $this.getBackgroundActivities();
    }

    public static final /* synthetic */ void access$sendCachedSessions(EmbraceDeliveryService $this, List ids, String currentSession) {
        $this.sendCachedSessions(ids, currentSession);
    }

    public static final /* synthetic */ void access$addCrashDataToCachedSession(EmbraceDeliveryService $this, NativeCrashData nativeCrashData) {
        $this.addCrashDataToCachedSession(nativeCrashData);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/embrace/android/embracesdk/EmbraceDeliveryService$Companion;", "", "()V", "CRASH_MAX_DIFF_WITH_SESSION_END", "", "SEND_SESSION_TIMEOUT", "", "TAG", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

