/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Application;
import android.content.Context;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.BackgroundActivityService;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.BuildInfo;
import io.embrace.android.embracesdk.ConnectionQualityListener;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceActivityService;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceInternalErrorService;
import io.embrace.android.embracesdk.EmbraceInternalInterface;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EmbraceSessionProperties;
import io.embrace.android.embracesdk.EmbraceSessionService;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.FlutterInternalInterface;
import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.InternalErrorLogger;
import io.embrace.android.embracesdk.InternalInterfaceModuleImpl;
import io.embrace.android.embracesdk.LogExceptionType;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.MetadataUtils;
import io.embrace.android.embracesdk.NativeModuleImpl;
import io.embrace.android.embracesdk.NdkService;
import io.embrace.android.embracesdk.NetworkCaptureService;
import io.embrace.android.embracesdk.NetworkLoggingService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.PropertyUtils;
import io.embrace.android.embracesdk.PushNotificationBreadcrumb;
import io.embrace.android.embracesdk.PushNotificationCaptureService;
import io.embrace.android.embracesdk.ReactNativeInternalInterface;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SessionModuleImpl;
import io.embrace.android.embracesdk.SessionService;
import io.embrace.android.embracesdk.StreamHandlerFactoryInstaller;
import io.embrace.android.embracesdk.TapBreadcrumb;
import io.embrace.android.embracesdk.UnityInternalInterface;
import io.embrace.android.embracesdk.anr.AnrService;
import io.embrace.android.embracesdk.anr.ndk.EmbraceNativeThreadSamplerServiceKt;
import io.embrace.android.embracesdk.anr.ndk.NativeThreadSamplerInstaller;
import io.embrace.android.embracesdk.anr.ndk.NativeThreadSamplerService;
import io.embrace.android.embracesdk.capture.crumbs.activity.ActivityLifecycleBreadcrumbService;
import io.embrace.android.embracesdk.capture.memory.MemoryService;
import io.embrace.android.embracesdk.capture.strictmode.StrictModeService;
import io.embrace.android.embracesdk.capture.user.UserService;
import io.embrace.android.embracesdk.capture.webview.WebViewService;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.clock.SystemClock;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.config.behavior.NetworkBehavior;
import io.embrace.android.embracesdk.config.behavior.SessionBehavior;
import io.embrace.android.embracesdk.injection.AnrModuleImpl;
import io.embrace.android.embracesdk.injection.CoreModule;
import io.embrace.android.embracesdk.injection.CoreModuleImpl;
import io.embrace.android.embracesdk.injection.CrashModule;
import io.embrace.android.embracesdk.injection.CrashModuleImpl;
import io.embrace.android.embracesdk.injection.CustomerLogModuleImpl;
import io.embrace.android.embracesdk.injection.DataCaptureServiceModule;
import io.embrace.android.embracesdk.injection.DataCaptureServiceModuleImpl;
import io.embrace.android.embracesdk.injection.DataContainerModuleImpl;
import io.embrace.android.embracesdk.injection.DeliveryModule;
import io.embrace.android.embracesdk.injection.DeliveryModuleImpl;
import io.embrace.android.embracesdk.injection.EssentialServiceModule;
import io.embrace.android.embracesdk.injection.EssentialServiceModuleImpl;
import io.embrace.android.embracesdk.injection.SdkObservabilityModuleImpl;
import io.embrace.android.embracesdk.injection.SystemServiceModuleImpl;
import io.embrace.android.embracesdk.internal.ApkToolsConfig;
import io.embrace.android.embracesdk.internal.crash.LastRunCrashVerifier;
import io.embrace.android.embracesdk.internal.spans.EmbraceSpansService;
import io.embrace.android.embracesdk.internal.spans.SpansService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.network.EmbraceNetworkRequest;
import io.embrace.android.embracesdk.network.EmbraceNetworkRequestV2;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.network.http.NetworkCaptureData;
import io.embrace.android.embracesdk.registry.ServiceRegistry;
import io.embrace.android.embracesdk.worker.WorkerName;
import io.embrace.android.embracesdk.worker.WorkerThreadModule;
import io.embrace.android.embracesdk.worker.WorkerThreadModuleImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;

final class EmbraceImpl {
    private static final String ERROR_USER_UPDATES_DISABLED = "User updates are disabled, ignoring user persona update.";
    private final AtomicBoolean started = new AtomicBoolean(false);
    private static String customAppId;
    private volatile Application application;
    private volatile Embrace.AppFramework appFramework;
    private volatile BreadcrumbService breadcrumbService;
    private volatile SessionService sessionService;
    private volatile BackgroundActivityService backgroundActivityService;
    private volatile MetadataService metadataService;
    private volatile ActivityService activityService;
    private volatile NetworkLoggingService networkLoggingService;
    @Nullable
    private volatile AnrService anrService;
    private volatile EmbraceRemoteLogger remoteLogger;
    private volatile ConfigService configService;
    private volatile PreferencesService preferencesService;
    private volatile EventService eventService;
    private volatile UserService userService;
    private volatile EmbraceInternalErrorService exceptionsService;
    private volatile NdkService ndkService;
    private volatile NetworkCaptureService networkCaptureService;
    private volatile WebViewService webViewService;
    private final InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
    private NativeThreadSamplerService nativeThreadSampler;
    private NativeThreadSamplerInstaller nativeThreadSamplerInstaller;
    @Nullable
    private ReactNativeInternalInterface reactNativeInternalInterface;
    @Nullable
    private UnityInternalInterface unityInternalInterface;
    @Nullable
    private FlutterInternalInterface flutterInternalInterface;
    private PushNotificationCaptureService pushNotificationService;
    private WorkerThreadModule workerThreadModule;
    private volatile SpansService spansService;
    private ServiceRegistry serviceRegistry;
    private LastRunCrashVerifier crashVerifier;
    @NonNull
    private Clock sdkClock = new SystemClock();
    @NonNull
    private final Function2<Context, Embrace.AppFramework, CoreModule> coreModuleSupplier;
    @NonNull
    private final Function0<WorkerThreadModule> workerThreadModuleSupplier;
    @NonNull
    private final Function4<CoreModule, EssentialServiceModule, DataCaptureServiceModule, WorkerThreadModule, DeliveryModule> deliveryModuleSupplier;

    EmbraceImpl(@NonNull Function2<Context, Embrace.AppFramework, CoreModule> coreModuleSupplier, @NonNull Function0<WorkerThreadModule> workerThreadModuleSupplier, @NonNull Function4<CoreModule, EssentialServiceModule, DataCaptureServiceModule, WorkerThreadModule, DeliveryModule> deliveryModuleSupplier) {
        this.coreModuleSupplier = coreModuleSupplier;
        this.workerThreadModuleSupplier = workerThreadModuleSupplier;
        this.deliveryModuleSupplier = deliveryModuleSupplier;
    }

    EmbraceImpl() {
        this((Function2<Context, Embrace.AppFramework, CoreModule>)((Function2)CoreModuleImpl::new), (Function0<WorkerThreadModule>)((Function0)WorkerThreadModuleImpl::new), (Function4<CoreModule, EssentialServiceModule, DataCaptureServiceModule, WorkerThreadModule, DeliveryModule>)((Function4)DeliveryModuleImpl::new));
    }

    public void start(@NonNull Context context2, boolean enableIntegrationTesting, @NonNull Embrace.AppFramework appFramework) {
        try {
            this.startImpl(context2, enableIntegrationTesting, appFramework);
        }
        catch (Exception ex) {
            this.internalEmbraceLogger.logError("Exception occurred while initializing the Embrace SDK. Instrumentation may be disabled.", ex, true);
        }
    }

    private void startImpl(@NonNull Context context2, boolean enableIntegrationTesting, @NonNull Embrace.AppFramework appFramework) {
        AnrService anrServiceImpl;
        if (this.application != null) {
            InternalStaticEmbraceLogger.logWarning("Embrace SDK has already been initialized");
            return;
        }
        if (ApkToolsConfig.IS_SDK_DISABLED) {
            this.internalEmbraceLogger.logInfo("SDK disabled through ApkToolsConfig");
            this.stop();
            return;
        }
        CoreModule coreModule = (CoreModule)this.coreModuleSupplier.invoke((Object)context2, (Object)appFramework);
        this.serviceRegistry = coreModule.getServiceRegistry();
        SystemServiceModuleImpl systemServiceModule = new SystemServiceModuleImpl(coreModule);
        this.application = coreModule.getApplication();
        this.appFramework = coreModule.getAppFramework();
        this.sdkClock = coreModule.getClock();
        this.internalEmbraceLogger.logDeveloper("Embrace", "Starting SDK for framework " + appFramework.name());
        long startTime = this.sdkClock.now();
        BuildInfo buildInfo = BuildInfo.fromResources(coreModule.getResources(), coreModule.getContext().getPackageName());
        this.workerThreadModule = (WorkerThreadModule)this.workerThreadModuleSupplier.invoke();
        EssentialServiceModuleImpl essentialServiceModule = new EssentialServiceModuleImpl(coreModule, systemServiceModule, this.workerThreadModule, buildInfo, customAppId, enableIntegrationTesting, (Function0<Unit>)((Function0)() -> {
            Embrace.getImpl().stop();
            return null;
        }));
        this.activityService = essentialServiceModule.getActivityService();
        this.preferencesService = essentialServiceModule.getPreferencesService();
        this.metadataService = essentialServiceModule.getMetadataService();
        this.configService = essentialServiceModule.getConfigService();
        this.serviceRegistry.registerServices(this.activityService, this.preferencesService, this.metadataService, this.configService);
        this.metadataService.precomputeValues();
        DataCaptureServiceModuleImpl dataCaptureServiceModule = new DataCaptureServiceModuleImpl(coreModule, systemServiceModule, essentialServiceModule, this.workerThreadModule);
        this.webViewService = dataCaptureServiceModule.getWebviewService();
        MemoryService memoryService2 = dataCaptureServiceModule.getMemoryService();
        ((EmbraceActivityService)essentialServiceModule.getActivityService()).setMemoryService(dataCaptureServiceModule.getMemoryService());
        this.serviceRegistry.registerServices(this.webViewService, memoryService2);
        AnrModuleImpl anrModule = new AnrModuleImpl(coreModule, systemServiceModule, essentialServiceModule);
        this.anrService = anrServiceImpl = anrModule.getAnrService();
        this.serviceRegistry.registerService(this.anrService);
        anrServiceImpl.finishInitialization(essentialServiceModule.getConfigService());
        this.serviceRegistry.registerService(dataCaptureServiceModule.getPowerSaveModeService());
        SdkObservabilityModuleImpl sdkObservabilityModule = new SdkObservabilityModuleImpl(coreModule, essentialServiceModule);
        this.exceptionsService = sdkObservabilityModule.getExceptionService();
        this.serviceRegistry.registerService(this.exceptionsService);
        this.internalEmbraceLogger.addLoggerAction(sdkObservabilityModule.getInternalErrorLogger());
        this.serviceRegistry.registerService(dataCaptureServiceModule.getNetworkConnectivityService());
        DeliveryModule deliveryModule = (DeliveryModule)this.deliveryModuleSupplier.invoke((Object)coreModule, (Object)essentialServiceModule, (Object)dataCaptureServiceModule, (Object)this.workerThreadModule);
        this.serviceRegistry.registerService(deliveryModule.getDeliveryService());
        EmbraceSessionProperties sessionProperties = new EmbraceSessionProperties(essentialServiceModule.getPreferencesService(), coreModule.getLogger(), essentialServiceModule.getConfigService());
        if (!essentialServiceModule.getConfigService().isSdkEnabled()) {
            this.internalEmbraceLogger.logDeveloper("Embrace", "the SDK is disabled");
            this.stop();
            return;
        }
        this.exceptionsService.setConfigService(this.configService);
        this.breadcrumbService = dataCaptureServiceModule.getBreadcrumbService();
        this.pushNotificationService = dataCaptureServiceModule.getPushNotificationService();
        this.serviceRegistry.registerServices(this.breadcrumbService, this.pushNotificationService, dataCaptureServiceModule.getAppExitInfoService());
        this.userService = essentialServiceModule.getUserService();
        this.serviceRegistry.registerServices(this.userService);
        CustomerLogModuleImpl customerLogModule = new CustomerLogModuleImpl(essentialServiceModule, coreModule, deliveryModule, sessionProperties, dataCaptureServiceModule, this.workerThreadModule);
        this.remoteLogger = customerLogModule.getRemoteLogger();
        this.networkCaptureService = customerLogModule.getNetworkCaptureService();
        this.networkLoggingService = customerLogModule.getNetworkLoggingService();
        this.serviceRegistry.registerServices(customerLogModule.getScreenshotService(), this.remoteLogger, this.networkCaptureService, this.networkLoggingService);
        NativeModuleImpl nativeModule = new NativeModuleImpl(coreModule, essentialServiceModule, deliveryModule, sessionProperties, this.workerThreadModule);
        DataContainerModuleImpl dataContainerModule = new DataContainerModuleImpl(essentialServiceModule, coreModule, dataCaptureServiceModule, anrModule, customerLogModule, deliveryModule, nativeModule, sessionProperties, this.workerThreadModule, startTime);
        this.spansService = dataContainerModule.getSpansService();
        this.eventService = dataContainerModule.getEventService();
        this.serviceRegistry.registerServices(dataContainerModule.getPerformanceInfoService(), this.spansService, this.eventService);
        this.ndkService = nativeModule.getNdkService();
        this.nativeThreadSampler = nativeModule.getNativeThreadSamplerService();
        this.nativeThreadSamplerInstaller = nativeModule.getNativeThreadSamplerInstaller();
        this.serviceRegistry.registerServices(this.ndkService, this.nativeThreadSampler);
        if (this.nativeThreadSampler != null && this.nativeThreadSamplerInstaller != null) {
            this.nativeThreadSampler.setupNativeSampler();
            if (coreModule.getAppFramework() == Embrace.AppFramework.UNITY && EmbraceNativeThreadSamplerServiceKt.isUnityMainThread()) {
                this.sampleCurrentThreadDuringAnrs();
            }
        } else {
            this.internalEmbraceLogger.logDeveloper("Embrace", "Failed to load SO file embrace-native");
        }
        SessionModuleImpl sessionModule = new SessionModuleImpl(coreModule, essentialServiceModule, nativeModule, dataContainerModule, deliveryModule, sessionProperties, dataCaptureServiceModule, customerLogModule, sdkObservabilityModule, this.workerThreadModule);
        this.sessionService = sessionModule.getSessionService();
        this.backgroundActivityService = sessionModule.getBackgroundActivityService();
        this.serviceRegistry.registerServices(this.sessionService, this.backgroundActivityService);
        if (this.backgroundActivityService != null) {
            this.internalEmbraceLogger.logInfo("Background activity capture enabled");
        } else {
            this.internalEmbraceLogger.logInfo("Background activity capture disabled");
        }
        CrashModuleImpl crashModule = new CrashModuleImpl(essentialServiceModule, deliveryModule, nativeModule, sessionModule, anrModule, dataContainerModule, coreModule);
        this.loadCrashVerifier(crashModule, this.workerThreadModule);
        Thread.setDefaultUncaughtExceptionHandler(crashModule.getAutomaticVerificationExceptionHandler());
        this.serviceRegistry.registerService(crashModule.getCrashService());
        StrictModeService strictModeService2 = dataCaptureServiceModule.getStrictModeService();
        this.serviceRegistry.registerService(strictModeService2);
        strictModeService2.start();
        this.serviceRegistry.registerService(dataCaptureServiceModule.getThermalStatusService());
        ActivityLifecycleBreadcrumbService collector = dataCaptureServiceModule.getActivityLifecycleBreadcrumbService();
        if (collector instanceof Application.ActivityLifecycleCallbacks) {
            coreModule.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)collector);
            this.serviceRegistry.registerService(collector);
        }
        InternalInterfaceModuleImpl internalInterfaceModule = new InternalInterfaceModuleImpl(coreModule, essentialServiceModule, this, crashModule);
        EmbraceInternalInterface embraceInternalInterface2 = internalInterfaceModule.getEmbraceInternalInterface();
        this.reactNativeInternalInterface = internalInterfaceModule.getReactNativeInternalInterface();
        this.unityInternalInterface = internalInterfaceModule.getUnityInternalInterface();
        this.flutterInternalInterface = internalInterfaceModule.getFlutterInternalInterface();
        String startMsg = "Embrace SDK started. App ID: " + this.configService.getSdkModeBehavior().getAppId() + " Version: " + "5.22.0";
        this.internalEmbraceLogger.logInfo(startMsg);
        NetworkBehavior networkBehavior2 = this.configService.getNetworkBehavior();
        if (networkBehavior2.isNativeNetworkingMonitoringEnabled()) {
            this.internalEmbraceLogger.logDeveloper("Embrace", "Native Networking Monitoring enabled");
            StreamHandlerFactoryInstaller.registerFactory(networkBehavior2.isRequestContentLengthCaptureEnabled());
        }
        long endTime = this.sdkClock.now();
        this.started.set(true);
        this.workerThreadModule.backgroundWorker(WorkerName.BACKGROUND_REGISTRATION).submit(() -> {
            ((EmbraceSpansService)this.spansService).initializeService(TimeUnit.MILLISECONDS.toNanos(startTime), TimeUnit.MILLISECONDS.toNanos(endTime));
            return null;
        });
        long startupDuration = endTime - startTime;
        ((EmbraceSessionService)this.sessionService).setSdkStartupDuration(startupDuration);
        this.internalEmbraceLogger.logDeveloper("Embrace", "Startup duration: " + startupDuration + " millis");
        this.serviceRegistry.closeRegistration();
        this.serviceRegistry.registerActivityListeners(this.activityService);
        this.serviceRegistry.registerConfigListeners(this.configService);
        this.serviceRegistry.registerMemoryCleanerListeners(essentialServiceModule.getMemoryCleanerService());
        if (!this.activityService.isInBackground()) {
            this.internalEmbraceLogger.logDeveloper("Embrace", "Sending startup moment");
            this.eventService.sendStartupMoment();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean setAppId(@NonNull String appId2) {
        if (this.isStarted()) {
            this.internalEmbraceLogger.logError("You must set the custom app ID before the SDK is started.");
            return false;
        }
        if (appId2 == null || appId2.isEmpty()) {
            this.internalEmbraceLogger.logError("App ID cannot be null or empty.");
            return false;
        }
        if (!MetadataUtils.isValidAppId(appId2)) {
            this.internalEmbraceLogger.logError("Invalid app ID. Must be a 5-character string with characters from the set [A-Za-z0-9], but it was \"" + appId2 + "\".");
            return false;
        }
        customAppId = appId2;
        this.internalEmbraceLogger.logDeveloper("Embrace", "App Id set");
        return true;
    }

    void stop() {
        if (this.started.compareAndSet(true, false)) {
            this.internalEmbraceLogger.logInfo("Shutting down Embrace SDK.");
            try {
                this.application = null;
                this.internalEmbraceLogger.logDeveloper("Embrace", "Attempting to close services...");
                this.serviceRegistry.close();
                this.internalEmbraceLogger.logDeveloper("Embrace", "Services closed");
                this.workerThreadModule.close();
            }
            catch (Exception ex) {
                this.internalEmbraceLogger.logError("Error while shutting down Embrace SDK", ex);
            }
        }
    }

    public void setUserIdentifier(@Nullable String userId) {
        if (this.isStarted()) {
            if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.USER)) {
                this.internalEmbraceLogger.logWarning("User updates are disabled, ignoring identifier update.");
                return;
            }
            this.userService.setUserIdentifier(userId);
            this.ndkService.onUserInfoUpdate();
            if (userId != null) {
                this.internalEmbraceLogger.logDebug("Set user ID to " + userId);
            } else {
                this.internalEmbraceLogger.logDebug("Cleared user ID by setting to null");
            }
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("set user identifier");
        }
    }

    public void clearUserIdentifier() {
        if (this.isStarted()) {
            if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.USER)) {
                this.internalEmbraceLogger.logWarning("User updates are disabled, ignoring identifier update.");
                return;
            }
            this.userService.clearUserIdentifier();
            this.internalEmbraceLogger.logDebug("Cleared user ID");
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("clear user identifier");
        }
    }

    public void setUserEmail(@Nullable String email) {
        if (this.isStarted()) {
            if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.USER)) {
                this.internalEmbraceLogger.logWarning("User updates are disabled, ignoring email update.");
                return;
            }
            this.userService.setUserEmail(email);
            this.ndkService.onUserInfoUpdate();
            if (email != null) {
                this.internalEmbraceLogger.logDebug("Set email to " + email);
            } else {
                this.internalEmbraceLogger.logDebug("Cleared email by setting to null");
            }
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("clear user email");
        }
    }

    public void clearUserEmail() {
        if (this.isStarted()) {
            if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.USER)) {
                this.internalEmbraceLogger.logWarning("User updates are disabled, ignoring email update.");
                return;
            }
            this.userService.clearUserEmail();
            this.ndkService.onUserInfoUpdate();
            this.internalEmbraceLogger.logDebug("Cleared email");
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("clear user email");
        }
    }

    public void setUserAsPayer() {
        if (this.isStarted()) {
            if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.USER)) {
                this.internalEmbraceLogger.logWarning("User updates are disabled, ignoring payer user update.");
                return;
            }
            this.userService.setUserAsPayer();
            this.ndkService.onUserInfoUpdate();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("set user as payer");
        }
    }

    public void clearUserAsPayer() {
        if (this.isStarted()) {
            if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.USER)) {
                this.internalEmbraceLogger.logWarning("User updates are disabled, ignoring payer user update.");
                return;
            }
            this.userService.clearUserAsPayer();
            this.ndkService.onUserInfoUpdate();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("clear user as payer");
        }
    }

    public void setUserPersona(@NonNull String persona) {
        if (this.isStarted()) {
            if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.USER)) {
                this.internalEmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.setUserPersona(persona);
            this.ndkService.onUserInfoUpdate();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("set user persona");
        }
    }

    public void clearUserPersona(@NonNull String persona) {
        if (this.isStarted()) {
            if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.USER)) {
                this.internalEmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.clearUserPersona(persona);
            this.ndkService.onUserInfoUpdate();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("clear user persona");
        }
    }

    public void clearAllUserPersonas() {
        if (this.isStarted()) {
            if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.USER)) {
                this.internalEmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.clearAllUserPersonas();
            this.ndkService.onUserInfoUpdate();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("clear user personas");
        }
    }

    public boolean addSessionProperty(@NonNull String key, @NonNull String value, boolean permanent) {
        if (this.isStarted()) {
            return this.sessionService.addProperty(key, value, permanent);
        }
        this.internalEmbraceLogger.logSDKNotInitialized("cannot add session property");
        return false;
    }

    public boolean removeSessionProperty(@NonNull String key) {
        if (this.isStarted()) {
            return this.sessionService.removeProperty(key);
        }
        this.internalEmbraceLogger.logSDKNotInitialized("remove session property");
        return false;
    }

    @Nullable
    public Map<String, String> getSessionProperties() {
        if (this.isStarted()) {
            return this.sessionService.getProperties();
        }
        this.internalEmbraceLogger.logSDKNotInitialized("gets session properties");
        return null;
    }

    public void setUsername(@Nullable String username) {
        if (this.isStarted()) {
            if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.USER)) {
                this.internalEmbraceLogger.logWarning("User updates are disabled, ignoring username update.");
                return;
            }
            this.userService.setUsername(username);
            this.ndkService.onUserInfoUpdate();
            if (username != null) {
                this.internalEmbraceLogger.logDebug("Set username to " + username);
            } else {
                this.internalEmbraceLogger.logDebug("Cleared username by setting to null");
            }
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("set username");
        }
    }

    public void clearUsername() {
        if (this.isStarted()) {
            if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.USER)) {
                this.internalEmbraceLogger.logWarning("User updates are disabled, ignoring username update.");
                return;
            }
            this.userService.clearUsername();
            this.ndkService.onUserInfoUpdate();
            this.internalEmbraceLogger.logDebug("Cleared username");
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("clear username");
        }
    }

    public void startEvent(@NonNull String name, @Nullable String identifier, boolean allowScreenshot, @Nullable Map<String, Object> properties) {
        if (this.isStarted()) {
            this.eventService.startEvent(name, identifier, allowScreenshot, this.normalizeProperties(properties));
            this.onActivityReported();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("log event");
        }
    }

    public void endEvent(@NonNull String name, @Nullable String identifier, @Nullable Map<String, Object> properties) {
        if (this.isStarted()) {
            this.eventService.endEvent(name, identifier, this.normalizeProperties(properties));
            this.onActivityReported();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("log event");
        }
    }

    public void endAppStartup(@Nullable Map<String, Object> properties) {
        this.endEvent("_startup", null, properties);
    }

    @NonNull
    public String getTraceIdHeader() {
        if (this.isStarted() && this.configService != null) {
            return this.configService.getNetworkBehavior().getTraceIdHeader();
        }
        return "x-emb-trace-id";
    }

    public void logNetworkRequest(@NonNull String url2, int httpMethod, long startTime, long endTime, int bytesSent, int bytesReceived, int statusCode, @Nullable String error) {
        EmbraceNetworkRequestV2.Builder requestBuilder = EmbraceNetworkRequestV2.newBuilder().withUrl(url2).withHttpMethod(httpMethod).withStartTime(startTime).withEndTime(endTime).withBytesIn(bytesReceived).withBytesOut(bytesSent).withResponseCode(statusCode);
        if (error != null && !error.isEmpty()) {
            this.internalEmbraceLogger.logDeveloper("Embrace", "Log network with error: " + error);
            requestBuilder.withError(new Throwable(error));
        } else {
            this.internalEmbraceLogger.logDeveloper("Embrace", "Log network request without errors");
        }
        this.logNetworkRequest(requestBuilder.build());
    }

    public void logNetworkRequest(@NonNull EmbraceNetworkRequestV2 request) {
        if (this.isStarted()) {
            if (request == null) {
                this.internalEmbraceLogger.logDeveloper("Embrace", "Request is null");
                return;
            }
            if (!request.canSend()) {
                this.internalEmbraceLogger.logDeveloper("Embrace", "Request can't be sent");
                return;
            }
            if (request.getError() != null) {
                this.networkLoggingService.logNetworkError(request.getUrl(), request.getHttpMethod(), request.getStartTime(), request.getEndTime() != null ? request.getEndTime() : 0L, request.getError().getClass().getCanonicalName(), request.getError().getLocalizedMessage(), request.getTraceId(), null);
            } else {
                this.networkLoggingService.logNetworkCall(request.getUrl(), request.getHttpMethod(), request.getResponseCode() != null ? request.getResponseCode() : 0, request.getStartTime(), request.getEndTime() != null ? request.getEndTime() : 0L, request.getBytesOut(), request.getBytesIn(), request.getTraceId(), null);
            }
            this.onActivityReported();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("log network request");
        }
    }

    public void logNetworkRequest(@NonNull EmbraceNetworkRequest request) {
        if (this.isStarted()) {
            if (request == null) {
                this.internalEmbraceLogger.logDeveloper("Embrace", "Request is null");
                return;
            }
            if (!request.canSend()) {
                this.internalEmbraceLogger.logDeveloper("Embrace", "Request can't be sent");
                return;
            }
            if (request.getError() != null) {
                this.networkLoggingService.logNetworkError(request.getUrl(), request.getHttpMethod(), request.getStartTime(), request.getEndTime() != null ? request.getEndTime() : 0L, request.getError().getClass().getCanonicalName(), request.getError().getLocalizedMessage(), request.getTraceId(), null);
            } else {
                this.networkLoggingService.logNetworkCall(request.getUrl(), request.getHttpMethod(), request.getResponseCode() != null ? request.getResponseCode() : 0, request.getStartTime(), request.getEndTime() != null ? request.getEndTime() : 0L, request.getBytesOut(), request.getBytesIn(), request.getTraceId(), null);
            }
            this.onActivityReported();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("log network request");
        }
    }

    public void logNetworkCall(@NonNull String url2, @NonNull HttpMethod httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived, @Nullable String traceId, @Nullable NetworkCaptureData networkCaptureData) {
        if (ApkToolsConfig.IS_NETWORK_CAPTURE_DISABLED) {
            return;
        }
        if (this.isStarted()) {
            this.internalEmbraceLogger.logDeveloper("Embrace", "Attempting to log network call");
            if (!this.configService.getNetworkBehavior().isUrlEnabled(url2)) {
                this.internalEmbraceLogger.logWarning("Recording of network calls disabled for url: " + url2);
                return;
            }
            this.internalEmbraceLogger.logDeveloper("Embrace", "Log network call");
            this.networkLoggingService.logNetworkCall(url2, httpMethod.name(), statusCode, startTime, endTime, bytesSent, bytesReceived, traceId, networkCaptureData);
            this.onActivityReported();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("log network call");
        }
    }

    public void logNetworkClientError(@NonNull String url2, @NonNull HttpMethod httpMethod, long startTime, long endTime, @NonNull String errorType, @NonNull String errorMessage, @Nullable String traceId, @Nullable NetworkCaptureData networkCaptureData) {
        this.internalEmbraceLogger.logDeveloper("Embrace", "Attempting to log network client error");
        if (this.isStarted()) {
            if (!this.configService.getNetworkBehavior().isUrlEnabled(url2)) {
                this.internalEmbraceLogger.logWarning("Recording of network calls disabled for url: " + url2);
                return;
            }
            this.internalEmbraceLogger.logDeveloper("Embrace", "Log network client error");
            this.networkLoggingService.logNetworkError(url2, httpMethod.name(), startTime, endTime, errorType, errorMessage, traceId, networkCaptureData);
            this.onActivityReported();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("log network error");
        }
    }

    void logMessage(@NonNull EmbraceEvent.Type type2, @NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot, @Nullable StackTraceElement[] stackTraceElements, @Nullable String customStackTrace, @NonNull LogExceptionType logExceptionType, @Nullable String context2, @Nullable String library) {
        this.logMessage(type2, message, properties, allowScreenshot, stackTraceElements, customStackTrace, logExceptionType, context2, library, null, null);
    }

    void logMessage(@NonNull EmbraceEvent.Type type2, @NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot, @Nullable StackTraceElement[] stackTraceElements, @Nullable String customStackTrace, @NonNull LogExceptionType logExceptionType, @Nullable String context2, @Nullable String library, @Nullable String exceptionName, @Nullable String exceptionMessage) {
        this.internalEmbraceLogger.logDeveloper("Embrace", "Attempting to log message");
        if (this.isStarted()) {
            try {
                this.remoteLogger.log(message, type2, allowScreenshot, logExceptionType, this.normalizeProperties(properties), stackTraceElements, customStackTrace, this.appFramework, context2, library, exceptionName, exceptionMessage);
                this.onActivityReported();
            }
            catch (Exception ex) {
                this.internalEmbraceLogger.logDebug("Failed to log message using Embrace SDK.", ex);
            }
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("log message");
        }
    }

    public void logBreadcrumb(@NonNull String message) {
        this.internalEmbraceLogger.logDeveloper("Embrace", "Attempting to log breadcrumb");
        if (this.isStarted()) {
            this.breadcrumbService.logCustom(message, this.sdkClock.now());
            this.onActivityReported();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("log breadcrumb");
        }
    }

    public void logRnAction(@NonNull String name, long startTime, long endTime, @NonNull Map<String, Object> properties, int bytesSent, @NonNull String output) {
        if (this.isStarted()) {
            this.breadcrumbService.logRnAction(name, startTime, endTime, properties, bytesSent, output);
        } else {
            this.internalEmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log breadcrumb.");
        }
    }

    @InternalApi
    public void logUnhandledJsException(@NonNull String name, @NonNull String message, @Nullable String type2, @Nullable String stacktrace) {
        if (this.reactNativeInternalInterface != null) {
            this.reactNativeInternalInterface.logUnhandledJsException(name, message, type2, stacktrace);
            this.onActivityReported();
        }
    }

    @InternalApi
    public void logUnityException(@Nullable String name, @NonNull String message, @Nullable String stacktrace, @NonNull LogExceptionType logExceptionType) {
        if (this.unityInternalInterface != null) {
            String sanitizedName;
            String string2 = sanitizedName = name == null ? "" : name;
            if (logExceptionType == LogExceptionType.UNHANDLED) {
                this.unityInternalInterface.logUnhandledUnityException(sanitizedName, message, stacktrace);
            } else if (logExceptionType == LogExceptionType.HANDLED) {
                this.unityInternalInterface.logHandledUnityException(sanitizedName, message, stacktrace);
            }
            this.onActivityReported();
        }
    }

    public void setReactNativeVersionNumber(@NonNull String version) {
        if (this.reactNativeInternalInterface != null) {
            this.reactNativeInternalInterface.setReactNativeVersionNumber(version);
        }
    }

    public void setJavaScriptPatchNumber(@NonNull String number) {
        if (this.reactNativeInternalInterface != null) {
            this.reactNativeInternalInterface.setJavaScriptPatchNumber(number);
        }
    }

    public void setReactNativeSdkVersion(@NonNull String version) {
        if (this.isStarted()) {
            this.metadataService.setRnSdkVersion(version);
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("setReactNativeSDKVersion");
        }
    }

    public void setJavaScriptBundleURL(@NonNull String url2) {
        if (this.reactNativeInternalInterface != null) {
            this.reactNativeInternalInterface.setJavaScriptBundleUrl((Context)this.application, url2);
        }
    }

    @InternalApi
    public void setUnityMetaData(@NonNull String unityVersion, @NonNull String buildGuid, @Nullable String unitySdkVersion) {
        if (this.unityInternalInterface != null) {
            this.unityInternalInterface.setUnityMetaData(unityVersion, buildGuid, unitySdkVersion);
        }
    }

    @InternalApi
    public void logInternalError(@Nullable String message, @Nullable String details) {
        if (this.isStarted()) {
            if (message == null) {
                return;
            }
            String msg = details != null ? message + ": " + details : message;
            this.exceptionsService.handleInternalError(new InternalErrorLogger.DartError(msg));
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("logInternalError");
        }
    }

    @InternalApi
    public void logDartError(@Nullable String stack, @Nullable String name, @Nullable String message, @Nullable String context2, @Nullable String library, @NonNull LogExceptionType logExceptionType) {
        if (this.flutterInternalInterface != null) {
            if (logExceptionType == LogExceptionType.HANDLED) {
                this.flutterInternalInterface.logHandledDartError(stack, name, message, context2, library);
            } else if (logExceptionType == LogExceptionType.UNHANDLED) {
                this.flutterInternalInterface.logUnhandledDartError(stack, name, message, context2, library);
            }
            this.onActivityReported();
        }
    }

    @InternalApi
    public void setEmbraceFlutterSdkVersion(@Nullable String version) {
        if (this.flutterInternalInterface != null) {
            this.flutterInternalInterface.setEmbraceFlutterSdkVersion(version);
        }
    }

    @InternalApi
    public void setDartVersion(@Nullable String version) {
        if (this.flutterInternalInterface != null) {
            this.flutterInternalInterface.setDartVersion(version);
        }
    }

    @Deprecated
    public void addConnectionQualityListener(@NonNull ConnectionQualityListener listener) {
        this.internalEmbraceLogger.logWarning("Warning: failed to remove connection quality listener. The signal quality service is deprecated.");
    }

    @Deprecated
    public void removeConnectionQualityListener(@NonNull ConnectionQualityListener listener) {
        this.internalEmbraceLogger.logWarning("Warning: failed to remove connection quality listener. The signal quality service is deprecated.");
    }

    public synchronized void endSession(boolean clearUserInfo) {
        if (this.isStarted()) {
            SessionBehavior sessionBehavior2 = this.configService.getSessionBehavior();
            if (sessionBehavior2.getMaxSessionSecondsAllowed() != null) {
                this.internalEmbraceLogger.logWarning("Can't close the session, automatic session close enabled.");
                return;
            }
            if (sessionBehavior2.isAsyncEndEnabled()) {
                this.internalEmbraceLogger.logWarning("Can't close the session, session ending in background thread enabled.");
                return;
            }
            if (clearUserInfo) {
                this.userService.clearAllUserInfo();
                this.ndkService.onUserInfoUpdate();
            }
            this.sessionService.triggerStatelessSessionEnd(Session.SessionLifeEventType.MANUAL);
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("end session");
        }
    }

    @NonNull
    public String getDeviceId() {
        return this.preferencesService.getDeviceIdentifier();
    }

    public void throwException() {
        throw new RuntimeException("EmbraceException", new Throwable("Embrace test exception"));
    }

    public boolean startFragment(@NonNull String name) {
        if (this.isStarted()) {
            this.internalEmbraceLogger.logDeveloper("Embrace", "Starting fragment: " + name);
            return this.breadcrumbService.startFragment(name);
        }
        this.internalEmbraceLogger.logDeveloper("Embrace", "Cannot start fragment, SDK is not started");
        return false;
    }

    public boolean endFragment(@NonNull String name) {
        if (this.isStarted()) {
            this.internalEmbraceLogger.logDeveloper("Embrace", "Ending fragment: " + name);
            return this.breadcrumbService.endFragment(name);
        }
        this.internalEmbraceLogger.logDeveloper("Embrace", "Cannot end fragment, SDK is not started");
        return false;
    }

    @InternalApi
    public void sampleCurrentThreadDuringAnrs() {
        try {
            AnrService service = this.anrService;
            if (service != null && this.nativeThreadSamplerInstaller != null) {
                this.nativeThreadSamplerInstaller.monitorCurrentThread(this.nativeThreadSampler, this.configService, service);
            } else {
                this.internalEmbraceLogger.logDeveloper("Embrace", "nativeThreadSamplerInstaller not started, cannot sample current thread");
            }
        }
        catch (Exception exc) {
            this.internalEmbraceLogger.logError("Failed to sample current thread during ANRs", exc);
        }
    }

    void logView(String screen) {
        if (this.isStarted()) {
            this.breadcrumbService.logView(screen, this.sdkClock.now());
            this.onActivityReported();
        }
        this.internalEmbraceLogger.logDeveloper("Embrace", "SDK not started, cannot log view");
    }

    public void logRnView(@NonNull String screen) {
        if (this.appFramework != Embrace.AppFramework.REACT_NATIVE) {
            InternalStaticEmbraceLogger.logWarning("[Embrace] logRnView is only available on React Native");
            return;
        }
        this.logView(screen);
    }

    void logWebView(String url2) {
        if (this.isStarted()) {
            this.breadcrumbService.logWebView(url2, this.sdkClock.now());
            this.onActivityReported();
        }
        this.internalEmbraceLogger.logDeveloper("Embrace", "SDK not started, cannot log view");
    }

    void forceLogView(String screen) {
        if (this.isStarted()) {
            this.breadcrumbService.forceLogView(screen, this.sdkClock.now());
            this.onActivityReported();
        } else {
            this.internalEmbraceLogger.logDeveloper("Embrace", "SDK not started, cannot force log view");
        }
    }

    void logTap(Pair<Float, Float> point, String elementName, TapBreadcrumb.TapBreadcrumbType type2) {
        if (this.isStarted()) {
            this.breadcrumbService.logTap(point, elementName, this.sdkClock.now(), type2);
            this.onActivityReported();
        } else {
            this.internalEmbraceLogger.logDeveloper("Embrace", "SDK not started, cannot log tap");
        }
    }

    @InternalApi
    @Nullable
    public ConfigService getConfigService() {
        if (this.isStarted()) {
            return this.configService;
        }
        this.internalEmbraceLogger.logSDKNotInitialized("get local config");
        return null;
    }

    EventService getEventService() {
        return this.eventService;
    }

    ActivityService getActivityService() {
        return this.activityService;
    }

    EmbraceRemoteLogger getRemoteLogger() {
        return this.remoteLogger;
    }

    EmbraceInternalErrorService getExceptionsService() {
        return this.exceptionsService;
    }

    MetadataService getMetadataService() {
        return this.metadataService;
    }

    SessionService getSessionService() {
        return this.sessionService;
    }

    Application getApplication() {
        return this.application;
    }

    @Nullable
    private Map<String, Object> normalizeProperties(@Nullable Map<String, Object> properties) {
        HashMap<String, Object> normalizedProperties = new HashMap();
        if (properties != null) {
            try {
                this.internalEmbraceLogger.logDeveloper("Embrace", "normalizing properties");
                normalizedProperties = PropertyUtils.sanitizeProperties(properties);
            }
            catch (Exception e) {
                this.internalEmbraceLogger.logError("Exception occurred while normalizing the properties.", e);
            }
            return normalizedProperties;
        }
        return null;
    }

    @Nullable
    ReactNativeInternalInterface getReactNativeInternalInterface() {
        return this.reactNativeInternalInterface;
    }

    @Nullable
    UnityInternalInterface getUnityInternalInterface() {
        return this.unityInternalInterface;
    }

    @Nullable
    FlutterInternalInterface getFlutterInternalInterface() {
        return this.flutterInternalInterface;
    }

    public void installUnityThreadSampler() {
        if (this.isStarted()) {
            this.sampleCurrentThreadDuringAnrs();
        } else {
            this.internalEmbraceLogger.logSDKNotInitialized("installUnityThreadSampler");
        }
    }

    void logPushNotification(@Nullable String title, @Nullable String body, @Nullable String topic, @Nullable String id, @Nullable Integer notificationPriority, Integer messageDeliveredPriority, PushNotificationBreadcrumb.NotificationType type2) {
        this.pushNotificationService.logPushNotification(title, body, topic, id, notificationPriority, messageDeliveredPriority, type2);
        this.onActivityReported();
    }

    private void onActivityReported() {
        if (this.backgroundActivityService != null) {
            this.backgroundActivityService.save();
        }
    }

    public boolean shouldCaptureNetworkCall(String url2, String method) {
        return !this.networkCaptureService.getNetworkCaptureRules(url2, method).isEmpty();
    }

    public void setProcessStartedByNotification() {
        this.eventService.setProcessStartedByNotification();
    }

    public void trackWebViewPerformance(@NonNull String tag, @NonNull String message) {
        if (this.configService.getWebViewVitalsBehavior().isWebViewVitalsEnabled()) {
            this.webViewService.collectWebData(tag, message);
        }
    }

    @NonNull
    public Embrace.LastRunEndState getLastRunEndState() {
        if (this.isStarted() && this.crashVerifier != null) {
            if (this.crashVerifier.didLastRunCrash()) {
                return Embrace.LastRunEndState.CRASH;
            }
            return Embrace.LastRunEndState.CLEAN_EXIT;
        }
        return Embrace.LastRunEndState.INVALID;
    }

    private void loadCrashVerifier(CrashModule crashModule, WorkerThreadModule workerThreadModule) {
        this.crashVerifier = crashModule.getLastRunCrashVerifier();
        this.crashVerifier.readAndCleanMarkerAsync(workerThreadModule.backgroundWorker(WorkerName.BACKGROUND_REGISTRATION));
    }
}

