/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.EmbraceInternalErrorService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/embrace/android/embracesdk/EmbraceMemoryCleanerService;", "Lio/embrace/android/embracesdk/MemoryCleanerService;", "()V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lio/embrace/android/embracesdk/MemoryCleanerListener;", "getListeners$annotations", "getListeners", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "addListener", "", "listener", "cleanServicesCollections", "metadataService", "Lio/embrace/android/embracesdk/MetadataService;", "exceptionService", "Lio/embrace/android/embracesdk/EmbraceInternalErrorService;", "embrace-android-sdk_release"})
public final class EmbraceMemoryCleanerService
implements MemoryCleanerService {
    @NotNull
    private final CopyOnWriteArrayList<MemoryCleanerListener> listeners = new CopyOnWriteArrayList();

    @VisibleForTesting
    public static /* synthetic */ void getListeners$annotations() {
    }

    @NotNull
    public final CopyOnWriteArrayList<MemoryCleanerListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanServicesCollections(@NotNull MetadataService metadataService2, @NotNull EmbraceInternalErrorService exceptionService2) {
        void className$iv;
        Intrinsics.checkNotNullParameter((Object)metadataService2, (String)"metadataService");
        Intrinsics.checkNotNullParameter((Object)exceptionService2, (String)"exceptionService");
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string2 = "EmbraceMemoryCleanerService";
        String msg$iv = "Clean services collections";
        boolean $i$f$logDeveloper = false;
        companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        Collection collection$iv = this.listeners;
        boolean $i$f$stream = false;
        Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            MemoryCleanerListener listener = (MemoryCleanerListener)element$iv$iv;
            boolean bl = false;
            try {
                listener.cleanCollections();
            }
            catch (Exception ex) {
                InternalStaticEmbraceLogger.Companion companion2 = InternalStaticEmbraceLogger.Companion;
                String msg$iv2 = "Failed to clean collections on service listener";
                boolean $i$f$logDebug = false;
                companion2.log(msg$iv2, EmbraceLogger.Severity.DEBUG, ex, true);
            }
        }
        exceptionService2.resetExceptionErrorObject();
    }

    @Override
    public void addListener(@NotNull MemoryCleanerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.addIfAbsent(listener);
    }
}

