/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.usage.StorageStatsManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.StatFs;
import android.view.WindowManager;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.BuildInfo;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceCpuInfoDelegate;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceMetadataService;
import io.embrace.android.embracesdk.EmbraceMetadataService$Companion$ofContext$deviceIdentifier$1;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.MetadataUtils;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.payload.AppInfo;
import io.embrace.android.embracesdk.payload.DeviceInfo;
import io.embrace.android.embracesdk.payload.DiskUsage;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Callable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 j2\u00020\u00012\u00020\u0002:\u0001jB\u0089\u0002\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0016\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0014\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013\u0012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013\u0012\b\u0010\"\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010#\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010$\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010%\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010&\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010'\u001a\u0004\u0018\u00010\u0014\u0012\u0006\u0010(\u001a\u00020)\u0012\u0006\u0010*\u001a\u00020+\u0012\u0006\u0010,\u001a\u00020-\u00a2\u0006\u0002\u0010.J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020AH\u0002J\u0010\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020\u001bH\u0007J\b\u0010E\u001a\u00020AH\u0002J\b\u0010F\u001a\u00020AH\u0002J\b\u0010G\u001a\u00020\u0014H\u0016J\b\u0010H\u001a\u00020IH\u0016J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u001bH\u0002J\b\u0010K\u001a\u00020\u0014H\u0016J\b\u0010L\u001a\u00020\u0014H\u0016J\b\u0010M\u001a\u00020\u0014H\u0016J\n\u0010N\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010O\u001a\u00020\u0014H\u0016J\b\u0010P\u001a\u00020QH\u0016J\u0010\u0010P\u001a\u00020Q2\u0006\u0010J\u001a\u00020\u001bH\u0002J\n\u0010R\u001a\u0004\u0018\u000107H\u0016J\n\u0010S\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010T\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010U\u001a\u00020IH\u0016J\b\u0010V\u001a\u00020QH\u0016J\n\u0010W\u001a\u0004\u0018\u00010\u0014H\u0007J\n\u0010X\u001a\u0004\u0018\u00010\u0014H\u0002J\n\u0010Y\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010Z\u001a\u00020\u001bH\u0016J\b\u0010[\u001a\u00020\u001bH\u0016J\u000f\u0010:\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\\J\b\u0010]\u001a\u00020\u001bH\u0016J\b\u0010^\u001a\u00020AH\u0016J\u0012\u0010_\u001a\u00020A2\b\u0010=\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010`\u001a\u00020A2\b\u0010=\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010a\u001a\u00020A2\b\u0010b\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010c\u001a\u00020A2\b\u0010b\u001a\u0004\u0018\u00010\u0014H\u0016J\u001a\u0010d\u001a\u00020A2\u0006\u0010e\u001a\u00020f2\b\u0010g\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010h\u001a\u00020A2\b\u0010b\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010i\u001a\u00020A2\b\u0010=\u001a\u0004\u0018\u00010\u0014H\u0002R\u0016\u0010/\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00103\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00101R\u0010\u00105\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010:\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010;R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lio/embrace/android/embracesdk/EmbraceMetadataService;", "Lio/embrace/android/embracesdk/MetadataService;", "Lio/embrace/android/embracesdk/ActivityListener;", "windowManager", "Landroid/view/WindowManager;", "packageManager", "Landroid/content/pm/PackageManager;", "storageStatsManager", "Landroid/app/usage/StorageStatsManager;", "activityManager", "Landroid/app/ActivityManager;", "buildInfo", "Lio/embrace/android/embracesdk/BuildInfo;", "configProvider", "Lkotlin/Function0;", "Lio/embrace/android/embracesdk/config/ConfigService;", "applicationInfo", "Landroid/content/pm/ApplicationInfo;", "deviceId", "Lkotlin/Lazy;", "", "packageName", "appVersionName", "appVersionCode", "appFramework", "Lio/embrace/android/embracesdk/Embrace$AppFramework;", "appUpdated", "", "osUpdated", "preferencesService", "Lio/embrace/android/embracesdk/PreferencesService;", "activityService", "Lio/embrace/android/embracesdk/ActivityService;", "reactNativeBundleId", "javaScriptPatchNumber", "reactNativeVersion", "unityVersion", "buildGuid", "unitySdkVersion", "rnSdkVersion", "metadataRetrieveWorker", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "embraceCpuInfoDelegate", "Lio/embrace/android/embracesdk/EmbraceCpuInfoDelegate;", "(Landroid/view/WindowManager;Landroid/content/pm/PackageManager;Landroid/app/usage/StorageStatsManager;Landroid/app/ActivityManager;Lio/embrace/android/embracesdk/BuildInfo;Lkotlin/jvm/functions/Function0;Landroid/content/pm/ApplicationInfo;Lkotlin/Lazy;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/embrace/android/embracesdk/Embrace$AppFramework;Lkotlin/Lazy;Lkotlin/Lazy;Lio/embrace/android/embracesdk/PreferencesService;Lio/embrace/android/embracesdk/ActivityService;Lkotlin/Lazy;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/embrace/android/embracesdk/worker/BackgroundWorker;Lio/embrace/android/embracesdk/clock/Clock;Lio/embrace/android/embracesdk/EmbraceCpuInfoDelegate;)V", "activeSessionId", "getActiveSessionId", "()Ljava/lang/String;", "cpuName", "dartSdkVersion", "getDartSdkVersion", "dartVersion", "diskUsage", "Lio/embrace/android/embracesdk/payload/DiskUsage;", "egl", "embraceFlutterSdkVersion", "isJailbroken", "Ljava/lang/Boolean;", "screenResolution", "sessionId", "statFs", "Landroid/os/StatFs;", "applicationStartupComplete", "", "asyncRetrieveAdditionalDeviceInfo", "asyncRetrieveDiskUsage", "isAndroid26OrAbove", "asyncRetrieveIsJailbroken", "asyncRetrieveScreenResolution", "getAppId", "getAppInfo", "Lio/embrace/android/embracesdk/payload/AppInfo;", "populateAllFields", "getAppState", "getAppVersionCode", "getAppVersionName", "getCpuName", "getDeviceId", "getDeviceInfo", "Lio/embrace/android/embracesdk/payload/DeviceInfo;", "getDiskUsage", "getEgl", "getEmbraceFlutterSdkVersion", "getLightweightAppInfo", "getLightweightDeviceInfo", "getReactNativeBundleId", "getRnSdkVersion", "getScreenResolution", "isAppUpdated", "isDebug", "()Ljava/lang/Boolean;", "isOsUpdated", "precomputeValues", "removeActiveSessionId", "setActiveSessionId", "setDartVersion", "version", "setEmbraceFlutterSdkVersion", "setReactNativeBundleId", "context", "Landroid/content/Context;", "jsBundleIdUrl", "setRnSdkVersion", "setSessionIdToProcessStateSummary", "Companion", "embrace-android-sdk_release"})
public final class EmbraceMetadataService
implements MetadataService,
ActivityListener {
    private final Lazy<StatFs> statFs;
    private final String javaScriptPatchNumber;
    private final String reactNativeVersion;
    private final String unityVersion;
    private final String buildGuid;
    private final String unitySdkVersion;
    private Lazy<String> reactNativeBundleId;
    private volatile String sessionId;
    private volatile DiskUsage diskUsage;
    private volatile String screenResolution;
    private volatile String cpuName;
    private volatile String egl;
    private volatile Boolean isJailbroken;
    private String embraceFlutterSdkVersion;
    private String dartVersion;
    private String rnSdkVersion;
    private final WindowManager windowManager;
    private final PackageManager packageManager;
    private final StorageStatsManager storageStatsManager;
    private final ActivityManager activityManager;
    private final BuildInfo buildInfo;
    private final Function0<ConfigService> configProvider;
    private final ApplicationInfo applicationInfo;
    private final Lazy<String> deviceId;
    private final String packageName;
    private final String appVersionName;
    private final String appVersionCode;
    private final Embrace.AppFramework appFramework;
    private final Lazy<Boolean> appUpdated;
    private final Lazy<Boolean> osUpdated;
    private final PreferencesService preferencesService;
    private final ActivityService activityService;
    private final BackgroundWorker metadataRetrieveWorker;
    private final Clock clock;
    private final EmbraceCpuInfoDelegate embraceCpuInfoDelegate;
    private static final String UNKNOWN_VALUE = "UNKNOWN";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void precomputeValues() {
        void className$iv;
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string2 = "EmbraceMetadataService";
        String msg$iv = "Precomputing values asynchronously: Jailbroken/ScreenResolution/DiskUsage";
        boolean $i$f$logDeveloper = false;
        companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        this.asyncRetrieveIsJailbroken();
        this.asyncRetrieveScreenResolution();
        this.asyncRetrieveAdditionalDeviceInfo();
        this.asyncRetrieveDiskUsage(Build.VERSION.SDK_INT >= 26);
    }

    /*
     * WARNING - void declaration
     */
    private final void asyncRetrieveAdditionalDeviceInfo() {
        ConfigService configService2 = (ConfigService)this.configProvider.invoke();
        if (!configService2.getAutoDataCaptureBehavior().isNdkEnabled()) {
            void className$iv2;
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String string2 = "EmbraceMetadataService";
            String msg$iv = "NDK not enabled";
            boolean $i$f$logDeveloper = false;
            companion.log('[' + (String)className$iv2 + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            return;
        }
        Object object = this.cpuName;
        boolean className$iv2 = false;
        boolean msg$iv = false;
        if (!(object == null || object.length() == 0)) {
            object = this.egl;
            className$iv2 = false;
            msg$iv = false;
            if (!(object == null || object.length() == 0)) {
                object = InternalStaticEmbraceLogger.Companion;
                String className$iv2 = "EmbraceMetadataService";
                String msg$iv2 = "Additional device info already exists";
                boolean $i$f$logDeveloper = false;
                ((InternalStaticEmbraceLogger.Companion)object).log('[' + className$iv2 + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
                return;
            }
        }
        this.metadataRetrieveWorker.submit((Callable)new Callable<Unit>(this){
            final /* synthetic */ EmbraceMetadataService this$0;

            /*
             * WARNING - void declaration
             */
            public final void call() {
                boolean $i$f$logDeveloper;
                String msg$iv;
                InternalStaticEmbraceLogger.Companion companion;
                void className$iv;
                InternalStaticEmbraceLogger.Companion companion2 = InternalStaticEmbraceLogger.Companion;
                String string2 = "EmbraceMetadataService";
                String msg$iv2 = "Async retrieve cpuName & egl";
                boolean $i$f$logDeveloper22 = false;
                companion2.log('[' + (String)className$iv + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
                String storedCpuName = EmbraceMetadataService.access$getPreferencesService$p(this.this$0).getCpuName();
                String storedEgl = EmbraceMetadataService.access$getPreferencesService$p(this.this$0).getEgl();
                if (storedCpuName != null) {
                    EmbraceMetadataService.access$setCpuName$p(this.this$0, storedCpuName);
                } else {
                    void className$iv2;
                    EmbraceMetadataService.access$setCpuName$p(this.this$0, EmbraceMetadataService.access$getEmbraceCpuInfoDelegate$p(this.this$0).getCpuName());
                    EmbraceMetadataService.access$getPreferencesService$p(this.this$0).setCpuName(EmbraceMetadataService.access$getCpuName$p(this.this$0));
                    companion = InternalStaticEmbraceLogger.Companion;
                    String $i$f$logDeveloper22 = "EmbraceMetadataService";
                    msg$iv = "cpu name computed and stored";
                    $i$f$logDeveloper = false;
                    companion.log('[' + (String)className$iv2 + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                }
                if (storedEgl != null) {
                    EmbraceMetadataService.access$setEgl$p(this.this$0, storedEgl);
                } else {
                    EmbraceMetadataService.access$setEgl$p(this.this$0, EmbraceMetadataService.access$getEmbraceCpuInfoDelegate$p(this.this$0).getElg());
                    EmbraceMetadataService.access$getPreferencesService$p(this.this$0).setEgl(EmbraceMetadataService.access$getEgl$p(this.this$0));
                    companion = InternalStaticEmbraceLogger.Companion;
                    String className$iv2 = "EmbraceMetadataService";
                    msg$iv = "egl computed and stored";
                    $i$f$logDeveloper = false;
                    companion.log('[' + className$iv2 + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                }
            }
            {
                this.this$0 = embraceMetadataService;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void asyncRetrieveScreenResolution() {
        Object object = this.screenResolution;
        boolean bl = false;
        boolean bl2 = false;
        if (!(object == null || object.length() == 0)) {
            void className$iv;
            object = InternalStaticEmbraceLogger.Companion;
            String string2 = "EmbraceMetadataService";
            String msg$iv = "Screen resolution already exists";
            boolean $i$f$logDeveloper = false;
            ((InternalStaticEmbraceLogger.Companion)object).log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            return;
        }
        this.metadataRetrieveWorker.submit((Callable)new Callable<Unit>(this){
            final /* synthetic */ EmbraceMetadataService this$0;

            /*
             * WARNING - void declaration
             */
            public final void call() {
                String className$iv;
                void className$iv2;
                InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                Object object = "EmbraceMetadataService";
                String msg$iv = "Async retrieve screen resolution";
                boolean $i$f$logDeveloper2 = false;
                companion.log('[' + (String)className$iv2 + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                String storedScreenResolution = EmbraceMetadataService.access$getPreferencesService$p(this.this$0).getScreenResolution();
                if (storedScreenResolution != null) {
                    void msg$iv2;
                    object = InternalStaticEmbraceLogger.Companion;
                    msg$iv = "EmbraceMetadataService";
                    String $i$f$logDeveloper2 = "Screen resolution is present, loading from store";
                    boolean $i$f$logDeveloper3 = false;
                    ((InternalStaticEmbraceLogger.Companion)object).log('[' + className$iv + "] " + (String)msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
                    EmbraceMetadataService.access$setScreenResolution$p(this.this$0, storedScreenResolution);
                } else {
                    EmbraceMetadataService.access$setScreenResolution$p(this.this$0, MetadataUtils.getScreenResolution(EmbraceMetadataService.access$getWindowManager$p(this.this$0)));
                    EmbraceMetadataService.access$getPreferencesService$p(this.this$0).setScreenResolution(EmbraceMetadataService.access$getScreenResolution$p(this.this$0));
                    object = InternalStaticEmbraceLogger.Companion;
                    className$iv = "EmbraceMetadataService";
                    String msg$iv3 = "Screen resolution computed and stored";
                    boolean $i$f$logDeveloper4 = false;
                    ((InternalStaticEmbraceLogger.Companion)object).log('[' + className$iv + "] " + msg$iv3, EmbraceLogger.Severity.DEVELOPER, null, true);
                }
            }
            {
                this.this$0 = embraceMetadataService;
            }
        });
    }

    private final void asyncRetrieveIsJailbroken() {
        String className$iv;
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string2 = "EmbraceMetadataService";
        String msg$iv = "Async retrieve Jailbroken";
        boolean $i$f$logDeveloper = false;
        companion.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        if (this.isJailbroken != null) {
            companion = InternalStaticEmbraceLogger.Companion;
            className$iv = "EmbraceMetadataService";
            msg$iv = "Jailbroken already exists";
            $i$f$logDeveloper = false;
            companion.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            return;
        }
        this.metadataRetrieveWorker.submit((Callable)new Callable<Object>(this){
            final /* synthetic */ EmbraceMetadataService this$0;

            /*
             * WARNING - void declaration
             */
            public final Object call() {
                String className$iv;
                boolean $i$f$logDeveloper;
                String msg$iv;
                void className$iv2;
                InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                Object object = "EmbraceMetadataService";
                String msg$iv2 = "Async retrieve jailbroken";
                boolean $i$f$logDeveloper2 = false;
                companion.log('[' + (String)className$iv2 + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
                Boolean storedIsJailbroken = EmbraceMetadataService.access$getPreferencesService$p(this.this$0).getJailbroken();
                if (storedIsJailbroken != null) {
                    object = InternalStaticEmbraceLogger.Companion;
                    msg$iv2 = "EmbraceMetadataService";
                    msg$iv = "Jailbroken is present, loading from store";
                    $i$f$logDeveloper = false;
                    ((InternalStaticEmbraceLogger.Companion)object).log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                    EmbraceMetadataService.access$setJailbroken$p(this.this$0, storedIsJailbroken);
                } else {
                    EmbraceMetadataService.access$setJailbroken$p(this.this$0, MetadataUtils.isJailbroken());
                    EmbraceMetadataService.access$getPreferencesService$p(this.this$0).setJailbroken(EmbraceMetadataService.access$isJailbroken$p(this.this$0));
                    object = InternalStaticEmbraceLogger.Companion;
                    className$iv = "EmbraceMetadataService";
                    msg$iv = "Jailbroken processed and stored";
                    $i$f$logDeveloper = false;
                    ((InternalStaticEmbraceLogger.Companion)object).log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                }
                object = InternalStaticEmbraceLogger.Companion;
                className$iv = "EmbraceMetadataService";
                msg$iv = "Jailbroken: " + EmbraceMetadataService.access$isJailbroken$p(this.this$0);
                $i$f$logDeveloper = false;
                ((InternalStaticEmbraceLogger.Companion)object).log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                return null;
            }
            {
                this.this$0 = embraceMetadataService;
            }
        });
    }

    @VisibleForTesting
    public final void asyncRetrieveDiskUsage(boolean isAndroid26OrAbove) {
        this.metadataRetrieveWorker.submit((Callable)new Callable<Object>(this, isAndroid26OrAbove){
            final /* synthetic */ EmbraceMetadataService this$0;
            final /* synthetic */ boolean $isAndroid26OrAbove;

            /*
             * WARNING - void declaration
             */
            public final Object call() {
                void className$iv;
                Object object;
                Long deviceDiskAppUsage;
                void className$iv2;
                InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                String string2 = "EmbraceMetadataService";
                String msg$iv = "Async retrieve disk usage";
                boolean $i$f$logDeveloper = false;
                companion.log('[' + (String)className$iv2 + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                long free = MetadataUtils.getInternalStorageFreeCapacity((StatFs)EmbraceMetadataService.access$getStatFs$p(this.this$0).getValue());
                ConfigService configService2 = (ConfigService)EmbraceMetadataService.access$getConfigProvider$p(this.this$0).invoke();
                if (this.$isAndroid26OrAbove && configService2.getAutoDataCaptureBehavior().isDiskUsageReportingEnabled() && (deviceDiskAppUsage = MetadataUtils.getDeviceDiskAppUsage(EmbraceMetadataService.access$getStorageStatsManager$p(this.this$0), EmbraceMetadataService.access$getPackageManager$p(this.this$0), EmbraceMetadataService.access$getPackageName$p(this.this$0))) != null) {
                    void className$iv3;
                    object = InternalStaticEmbraceLogger.Companion;
                    String string3 = "EmbraceMetadataService";
                    String msg$iv2 = "Disk usage is present";
                    boolean $i$f$logDeveloper2 = false;
                    ((InternalStaticEmbraceLogger.Companion)object).log('[' + (String)className$iv3 + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
                    EmbraceMetadataService.access$setDiskUsage$p(this.this$0, new DiskUsage(deviceDiskAppUsage, free));
                }
                if (EmbraceMetadataService.access$getDiskUsage$p(this.this$0) == null) {
                    EmbraceMetadataService.access$setDiskUsage$p(this.this$0, new DiskUsage(null, free));
                }
                InternalStaticEmbraceLogger.Companion companion2 = InternalStaticEmbraceLogger.Companion;
                object = "EmbraceMetadataService";
                String msg$iv3 = "Device disk free: " + free;
                boolean $i$f$logDeveloper3 = false;
                companion2.log('[' + (String)className$iv + "] " + msg$iv3, EmbraceLogger.Severity.DEVELOPER, null, true);
                return null;
            }
            {
                this.this$0 = embraceMetadataService;
                this.$isAndroid26OrAbove = bl;
            }
        });
    }

    @VisibleForTesting
    @Nullable
    public final String getReactNativeBundleId() {
        return (String)this.reactNativeBundleId.getValue();
    }

    @Override
    @NotNull
    public String getDeviceId() {
        return (String)this.deviceId.getValue();
    }

    @Override
    @NotNull
    public String getAppVersionCode() {
        return this.appVersionCode;
    }

    @Override
    @NotNull
    public String getAppVersionName() {
        return this.appVersionName;
    }

    @Override
    @NotNull
    public DeviceInfo getDeviceInfo() {
        return this.getDeviceInfo(true);
    }

    private final DeviceInfo getDeviceInfo(boolean populateAllFields) {
        long storageCapacityBytes = populateAllFields ? MetadataUtils.getInternalStorageTotalCapacity((StatFs)this.statFs.getValue()) : 0L;
        return new DeviceInfo(MetadataUtils.getDeviceManufacturer(), MetadataUtils.getModel(), MetadataUtils.getArchitecture(), this.isJailbroken(), MetadataUtils.getLocale(), storageCapacityBytes, MetadataUtils.getOperatingSystemType(), MetadataUtils.getOperatingSystemVersion(), MetadataUtils.getOperatingSystemVersionCode(), this.getScreenResolution(), MetadataUtils.getTimezoneId(), MetadataUtils.getSystemUptime(), MetadataUtils.getNumberOfCores(), populateAllFields ? this.getCpuName() : null, populateAllFields ? this.getEgl() : null);
    }

    @Override
    @NotNull
    public DeviceInfo getLightweightDeviceInfo() {
        return this.getDeviceInfo(false);
    }

    @Override
    @NotNull
    public AppInfo getAppInfo() {
        return this.getAppInfo(true);
    }

    private final AppInfo getAppInfo(boolean populateAllFields) {
        String infoPlatformVersion = null;
        String hostedSdkVersion = null;
        String infoUnityBuildIdNumber = null;
        String infoReactNativeBundle = null;
        String infoJavaScriptPatchNumber = null;
        String infoReactNativeVersion = null;
        if (this.appFramework == Embrace.AppFramework.UNITY) {
            String string2;
            String string3;
            String string4 = this.unityVersion;
            if (string4 == null) {
                string4 = infoPlatformVersion = this.preferencesService.getUnityVersionNumber();
            }
            if ((string3 = this.buildGuid) == null) {
                string3 = infoUnityBuildIdNumber = this.preferencesService.getUnityBuildIdNumber();
            }
            if ((string2 = this.unitySdkVersion) == null) {
                string2 = hostedSdkVersion = this.preferencesService.getUnitySdkVersionNumber();
            }
        }
        if (this.appFramework == Embrace.AppFramework.REACT_NATIVE) {
            infoReactNativeBundle = (String)this.reactNativeBundleId.getValue();
            infoJavaScriptPatchNumber = this.javaScriptPatchNumber;
            infoReactNativeVersion = this.reactNativeVersion;
            hostedSdkVersion = this.getRnSdkVersion();
        }
        if (this.appFramework == Embrace.AppFramework.FLUTTER) {
            infoPlatformVersion = this.getDartSdkVersion();
            hostedSdkVersion = this.getEmbraceFlutterSdkVersion();
        }
        return new AppInfo(this.appVersionName, this.appFramework.getValue(), this.buildInfo.getBuildId(), this.buildInfo.getBuildType(), this.buildInfo.getBuildFlavor(), MetadataUtils.appEnvironment(this.applicationInfo), populateAllFields ? (Boolean)this.appUpdated.getValue() : false, populateAllFields ? (Boolean)this.appUpdated.getValue() : false, this.appVersionCode, populateAllFields ? (Boolean)this.osUpdated.getValue() : false, populateAllFields ? (Boolean)this.osUpdated.getValue() : false, "5.22.0", "53", infoReactNativeBundle, infoJavaScriptPatchNumber, infoReactNativeVersion, infoPlatformVersion, infoUnityBuildIdNumber, hostedSdkVersion);
    }

    @Override
    @NotNull
    public AppInfo getLightweightAppInfo() {
        return this.getAppInfo(false);
    }

    private final String getRnSdkVersion() {
        String string2 = this.rnSdkVersion;
        if (string2 == null) {
            string2 = this.preferencesService.getRnSdkVersion();
        }
        return string2;
    }

    private final String getDartSdkVersion() {
        String string2 = this.dartVersion;
        if (string2 == null) {
            string2 = this.preferencesService.getDartSdkVersion();
        }
        return string2;
    }

    private final String getEmbraceFlutterSdkVersion() {
        String string2 = this.embraceFlutterSdkVersion;
        if (string2 == null) {
            string2 = this.preferencesService.getEmbraceFlutterSdkVersion();
        }
        return string2;
    }

    @Override
    public boolean isDebug() {
        return MetadataUtils.isDebug(this.applicationInfo);
    }

    @Override
    @NotNull
    public String getAppId() {
        ConfigService configService2 = (ConfigService)this.configProvider.invoke();
        return configService2.getSdkModeBehavior().getAppId();
    }

    @Override
    public boolean isAppUpdated() {
        return (Boolean)this.appUpdated.getValue();
    }

    @Override
    public boolean isOsUpdated() {
        return (Boolean)this.osUpdated.getValue();
    }

    @Override
    @Nullable
    public String getActiveSessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setActiveSessionId(@Nullable String sessionId) {
        void className$iv;
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string2 = "EmbraceMetadataService";
        String msg$iv = "Active session Id: " + sessionId;
        boolean $i$f$logDeveloper = false;
        companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        this.sessionId = sessionId;
        this.setSessionIdToProcessStateSummary(this.sessionId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeActiveSessionId(@Nullable String sessionId) {
        if (this.sessionId != null && Intrinsics.areEqual((Object)this.sessionId, (Object)sessionId)) {
            void className$iv;
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String string2 = "EmbraceMetadataService";
            String msg$iv = "Nulling active session Id";
            boolean $i$f$logDeveloper = false;
            companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            this.setActiveSessionId(null);
        }
    }

    private final void setSessionIdToProcessStateSummary(String sessionId) {
        block1: {
            Activity activity;
            if (Build.VERSION.SDK_INT < 30 || (activity = this.activityService.getForegroundActivity()) == null || sessionId == null) break block1;
            ActivityManager activityManager2 = this.activityManager;
            if (activityManager2 != null) {
                String string2 = sessionId;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                activityManager2.setProcessStateSummary(byArray);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getAppState() {
        String string2;
        if (this.activityService.isInBackground()) {
            void className$iv;
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String string3 = "EmbraceMetadataService";
            String msg$iv = "App state: BACKGROUND";
            boolean $i$f$logDeveloper = false;
            companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            string2 = "background";
        } else {
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String className$iv = "EmbraceMetadataService";
            String msg$iv = "App state: ACTIVE";
            boolean $i$f$logDeveloper = false;
            companion.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            string2 = "active";
        }
        return string2;
    }

    @Override
    @Nullable
    public DiskUsage getDiskUsage() {
        return this.diskUsage;
    }

    @Override
    @Nullable
    public String getScreenResolution() {
        return this.screenResolution;
    }

    @Override
    @Nullable
    public Boolean isJailbroken() {
        return this.isJailbroken;
    }

    @Override
    @Nullable
    public String getCpuName() {
        return this.cpuName;
    }

    @Override
    @Nullable
    public String getEgl() {
        return this.egl;
    }

    @Override
    public void setReactNativeBundleId(@NotNull Context context2, @Nullable String jsBundleIdUrl) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        CharSequence charSequence = jsBundleIdUrl;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            EmbraceLogger.logError("JavaScript bundle URL must have non-zero length");
            this.reactNativeBundleId = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ EmbraceMetadataService this$0;

                @Nullable
                public final String invoke() {
                    return EmbraceMetadataService.access$getBuildInfo$p(this.this$0).getBuildId();
                }
                {
                    this.this$0 = embraceMetadataService;
                    super(0);
                }
            }));
            return;
        }
        String currentUrl = this.preferencesService.getJavaScriptBundleURL();
        if (currentUrl != null && Intrinsics.areEqual((Object)currentUrl, (Object)jsBundleIdUrl)) {
            EmbraceLogger.logDebug("JavaScript bundle URL already exists and didn't change. Using: " + currentUrl + ".");
            this.reactNativeBundleId = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ EmbraceMetadataService this$0;

                @Nullable
                public final String invoke() {
                    return EmbraceMetadataService.access$getBuildInfo$p(this.this$0).getBuildId();
                }
                {
                    this.this$0 = embraceMetadataService;
                    super(0);
                }
            }));
            return;
        }
        this.preferencesService.setJavaScriptBundleURL(jsBundleIdUrl);
        this.reactNativeBundleId = this.metadataRetrieveWorker.eagerLazyLoad((Callable)new Callable<String>(this, context2, jsBundleIdUrl){
            final /* synthetic */ EmbraceMetadataService this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $jsBundleIdUrl;

            @Nullable
            public final String call() {
                return EmbraceMetadataService.Companion.computeReactNativeBundleId$embrace_android_sdk_release(this.$context, this.$jsBundleIdUrl, EmbraceMetadataService.access$getBuildInfo$p(this.this$0).getBuildId());
            }
            {
                this.this$0 = embraceMetadataService;
                this.$context = context2;
                this.$jsBundleIdUrl = string2;
            }
        });
    }

    @Override
    public void setEmbraceFlutterSdkVersion(@Nullable String version) {
        this.embraceFlutterSdkVersion = version;
        this.preferencesService.setEmbraceFlutterSdkVersion(version);
    }

    @Override
    public void setRnSdkVersion(@Nullable String version) {
        this.rnSdkVersion = version;
        this.preferencesService.setRnSdkVersion(version);
    }

    @Override
    public void setDartVersion(@Nullable String version) {
        this.dartVersion = version;
        this.preferencesService.setDartSdkVersion(version);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applicationStartupComplete() {
        void className$iv;
        String msg$iv;
        String appVersion = this.getAppVersionName();
        String osVersion = Build.VERSION.RELEASE;
        String localDeviceId = this.getDeviceId();
        long installDate = this.clock.now();
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        Object object = StringCompanionObject.INSTANCE;
        Locale locale = Locale.getDefault();
        String string2 = "Setting metadata on preferences service. App version: {%s}, OS version {%s}, device ID: {%s}, install date: {%d}";
        Object[] objectArray = new Object[]{appVersion, osVersion, localDeviceId, installDate};
        boolean bl = false;
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        object = string3;
        Throwable throwable$iv = null;
        boolean $i$f$logDebug = false;
        companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
        this.preferencesService.setAppVersion(appVersion);
        this.preferencesService.setOsVersion(osVersion);
        this.preferencesService.setDeviceIdentifier(localDeviceId);
        if (this.preferencesService.getInstallDate() == null) {
            this.preferencesService.setInstallDate(installDate);
        }
        companion = InternalStaticEmbraceLogger.Companion;
        msg$iv = "EmbraceMetadataService";
        String msg$iv2 = "- Application Startup Complete -";
        boolean $i$f$logDeveloper = false;
        companion.log('[' + (String)className$iv + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
    }

    private EmbraceMetadataService(WindowManager windowManager2, PackageManager packageManager, StorageStatsManager storageStatsManager, ActivityManager activityManager2, BuildInfo buildInfo, Function0<? extends ConfigService> configProvider2, ApplicationInfo applicationInfo, Lazy<String> deviceId, String packageName, String appVersionName, String appVersionCode, Embrace.AppFramework appFramework, Lazy<Boolean> appUpdated, Lazy<Boolean> osUpdated, PreferencesService preferencesService2, ActivityService activityService2, Lazy<String> reactNativeBundleId, String javaScriptPatchNumber, String reactNativeVersion, String unityVersion, String buildGuid, String unitySdkVersion, String rnSdkVersion, BackgroundWorker metadataRetrieveWorker, Clock clock2, EmbraceCpuInfoDelegate embraceCpuInfoDelegate2) {
        String className$iv;
        boolean $i$f$logDeveloper;
        String msg$iv;
        InternalStaticEmbraceLogger.Companion companion;
        this.windowManager = windowManager2;
        this.packageManager = packageManager;
        this.storageStatsManager = storageStatsManager;
        this.activityManager = activityManager2;
        this.buildInfo = buildInfo;
        this.configProvider = configProvider2;
        this.applicationInfo = applicationInfo;
        this.deviceId = deviceId;
        this.packageName = packageName;
        this.appVersionName = appVersionName;
        this.appVersionCode = appVersionCode;
        this.appFramework = appFramework;
        this.appUpdated = appUpdated;
        this.osUpdated = osUpdated;
        this.preferencesService = preferencesService2;
        this.activityService = activityService2;
        this.metadataRetrieveWorker = metadataRetrieveWorker;
        this.clock = clock2;
        this.embraceCpuInfoDelegate = embraceCpuInfoDelegate2;
        this.statFs = LazyKt.lazy((Function0)statFs.1.INSTANCE);
        if (this.appFramework == Embrace.AppFramework.REACT_NATIVE) {
            companion = InternalStaticEmbraceLogger.Companion;
            String string2 = "EmbraceMetadataService";
            msg$iv = "Setting RN settings";
            $i$f$logDeveloper = false;
            companion.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            this.reactNativeBundleId = reactNativeBundleId;
            this.javaScriptPatchNumber = javaScriptPatchNumber;
            this.reactNativeVersion = reactNativeVersion;
            this.rnSdkVersion = rnSdkVersion;
        } else {
            this.reactNativeBundleId = LazyKt.lazy((Function0)((Function0)new Function0<String>(){

                @Nullable
                public final String invoke() {
                    return buildInfo.getBuildId();
                }
            }));
            this.javaScriptPatchNumber = null;
            this.reactNativeVersion = null;
            this.rnSdkVersion = null;
        }
        if (this.appFramework == Embrace.AppFramework.UNITY) {
            companion = InternalStaticEmbraceLogger.Companion;
            className$iv = "EmbraceMetadataService";
            msg$iv = "Setting Unity settings";
            $i$f$logDeveloper = false;
            companion.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            this.unityVersion = unityVersion;
            this.buildGuid = buildGuid;
            this.unitySdkVersion = unitySdkVersion;
        } else {
            this.unityVersion = null;
            this.buildGuid = null;
            this.unitySdkVersion = null;
        }
    }

    @Override
    public void onBackground(long timestamp) {
        ActivityListener.DefaultImpls.onBackground(this, timestamp);
    }

    @Override
    public void onForeground(boolean coldStart, long startupTime, long timestamp) {
        ActivityListener.DefaultImpls.onForeground(this, coldStart, startupTime, timestamp);
    }

    @Override
    public void onView(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onView(this, activity);
    }

    @Override
    public void onViewClose(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onViewClose(this, activity);
    }

    @Override
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onActivityCreated(this, activity, bundle);
    }

    public static final /* synthetic */ PreferencesService access$getPreferencesService$p(EmbraceMetadataService $this) {
        return $this.preferencesService;
    }

    public static final /* synthetic */ String access$getCpuName$p(EmbraceMetadataService $this) {
        return $this.cpuName;
    }

    public static final /* synthetic */ void access$setCpuName$p(EmbraceMetadataService $this, String string2) {
        $this.cpuName = string2;
    }

    public static final /* synthetic */ EmbraceCpuInfoDelegate access$getEmbraceCpuInfoDelegate$p(EmbraceMetadataService $this) {
        return $this.embraceCpuInfoDelegate;
    }

    public static final /* synthetic */ String access$getEgl$p(EmbraceMetadataService $this) {
        return $this.egl;
    }

    public static final /* synthetic */ void access$setEgl$p(EmbraceMetadataService $this, String string2) {
        $this.egl = string2;
    }

    public static final /* synthetic */ String access$getScreenResolution$p(EmbraceMetadataService $this) {
        return $this.screenResolution;
    }

    public static final /* synthetic */ void access$setScreenResolution$p(EmbraceMetadataService $this, String string2) {
        $this.screenResolution = string2;
    }

    public static final /* synthetic */ WindowManager access$getWindowManager$p(EmbraceMetadataService $this) {
        return $this.windowManager;
    }

    public static final /* synthetic */ Boolean access$isJailbroken$p(EmbraceMetadataService $this) {
        return $this.isJailbroken;
    }

    public static final /* synthetic */ void access$setJailbroken$p(EmbraceMetadataService $this, Boolean bl) {
        $this.isJailbroken = bl;
    }

    public static final /* synthetic */ Lazy access$getStatFs$p(EmbraceMetadataService $this) {
        return $this.statFs;
    }

    public static final /* synthetic */ Function0 access$getConfigProvider$p(EmbraceMetadataService $this) {
        return $this.configProvider;
    }

    public static final /* synthetic */ StorageStatsManager access$getStorageStatsManager$p(EmbraceMetadataService $this) {
        return $this.storageStatsManager;
    }

    public static final /* synthetic */ PackageManager access$getPackageManager$p(EmbraceMetadataService $this) {
        return $this.packageManager;
    }

    public static final /* synthetic */ String access$getPackageName$p(EmbraceMetadataService $this) {
        return $this.packageName;
    }

    public static final /* synthetic */ DiskUsage access$getDiskUsage$p(EmbraceMetadataService $this) {
        return $this.diskUsage;
    }

    public static final /* synthetic */ void access$setDiskUsage$p(EmbraceMetadataService $this, DiskUsage diskUsage) {
        $this.diskUsage = diskUsage;
    }

    public /* synthetic */ EmbraceMetadataService(WindowManager windowManager2, PackageManager packageManager, StorageStatsManager storageStatsManager, ActivityManager activityManager2, BuildInfo buildInfo, Function0 configProvider2, ApplicationInfo applicationInfo, Lazy deviceId, String packageName, String appVersionName, String appVersionCode, Embrace.AppFramework appFramework, Lazy appUpdated, Lazy osUpdated, PreferencesService preferencesService2, ActivityService activityService2, Lazy reactNativeBundleId, String javaScriptPatchNumber, String reactNativeVersion, String unityVersion, String buildGuid, String unitySdkVersion, String rnSdkVersion, BackgroundWorker metadataRetrieveWorker, Clock clock2, EmbraceCpuInfoDelegate embraceCpuInfoDelegate2, DefaultConstructorMarker $constructor_marker) {
        this(windowManager2, packageManager, storageStatsManager, activityManager2, buildInfo, (Function0<? extends ConfigService>)configProvider2, applicationInfo, (Lazy<String>)deviceId, packageName, appVersionName, appVersionCode, appFramework, (Lazy<Boolean>)appUpdated, (Lazy<Boolean>)osUpdated, preferencesService2, activityService2, (Lazy<String>)reactNativeBundleId, javaScriptPatchNumber, reactNativeVersion, unityVersion, buildGuid, unitySdkVersion, rnSdkVersion, metadataRetrieveWorker, clock2, embraceCpuInfoDelegate2);
    }

    @JvmStatic
    @NotNull
    public static final EmbraceMetadataService ofContext(@NotNull Context context2, @NotNull BuildInfo buildInfo, @NotNull Function0<? extends ConfigService> configProvider2, @NotNull Embrace.AppFramework appFramework, @NotNull PreferencesService preferencesService2, @NotNull ActivityService activityService2, @NotNull BackgroundWorker metadataRetrieveWorker, @Nullable StorageStatsManager storageStatsManager, @Nullable WindowManager windowManager2, @Nullable ActivityManager activityManager2, @NotNull Clock clock2, @NotNull EmbraceCpuInfoDelegate embraceCpuInfoDelegate2) {
        return Companion.ofContext(context2, buildInfo, configProvider2, appFramework, preferencesService2, activityService2, metadataRetrieveWorker, storageStatsManager, windowManager2, activityManager2, clock2, embraceCpuInfoDelegate2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002Jt\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/embrace/android/embracesdk/EmbraceMetadataService$Companion;", "", "()V", "UNKNOWN_VALUE", "", "computeReactNativeBundleId", "context", "Landroid/content/Context;", "bundleUrl", "defaultBundleId", "computeReactNativeBundleId$embrace_android_sdk_release", "getBundleAsset", "Ljava/io/InputStream;", "getBundleAssetName", "getCustomBundleStream", "hashBundleToMd5", "bundle", "", "ofContext", "Lio/embrace/android/embracesdk/EmbraceMetadataService;", "buildInfo", "Lio/embrace/android/embracesdk/BuildInfo;", "configProvider", "Lkotlin/Function0;", "Lio/embrace/android/embracesdk/config/ConfigService;", "appFramework", "Lio/embrace/android/embracesdk/Embrace$AppFramework;", "preferencesService", "Lio/embrace/android/embracesdk/PreferencesService;", "activityService", "Lio/embrace/android/embracesdk/ActivityService;", "metadataRetrieveWorker", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "storageStatsManager", "Landroid/app/usage/StorageStatsManager;", "windowManager", "Landroid/view/WindowManager;", "activityManager", "Landroid/app/ActivityManager;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "embraceCpuInfoDelegate", "Lio/embrace/android/embracesdk/EmbraceCpuInfoDelegate;", "embrace-android-sdk_release"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final EmbraceMetadataService ofContext(@NotNull Context context2, @NotNull BuildInfo buildInfo, @NotNull Function0<? extends ConfigService> configProvider2, @NotNull Embrace.AppFramework appFramework, @NotNull PreferencesService preferencesService2, @NotNull ActivityService activityService2, @NotNull BackgroundWorker metadataRetrieveWorker, @Nullable StorageStatsManager storageStatsManager, @Nullable WindowManager windowManager2, @Nullable ActivityManager activityManager2, @NotNull Clock clock2, @NotNull EmbraceCpuInfoDelegate embraceCpuInfoDelegate2) {
            String msg$iv;
            boolean $i$f$logDeveloper;
            String msg$iv2;
            InternalStaticEmbraceLogger.Companion className$iv;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)buildInfo, (String)"buildInfo");
            Intrinsics.checkNotNullParameter(configProvider2, (String)"configProvider");
            Intrinsics.checkNotNullParameter((Object)((Object)appFramework), (String)"appFramework");
            Intrinsics.checkNotNullParameter((Object)preferencesService2, (String)"preferencesService");
            Intrinsics.checkNotNullParameter((Object)activityService2, (String)"activityService");
            Intrinsics.checkNotNullParameter((Object)metadataRetrieveWorker, (String)"metadataRetrieveWorker");
            Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
            Intrinsics.checkNotNullParameter((Object)embraceCpuInfoDelegate2, (String)"embraceCpuInfoDelegate");
            PackageInfo packageInfo = null;
            String appVersionName = null;
            String appVersionCode = null;
            PackageManager packageManager = context2.getPackageManager();
            try {
                PackageInfo packageInfo2 = packageManager.getPackageInfo(context2.getPackageName(), 0);
                Intrinsics.checkNotNullExpressionValue((Object)packageInfo2, (String)"packageManager.getPackag\u2026o(context.packageName, 0)");
                packageInfo = packageInfo2;
                Object $this$trim$iv = packageInfo.versionName.toString();
                boolean $i$f$trim22 = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                appVersionName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                appVersionCode = String.valueOf(packageInfo.versionCode);
                $this$trim$iv = InternalStaticEmbraceLogger.Companion;
                String $i$f$trim22 = "EmbraceMetadataService";
                $this$trim$iv$iv = "App version name: " + appVersionName + " - App version code: " + appVersionCode;
                boolean $i$f$logDeveloper2 = false;
                ((InternalStaticEmbraceLogger.Companion)$this$trim$iv).log('[' + (String)((Object)className$iv) + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
            }
            catch (Exception e) {
                void msg$iv3;
                void className$iv2;
                className$iv = InternalStaticEmbraceLogger.Companion;
                msg$iv2 = "EmbraceMetadataService";
                String $i$f$logDeveloper2 = "Cannot set appVersionName and appVersionCode, setting UNKNOWN_VALUE";
                boolean $i$f$logDeveloper3 = false;
                className$iv.log('[' + (String)className$iv2 + "] " + (String)msg$iv3, EmbraceLogger.Severity.DEVELOPER, e, true);
                appVersionName = EmbraceMetadataService.UNKNOWN_VALUE;
                appVersionCode = EmbraceMetadataService.UNKNOWN_VALUE;
            }
            String finalAppVersionName = appVersionName;
            Lazy isAppUpdated2 = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(preferencesService2, finalAppVersionName){
                final /* synthetic */ PreferencesService $preferencesService;
                final /* synthetic */ String $finalAppVersionName;

                /*
                 * WARNING - void declaration
                 */
                public final boolean invoke() {
                    void var2_2;
                    void className$iv;
                    String lastKnownAppVersion = this.$preferencesService.getAppVersion();
                    boolean appUpdated = lastKnownAppVersion != null && !StringsKt.equals((String)lastKnownAppVersion, (String)this.$finalAppVersionName, (boolean)true);
                    InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                    String string2 = "EmbraceMetadataService";
                    String msg$iv = "App updated: " + appUpdated;
                    boolean $i$f$logDeveloper = false;
                    companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                    return (boolean)var2_2;
                }
                {
                    this.$preferencesService = preferencesService2;
                    this.$finalAppVersionName = string2;
                    super(0);
                }
            }));
            Lazy isOsUpdated2 = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(preferencesService2){
                final /* synthetic */ PreferencesService $preferencesService;

                /*
                 * WARNING - void declaration
                 */
                public final boolean invoke() {
                    void var2_2;
                    void className$iv;
                    String lastKnownOsVersion = this.$preferencesService.getOsVersion();
                    boolean osUpdated = lastKnownOsVersion != null && !StringsKt.equals((String)lastKnownOsVersion, (String)Build.VERSION.RELEASE, (boolean)true);
                    InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                    String string2 = "EmbraceMetadataService";
                    String msg$iv = "OS updated: " + osUpdated;
                    boolean $i$f$logDeveloper = false;
                    companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                    return (boolean)var2_2;
                }
                {
                    this.$preferencesService = preferencesService2;
                    super(0);
                }
            }));
            Lazy deviceIdentifier2 = LazyKt.lazy((Function0)((Function0)new EmbraceMetadataService$Companion$ofContext$deviceIdentifier$1(preferencesService2)));
            String javaScriptPatchNumber = null;
            String reactNativeVersion = null;
            String rnSdkVersion = null;
            Lazy reactNativeBundleId = null;
            if (appFramework == Embrace.AppFramework.REACT_NATIVE) {
                reactNativeBundleId = metadataRetrieveWorker.eagerLazyLoad((Callable)new Callable<String>(preferencesService2, context2, buildInfo){
                    final /* synthetic */ PreferencesService $preferencesService;
                    final /* synthetic */ Context $context;
                    final /* synthetic */ BuildInfo $buildInfo;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final String call() {
                        String string2;
                        String lastKnownJsBundleUrl = this.$preferencesService.getJavaScriptBundleURL();
                        if (lastKnownJsBundleUrl != null) {
                            string2 = EmbraceMetadataService.Companion.computeReactNativeBundleId$embrace_android_sdk_release(this.$context, lastKnownJsBundleUrl, this.$buildInfo.getBuildId());
                        } else {
                            void msg$iv;
                            void className$iv;
                            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                            String string3 = "EmbraceMetadataService";
                            String string4 = "setting JSBundleUrl as buildId: " + this.$buildInfo.getBuildId();
                            boolean $i$f$logDeveloper = false;
                            companion.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                            string2 = this.$buildInfo.getBuildId();
                        }
                        return string2;
                    }
                    {
                        this.$preferencesService = preferencesService2;
                        this.$context = context2;
                        this.$buildInfo = buildInfo;
                    }
                });
                javaScriptPatchNumber = preferencesService2.getJavaScriptPatchNumber();
                if (javaScriptPatchNumber != null) {
                    void className$iv3;
                    InternalStaticEmbraceLogger.Companion match$iv$iv = InternalStaticEmbraceLogger.Companion;
                    String bl = "EmbraceMetadataService";
                    String string2 = "Java script patch number: " + javaScriptPatchNumber;
                    $i$f$logDeveloper = false;
                    match$iv$iv.log('[' + (String)className$iv3 + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                }
                if ((rnSdkVersion = preferencesService2.getRnSdkVersion()) != null) {
                    InternalStaticEmbraceLogger.Companion match$iv$iv = InternalStaticEmbraceLogger.Companion;
                    String className$iv3 = "EmbraceMetadataService";
                    msg$iv = "RN Embrace SDK version: " + rnSdkVersion;
                    $i$f$logDeveloper = false;
                    match$iv$iv.log('[' + className$iv3 + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                }
            } else {
                reactNativeBundleId = LazyKt.lazy((Function0)((Function0)new Function0<String>(buildInfo){
                    final /* synthetic */ BuildInfo $buildInfo;

                    @Nullable
                    public final String invoke() {
                        return this.$buildInfo.getBuildId();
                    }
                    {
                        this.$buildInfo = buildInfo;
                        super(0);
                    }
                }));
                InternalStaticEmbraceLogger.Companion match$iv$iv = InternalStaticEmbraceLogger.Companion;
                String className$iv4 = "EmbraceMetadataService";
                msg$iv = "setting default RN as buildId";
                $i$f$logDeveloper = false;
                match$iv$iv.log('[' + className$iv4 + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            }
            String unityVersion = null;
            String buildGuid = null;
            String unitySdkVersion = null;
            if (appFramework == Embrace.AppFramework.UNITY) {
                String className$iv5;
                boolean $i$f$logDeveloper4;
                String msg$iv4;
                InternalStaticEmbraceLogger.Companion companion;
                unityVersion = preferencesService2.getUnityVersionNumber();
                if (unityVersion != null) {
                    companion = InternalStaticEmbraceLogger.Companion;
                    String string3 = "EmbraceMetadataService";
                    msg$iv4 = "Unity version: " + unityVersion;
                    $i$f$logDeveloper4 = false;
                    companion.log('[' + className$iv5 + "] " + msg$iv4, EmbraceLogger.Severity.DEVELOPER, null, true);
                } else {
                    companion = InternalStaticEmbraceLogger.Companion;
                    className$iv5 = "EmbraceMetadataService";
                    msg$iv4 = "Unity version is not present";
                    $i$f$logDeveloper4 = false;
                    companion.log('[' + className$iv5 + "] " + msg$iv4, EmbraceLogger.Severity.DEVELOPER, null, true);
                }
                buildGuid = preferencesService2.getUnityBuildIdNumber();
                if (buildGuid != null) {
                    companion = InternalStaticEmbraceLogger.Companion;
                    className$iv5 = "EmbraceMetadataService";
                    msg$iv4 = "Unity build id: " + buildGuid;
                    $i$f$logDeveloper4 = false;
                    companion.log('[' + className$iv5 + "] " + msg$iv4, EmbraceLogger.Severity.DEVELOPER, null, true);
                } else {
                    companion = InternalStaticEmbraceLogger.Companion;
                    className$iv5 = "EmbraceMetadataService";
                    msg$iv4 = "Unity build id number is not present";
                    $i$f$logDeveloper4 = false;
                    companion.log('[' + className$iv5 + "] " + msg$iv4, EmbraceLogger.Severity.DEVELOPER, null, true);
                }
                unitySdkVersion = preferencesService2.getUnitySdkVersionNumber();
                if (unitySdkVersion != null) {
                    companion = InternalStaticEmbraceLogger.Companion;
                    className$iv5 = "EmbraceMetadataService";
                    msg$iv4 = "Unity SDK version: " + unitySdkVersion;
                    $i$f$logDeveloper4 = false;
                    companion.log('[' + className$iv5 + "] " + msg$iv4, EmbraceLogger.Severity.DEVELOPER, null, true);
                } else {
                    companion = InternalStaticEmbraceLogger.Companion;
                    className$iv5 = "EmbraceMetadataService";
                    msg$iv4 = "Unity SDK version is not present";
                    $i$f$logDeveloper4 = false;
                    companion.log('[' + className$iv5 + "] " + msg$iv4, EmbraceLogger.Severity.DEVELOPER, null, true);
                }
            }
            PackageManager packageManager2 = packageManager;
            Intrinsics.checkNotNullExpressionValue((Object)packageManager2, (String)"packageManager");
            ApplicationInfo applicationInfo = context2.getApplicationInfo();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.applicationInfo");
            String string4 = context2.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.packageName");
            return new EmbraceMetadataService(windowManager2, packageManager2, storageStatsManager, activityManager2, buildInfo, configProvider2, applicationInfo, deviceIdentifier2, string4, appVersionName, appVersionCode, appFramework, isAppUpdated2, isOsUpdated2, preferencesService2, activityService2, reactNativeBundleId, javaScriptPatchNumber, reactNativeVersion, unityVersion, buildGuid, unitySdkVersion, rnSdkVersion, metadataRetrieveWorker, clock2, embraceCpuInfoDelegate2, null);
        }

        /*
         * WARNING - void declaration
         */
        private final String getBundleAssetName(String bundleUrl) {
            void className$iv;
            Object object = bundleUrl;
            int n = StringsKt.indexOf$default((CharSequence)bundleUrl, (String)"://", (int)0, (boolean)false, (int)6, null) + 3;
            boolean bl = false;
            String string2 = object;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String name = string3;
            object = InternalStaticEmbraceLogger.Companion;
            String string4 = "EmbraceMetadataService";
            String msg$iv = "Asset name: " + name;
            boolean $i$f$logDeveloper = false;
            ((InternalStaticEmbraceLogger.Companion)object).log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            return name;
        }

        /*
         * WARNING - void declaration
         */
        private final InputStream getBundleAsset(Context context2, String bundleUrl) {
            try {
                void msg$iv;
                void className$iv;
                InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                String string2 = "EmbraceMetadataService";
                String string3 = "Attempting to read bundle asset: " + bundleUrl;
                boolean $i$f$logDeveloper = false;
                companion.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                return context2.getAssets().open(this.getBundleAssetName(bundleUrl));
            }
            catch (Exception e) {
                EmbraceLogger.logError("Failed to retrieve RN bundle file from assets.", e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final InputStream getCustomBundleStream(String bundleUrl) {
            try {
                void msg$iv;
                void className$iv;
                InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                String string2 = "EmbraceMetadataService";
                String string3 = "Attempting to load bundle from custom path: " + bundleUrl;
                boolean $i$f$logDeveloper = false;
                companion.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                return new FileInputStream(bundleUrl);
            }
            catch (NullPointerException e) {
                EmbraceLogger.logError("Failed to retrieve the custom RN bundle file.", e);
            }
            catch (FileNotFoundException e) {
                EmbraceLogger.logError("Failed to retrieve the custom RN bundle file.", e);
            }
            return null;
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public final String computeReactNativeBundleId$embrace_android_sdk_release(@NotNull Context context, @NotNull String bundleUrl, @Nullable String defaultBundleId) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - void declaration
         */
        private final String hashBundleToMd5(byte[] bundle) {
            void className$iv;
            String hashBundle = null;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bundleHashed = md.digest(bundle);
            StringBuilder sb = new StringBuilder();
            for (byte b : bundleHashed) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.getDefault();
                String string2 = "%02x";
                Object[] objectArray = new Object[]{b & 0xFF};
                boolean bl = false;
                String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
                sb.append(string3);
            }
            String string4 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"sb.toString()");
            Object object = string4;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
            Object object2 = locale;
            boolean bl = false;
            String string5 = object;
            boolean bl2 = false;
            String string6 = string5;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toUpperCase((Locale)object2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toUpperCase(locale)");
            hashBundle = string7;
            object = InternalStaticEmbraceLogger.Companion;
            object2 = "EmbraceMetadataService";
            String msg$iv = "Setting RN bundleId: " + hashBundle;
            boolean $i$f$logDeveloper = false;
            ((InternalStaticEmbraceLogger.Companion)object).log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            return hashBundle;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

