/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceNdkServiceRepository;
import io.embrace.android.embracesdk.EmbraceSessionProperties;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.MetadataUtils;
import io.embrace.android.embracesdk.NativeCrashData;
import io.embrace.android.embracesdk.NativeSymbols;
import io.embrace.android.embracesdk.NdkService;
import io.embrace.android.embracesdk.NdkServiceDelegate;
import io.embrace.android.embracesdk.SharedObjectLoader;
import io.embrace.android.embracesdk.Uuid;
import io.embrace.android.embracesdk.capture.user.UserService;
import io.embrace.android.embracesdk.comms.delivery.DeliveryService;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.ApkToolsConfig;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.utils.NativeUtils;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;

class EmbraceNdkService
implements NdkService,
ActivityListener {
    private static final String APPLICATION_STATE_ACTIVE = "active";
    private static final String APPLICATION_STATE_BACKGROUND = "background";
    private static final String KEY_NDK_SYMBOLS = "emb_ndk_symbols";
    private static final String CRASH_REPORT_EVENT_NAME = "_crash_report";
    private static final String NATIVE_CRASH_FILE_PREFIX = "emb_ndk";
    private static final String NATIVE_CRASH_FILE_SUFFIX = ".crash";
    private static final String NATIVE_CRASH_ERROR_FILE_SUFFIX = ".error";
    private static final String NATIVE_CRASH_MAP_FILE_SUFFIX = ".map";
    private static final String NATIVE_CRASH_FILE_FOLDER = "ndk";
    private static final int MAX_NATIVE_CRASH_FILES_ALLOWED = 4;
    private static final int HANDLER_CHECK_DELAY_MS = 5000;
    private final Object lock = new Object();
    private boolean isInstalled = false;
    private final Context context;
    private final MetadataService metadataService;
    private final ConfigService configService;
    private final DeliveryService deliveryService;
    private final UserService userService;
    private final EmbraceSessionProperties sessionProperties;
    private Lazy<Gson> gson;
    private String unityCrashId;
    private final Lazy<File> cacheDir;
    private final BackgroundWorker cleanCacheWorker;
    private final BackgroundWorker ndkStartupWorker;
    private final SharedObjectLoader sharedObjectLoader;
    private final InternalEmbraceLogger logger;
    private final Lazy<Map<String, String>> symbolsForArch;
    private final EmbraceNdkServiceRepository repository;
    private final NdkServiceDelegate.NdkDelegate delegate;

    EmbraceNdkService(@NonNull Context context2, @NonNull MetadataService metadataService2, @NonNull ActivityService activityService2, @NonNull ConfigService configService2, @NonNull DeliveryService deliveryService2, @NonNull UserService userService2, @NonNull EmbraceSessionProperties sessionProperties, @NonNull Embrace.AppFramework appFramework, @NonNull SharedObjectLoader sharedObjectLoader2, @NonNull InternalEmbraceLogger logger, @NonNull EmbraceNdkServiceRepository repository, @NonNull NdkServiceDelegate.NdkDelegate delegate, @NonNull BackgroundWorker cleanCacheWorker, @NonNull BackgroundWorker ndkStartupWorker) {
        this.context = context2;
        this.metadataService = metadataService2;
        this.configService = configService2;
        this.deliveryService = deliveryService2;
        this.userService = userService2;
        this.sessionProperties = sessionProperties;
        this.sharedObjectLoader = sharedObjectLoader2;
        this.logger = logger;
        this.repository = repository;
        this.delegate = delegate;
        this.symbolsForArch = LazyKt.lazy(() -> {
            NativeSymbols nativeSymbols = this.getNativeSymbols();
            if (nativeSymbols != null) {
                String arch = MetadataUtils.getArchitecture();
                return nativeSymbols.getSymbolByArchitecture(arch);
            }
            return null;
        });
        this.cacheDir = LazyKt.lazy(() -> ((Context)context2).getCacheDir());
        this.cleanCacheWorker = cleanCacheWorker;
        this.ndkStartupWorker = ndkStartupWorker;
        if (configService2.getAutoDataCaptureBehavior().isNdkEnabled()) {
            activityService2.addListener(this);
            this.gson = LazyKt.lazy(Gson::new);
            if (appFramework == Embrace.AppFramework.UNITY) {
                this.unityCrashId = Uuid.getEmbUuid();
            }
            logger.logDeveloper("EmbraceNDKService", "NDK enabled - starting service installation.");
            this.startNdk();
            this.cleanOldCrashFiles();
        } else {
            logger.logDeveloper("EmbraceNDKService", "NDK disabled.");
        }
    }

    @Override
    public void testCrash(boolean isCpp) {
        if (isCpp) {
            this.testCrashCpp();
        } else {
            this.testCrashC();
        }
    }

    @Override
    public void updateSessionId(@NonNull String newSessionId) {
        this.logger.logDeveloper("EmbraceNDKService", "NDK update (session ID): " + newSessionId);
        if (this.isInstalled) {
            this.delegate._updateSessionId(newSessionId);
        }
    }

    @Override
    public void onSessionPropertiesUpdate(@NonNull Map<String, String> properties) {
        this.logger.logDeveloper("EmbraceNDKService", "NDK update: (session properties): " + properties);
        if (this.isInstalled) {
            this.updateDeviceMetaData();
        }
    }

    @Override
    public void onUserInfoUpdate() {
        this.logger.logDeveloper("EmbraceNDKService", "NDK update (user)");
        if (this.isInstalled) {
            this.updateDeviceMetaData();
        }
    }

    @Override
    @Nullable
    public String getUnityCrashId() {
        return this.unityCrashId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBackground(long timestamp) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isInstalled) {
                this.updateAppState(APPLICATION_STATE_BACKGROUND);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onForeground(boolean coldStart, long startupTime, long timestamp) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isInstalled) {
                this.updateAppState(APPLICATION_STATE_ACTIVE);
            }
        }
    }

    private void startNdk() {
        try {
            if (this.sharedObjectLoader.loadEmbraceNative()) {
                this.installSignals();
                this.createCrashReportDirectory();
                Handler handler = new Handler(Looper.myLooper());
                handler.postDelayed(this::checkSignalHandlersOverwritten, 5000L);
                this.logger.logInfo("NDK library successfully loaded");
            } else {
                this.logger.logDeveloper("EmbraceNDKService", "Failed to load embrace library - probable unsatisfied linkage.");
            }
        }
        catch (Exception ex) {
            this.logger.logError("Failed to load NDK library", ex);
        }
    }

    @VisibleForTesting
    void checkSignalHandlersOverwritten() {
        String culprit;
        if (this.configService.getAutoDataCaptureBehavior().isSigHandlerDetectionEnabled() && (culprit = this.delegate._checkForOverwrittenHandlers()) != null) {
            if (this.shouldIgnoreOverriddenHandler(culprit)) {
                return;
            }
            String errMsg = "Embrace detected that another signal handler has replaced our signal handler.\nThis may lead to unexpected behaviour and lost NDK crashes.\nWe will attempt to reinstall our signal handler but please consider disabling\nother signal handlers if you observed unexpected behaviour.\nIf you believe this is a false positive, please contact support@embrace.io.\nHandler origin: " + culprit;
            RuntimeException exc = new RuntimeException(errMsg);
            exc.setStackTrace(new StackTraceElement[0]);
            this.logger.logWarningWithException(errMsg, exc, false);
            this.delegate._reinstallSignalHandlers();
        }
    }

    private boolean shouldIgnoreOverriddenHandler(@NonNull String culprit) {
        List<String> allowList = Collections.singletonList("libwebviewchromium.so");
        for (String allowed : allowList) {
            if (!culprit.contains(allowed)) continue;
            return true;
        }
        return false;
    }

    protected void createCrashReportDirectory() {
        String directory = this.cacheDir.getValue() + "/" + NATIVE_CRASH_FILE_FOLDER;
        File directoryFile = new File(directory);
        if (directoryFile.exists()) {
            return;
        }
        if (!directoryFile.mkdirs()) {
            this.logger.logError("Failed to create crash report directory {crashDirPath=" + directoryFile.getAbsolutePath() + "}");
        }
    }

    protected void installSignals() {
        String reportBasePath = ((File)this.cacheDir.getValue()).getAbsolutePath() + "/" + NATIVE_CRASH_FILE_FOLDER;
        String markerFilePath = ((File)this.cacheDir.getValue()).getAbsolutePath() + "/" + "embrace_crash_marker";
        this.logger.logDeveloper("EmbraceNDKService", "Creating report path at " + reportBasePath);
        String nativeCrashId = this.unityCrashId != null ? this.unityCrashId : Uuid.getEmbUuid();
        boolean is32bit = NativeUtils.is32BitDevice();
        this.logger.logDeveloper("EmbraceNDKService", "Installing signal handlers. 32bit=" + is32bit + ", crashId=" + nativeCrashId);
        String initialMetaData = new NativeCrashData.NativeCrashMetadata(this.metadataService.getLightweightAppInfo(), this.metadataService.getLightweightDeviceInfo(), this.userService.getUserInfo(), this.sessionProperties.get()).toJson();
        this.delegate._installSignalHandlers(reportBasePath, markerFilePath, initialMetaData, "null", this.metadataService.getAppState(), nativeCrashId, Build.VERSION.SDK_INT, is32bit, ApkToolsConfig.IS_DEVELOPER_LOGGING_ENABLED);
        this.updateDeviceMetaData();
        this.isInstalled = true;
    }

    protected List<NativeCrashData.Error> getNativeCrashErrors(NativeCrashData nativeCrash, File errorFile) {
        if (errorFile != null) {
            String absolutePath = errorFile.getAbsolutePath();
            this.logger.logDeveloper("EmbraceNDKService", "Processing error file at " + absolutePath);
            String errorsRaw = this.delegate._getErrors(absolutePath);
            if (errorsRaw != null) {
                Type listOfNativeCrashError = new TypeToken<ArrayList<NativeCrashData.Error>>(){}.getType();
                try {
                    return (List)((Gson)this.gson.getValue()).fromJson(errorsRaw, listOfNativeCrashError);
                }
                catch (JsonSyntaxException e) {
                    this.logger.logError("Failed to parse native crash error file {crashId=" + nativeCrash.getNativeCrashId() + ", errorFilePath=" + absolutePath + "}");
                }
            } else {
                this.logger.logDeveloper("EmbraceNDKService", "Failed to load errorsRaw.");
            }
        } else {
            this.logger.logDeveloper("EmbraceNDKService", "Failed to find error file for crash.");
        }
        return null;
    }

    private String getMapFileContent(File mapFile) {
        if (mapFile != null) {
            this.logger.logDeveloper("EmbraceNDKService", "Processing map file at " + mapFile.getAbsolutePath());
            String mapContents = this.readMapFile(mapFile);
            if (mapContents != null) {
                return mapContents;
            }
            this.logger.logDeveloper("EmbraceNDKService", "Failed to load mapContents.");
        } else {
            this.logger.logDeveloper("EmbraceNDKService", "Failed to find map file for crash.");
        }
        return null;
    }

    @Override
    @Nullable
    public NativeCrashData checkForNativeCrash() {
        this.logger.logDeveloper("EmbraceNDKService", "Processing native crash check runnable.");
        NativeCrashData nativeCrash = null;
        List<File> matchingFiles = this.repository.sortNativeCrashes(false);
        this.logger.logDeveloper("EmbraceNDKService", "Found " + matchingFiles.size() + " native crashes.");
        for (File crashFile : matchingFiles) {
            try {
                String path = crashFile.getPath();
                String crashRaw = this.delegate._getCrashReport(path);
                this.logger.logDeveloper("EmbraceNDKService", "Processing native crash at " + path);
                if (crashRaw != null) {
                    nativeCrash = (NativeCrashData)((Gson)this.gson.getValue()).fromJson(crashRaw, NativeCrashData.class);
                    if (nativeCrash == null) {
                        this.logger.logError("Failed to deserialize native crash error file: " + crashFile.getAbsolutePath());
                    }
                } else {
                    this.logger.logError("Failed to load crash report at " + path);
                }
                File errorFile = this.repository.errorFileForCrash(crashFile);
                if (nativeCrash != null) {
                    List<NativeCrashData.Error> errors = this.getNativeCrashErrors(nativeCrash, errorFile);
                    if (errors != null) {
                        nativeCrash.setErrors(errors);
                    } else {
                        this.logger.logDeveloper("EmbraceNDKService", "Failed to find error file for crash.");
                    }
                } else {
                    this.logger.logDeveloper("EmbraceNDKService", "Failed to find error file for crash.");
                }
                File mapFile = this.repository.mapFileForCrash(crashFile);
                if (mapFile != null && nativeCrash != null) {
                    nativeCrash.setMap(this.getMapFileContent(mapFile));
                } else {
                    this.logger.logDeveloper("EmbraceNDKService", "Failed to find map file for crash.");
                }
                if (nativeCrash != null) {
                    Map<String, String> symbols = this.getSymbolsForCurrentArch();
                    if (symbols == null) {
                        this.logger.logError("Failed to find symbols for native crash - stacktraces will not symbolicate correctly.");
                    } else {
                        nativeCrash.setSymbols(symbols);
                        this.logger.logDeveloper("EmbraceNDKService", "Added symbols for native crash");
                    }
                    this.sendNativeCrash(nativeCrash);
                }
                this.repository.deleteFiles(crashFile, errorFile, mapFile, nativeCrash);
            }
            catch (JsonSyntaxException ex) {
                crashFile.delete();
                this.logger.logError("Failed to parse JSON from crash file {crashFilePath=" + crashFile.getAbsolutePath() + "}.", ex, true);
            }
            catch (IllegalStateException ex) {
                crashFile.delete();
                this.logger.logError("Failed to read native crash file {crashFilePath=" + crashFile.getAbsolutePath() + "}.", ex, true);
            }
            catch (Exception ex) {
                crashFile.delete();
                this.logger.logError("Failed to read native crash file {crashFilePath=" + crashFile.getAbsolutePath() + "}.", ex, true);
            }
        }
        return nativeCrash;
    }

    @Override
    @Nullable
    public Map<String, String> getSymbolsForCurrentArch() {
        return (Map)this.symbolsForArch.getValue();
    }

    private NativeSymbols getNativeSymbols() {
        Resources resources2 = this.context.getResources();
        int resourceId = resources2.getIdentifier(KEY_NDK_SYMBOLS, "string", this.context.getPackageName());
        if (resourceId != 0) {
            try {
                String encodedSymbols = new String(Base64.decode((String)this.context.getResources().getString(resourceId), (int)0));
                return (NativeSymbols)((Gson)this.gson.getValue()).fromJson(encodedSymbols, NativeSymbols.class);
            }
            catch (Exception ex) {
                this.logger.logError(String.format(Locale.getDefault(), "Failed to decode symbols from resources {resourceId=%d}.", resourceId), ex);
            }
        } else {
            this.logger.logError(String.format(Locale.getDefault(), "Failed to find symbols in resources {resourceId=%d}.", resourceId));
        }
        return null;
    }

    private File[] getNativeFiles(FilenameFilter filter) {
        File[] matchingFiles = null;
        File[] files = ((File)this.cacheDir.getValue()).listFiles();
        if (files == null) {
            return null;
        }
        for (File cached2 : files) {
            if (!cached2.isDirectory() || !cached2.getName().equals(NATIVE_CRASH_FILE_FOLDER)) continue;
            matchingFiles = cached2.listFiles(filter);
            break;
        }
        return matchingFiles;
    }

    private File[] getNativeErrorFiles() {
        FilenameFilter nativeCrashFilter2 = (f, name) -> name.startsWith(NATIVE_CRASH_FILE_PREFIX) && name.endsWith(NATIVE_CRASH_ERROR_FILE_SUFFIX);
        return this.getNativeFiles(nativeCrashFilter2);
    }

    private File[] getNativeMapFiles() {
        FilenameFilter nativeCrashFilter2 = (f, name) -> name.startsWith(NATIVE_CRASH_FILE_PREFIX) && name.endsWith(NATIVE_CRASH_MAP_FILE_SUFFIX);
        return this.getNativeFiles(nativeCrashFilter2);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String readMapFile(File mapFile) {
        try (FileInputStream fin = new FileInputStream(mapFile);){
            String string2;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(fin));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                string2 = sb.toString();
            }
            return string2;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void cleanOldCrashFiles() {
        this.cleanCacheWorker.submit(() -> {
            File[] mapFiles;
            File[] errorFiles;
            this.logger.logDeveloper("EmbraceNDKService", "Processing clean of old crash files.");
            List<File> sortedFiles = this.repository.sortNativeCrashes(true);
            int deleteCount = sortedFiles.size() - 4;
            if (deleteCount > 0) {
                LinkedList<File> files = new LinkedList<File>(sortedFiles);
                try {
                    for (int i = 0; i < deleteCount; ++i) {
                        File removed = files.get(i);
                        if (!files.get(i).delete()) continue;
                        this.logger.logDebug("Native crash file " + removed.getName() + " removed from cache");
                    }
                }
                catch (Exception ex) {
                    this.logger.logError("Failed to delete native crash from cache.", ex);
                }
            }
            if ((errorFiles = this.getNativeErrorFiles()) != null) {
                for (File errorFile : errorFiles) {
                    if (this.hasNativeCrashFile(errorFile)) {
                        this.logger.logDeveloper("EmbraceNDKService", "Skipping error file as it has a matching crash file " + errorFile.getAbsolutePath());
                        continue;
                    }
                    errorFile.delete();
                    this.logger.logDeveloper("EmbraceNDKService", "Deleting error file as it has no matching crash file " + errorFile.getAbsolutePath());
                }
            }
            if ((mapFiles = this.getNativeMapFiles()) != null) {
                for (File mapFile : mapFiles) {
                    if (this.hasNativeCrashFile(mapFile)) {
                        this.logger.logDeveloper("EmbraceNDKService", "Skipping map file as it has a matching crash file " + mapFile.getAbsolutePath());
                        continue;
                    }
                    mapFile.delete();
                    this.logger.logDeveloper("EmbraceNDKService", "Deleting map file as it has no matching crash file " + mapFile.getAbsolutePath());
                }
            }
            return null;
        });
    }

    private boolean hasNativeCrashFile(File file) {
        String filename = file.getAbsolutePath();
        if (!filename.contains(".")) {
            return false;
        }
        String crashFilename = filename.substring(0, filename.lastIndexOf(46)) + NATIVE_CRASH_FILE_SUFFIX;
        File crashFile = new File(crashFilename);
        return crashFile.exists();
    }

    private void sendNativeCrash(NativeCrashData nativeCrash) {
        this.logger.logDeveloper("EmbraceNDKService", "Constructing EventMessage from native crash.");
        Event nativeCrashEvent = new Event(CRASH_REPORT_EVENT_NAME, null, Uuid.getEmbUuid(), nativeCrash.getSessionId(), EmbraceEvent.Type.CRASH, nativeCrash.getTimestamp(), null, false, null, nativeCrash.getAppState(), null, nativeCrash.getMetadata().getSessionProperties(), null, null, null, null, null);
        EventMessage nativeCrashMessageEvent = new EventMessage(nativeCrashEvent, null, nativeCrash.getMetadata().getDeviceInfo(), nativeCrash.getMetadata().getAppInfo(), nativeCrash.getMetadata().getUserInfo(), null, null, 13, nativeCrash.getCrash());
        try {
            this.logger.logDeveloper("EmbraceNDKService", "About to send EventMessage from native crash.");
            this.deliveryService.sendEventAndWait(nativeCrashMessageEvent);
            this.logger.logDeveloper("EmbraceNDKService", "Finished send attempt for EventMessage from native crash.");
        }
        catch (Exception ex) {
            this.logger.logError("Failed to report native crash to the api {sessionId=" + nativeCrash.getSessionId() + ", crashId=" + nativeCrash.getNativeCrashId(), ex);
        }
    }

    private void updateAppState(String newAppState) {
        this.logger.logDeveloper("EmbraceNDKService", "NDK update (app state): " + newAppState);
        this.delegate._updateAppState(newAppState);
    }

    private void updateDeviceMetaData() {
        this.ndkStartupWorker.submit(() -> {
            this.logger.logDeveloper("EmbraceNDKService", "Processing NDK metadata update on bg thread.");
            NativeCrashData.NativeCrashMetadata newDeviceMetaData = new NativeCrashData.NativeCrashMetadata(this.metadataService.getAppInfo(), this.metadataService.getDeviceInfo(), this.userService.getUserInfo(), this.sessionProperties.get());
            String json = newDeviceMetaData.toJson();
            this.logger.logDeveloper("EmbraceNDKService", "NDK update (metadata): " + json);
            this.delegate._updateMetaData(json);
            return null;
        });
    }

    private void uninstallSignals() {
        this.delegate._uninstallSignals();
    }

    private void testCrashC() {
        this.delegate._testNativeCrash_C();
    }

    private void testCrashCpp() {
        this.delegate._testNativeCrash_CPP();
    }

    @Override
    public void applicationStartupComplete() {
    }

    @Override
    public void onView(@NonNull Activity activity) {
    }

    @Override
    public void onViewClose(@NonNull Activity activity) {
    }

    @Override
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle bundle) {
    }
}

