/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceNdkServiceRepository;
import io.embrace.android.embracesdk.NativeCrashData;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bJ\u0015\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/embrace/android/embracesdk/EmbraceNdkServiceRepository;", "", "context", "Landroid/content/Context;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "(Landroid/content/Context;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;)V", "companionFileForCrash", "Ljava/io/File;", "crashFile", "suffix", "", "deleteFiles", "", "errorFile", "mapFile", "nativeCrash", "Lio/embrace/android/embracesdk/NativeCrashData;", "errorFileForCrash", "getNativeCrashFiles", "", "()[Ljava/io/File;", "getNativeFiles", "filter", "Ljava/io/FilenameFilter;", "(Ljava/io/FilenameFilter;)[Ljava/io/File;", "mapFileForCrash", "sortNativeCrashes", "", "byOldest", "", "embrace-android-sdk_release"})
public final class EmbraceNdkServiceRepository {
    private final Context context;
    private final InternalEmbraceLogger logger;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> sortNativeCrashes(boolean byOldest) {
        Object[] nativeCrashFiles = this.getNativeCrashFiles();
        boolean bl = false;
        List nativeCrashList = new ArrayList();
        if (nativeCrashFiles != null) {
            Object[] objectArray = nativeCrashFiles;
            boolean bl2 = false;
            boolean bl3 = false;
            Object[] it = objectArray;
            boolean bl4 = false;
            CollectionsKt.addAll((Collection)nativeCrashList, (Object[])nativeCrashFiles);
            Map sorted = new HashMap();
            try {
                for (File f : nativeCrashList) {
                    sorted.put(f, f.lastModified());
                }
                Comparator comparator2 = byOldest ? (Comparator)new Comparator<File>(sorted){
                    final /* synthetic */ Map $sorted;

                    public final int compare(@NotNull File first, @NotNull File next) {
                        Integer n;
                        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
                        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
                        Long l = (Long)this.$sorted.get(first);
                        if (l != null) {
                            long l2 = l;
                            V v = this.$sorted.get(next);
                            Intrinsics.checkNotNull(v);
                            long l3 = l2 - ((Number)v).longValue();
                            n = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                        } else {
                            n = null;
                        }
                        Intrinsics.checkNotNull(n);
                        return n;
                    }
                    {
                        this.$sorted = map;
                    }
                } : (Comparator)new Comparator<File>(sorted){
                    final /* synthetic */ Map $sorted;

                    public final int compare(@NotNull File first, @NotNull File next) {
                        Integer n;
                        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
                        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
                        Long l = (Long)this.$sorted.get(next);
                        if (l != null) {
                            long l2 = l;
                            V v = this.$sorted.get(first);
                            Intrinsics.checkNotNull(v);
                            long l3 = l2 - ((Number)v).longValue();
                            n = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                        } else {
                            n = null;
                        }
                        Intrinsics.checkNotNull(n);
                        return n;
                    }
                    {
                        this.$sorted = map;
                    }
                };
                return CollectionsKt.sortedWith((Iterable)nativeCrashList, (Comparator)comparator2);
            }
            catch (Exception ex) {
                void this_$iv;
                InternalEmbraceLogger internalEmbraceLogger = this.logger;
                String msg$iv = "Failed sorting native crashes.";
                boolean logStacktrace$iv = false;
                boolean $i$f$logError = false;
                this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, ex, logStacktrace$iv);
            }
        }
        return nativeCrashList;
    }

    private final File[] getNativeCrashFiles() {
        FilenameFilter nativeCrashFilter2 = getNativeCrashFiles.nativeCrashFilter.1.INSTANCE;
        return this.getNativeFiles(nativeCrashFilter2);
    }

    private final File[] getNativeFiles(FilenameFilter filter) {
        File[] files;
        File[] matchingFiles = null;
        File[] fileArray = this.context.getCacheDir().listFiles();
        if (fileArray == null) {
            return null;
        }
        for (File cached2 : files = fileArray) {
            if (!cached2.isDirectory() || !Intrinsics.areEqual((Object)cached2.getName(), (Object)"ndk")) continue;
            matchingFiles = cached2.listFiles(filter);
            break;
        }
        return matchingFiles;
    }

    private final File companionFileForCrash(File crashFile, String suffix) {
        String crashFilename = crashFile.getAbsolutePath();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = crashFilename;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"crashFilename");
        String string3 = string2;
        int n = 0;
        int n2 = StringsKt.lastIndexOf$default((CharSequence)crashFilename, (char)'.', (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String errorFilename = stringBuilder.append(string5).append(suffix).toString();
        File errorFile = new File(errorFilename);
        return !errorFile.exists() ? null : errorFile;
    }

    @Nullable
    public final File errorFileForCrash(@NotNull File crashFile) {
        Intrinsics.checkNotNullParameter((Object)crashFile, (String)"crashFile");
        return this.companionFileForCrash(crashFile, ".error");
    }

    @Nullable
    public final File mapFileForCrash(@NotNull File crashFile) {
        Intrinsics.checkNotNullParameter((Object)crashFile, (String)"crashFile");
        return this.companionFileForCrash(crashFile, ".map");
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteFiles(@NotNull File crashFile, @Nullable File errorFile, @Nullable File mapFile, @Nullable NativeCrashData nativeCrash) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)crashFile, (String)"crashFile");
            if (!crashFile.delete()) {
                String msg = nativeCrash != null ? "Failed to delete native crash file {sessionId=" + nativeCrash.getSessionId() + ", crashId=" + nativeCrash.getNativeCrashId() + ", crashFilePath=" + crashFile.getAbsolutePath() + "}" : "Failed to delete native crash file {crashFilePath=" + crashFile.getAbsolutePath() + "}";
                InternalEmbraceLogger this_$iv = this.logger;
                Throwable throwable$iv = null;
                boolean logStacktrace$iv = false;
                boolean $i$f$logWarning = false;
                this_$iv.log(msg, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
            } else {
                void this_$iv;
                InternalEmbraceLogger msg = this.logger;
                String msg$iv = "Deleted processed crash file at " + crashFile.getAbsolutePath();
                Throwable throwable$iv = null;
                boolean $i$f$logDebug = false;
                this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
            }
            File file = errorFile;
            if (file != null) {
                file.delete();
            }
            File file2 = mapFile;
            if (file2 == null) break block3;
            file2.delete();
        }
    }

    public EmbraceNdkServiceRepository(@NotNull Context context2, @NotNull InternalEmbraceLogger logger) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context2;
        this.logger = logger;
    }
}

