/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceNetworkCaptureService;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EmbraceSerializer;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.NetworkCaptureService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.config.remote.NetworkCaptureRuleRemoteConfig;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.network.http.NetworkCaptureData;
import io.embrace.android.embracesdk.payload.NetworkCapturedCall;
import io.embrace.android.embracesdk.utils.NetworkCaptureEncryptionManager;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002JD\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010\u0011H\u0016J\u001c\u0010%\u001a\u0004\u0018\u00010\u00112\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020 H\u0002J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/embrace/android/embracesdk/EmbraceNetworkCaptureService;", "Lio/embrace/android/embracesdk/NetworkCaptureService;", "metadataService", "Lio/embrace/android/embracesdk/MetadataService;", "preferencesService", "Lio/embrace/android/embracesdk/PreferencesService;", "remoteLogger", "Lio/embrace/android/embracesdk/EmbraceRemoteLogger;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "serializer", "Lio/embrace/android/embracesdk/EmbraceSerializer;", "(Lio/embrace/android/embracesdk/MetadataService;Lio/embrace/android/embracesdk/PreferencesService;Lio/embrace/android/embracesdk/EmbraceRemoteLogger;Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/EmbraceSerializer;)V", "networkCaptureEncryptionManager", "Lkotlin/Lazy;", "Lio/embrace/android/embracesdk/utils/NetworkCaptureEncryptionManager;", "encryptNetworkCall", "", "capturedNetworkCall", "Lio/embrace/android/embracesdk/payload/NetworkCapturedCall;", "getNetworkCaptureRules", "", "Lio/embrace/android/embracesdk/config/remote/NetworkCaptureRuleRemoteConfig;", "url", "method", "getNetworkPayload", "logNetworkCapturedData", "", "httpMethod", "statusCode", "", "startTime", "", "endTime", "networkCaptureData", "Lio/embrace/android/embracesdk/network/http/NetworkCaptureData;", "errorMessage", "parseBody", "body", "", "maxSize", "shouldApplyRule", "", "rule", "duration", "Companion", "embrace-android-sdk_release"})
public final class EmbraceNetworkCaptureService
implements NetworkCaptureService {
    private final Lazy<NetworkCaptureEncryptionManager> networkCaptureEncryptionManager;
    private final MetadataService metadataService;
    private final PreferencesService preferencesService;
    private final EmbraceRemoteLogger remoteLogger;
    private final ConfigService configService;
    private final EmbraceSerializer serializer;
    public static final int NETWORK_ERROR_CODE = -1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public Set<NetworkCaptureRuleRemoteConfig> getNetworkCaptureRules(@NotNull String url, @NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        networkCaptureRules = CollectionsKt.toMutableSet((Iterable)this.configService.getNetworkBehavior().getNetworkCaptureRules());
        if (networkCaptureRules.isEmpty()) {
            var4_4 = InternalStaticEmbraceLogger.logger;
            msg$iv = "No network capture rules";
            throwable$iv = null;
            $i$f$logDebug = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
            return SetsKt.emptySet();
        }
        this_$iv = url;
        msg$iv = this.configService.getSdkEndpointBehavior().getData();
        throwable$iv = false;
        if (this_$iv.contentEquals(msg$iv)) {
            this_$iv = InternalStaticEmbraceLogger.logger;
            msg$iv = "Cannot intercept Embrace endpoints";
            throwable$iv = null;
            $i$f$logDebug = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
            return SetsKt.emptySet();
        }
        $this$filter$iv = networkCaptureRules;
        $i$f$filter = false;
        $i$f$logDebug = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            rule = (NetworkCaptureRuleRemoteConfig)element$iv$iv;
            $i$a$-filter-EmbraceNetworkCaptureService$getNetworkCaptureRules$applicableRules$1 = false;
            if (!StringsKt.contains$default((CharSequence)rule.getMethod(), (CharSequence)method, (boolean)false, (int)2, null)) ** GOTO lbl-1000
            var14_25 = rule.getUrlRegex();
            var15_26 = false;
            if (new Regex(var14_25).containsMatchIn((CharSequence)url) && rule.getExpiresIn() > 0L) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        applicableRules = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        $i$f$filter = false;
        rulesToRemove = new LinkedHashSet<E>();
        $this$forEach$iv = applicableRules;
        $i$f$forEach = false;
        destination$iv$iv = $this$forEach$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            element$iv = destination$iv$iv.next();
            rule = (NetworkCaptureRuleRemoteConfig)element$iv;
            $i$a$-forEach-EmbraceNetworkCaptureService$getNetworkCaptureRules$1 = false;
            if (!this.preferencesService.isNetworkCaptureRuleOver(rule.getId())) continue;
            rulesToRemove.add(rule);
        }
        networkCaptureRules.removeAll(rulesToRemove);
        applicableRules.removeAll(rulesToRemove);
        $this$forEach$iv = InternalStaticEmbraceLogger.logger;
        msg$iv = "Capture rule is: " + applicableRules;
        throwable$iv = null;
        $i$f$logDebug = false;
        this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
        return applicableRules;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logNetworkCapturedData(@NotNull String url2, @NotNull String httpMethod, int statusCode, long startTime, long endTime, @Nullable NetworkCaptureData networkCaptureData, @Nullable String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"httpMethod");
        long l = endTime - startTime;
        long l2 = 0L;
        boolean bl = false;
        long duration = Math.max(l, l2);
        Iterable $this$forEach$iv = this.getNetworkCaptureRules(url2, httpMethod);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void this_$iv;
            Object requestBody;
            NetworkCaptureRuleRemoteConfig rule = (NetworkCaptureRuleRemoteConfig)element$iv;
            boolean bl2 = false;
            if (this.shouldApplyRule(rule, duration, statusCode)) {
                NetworkCaptureData networkCaptureData2 = networkCaptureData;
                requestBody = this.parseBody((byte[])(networkCaptureData2 != null ? networkCaptureData2.getCapturedRequestBody() : null), rule.getMaxSize());
                Object object = networkCaptureData;
                if (object == null || (object = ((NetworkCaptureData)object).getDataCaptureErrorMessage()) == null) {
                    NetworkCaptureData networkCaptureData3 = networkCaptureData;
                    object = this.parseBody((byte[])(networkCaptureData3 != null ? networkCaptureData3.getCapturedResponseBody() : null), rule.getMaxSize());
                }
                Object responseBody = object;
                this.preferencesService.decreaseNetworkCaptureRuleRemainingCount(rule.getId(), rule.getMaxCount());
                NetworkCaptureData networkCaptureData4 = networkCaptureData;
                NetworkCaptureData networkCaptureData5 = networkCaptureData;
                NetworkCaptureData networkCaptureData6 = networkCaptureData;
                NetworkCaptureData networkCaptureData7 = networkCaptureData;
                NetworkCaptureData networkCaptureData8 = networkCaptureData;
                NetworkCaptureData networkCaptureData9 = networkCaptureData;
                NetworkCaptureData networkCaptureData10 = networkCaptureData;
                NetworkCapturedCall capturedNetworkCall = new NetworkCapturedCall(duration, endTime, httpMethod, rule.getUrlRegex(), null, (String)requestBody, networkCaptureData4 != null ? Integer.valueOf(networkCaptureData4.getRequestBodySize()) : null, networkCaptureData5 != null ? networkCaptureData5.getRequestQueryParams() : null, networkCaptureData6 != null ? networkCaptureData6.getRequestHeaders() : null, networkCaptureData7 != null ? Integer.valueOf(networkCaptureData7.getRequestBodySize()) : null, (String)responseBody, networkCaptureData8 != null ? Integer.valueOf(networkCaptureData8.getResponseBodySize()) : null, networkCaptureData9 != null ? networkCaptureData9.getResponseHeaders() : null, networkCaptureData10 != null ? Integer.valueOf(networkCaptureData10.getResponseBodySize()) : null, statusCode, this.metadataService.getActiveSessionId(), startTime, url2, errorMessage, null, 524304, null);
                NetworkCapturedCall networkLog = this.getNetworkPayload(capturedNetworkCall);
                this.remoteLogger.logNetwork(networkLog);
                return;
            }
            requestBody = InternalStaticEmbraceLogger.logger;
            String msg$iv = "The captured data doesn't match the rule criteria";
            Throwable throwable$iv = null;
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
        }
    }

    private final NetworkCapturedCall getNetworkPayload(NetworkCapturedCall capturedNetworkCall) {
        NetworkCapturedCall networkCapturedCall;
        if (this.configService.getNetworkBehavior().isCaptureBodyEncryptionEnabled()) {
            String encryptedPayload = this.encryptNetworkCall(capturedNetworkCall);
            networkCapturedCall = new NetworkCapturedCall(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, encryptedPayload, 524287, null);
        } else {
            networkCapturedCall = capturedNetworkCall;
        }
        return networkCapturedCall;
    }

    private final String encryptNetworkCall(NetworkCapturedCall capturedNetworkCall) {
        String string2 = this.configService.getNetworkBehavior().getCapturePublicKey();
        if (string2 == null) {
            return null;
        }
        String capturePublicKey = string2;
        return ((NetworkCaptureEncryptionManager)this.networkCaptureEncryptionManager.getValue()).encrypt(this.serializer.toJson(capturedNetworkCall), capturePublicKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldApplyRule(NetworkCaptureRuleRemoteConfig rule, long duration, int statusCode) {
        if (!rule.getStatusCodes().contains(statusCode)) return false;
        if (rule.getDuration() == null) return true;
        Long l = rule.getDuration();
        if (l != null && l == 0L) {
            return true;
        }
        if (duration < rule.getDuration()) return false;
        return true;
    }

    private final String parseBody(byte[] body, long maxSize) {
        if (body != null) {
            byte[] byArray = body;
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray;
            boolean bl3 = false;
            Number endIndex = (long)it.length > maxSize ? (Number)maxSize : (Number)it.length;
            return StringsKt.decodeToString((byte[])it, (int)0, (int)((Number)endIndex).intValue(), (boolean)false);
        }
        return null;
    }

    public EmbraceNetworkCaptureService(@NotNull MetadataService metadataService2, @NotNull PreferencesService preferencesService2, @NotNull EmbraceRemoteLogger remoteLogger2, @NotNull ConfigService configService2, @NotNull EmbraceSerializer serializer) {
        Intrinsics.checkNotNullParameter((Object)metadataService2, (String)"metadataService");
        Intrinsics.checkNotNullParameter((Object)preferencesService2, (String)"preferencesService");
        Intrinsics.checkNotNullParameter((Object)remoteLogger2, (String)"remoteLogger");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        this.metadataService = metadataService2;
        this.preferencesService = preferencesService2;
        this.remoteLogger = remoteLogger2;
        this.configService = configService2;
        this.serializer = serializer;
        this.networkCaptureEncryptionManager = LazyKt.lazy((Function0)networkCaptureEncryptionManager.1.INSTANCE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/EmbraceNetworkCaptureService$Companion;", "", "()V", "NETWORK_ERROR_CODE", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

