/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0018J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0012\u0010\u001a\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\u001b\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bJ\b\u0010\u001d\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/embrace/android/embracesdk/EmbraceSessionProperties;", "", "preferencesService", "Lio/embrace/android/embracesdk/PreferencesService;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "(Lio/embrace/android/embracesdk/PreferencesService;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;Lio/embrace/android/embracesdk/config/ConfigService;)V", "permanent", "", "", "temporary", "add", "", "key", "value", "isPermanent", "clearTemporary", "", "enforceLength", "maxLength", "", "get", "", "haveKey", "isValidKey", "isValidValue", "remove", "size", "Companion", "embrace-android-sdk_release"})
public final class EmbraceSessionProperties {
    private final Map<String, String> temporary;
    private Map<String, String> permanent;
    private final PreferencesService preferencesService;
    private final InternalEmbraceLogger logger;
    private final ConfigService configService;
    private static final int SESSION_PROPERTY_KEY_LIMIT = 128;
    private static final int SESSION_PROPERTY_VALUE_LIMIT = 1024;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final boolean haveKey(String key) {
        return this.permanent.containsKey(key) || this.temporary.containsKey(key);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValidKey(String key) {
        if (key == null) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv = "Session property key cannot be null";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            return false;
        }
        if (Intrinsics.areEqual((Object)key, (Object)"")) {
            InternalEmbraceLogger this_$iv = this.logger;
            String msg$iv = "Session property key cannot be empty string";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValidValue(String key) {
        if (key == null) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv = "Session property value cannot be null";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            return false;
        }
        return true;
    }

    private final String enforceLength(String value, int maxLength) {
        if (value.length() <= maxLength) {
            return value;
        }
        String endChars = "...";
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = value;
        int n = 0;
        int n2 = maxLength - endChars.length();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return stringBuilder.append(string4).append(endChars).toString();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean add(@NotNull String key, @NotNull String value, boolean isPermanent) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!this.isValidKey(key)) {
            return false;
        }
        String sanitizedKey = this.enforceLength(key, 128);
        if (!this.isValidValue(value)) {
            return false;
        }
        String sanitizedValue = this.enforceLength(value, 1024);
        int maxSessionProperties = this.configService.getSessionBehavior().getMaxSessionProperties();
        if (this.size() > maxSessionProperties || this.size() == maxSessionProperties && !this.haveKey(sanitizedKey)) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv = "Session property count is at its limit. Rejecting.";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            return false;
        }
        if (isPermanent) {
            this.permanent.put(sanitizedKey, sanitizedValue);
            this.temporary.remove(sanitizedKey);
            this.preferencesService.setPermanentSessionProperties(this.permanent);
        } else {
            if (this.permanent.remove(sanitizedKey) != null) {
                this.preferencesService.setPermanentSessionProperties(this.permanent);
            }
            this.temporary.put(sanitizedKey, sanitizedValue);
        }
        return true;
    }

    public final synchronized boolean remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!this.isValidKey(key)) {
            return false;
        }
        String sanitizedKey = this.enforceLength(key, 128);
        boolean existed = false;
        if (this.temporary.remove(sanitizedKey) != null) {
            existed = true;
        }
        if (this.permanent.remove(sanitizedKey) != null) {
            this.preferencesService.setPermanentSessionProperties(this.permanent);
            existed = true;
        }
        return existed;
    }

    @NotNull
    public final synchronized Map<String, String> get() {
        return MapsKt.plus(this.permanent, this.temporary);
    }

    private final int size() {
        return this.permanent.size() + this.temporary.size();
    }

    public final void clearTemporary() {
        this.temporary.clear();
    }

    /*
     * WARNING - void declaration
     */
    public EmbraceSessionProperties(@NotNull PreferencesService preferencesService2, @NotNull InternalEmbraceLogger logger, @NotNull ConfigService configService2) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)preferencesService2, (String)"preferencesService");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        this.preferencesService = preferencesService2;
        this.logger = logger;
        this.configService = configService2;
        this.temporary = new HashMap();
        Map<String, String> existingPermanent = this.preferencesService.getPermanentSessionProperties();
        EmbraceSessionProperties embraceSessionProperties = this;
        Map<String, String> map2 = existingPermanent;
        if (map2 != null) {
            void p1;
            Map<String, String> map3 = map2;
            boolean bl = false;
            boolean bl2 = false;
            Map<String, String> map4 = map3;
            EmbraceSessionProperties embraceSessionProperties2 = embraceSessionProperties;
            boolean bl3 = false;
            HashMap hashMap = new HashMap(p1);
            embraceSessionProperties = embraceSessionProperties2;
            map = hashMap;
        } else {
            map = new HashMap();
        }
        embraceSessionProperties.permanent = map;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/embrace/android/embracesdk/EmbraceSessionProperties$Companion;", "", "()V", "SESSION_PROPERTY_KEY_LIMIT", "", "SESSION_PROPERTY_VALUE_LIMIT", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

