/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSessionProperties;
import io.embrace.android.embracesdk.EmbraceSessionService$sam$java_lang_Runnable$0;
import io.embrace.android.embracesdk.NdkService;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SessionHandler;
import io.embrace.android.embracesdk.SessionMessage;
import io.embrace.android.embracesdk.SessionService;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.comms.delivery.DeliveryService;
import io.embrace.android.embracesdk.internal.spans.EmbraceAttributes;
import io.embrace.android.embracesdk.internal.spans.SpansService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0011\b\u0000\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0010H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001bH\u0002J\b\u0010'\u001a\u0004\u0018\u00010\u0017J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0)H\u0016J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u001eH\u0016J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u001bH\u0016J \u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001bH\u0016J\b\u00101\u001a\u00020\"H\u0007J\u0010\u00102\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u00103\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bJ \u00104\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u00102\u0006\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020\u001bH\u0016J\u0018\u00107\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0010\u00108\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0016R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lio/embrace/android/embracesdk/EmbraceSessionService;", "Lio/embrace/android/embracesdk/SessionService;", "Lio/embrace/android/embracesdk/ActivityListener;", "activityService", "Lio/embrace/android/embracesdk/ActivityService;", "ndkService", "Lio/embrace/android/embracesdk/NdkService;", "sessionProperties", "Lio/embrace/android/embracesdk/EmbraceSessionProperties;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "sessionHandler", "Lio/embrace/android/embracesdk/SessionHandler;", "deliveryService", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;", "isNdkEnabled", "", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "spansService", "Lio/embrace/android/embracesdk/internal/spans/SpansService;", "(Lio/embrace/android/embracesdk/ActivityService;Lio/embrace/android/embracesdk/NdkService;Lio/embrace/android/embracesdk/EmbraceSessionProperties;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;Lio/embrace/android/embracesdk/SessionHandler;Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;ZLio/embrace/android/embracesdk/clock/Clock;Lio/embrace/android/embracesdk/internal/spans/SpansService;)V", "activeSession", "Lio/embrace/android/embracesdk/Session;", "lock", "", "sdkStartupDuration", "", "addProperty", "key", "", "value", "permanent", "close", "", "endSession", "endType", "Lio/embrace/android/embracesdk/Session$SessionLifeEventType;", "endTime", "getActiveSession", "getProperties", "", "handleCrash", "crashId", "onBackground", "timestamp", "onForeground", "coldStart", "startupTime", "onPeriodicCacheActiveSession", "removeProperty", "setSdkStartupDuration", "startSession", "startType", "startTime", "startStateSession", "triggerStatelessSessionEnd", "Companion", "embrace-android-sdk_release"})
public final class EmbraceSessionService
implements SessionService,
ActivityListener {
    private final Object lock;
    private long sdkStartupDuration;
    private volatile Session activeSession;
    private final ActivityService activityService;
    private final NdkService ndkService;
    private final EmbraceSessionProperties sessionProperties;
    private final InternalEmbraceLogger logger;
    private final SessionHandler sessionHandler;
    private final DeliveryService deliveryService;
    private final boolean isNdkEnabled;
    private final Clock clock;
    private final SpansService spansService;
    private static final String TAG = "EmbraceSessionService";
    @NotNull
    public static final String APPLICATION_STATE_FOREGROUND = "foreground";
    public static final long minSessionTime = 5000L;
    public static final int SESSION_CACHING_INTERVAL = 2;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void setSdkStartupDuration(long sdkStartupDuration) {
        void className$iv;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String msg$iv = "Setting startup duration: " + sdkStartupDuration;
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        this.sdkStartupDuration = sdkStartupDuration;
    }

    @Override
    public void startSession(boolean coldStart, @NotNull Session.SessionLifeEventType startType, long startTime) {
        InternalEmbraceLogger this_$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)startType), (String)"startType");
        Runnable automaticSessionCloserCallback2 = new Runnable(this){
            final /* synthetic */ EmbraceSessionService this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void run() {
                try {
                    Object object = EmbraceSessionService.access$getLock$p(this.this$0);
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        void this_$iv;
                        boolean bl3 = false;
                        InternalEmbraceLogger internalEmbraceLogger = EmbraceSessionService.access$getLogger$p(this.this$0);
                        String msg$iv = "Automatic session closing triggered.";
                        boolean $i$f$logInfo = false;
                        this_$iv.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
                        this.this$0.triggerStatelessSessionEnd(Session.SessionLifeEventType.TIMED);
                        Unit unit = Unit.INSTANCE;
                    }
                }
                catch (Exception ex) {
                    void this_$iv;
                    InternalEmbraceLogger internalEmbraceLogger = EmbraceSessionService.access$getLogger$p(this.this$0);
                    String msg$iv = "Error while trying to close the session automatically";
                    boolean logStacktrace$iv = false;
                    boolean $i$f$logError = false;
                    this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, ex, logStacktrace$iv);
                }
            }
            {
                this.this$0 = embraceSessionService;
            }
        };
        Object object = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((EmbraceSessionService)this.receiver).onPeriodicCacheActiveSession();
            }
        };
        SessionMessage sessionMessage2 = this.sessionHandler.onSessionStarted(coldStart, startType, startTime, this.sessionProperties, automaticSessionCloserCallback2, new EmbraceSessionService$sam$java_lang_Runnable$0((Function0)object));
        if (sessionMessage2 != null) {
            String className$iv;
            object = this.logger;
            String string2 = TAG;
            String msg$iv = "Session Message is created";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            this.activeSession = sessionMessage2.getSession();
            this_$iv = this.logger;
            className$iv = TAG;
            Session session2 = this.activeSession;
            msg$iv = "Active session: " + (session2 != null ? session2.getSessionId() : null);
            throwable$iv = null;
            $i$f$logDeveloper = false;
            this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        } else {
            this_$iv = this.logger;
            String className$iv = TAG;
            String msg$iv = "Session Message is NULL";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCrash(@NotNull String crashId) {
        block6: {
            Object object;
            String className$iv22;
            Object this_$iv;
            boolean $i$f$logDeveloper;
            Throwable throwable$iv;
            String msg$iv22;
            block5: {
                Intrinsics.checkNotNullParameter((Object)crashId, (String)"crashId");
                InternalEmbraceLogger internalEmbraceLogger = this.logger;
                String string2 = TAG;
                msg$iv22 = "Attempt to handle crash id: " + crashId;
                throwable$iv = null;
                $i$f$logDeveloper = false;
                ((InternalEmbraceLogger)this_$iv).log('[' + className$iv22 + "] " + msg$iv22, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                object = this.activeSession;
                if (object == null) break block5;
                this_$iv = object;
                boolean className$iv22 = false;
                boolean msg$iv22 = false;
                Object it = this_$iv;
                boolean bl = false;
                Object object2 = this.lock;
                boolean bl2 = false;
                boolean bl3 = false;
                synchronized (object2) {
                    boolean bl4 = false;
                    this.sessionHandler.onCrash((Session)it, crashId, this.sessionProperties, this.sdkStartupDuration, this.spansService.flushSpans(EmbraceAttributes.AppTerminationCause.CRASH));
                    Unit unit = Unit.INSTANCE;
                }
                object = this_$iv;
                if (object != null) break block6;
            }
            this_$iv = this.logger;
            className$iv22 = TAG;
            msg$iv22 = "Active session is NULL";
            throwable$iv = null;
            $i$f$logDeveloper = false;
            ((InternalEmbraceLogger)this_$iv).log('[' + className$iv22 + "] " + msg$iv22, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            object = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void onPeriodicCacheActiveSession() {
        try {
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                Unit unit;
                SessionMessage activeSessionInfo;
                boolean bl3 = false;
                SessionMessage sessionMessage2 = activeSessionInfo = this.sessionHandler.getActiveSessionEndMessage(this.activeSession, this.sessionProperties, this.sdkStartupDuration, this.spansService.completedSpans());
                if (sessionMessage2 != null) {
                    SessionMessage sessionMessage3 = sessionMessage2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    SessionMessage it = sessionMessage3;
                    boolean bl6 = false;
                    this.deliveryService.saveSession(it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
        }
        catch (Exception ex) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv = "Error while caching active session";
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, ex, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onForeground(boolean coldStart, long startupTime, long timestamp) {
        void className$iv;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String msg$iv = "OnForeground. Starting session.";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        this.startStateSession(coldStart, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void startStateSession(boolean coldStart, long endTime) {
        void className$iv;
        void this_$iv;
        Object object = this.logger;
        String string2 = TAG;
        String msg$iv = "Start state session. Is cold start: " + coldStart;
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.startSession(coldStart, Session.SessionLifeEventType.STATE, endTime);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onBackground(long timestamp) {
        void className$iv;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String msg$iv = "OnBackground. Ending session.";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        this.endSession(Session.SessionLifeEventType.STATE, timestamp);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void triggerStatelessSessionEnd(@NotNull Session.SessionLifeEventType endType) {
        String className$iv;
        String msg$iv2;
        InternalEmbraceLogger this_$iv2;
        Intrinsics.checkNotNullParameter((Object)((Object)endType), (String)"endType");
        if (Session.SessionLifeEventType.STATE == endType) {
            void this_$iv2;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv2 = "triggerStatelessSessionEnd is not allowed to be called for SessionLifeEventType=" + (Object)((Object)endType);
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv2.log(msg$iv2, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
            return;
        }
        this.endSession(endType, this.clock.now());
        if (!this.activityService.isInBackground()) {
            this_$iv2 = this.logger;
            msg$iv2 = TAG;
            String msg$iv3 = "Activity is not in background, starting session.";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv2.log('[' + className$iv + "] " + msg$iv3, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            this.startSession(false, endType, this.clock.now());
        } else {
            this_$iv2 = this.logger;
            className$iv = TAG;
            String msg$iv4 = "Activity in background, not starting session.";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv2.log('[' + className$iv + "] " + msg$iv4, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        }
        this_$iv2 = this.logger;
        msg$iv2 = "Session successfully closed.";
        boolean $i$f$logInfo = false;
        this_$iv2.log(msg$iv2, EmbraceLogger.Severity.INFO, null, true);
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void endSession(Session.SessionLifeEventType endType, long endTime) {
        void className$iv;
        InternalEmbraceLogger this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String msg$iv = "Will try to end session.";
        Throwable throwable$iv = null;
        boolean $i$f$logDebug = false;
        this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
        this.sessionHandler.onSessionEnded(endType, this.activeSession, this.sessionProperties, this.sdkStartupDuration, endTime, SpansService.DefaultImpls.flushSpans$default(this.spansService, null, 1, null));
        this.activeSession = null;
        this_$iv = this.logger;
        msg$iv = TAG;
        String msg$iv2 = "Active session cleared";
        Throwable throwable$iv2 = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String msg$iv = "Shutting down EmbraceSessionService";
        boolean $i$f$logInfo = false;
        this_$iv.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
        this.sessionHandler.close();
    }

    @Nullable
    public final Session getActiveSession() {
        return this.activeSession;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addProperty(@NotNull String key, @NotNull String value, boolean permanent) {
        String className$iv;
        InternalEmbraceLogger this_$iv;
        String msg$iv;
        InternalEmbraceLogger className$iv2;
        void this_$iv2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String msg$iv2 = "Add Property: " + key + " - " + value;
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv2.log('[' + (String)((Object)className$iv2) + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        boolean added = this.sessionProperties.add(key, value, permanent);
        if (added) {
            className$iv2 = this.logger;
            msg$iv2 = TAG;
            msg$iv = "Session properties updated";
            Throwable throwable$iv2 = null;
            boolean $i$f$logDeveloper2 = false;
            this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
            this.ndkService.onSessionPropertiesUpdate(this.sessionProperties.get());
        } else {
            this_$iv = this.logger;
            className$iv = TAG;
            msg$iv = "Cannot add property: " + key;
            Throwable throwable$iv3 = null;
            boolean $i$f$logDeveloper3 = false;
            this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv3, true);
        }
        return added;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeProperty(@NotNull String key) {
        String className$iv;
        InternalEmbraceLogger this_$iv;
        String msg$iv;
        InternalEmbraceLogger className$iv2;
        void this_$iv2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String msg$iv2 = "Remove Property: " + key;
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv2.log('[' + (String)((Object)className$iv2) + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        boolean removed = this.sessionProperties.remove(key);
        if (removed) {
            className$iv2 = this.logger;
            msg$iv2 = TAG;
            msg$iv = "Session properties updated";
            Throwable throwable$iv2 = null;
            boolean $i$f$logDeveloper2 = false;
            this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
            this.ndkService.onSessionPropertiesUpdate(this.sessionProperties.get());
        } else {
            this_$iv = this.logger;
            className$iv = TAG;
            msg$iv = "Cannot remove property: " + key;
            Throwable throwable$iv3 = null;
            boolean $i$f$logDeveloper3 = false;
            this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv3, true);
        }
        return removed;
    }

    @Override
    @NotNull
    public Map<String, String> getProperties() {
        return this.sessionProperties.get();
    }

    /*
     * WARNING - void declaration
     */
    public EmbraceSessionService(@NotNull ActivityService activityService2, @NotNull NdkService ndkService2, @NotNull EmbraceSessionProperties sessionProperties, @NotNull InternalEmbraceLogger logger, @NotNull SessionHandler sessionHandler2, @NotNull DeliveryService deliveryService2, boolean isNdkEnabled, @NotNull Clock clock2, @NotNull SpansService spansService2) {
        Intrinsics.checkNotNullParameter((Object)activityService2, (String)"activityService");
        Intrinsics.checkNotNullParameter((Object)ndkService2, (String)"ndkService");
        Intrinsics.checkNotNullParameter((Object)sessionProperties, (String)"sessionProperties");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)sessionHandler2, (String)"sessionHandler");
        Intrinsics.checkNotNullParameter((Object)deliveryService2, (String)"deliveryService");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)spansService2, (String)"spansService");
        this.activityService = activityService2;
        this.ndkService = ndkService2;
        this.sessionProperties = sessionProperties;
        this.logger = logger;
        this.sessionHandler = sessionHandler2;
        this.deliveryService = deliveryService2;
        this.isNdkEnabled = isNdkEnabled;
        this.clock = clock2;
        this.spansService = spansService2;
        this.lock = new Object();
        if (!this.activityService.isInBackground()) {
            void className$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = TAG;
            String msg$iv = "Forcing cold start";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            this.startStateSession(true, this.clock.now());
        }
        Session session2 = this.activeSession;
        this.deliveryService.sendCachedSessions(this.isNdkEnabled, this.ndkService, session2 != null ? session2.getSessionId() : null);
    }

    @Override
    public void applicationStartupComplete() {
        ActivityListener.DefaultImpls.applicationStartupComplete(this);
    }

    @Override
    public void onView(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onView(this, activity);
    }

    @Override
    public void onViewClose(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onViewClose(this, activity);
    }

    @Override
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onActivityCreated(this, activity, bundle);
    }

    public static final /* synthetic */ Object access$getLock$p(EmbraceSessionService $this) {
        return $this.lock;
    }

    public static final /* synthetic */ InternalEmbraceLogger access$getLogger$p(EmbraceSessionService $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/embrace/android/embracesdk/EmbraceSessionService$Companion;", "", "()V", "APPLICATION_STATE_FOREGROUND", "", "SESSION_CACHING_INTERVAL", "", "TAG", "minSessionTime", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

