/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSessionProperties;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventDescription;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.NativeCrash;
import io.embrace.android.embracesdk.StartupEventInfo;
import io.embrace.android.embracesdk.capture.PerformanceInfoService;
import io.embrace.android.embracesdk.capture.screenshot.ScreenshotService;
import io.embrace.android.embracesdk.capture.user.UserService;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.comms.delivery.DeliveryService;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.payload.AppInfo;
import io.embrace.android.embracesdk.payload.DeviceInfo;
import io.embrace.android.embracesdk.payload.PerformanceInfo;
import io.embrace.android.embracesdk.payload.Stacktraces;
import io.embrace.android.embracesdk.payload.UserInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014JN\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0001\u0018\u00010!H\u0002J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JF\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0001\u0018\u00010!H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0016H\u0002J\u0016\u0010,\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u0016J\u0010\u0010/\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\"H\u0002J\u0018\u00100\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u0019H\u0002J\u0018\u00101\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u00102\u001a\u000203H\u0002J\u0006\u00104\u001a\u00020\u001cJ\u000e\u00105\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\"J4\u00106\u001a\u00020$2\u0006\u00107\u001a\u0002032\u0006\u0010\u001d\u001a\u00020\u001c2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0001\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u001fJL\u00108\u001a\u0002032\u0006\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0001\u0018\u00010!2\u0006\u0010:\u001a\u00020;J\u0012\u0010<\u001a\u00020\u001c2\b\u0010=\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010>\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u00102\u001a\u000203H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lio/embrace/android/embracesdk/EventHandler;", "", "metadataService", "Lio/embrace/android/embracesdk/MetadataService;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "userService", "Lio/embrace/android/embracesdk/capture/user/UserService;", "screenshotService", "Lio/embrace/android/embracesdk/capture/screenshot/ScreenshotService;", "performanceInfoService", "Lio/embrace/android/embracesdk/capture/PerformanceInfoService;", "deliveryService", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lio/embrace/android/embracesdk/MetadataService;Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/capture/user/UserService;Lio/embrace/android/embracesdk/capture/screenshot/ScreenshotService;Lio/embrace/android/embracesdk/capture/PerformanceInfoService;Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;Lio/embrace/android/embracesdk/clock/Clock;Ljava/util/concurrent/ScheduledExecutorService;)V", "buildEndEvent", "Lio/embrace/android/embracesdk/Event;", "originEvent", "endTime", "", "duration", "screenshotTaken", "", "late", "sessionProperties", "Lio/embrace/android/embracesdk/EmbraceSessionProperties;", "eventProperties", "", "", "buildEndEventMessage", "Lio/embrace/android/embracesdk/EventMessage;", "event", "startTime", "buildStartEvent", "eventId", "eventName", "threshold", "buildStartEventMessage", "buildStartupEventInfo", "Lio/embrace/android/embracesdk/StartupEventInfo;", "endEvent", "calculateLateThreshold", "calculateOffset", "handleScreenshot", "eventDescription", "Lio/embrace/android/embracesdk/EventDescription;", "isAllowedToEnd", "isAllowedToStart", "onEventEnded", "originEventDescription", "onEventStarted", "allowScreenshot", "timeoutCallback", "Ljava/lang/Runnable;", "shouldSendMoment", "name", "shouldTakeScreenshot", "embrace-android-sdk_release"})
public final class EventHandler {
    private final MetadataService metadataService;
    private final ConfigService configService;
    private final UserService userService;
    private final ScreenshotService screenshotService;
    private final PerformanceInfoService performanceInfoService;
    private final DeliveryService deliveryService;
    private final InternalEmbraceLogger logger;
    private final Clock clock;
    private final ScheduledExecutorService scheduledExecutor;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EventDescription onEventStarted(@NotNull String eventId, @NotNull String eventName, long startTime, boolean allowScreenshot, @NotNull EmbraceSessionProperties sessionProperties, @Nullable Map<String, ? extends Object> eventProperties, @NotNull Runnable timeoutCallback) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)sessionProperties, (String)"sessionProperties");
        Intrinsics.checkNotNullParameter((Object)timeoutCallback, (String)"timeoutCallback");
        long threshold = this.calculateLateThreshold(eventId);
        Event event = this.buildStartEvent(eventId, eventName, startTime, threshold, sessionProperties, eventProperties);
        ScheduledFuture<?> timer = this.scheduledExecutor.schedule(timeoutCallback, threshold - this.calculateOffset(startTime, threshold), TimeUnit.MILLISECONDS);
        if (this.shouldSendMoment(eventName)) {
            EventMessage eventMessage = this.buildStartEventMessage(event);
            this.deliveryService.sendEventAsync(eventMessage);
        } else {
            void this_$iv;
            InternalEmbraceLogger eventMessage = this.logger;
            String msg$iv = eventName + " start moment not sent based on gating config.";
            Throwable throwable$iv = null;
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
        }
        ScheduledFuture<?> scheduledFuture = timer;
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"timer");
        return new EventDescription((Future)scheduledFuture, event, allowScreenshot);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EventMessage onEventEnded(@NotNull EventDescription originEventDescription, boolean late, @Nullable Map<String, ? extends Object> eventProperties, @NotNull EmbraceSessionProperties sessionProperties) {
        Intrinsics.checkNotNullParameter((Object)originEventDescription, (String)"originEventDescription");
        Intrinsics.checkNotNullParameter((Object)sessionProperties, (String)"sessionProperties");
        Event event = originEventDescription.getEvent();
        Long l = event.timestamp;
        long startTime = l != null ? l : 0L;
        long endTime = this.clock.now();
        long duration = Math.max(0L, endTime - startTime);
        boolean screenshotTaken = this.handleScreenshot(late, originEventDescription);
        originEventDescription.getLateTimer().cancel(false);
        Event endEvent = this.buildEndEvent(event, endTime, duration, screenshotTaken, late, sessionProperties, eventProperties);
        EventMessage endEventMessage = this.buildEndEventMessage(endEvent, startTime, endTime);
        if (this.shouldSendMoment(event.name)) {
            this.deliveryService.sendEventAsync(endEventMessage);
        } else {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv = event.name + " end moment not sent based on gating config.";
            Throwable throwable$iv = null;
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
        }
        return endEventMessage;
    }

    public final boolean isAllowedToStart(@NotNull String eventName) {
        boolean bl;
        InternalEmbraceLogger this_$iv;
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Object object = eventName;
        boolean bl2 = false;
        boolean bl3 = false;
        if (object.length() == 0) {
            object = this.logger;
            String msg$iv = "Event name is empty. Ignoring this event.";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
            bl = false;
        } else if (!this.configService.getDataCaptureEventBehavior().isEventEnabled(eventName)) {
            this_$iv = this.logger;
            String msg$iv = "Event disabled. Ignoring event with name " + eventName;
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
            bl = false;
        } else if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.EVENT)) {
            this_$iv = this.logger;
            String msg$iv = "Event message disabled. Ignoring all Events.";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
            bl = false;
        } else if (this.scheduledExecutor.isShutdown()) {
            this_$iv = this.logger;
            String msg$iv = "Cannot start event as service is shut down";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAllowedToEnd() {
        boolean bl;
        if (!this.configService.getDataCaptureEventBehavior().isMessageTypeEnabled(MessageType.EVENT)) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv = "Event message disabled. Ignoring all Events.";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @NotNull
    public final StartupEventInfo buildStartupEventInfo(@NotNull Event originEvent, @NotNull Event endEvent) {
        Intrinsics.checkNotNullParameter((Object)originEvent, (String)"originEvent");
        Intrinsics.checkNotNullParameter((Object)endEvent, (String)"endEvent");
        return new StartupEventInfo(endEvent.duration, originEvent.lateThreshold);
    }

    private final EventMessage buildEndEventMessage(Event event, long startTime, long endTime) {
        NativeCrash nativeCrash = null;
        int n = 0;
        Stacktraces stacktraces = null;
        UserInfo userInfo2 = this.userService.getUserInfo();
        PerformanceInfo performanceInfo2 = this.performanceInfoService.getPerformanceInfo(startTime, endTime, false);
        return new EventMessage(event, null, null, null, userInfo2, performanceInfo2, stacktraces, n, nativeCrash, 462, null);
    }

    private final boolean shouldSendMoment(String name) {
        return Intrinsics.areEqual((Object)name, (Object)"_startup") ? !this.configService.getSessionBehavior().shouldGateStartupMoment() : !this.configService.getSessionBehavior().shouldGateMoment();
    }

    private final EventMessage buildStartEventMessage(Event event) {
        NativeCrash nativeCrash = null;
        int n = 0;
        Stacktraces stacktraces = null;
        PerformanceInfo performanceInfo2 = null;
        DeviceInfo deviceInfo2 = this.metadataService.getDeviceInfo();
        AppInfo appInfo2 = this.metadataService.getAppInfo();
        UserInfo userInfo2 = this.userService.getUserInfo();
        return new EventMessage(event, null, deviceInfo2, appInfo2, userInfo2, performanceInfo2, stacktraces, n, nativeCrash, 482, null);
    }

    private final Event buildStartEvent(String eventId, String eventName, long startTime, long threshold, EmbraceSessionProperties sessionProperties, Map<String, ? extends Object> eventProperties) {
        Integer n = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        List list = null;
        Map<String, ? extends Object> map = eventProperties;
        Map<String, String> map2 = sessionProperties.get();
        Long l = startTime;
        Long l2 = null;
        Boolean bl = null;
        Long l3 = threshold;
        String string5 = this.metadataService.getAppState();
        EmbraceEvent.Type type2 = EmbraceEvent.Type.START;
        String string6 = eventId;
        String string7 = this.metadataService.getActiveSessionId();
        return new Event(eventName, null, string6, string7, type2, l, l3, bl, l2, string5, map, map2, list, string4, string3, string2, n, 127362, null);
    }

    private final Event buildEndEvent(Event originEvent, long endTime, long duration, boolean screenshotTaken, boolean late, EmbraceSessionProperties sessionProperties, Map<String, ? extends Object> eventProperties) {
        Integer n = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        List list = null;
        Map<String, String> map = sessionProperties.get();
        Map<String, ? extends Object> map2 = eventProperties;
        EmbraceEvent.Type type2 = late ? EmbraceEvent.Type.LATE : EmbraceEvent.Type.END;
        Boolean bl = screenshotTaken;
        String string5 = this.metadataService.getAppState();
        Long l = null;
        Long l2 = duration;
        Long l3 = endTime;
        return new Event(originEvent.name, null, originEvent.eventId, this.metadataService.getActiveSessionId(), type2, l3, l, bl, l2, string5, map2, map, list, string4, string3, string2, n, 127042, null);
    }

    private final long calculateOffset(long startTime, long threshold) {
        return Math.min(threshold, Math.max(0L, this.clock.now() - startTime));
    }

    private final long calculateLateThreshold(String eventId) {
        Map<String, Long> limits = this.configService.getDataCaptureEventBehavior().getEventLimits();
        Long value = limits.get(eventId);
        return value == null || !limits.containsKey(eventId) ? 5000L : value;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean handleScreenshot(boolean late, EventDescription eventDescription2) {
        if (this.shouldTakeScreenshot(late, eventDescription2)) {
            boolean bl;
            try {
                String string2 = eventDescription2.getEvent().eventId;
                Intrinsics.checkNotNull((Object)string2);
                bl = this.screenshotService.takeScreenshotMoment(string2);
            }
            catch (Exception ex) {
                void msg$iv;
                void this_$iv;
                InternalEmbraceLogger internalEmbraceLogger = this.logger;
                String string3 = "Failed to take screenshot for event " + eventDescription2.getEvent().name;
                boolean logStacktrace$iv = false;
                boolean $i$f$logWarning = false;
                this_$iv.log((String)msg$iv, EmbraceLogger.Severity.WARNING, ex, logStacktrace$iv);
                bl = false;
            }
            return bl;
        }
        return false;
    }

    private final boolean shouldTakeScreenshot(boolean late, EventDescription eventDescription2) {
        return late && eventDescription2.isAllowScreenshot() && this.configService.getDataCaptureEventBehavior().isScreenshotEnabledForEvent(eventDescription2.getEvent().name);
    }

    public EventHandler(@NotNull MetadataService metadataService2, @NotNull ConfigService configService2, @NotNull UserService userService2, @NotNull ScreenshotService screenshotService2, @NotNull PerformanceInfoService performanceInfoService2, @NotNull DeliveryService deliveryService2, @NotNull InternalEmbraceLogger logger, @NotNull Clock clock2, @NotNull ScheduledExecutorService scheduledExecutor) {
        Intrinsics.checkNotNullParameter((Object)metadataService2, (String)"metadataService");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)userService2, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)screenshotService2, (String)"screenshotService");
        Intrinsics.checkNotNullParameter((Object)performanceInfoService2, (String)"performanceInfoService");
        Intrinsics.checkNotNullParameter((Object)deliveryService2, (String)"deliveryService");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)scheduledExecutor, (String)"scheduledExecutor");
        this.metadataService = metadataService2;
        this.configService = configService2;
        this.userService = userService2;
        this.screenshotService = screenshotService2;
        this.performanceInfoService = performanceInfoService2;
        this.deliveryService = deliveryService2;
        this.logger = logger;
        this.clock = clock2;
        this.scheduledExecutor = scheduledExecutor;
    }
}

