/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.annotation.TargetApi;
import android.app.usage.StorageStats;
import android.app.usage.StorageStatsManager;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.os.StatFs;
import android.os.SystemClock;
import android.os.storage.StorageManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

final class MetadataUtils {
    private static final String OS_VERSION = "Android OS";
    private static final String ENVIRONMENT_DEV = "dev";
    private static final String ENVIRONMENT_PROD = "prod";
    private static final List<String> JAILBREAK_LOCATIONS = Arrays.asList("/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/");
    private static final Pattern appIdPattern = Pattern.compile("^[A-Za-z0-9]{5}$");

    static String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    static String getModel() {
        return Build.MODEL;
    }

    static String getArchitecture() {
        return Build.VERSION.SDK_INT >= 21 ? Build.SUPPORTED_ABIS[0] : Build.CPU_ABI;
    }

    static String getLocale() {
        return Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
    }

    static String getOperatingSystemType() {
        return OS_VERSION;
    }

    static String getOperatingSystemVersion() {
        return String.valueOf(Build.VERSION.RELEASE);
    }

    static int getOperatingSystemVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    static Long getSystemUptime() {
        return SystemClock.uptimeMillis();
    }

    @Nullable
    static String getScreenResolution(WindowManager windowManager2) {
        try {
            InternalStaticEmbraceLogger.logDeveloper("MetadataUtils", "Computing screen resolution");
            Display display = windowManager2.getDefaultDisplay();
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getMetrics(displayMetrics);
            return String.format(Locale.US, "%dx%d", displayMetrics.widthPixels, displayMetrics.heightPixels);
        }
        catch (Exception ex) {
            InternalStaticEmbraceLogger.logDebug("Could not determine screen resolution", ex);
            return null;
        }
    }

    static String getTimezoneId() {
        return TimeZone.getDefault().getID();
    }

    static long getInternalStorageTotalCapacity(StatFs statFs2) {
        if (Build.VERSION.SDK_INT >= 18) {
            return statFs2.getTotalBytes();
        }
        return (long)statFs2.getBlockCount() * (long)statFs2.getBlockSize();
    }

    static long getInternalStorageFreeCapacity(StatFs statFs2) {
        InternalStaticEmbraceLogger.logDeveloper("MetadataUtils", "Getting internal storage free capacity");
        if (Build.VERSION.SDK_INT >= 18) {
            return statFs2.getFreeBytes();
        }
        return (long)statFs2.getFreeBlocks() * (long)statFs2.getBlockSize();
    }

    @TargetApi(value=26)
    @Nullable
    static Long getDeviceDiskAppUsage(StorageStatsManager storageStatsManager, PackageManager packageManager, String contextPackageName) {
        InternalStaticEmbraceLogger.logDeveloper("MetadataUtils", "Getting device disk app usage");
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(contextPackageName, 0);
            if (packageInfo != null && packageInfo.packageName != null) {
                StorageStats stats = storageStatsManager.queryStatsForPackage(StorageManager.UUID_DEFAULT, packageInfo.packageName, Process.myUserHandle());
                return stats.getAppBytes() + stats.getDataBytes() + stats.getCacheBytes();
            }
            InternalStaticEmbraceLogger.logDeveloper("MetadataUtils", "Cannot get disk usage, packageInfo is null");
        }
        catch (Exception ex) {
            InternalStaticEmbraceLogger.logError("Error retrieving device disk usage", ex);
        }
        return null;
    }

    static boolean isJailbroken() {
        InternalStaticEmbraceLogger.logDeveloper("MetadataUtils", "Processing jailbroken");
        if (MetadataUtils.isEmulator()) {
            InternalStaticEmbraceLogger.logDeveloper("MetadataUtils", "Device is an emulator, Jailbroken=false");
            return false;
        }
        for (String location : JAILBREAK_LOCATIONS) {
            if (!new File(location + "su").exists()) continue;
            return true;
        }
        return false;
    }

    static boolean isEmulator() {
        boolean isEmulator = Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
        InternalStaticEmbraceLogger.logDeveloper("MetadataUtils", "Device is an Emulator = " + isEmulator);
        return isEmulator;
    }

    static boolean isDebug(ApplicationInfo applicationInfo) {
        return (applicationInfo.flags & 2) != 0;
    }

    static String appEnvironment(ApplicationInfo applicationInfo) {
        return MetadataUtils.isDebug(applicationInfo) ? ENVIRONMENT_DEV : ENVIRONMENT_PROD;
    }

    static boolean isValidAppId(String appId2) {
        return appIdPattern.matcher(appId2).find();
    }

    static int getNumberOfCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    private MetadataUtils() {
    }
}

