/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.MessageUtils;
import io.embrace.android.embracesdk.NativeCrash;
import io.embrace.android.embracesdk.payload.AppInfo;
import io.embrace.android.embracesdk.payload.DeviceInfo;
import io.embrace.android.embracesdk.payload.UserInfo;
import java.util.List;
import java.util.Map;

class NativeCrashData {
    @SerializedName(value="report_id")
    private final String id;
    @SerializedName(value="sid")
    private final String sessionId;
    @SerializedName(value="ts")
    private final Long timestamp;
    @SerializedName(value="state")
    private final String appState;
    @SerializedName(value="meta")
    private final NativeCrashMetadata metadata;
    @SerializedName(value="ue")
    private final int unwindError;
    @SerializedName(value="crash")
    private final String crash;
    @SerializedName(value="symbols")
    private Map<String, String> symbols;
    @SerializedName(value="errors")
    private List<Error> errors;
    @SerializedName(value="map")
    private String map;

    public NativeCrashData(String id, String sessionId, Long timestamp, String appState, NativeCrashMetadata metadata, int unwindError, String crash, Map<String, String> symbols, List<Error> errors, String map) {
        this.id = id;
        this.sessionId = sessionId;
        this.timestamp = timestamp;
        this.appState = appState;
        this.metadata = metadata;
        this.unwindError = unwindError;
        this.crash = crash;
        this.symbols = symbols;
        this.errors = errors;
        this.map = map;
    }

    public void setSymbols(Map<String, String> symbols) {
        this.symbols = symbols;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public void setMap(String map) {
        this.map = map;
    }

    public String getNativeCrashId() {
        return this.id;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getAppState() {
        return this.appState;
    }

    public NativeCrashMetadata getMetadata() {
        return this.metadata;
    }

    public int getUnwindError() {
        return this.unwindError;
    }

    public NativeCrash getCrash() {
        return new NativeCrash(this.id, this.crash, this.symbols, this.errors, this.unwindError, this.map);
    }

    public Map<String, String> getSymbols() {
        return this.symbols;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public String getMap() {
        return this.map;
    }

    public static class Error {
        @SerializedName(value="n")
        private final int number;
        @SerializedName(value="c")
        private final int context;

        Error(int number, int context2) {
            this.number = number;
            this.context = context2;
        }

        public int getNumber() {
            return this.number;
        }

        public int getContext() {
            return this.context;
        }
    }

    public static class NativeCrashMetadata {
        @SerializedName(value="a")
        private final AppInfo appInfo;
        @SerializedName(value="d")
        private final DeviceInfo deviceInfo;
        @SerializedName(value="u")
        private final UserInfo userInfo;
        @SerializedName(value="sp")
        private final Map<String, String> sessionProperties;

        NativeCrashMetadata(AppInfo appInfo2, DeviceInfo deviceInfo2, UserInfo userInfo2, Map<String, String> sessionProperties) {
            this.appInfo = appInfo2;
            this.deviceInfo = deviceInfo2;
            this.userInfo = userInfo2;
            this.sessionProperties = sessionProperties;
        }

        public DeviceInfo getDeviceInfo() {
            return this.deviceInfo;
        }

        public AppInfo getAppInfo() {
            return this.appInfo;
        }

        public UserInfo getUserInfo() {
            return this.userInfo;
        }

        public Map<String, String> getSessionProperties() {
            return this.sessionProperties;
        }

        public String toJson() {
            StringBuilder sb = new StringBuilder();
            sb.append("{\"a\":");
            sb.append(this.appInfo.toJson());
            sb.append(",\"d\":");
            sb.append(this.deviceInfo.toJson());
            sb.append(",\"u\":");
            sb.append(this.userInfo.toJson());
            sb.append(",\"sp\":");
            sb.append(MessageUtils.withMap(this.sessionProperties));
            sb.append("}");
            return sb.toString();
        }
    }
}

