/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Parcelable;
import androidx.annotation.NonNull;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.utils.StreamUtilsKt;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class PropertyUtils {
    static final int MAX_PROPERTY_SIZE = 10;

    @NonNull
    static Map<String, Object> sanitizeProperties(Map<String, Object> properties) {
        if (properties == null) {
            return new HashMap<String, Object>();
        }
        if (properties.size() > 10) {
            String msg = "The maximum number of properties is 10, the rest will be ignored.";
            InternalStaticEmbraceLogger.logWarning(msg);
        }
        List<Map.Entry<String, Object>> entries = StreamUtilsKt.filter(properties.entrySet(), entry -> entry.getKey() != null);
        int toIndex = Math.min(entries.size(), 10);
        List<Map.Entry<String, Object>> slice = entries.subList(0, toIndex);
        List<Map.Entry> sanitizedEntries = StreamUtilsKt.map(slice, PropertyUtils::mapNullValue);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry sanitizedEntry : sanitizedEntries) {
            map.put((String)sanitizedEntry.getKey(), sanitizedEntry.getValue());
        }
        return map;
    }

    private static Map.Entry<String, Object> mapNullValue(Map.Entry<String, Object> entry) {
        return new AbstractMap.SimpleEntry<String, Object>(entry.getKey(), PropertyUtils.checkIfSerializable(entry.getKey(), entry.getValue()));
    }

    private static Object checkIfSerializable(String key, Object value) {
        if (value == null) {
            return "null";
        }
        if (!(value instanceof Parcelable) && !(value instanceof Serializable)) {
            String msg = "The property with key " + key + " has an entry that cannot be serialized. It will be ignored.";
            InternalStaticEmbraceLogger.logWarning(msg);
            return "not serializable";
        }
        return value;
    }

    private PropertyUtils() {
    }
}

