/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import androidx.annotation.NonNull;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.Breadcrumb;
import io.embrace.android.embracesdk.InternalApi;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class RnActionBreadcrumb
implements Breadcrumb {
    @SerializedName(value="n")
    private final String name;
    @SerializedName(value="o")
    private String output;
    @SerializedName(value="st")
    private final long startTime;
    @SerializedName(value="en")
    private long endTime;
    @SerializedName(value="pz")
    int bytesSent;
    @SerializedName(value="p")
    private Map<String, Object> properties;

    @NonNull
    public static String getValidRnBreadcrumbOutputName() {
        return Arrays.toString((Object[])RnOutputType.values());
    }

    public static boolean validateRnBreadcrumbOutputName(@NonNull String output) {
        for (RnOutputType rnOutput : RnOutputType.values()) {
            if (!rnOutput.name().equalsIgnoreCase(output)) continue;
            return true;
        }
        return false;
    }

    RnActionBreadcrumb(String name, long start2, long end, Map<String, Object> properties, int bytesSent, String output) {
        this.name = name;
        this.startTime = start2;
        this.endTime = end;
        this.properties = properties != null ? properties : new HashMap();
        this.output = output;
        this.bytesSent = bytesSent;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getOutput() {
        return this.output;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @NonNull
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RnActionBreadcrumb that = (RnActionBreadcrumb)o;
        if (this.startTime != that.startTime) {
            return false;
        }
        if (this.endTime != that.endTime) {
            return false;
        }
        if (this.bytesSent != that.bytesSent) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
    }

    public int hashCode() {
        int result2 = this.name != null ? this.name.hashCode() : 0;
        result2 = 31 * result2 + (this.output != null ? this.output.hashCode() : 0);
        result2 = 31 * result2 + (int)(this.startTime ^ this.startTime >>> 32);
        result2 = 31 * result2 + (int)(this.endTime ^ this.endTime >>> 32);
        result2 = 31 * result2 + this.bytesSent;
        result2 = 31 * result2 + (this.properties != null ? this.properties.hashCode() : 0);
        return result2;
    }

    static enum RnOutputType {
        SUCCESS,
        FAIL,
        INCOMPLETE;

    }
}

