/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.CustomFlow;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.PropertyUtils;
import io.embrace.android.embracesdk.Uuid;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.util.Map;

public final class SubscriptionPurchaseFlow
extends CustomFlow {
    static final String MOMENT_SUBSCRIPTION_PURCHASE = "_subscription-purchase";
    static final String PROP_AMOUNT = "amount";
    static final String PROP_ORDER_ID = "order-id";
    static final String PROP_PAYMENT_TYPE = "payment-type";
    static final String PROP_SUBSCRIPTION_TYPE = "subscription-type";
    private volatile String purchaseMomentId;
    private Map<String, Object> purchaseProps;

    public boolean subscriptionPurchaseStart(String orderId, String subscriptionType, Number amount, String paymentType, Map<String, Object> properties) {
        Map<String, Object> normalizedProperties = PropertyUtils.sanitizeProperties(properties);
        if (orderId != null) {
            normalizedProperties.put(PROP_ORDER_ID, orderId);
        }
        if (subscriptionType != null) {
            normalizedProperties.put(PROP_SUBSCRIPTION_TYPE, subscriptionType);
        }
        if (amount != null) {
            normalizedProperties.put(PROP_AMOUNT, amount);
        }
        if (paymentType != null) {
            normalizedProperties.put(PROP_PAYMENT_TYPE, paymentType);
        }
        this.purchaseProps = normalizedProperties;
        this.purchaseMomentId = Uuid.getEmbUuid();
        this.sendMomentStartEvent(MOMENT_SUBSCRIPTION_PURCHASE, this.purchaseMomentId, false, normalizedProperties);
        return true;
    }

    public boolean subscriptionPurchaseComplete(Map<String, Object> properties) {
        if (this.purchaseMomentId == null) {
            InternalStaticEmbraceLogger.logError("Subscription purchase wasn't started.");
            return false;
        }
        this.sendMomentEndEvent(MOMENT_SUBSCRIPTION_PURCHASE, this.purchaseMomentId, properties);
        this.sendLogInfo("Subscription purchase was completed.", this.purchaseProps);
        Embrace.getInstance().setUserAsPayer();
        this.purchaseMomentId = null;
        return true;
    }

    public boolean subscriptionPurchaseComplete() {
        return this.subscriptionPurchaseComplete(null);
    }

    public boolean subscriptionPurchaseFail(String msg) {
        return this.subscriptionPurchaseFail(msg, null, false);
    }

    public boolean subscriptionPurchaseFail(String msg, Map<String, Object> properties, boolean allowScreenshot) {
        if (this.purchaseMomentId == null) {
            InternalStaticEmbraceLogger.logError("Subscription purchase wasn't started.");
            return false;
        }
        if (msg != null) {
            this.purchaseProps.put("message", msg);
        }
        String errorLogMsg = TextUtils.isEmpty((CharSequence)msg) ? "A failure occurred during subscription purchase." : "A failure occurred during subscription purchase: " + msg;
        this.sendMomentEndEvent(MOMENT_SUBSCRIPTION_PURCHASE, this.purchaseMomentId, properties);
        this.sendLogError(errorLogMsg, allowScreenshot, this.purchaseProps);
        this.purchaseMomentId = null;
        return true;
    }
}

