/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Pair;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.Breadcrumb;

final class TapBreadcrumb
implements Breadcrumb {
    @SerializedName(value="tt")
    final String tappedElementName;
    @SerializedName(value="tl")
    final String location;
    @SerializedName(value="ts")
    private final Long timestamp;
    @SerializedName(value="t")
    final TapBreadcrumbType type;

    TapBreadcrumb(Pair<Float, Float> point, String tappedElementName, long timestamp, TapBreadcrumbType tapBreadcrumbType) {
        this.timestamp = timestamp;
        this.type = tapBreadcrumbType;
        this.tappedElementName = tappedElementName;
        if (point != null) {
            float first = point.first != null ? (float)((Float)point.first).intValue() : 0.0f;
            float second = point.second != null ? (float)((Float)point.second).intValue() : 0.0f;
            this.location = (int)first + "," + (int)second;
        } else {
            this.location = "0,0";
        }
    }

    @Override
    public long getStartTime() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TapBreadcrumb that = (TapBreadcrumb)o;
        if (this.tappedElementName != null ? !this.tappedElementName.equals(that.tappedElementName) : that.tappedElementName != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result2 = this.tappedElementName != null ? this.tappedElementName.hashCode() : 0;
        result2 = 31 * result2 + (this.location != null ? this.location.hashCode() : 0);
        result2 = 31 * result2 + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result2 = 31 * result2 + (this.type != null ? this.type.hashCode() : 0);
        return result2;
    }

    static enum TapBreadcrumbType {
        TAP,
        LONG_PRESS;

    }
}

