/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.AutomaticVerificationChecker;
import io.embrace.android.embracesdk.ComparableVersion;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.VerificationActions;
import io.embrace.android.embracesdk.VerifyIntegrationException;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0011\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0003J\b\u0010\u0018\u001a\u00020\u000bH\u0007J\b\u0010\u0019\u001a\u00020\u000bH\u0003J\b\u0010\u001a\u001a\u00020\u000bH\u0003J\u0006\u0010\u001b\u001a\u00020\u000bJ\b\u0010\u001c\u001a\u00020\u000bH\u0002J\b\u0010\u001d\u001a\u00020\u000bH\u0003J\b\u0010\u001e\u001a\u00020\u000bH\u0002J\u001e\u0010\u001f\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010!\u001a\u00020\fH\u0002R&\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/embrace/android/embracesdk/VerificationActions;", "", "embraceInstance", "Lio/embrace/android/embracesdk/Embrace;", "automaticVerificationChecker", "Lio/embrace/android/embracesdk/AutomaticVerificationChecker;", "(Lio/embrace/android/embracesdk/Embrace;Lio/embrace/android/embracesdk/AutomaticVerificationChecker;)V", "actionsToVerify", "", "Lkotlin/Pair;", "Lkotlin/Function0;", "", "", "currentStep", "", "handler", "Landroid/os/Handler;", "sampleProperties", "", "totalSteps", "checkEmbraceSDKVersion", "latestEmbraceVersion", "executeLogsActions", "executeMoment", "executeNetworkHttpGETRequest", "executeNetworkHttpPOSTRequest", "executeNetworkHttpWrongRequest", "runActions", "setUserData", "throwAnException", "triggerAnr", "verifyAction", "action", "message", "Companion", "embrace-android-sdk_release"})
public final class VerificationActions {
    private final Handler handler;
    private final List<Pair<Function0<Unit>, String>> actionsToVerify;
    private int currentStep;
    private final int totalSteps;
    private final Map<String, Object> sampleProperties;
    private final Embrace embraceInstance;
    private final AutomaticVerificationChecker automaticVerificationChecker;
    private static final long THROW_EXCEPTION_DELAY_MILLIS = 100L;
    private static final long ANR_DURATION_MILLIS = 2000L;
    private static final long MOMENT_DURATION_MILLIS = 3000L;
    private static final String networkingGetUrl = "https://dash-api.embrace.io/external/sdk/android/version";
    private static final String networkingPostUrl = "https://httpbin.org/post";
    private static final String networkingWrongUrl = "https://httpbin.org/deaasd/ASdasdkjl";
    private static final String networkingPostBody = "{\"key_one\":\"value_one\"}";
    private static final String embraceChangelogLink = "https://embrace.io/docs/android/changelog/";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void runActions() {
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
        String msg$iv = "[EmbraceVerification] Starting Verification...";
        boolean $i$f$logInfo = false;
        this_$iv.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
        this.embraceInstance.logBreadcrumb("This is a breadcrumb");
        Iterable $this$forEach$iv = this.actionsToVerify;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.verifyAction((Function0<Unit>)((Function0)it.getFirst()), (String)it.getSecond());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyAction(Function0<Unit> action, String message) {
        int n = this.currentStep;
        this.currentStep = n + 1;
        try {
            void msg$iv2;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
            String string2 = "[EmbraceVerification] \u2713 Step " + this.currentStep + '/' + this.totalSteps + ": " + message;
            boolean $i$f$logInfo = false;
            this_$iv.log((String)msg$iv2, EmbraceLogger.Severity.INFO, null, true);
            action.invoke();
        }
        catch (Throwable e) {
            void msg$iv;
            void this_$iv;
            InternalEmbraceLogger msg$iv2 = InternalStaticEmbraceLogger.logger;
            String $i$f$logInfo = "[EmbraceVerification] -- " + message + " ERROR " + e.getLocalizedMessage();
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            this.automaticVerificationChecker.addException(e);
        }
    }

    private final void setUserData() {
        String identifier = "1234567890";
        String username = "Mr. Automated User";
        String email = "automated@embrace.io";
        this.embraceInstance.setUserIdentifier(identifier);
        this.embraceInstance.setUsername(username);
        this.embraceInstance.setUserEmail(email);
        this.embraceInstance.setUserAsPayer();
        this.embraceInstance.setUserPersona("userPersona");
    }

    private final void executeLogsActions() {
        this.embraceInstance.logInfo("test info", this.sampleProperties);
        this.embraceInstance.logWarning("test warn", this.sampleProperties);
        this.embraceInstance.logError(new Throwable("Sample throwable"), "test error", this.sampleProperties, true);
    }

    @VisibleForTesting
    private final void executeMoment() {
        String momentName = "Verify Integration Moment";
        String momentIdentifier = "Verify Integration identifier";
        this.embraceInstance.startEvent(momentName, momentIdentifier, true, this.sampleProperties);
        this.handler.postDelayed(new Runnable(this, momentName, momentIdentifier){
            final /* synthetic */ VerificationActions this$0;
            final /* synthetic */ String $momentName;
            final /* synthetic */ String $momentIdentifier;

            public final void run() {
                VerificationActions.access$getEmbraceInstance$p(this.this$0).endEvent(this.$momentName, this.$momentIdentifier);
            }
            {
                this.this$0 = verificationActions;
                this.$momentName = string2;
                this.$momentIdentifier = string3;
            }
        }, 3000L);
    }

    @VisibleForTesting
    public final void executeNetworkHttpGETRequest() {
        URLConnection uRLConnection = new URL(networkingGetUrl).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty(this.embraceInstance.getTraceIdHeader(), "traceId : " + this.embraceInstance.getTraceIdHeader());
        InputStream inputStream = connection.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Closeable closeable = inputStream2;
        int n = 0;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        boolean bl2 = false;
        String data = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
        if (connection.getResponseCode() != 200) {
            throw (Throwable)new VerifyIntegrationException("RESPONSE CODE IS " + connection.getResponseCode());
        }
        String string2 = new JSONObject(data).getString("value");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JSONObject(data).getString(\"value\")");
        this.checkEmbraceSDKVersion(string2);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEmbraceSDKVersion(String latestEmbraceVersion) {
        String currentVersion = "5.22.0";
        if (new ComparableVersion(currentVersion).compareTo(new ComparableVersion(latestEmbraceVersion)) < 0) {
            void msg$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
            String string2 = "[EmbraceVerification] Note that there is a newer version of Embrace available \ud83d\ude4c! " + "You can read the changelog for " + latestEmbraceVersion + " here: https://embrace.io/docs/android/changelog/";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final void executeNetworkHttpPOSTRequest() {
        URLConnection uRLConnection = new URL(networkingPostUrl).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setDoOutput(true);
        Closeable closeable = new DataOutputStream(connection.getOutputStream());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            DataOutputStream it = (DataOutputStream)closeable;
            boolean bl3 = false;
            it.writeBytes(networkingPostBody);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        int result2 = connection.getResponseCode();
        if (result2 != 200) {
            throw (Throwable)new VerifyIntegrationException("RESPONSE CODE IS " + result2);
        }
    }

    @VisibleForTesting
    private final void executeNetworkHttpWrongRequest() {
        URLConnection uRLConnection = new URL(networkingWrongUrl).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        int result2 = connection.getResponseCode();
        if (result2 != 404) {
            throw (Throwable)new VerifyIntegrationException("RESPONSE CODE IS " + result2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void triggerAnr() {
        void this_$iv;
        this.handler.post((Runnable)triggerAnr.1.INSTANCE);
        InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
        String msg$iv = "[EmbraceVerification] ANR Finished";
        boolean $i$f$logInfo = false;
        this_$iv.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
    }

    @VisibleForTesting
    private final void throwAnException() {
        this.handler.postDelayed((Runnable)throwAnException.1.INSTANCE, 100L);
    }

    public VerificationActions(@NotNull Embrace embraceInstance, @NotNull AutomaticVerificationChecker automaticVerificationChecker) {
        Intrinsics.checkNotNullParameter((Object)embraceInstance, (String)"embraceInstance");
        Intrinsics.checkNotNullParameter((Object)automaticVerificationChecker, (String)"automaticVerificationChecker");
        this.embraceInstance = embraceInstance;
        this.automaticVerificationChecker = automaticVerificationChecker;
        this.handler = new Handler(Looper.getMainLooper());
        this.actionsToVerify = CollectionsKt.listOf((Object[])new Pair[]{new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$setUserData(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Set user data"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$executeLogsActions(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Log messages"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$executeMoment(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Trigger moment"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                this.this$0.executeNetworkHttpGETRequest();
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Executing network request: GET"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$executeNetworkHttpPOSTRequest(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Executing network request: POST"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$executeNetworkHttpWrongRequest(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Executing network request: testing a wrong url"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$triggerAnr(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Causing an ANR, the application will be tilt"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$throwAnException(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Throwing an Exception! \ud83d\udca3")});
        this.totalSteps = this.actionsToVerify.size();
        this.sampleProperties = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"String", (Object)"Test String"), TuplesKt.to((Object)"LongString", (Object)"This value will be trimmed Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum. In culpa qui officia deserunt mollit anim id est laborum."), TuplesKt.to((Object)"Float", (Object)Float.valueOf(1.0f)), TuplesKt.to((Object)"Nested Properties", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"a", (Object)"b"), TuplesKt.to((Object)"c", (Object)"d")}))});
    }

    public static final /* synthetic */ Embrace access$getEmbraceInstance$p(VerificationActions $this) {
        return $this.embraceInstance;
    }

    public static final /* synthetic */ void access$setUserData(VerificationActions $this) {
        $this.setUserData();
    }

    public static final /* synthetic */ void access$executeLogsActions(VerificationActions $this) {
        $this.executeLogsActions();
    }

    public static final /* synthetic */ void access$executeMoment(VerificationActions $this) {
        $this.executeMoment();
    }

    public static final /* synthetic */ void access$executeNetworkHttpPOSTRequest(VerificationActions $this) {
        $this.executeNetworkHttpPOSTRequest();
    }

    public static final /* synthetic */ void access$executeNetworkHttpWrongRequest(VerificationActions $this) {
        $this.executeNetworkHttpWrongRequest();
    }

    public static final /* synthetic */ void access$triggerAnr(VerificationActions $this) {
        $this.triggerAnr();
    }

    public static final /* synthetic */ void access$throwAnException(VerificationActions $this) {
        $this.throwAnException();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/embrace/android/embracesdk/VerificationActions$Companion;", "", "()V", "ANR_DURATION_MILLIS", "", "MOMENT_DURATION_MILLIS", "THROW_EXCEPTION_DELAY_MILLIS", "embraceChangelogLink", "", "networkingGetUrl", "networkingPostBody", "networkingPostUrl", "networkingWrongUrl", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

