/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Pair;
import android.view.View;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.TapBreadcrumb;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;

@InternalApi
public final class ViewSwazzledHooks {
    private static final String UNKNOWN_ELEMENT_NAME = "Unknown element";

    static void logOnClickEvent(View view, TapBreadcrumb.TapBreadcrumbType breadcrumbType) {
        try {
            String viewName = "";
            try {
                viewName = view.getResources().getResourceName(view.getId());
            }
            catch (Exception e) {
                viewName = UNKNOWN_ELEMENT_NAME;
            }
            Pair point = null;
            try {
                point = new Pair((Object)Float.valueOf(view.getX()), (Object)Float.valueOf(view.getY()));
            }
            catch (Exception e) {
                point = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
            }
            Embrace.getImpl().logTap((Pair<Float, Float>)point, viewName, breadcrumbType);
        }
        catch (NoSuchMethodError exception) {
            InternalStaticEmbraceLogger.logError("Could not log onClickEvent. Some methods are missing. ", exception);
        }
        catch (Exception exception) {
            InternalStaticEmbraceLogger.logError("Could not log onClickEvent.", exception);
        }
    }

    @InternalApi
    public static final class OnLongClickListener {
        public static void _preOnLongClick(View.OnLongClickListener thiz, View view) {
            if (thiz != null) {
                ViewSwazzledHooks.logOnClickEvent(view, TapBreadcrumb.TapBreadcrumbType.LONG_PRESS);
            }
        }
    }

    @InternalApi
    public static final class OnClickListener {
        public static void _preOnClick(View.OnClickListener thiz, View view) {
            ViewSwazzledHooks.logOnClickEvent(view, TapBreadcrumb.TapBreadcrumbType.TAP);
        }
    }
}

