/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr;

import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.anr.BlockedThreadListener;
import io.embrace.android.embracesdk.anr.ThreadInfoCollector;
import io.embrace.android.embracesdk.anr.detection.ThreadMonitoringState;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.payload.AnrInterval;
import io.embrace.android.embracesdk.payload.AnrSample;
import io.embrace.android.embracesdk.payload.AnrSampleList;
import io.embrace.android.embracesdk.payload.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010&\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0019\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\"H\u0001\u00a2\u0006\u0002\b#J,\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0%2\u0006\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\fH\u0016J\u0018\u0010-\u001a\u00020 2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\fH\u0016J\u0018\u0010.\u001a\u00020 2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\fH\u0016J\r\u0010/\u001a\u000200H\u0001\u00a2\u0006\u0002\b1J\u000e\u00102\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u0004J\r\u00103\u001a\u000204H\u0000\u00a2\u0006\u0002\b5R0\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\u0014\u001a\u001e\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\r0\r0\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lio/embrace/android/embracesdk/anr/AnrStacktraceSampler;", "Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "Lio/embrace/android/embracesdk/MemoryCleanerListener;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "targetThread", "Ljava/lang/Thread;", "(Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/clock/Clock;Ljava/lang/Thread;)V", "anrIntervals", "Ljava/util/NavigableMap;", "", "Lio/embrace/android/embracesdk/payload/AnrInterval;", "getAnrIntervals$embrace_android_sdk_release$annotations", "()V", "getAnrIntervals$embrace_android_sdk_release", "()Ljava/util/NavigableMap;", "setAnrIntervals$embrace_android_sdk_release", "(Ljava/util/NavigableMap;)V", "intervalsWithSamples", "", "kotlin.jvm.PlatformType", "getIntervalsWithSamples", "()Ljava/util/Map;", "lastUnblockedMs", "samples", "", "Lio/embrace/android/embracesdk/payload/AnrSample;", "threadInfoCollector", "Lio/embrace/android/embracesdk/anr/ThreadInfoCollector;", "cleanCollections", "", "findLeastValuableInterval", "", "findLeastValuableInterval$embrace_android_sdk_release", "getAnrIntervals", "", "startTime", "endTime", "state", "Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;", "onThreadBlocked", "thread", "timestamp", "onThreadBlockedInterval", "onThreadUnblocked", "reachedAnrCaptureLimit", "", "reachedAnrCaptureLimit$embrace_android_sdk_release", "setConfigService", "size", "", "size$embrace_android_sdk_release", "Companion", "embrace-android-sdk_release"})
public final class AnrStacktraceSampler
implements BlockedThreadListener,
MemoryCleanerListener {
    @NotNull
    private NavigableMap<Long, AnrInterval> anrIntervals;
    private final List<AnrSample> samples;
    private long lastUnblockedMs;
    private final ThreadInfoCollector threadInfoCollector;
    private ConfigService configService;
    private final Clock clock;
    private static final long BACKGROUND_ANR_SAFE_INTERVAL_MS = 10L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void getAnrIntervals$embrace_android_sdk_release$annotations() {
    }

    @NotNull
    public final NavigableMap<Long, AnrInterval> getAnrIntervals$embrace_android_sdk_release() {
        return this.anrIntervals;
    }

    public final void setAnrIntervals$embrace_android_sdk_release(@NotNull NavigableMap<Long, AnrInterval> navigableMap) {
        Intrinsics.checkNotNullParameter(navigableMap, (String)"<set-?>");
        this.anrIntervals = navigableMap;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Long, AnrInterval> getIntervalsWithSamples() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.anrIntervals;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var6_6 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Integer n = ((AnrInterval)it.getValue()).getCode();
            int n2 = 1;
            if (!(n == null || n != n2)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public final void setConfigService(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        this.configService = configService2;
    }

    public final int size$embrace_android_sdk_release() {
        return this.samples.size();
    }

    @Override
    public void onThreadBlocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.threadInfoCollector.clearStacktraceCache();
        this.lastUnblockedMs = timestamp;
    }

    @Override
    public void onThreadBlockedInterval(@NotNull Thread thread, long timestamp) {
        AnrSample anrSample;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        int limit = this.configService.getAnrBehavior().getMaxStacktracesPerInterval();
        if (this.size$embrace_android_sdk_release() >= limit) {
            anrSample = new AnrSample(timestamp, null, 0L, 1);
        } else {
            long start2 = this.clock.now();
            List<ThreadInfo> threads = this.threadInfoCollector.captureSample(this.configService);
            long sampleOverheadMs = this.clock.now() - start2;
            anrSample = new AnrSample(timestamp, threads, sampleOverheadMs, null, 8, null);
        }
        AnrSample anrSample2 = anrSample;
        this.samples.add(anrSample2);
    }

    @Override
    public void onThreadUnblocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        long responseMs = this.lastUnblockedMs;
        AnrInterval anrInterval = new AnrInterval(responseMs, null, timestamp, AnrInterval.Type.UI, new AnrSampleList(CollectionsKt.toList((Iterable)this.samples)), null, 32, null);
        ((Map)this.anrIntervals).put(timestamp, anrInterval);
        if (this.reachedAnrCaptureLimit$embrace_android_sdk_release()) {
            Map.Entry<Long, AnrInterval> entry = this.findLeastValuableInterval$embrace_android_sdk_release();
            if (entry != null) {
                Map.Entry<Long, AnrInterval> entry2 = entry;
                boolean bl = false;
                boolean bl2 = false;
                Map.Entry<Long, AnrInterval> entry3 = entry2;
                boolean bl3 = false;
                ((Map)this.anrIntervals).put(entry3.getKey(), entry3.getValue().clearSamples());
            }
        }
        this.samples.clear();
        this.lastUnblockedMs = timestamp;
        this.threadInfoCollector.clearStacktraceCache();
    }

    @VisibleForTesting
    @NotNull
    public final Map.Entry<Long, AnrInterval> findLeastValuableInterval$embrace_android_sdk_release() {
        Object v0;
        Map<Long, AnrInterval> map = this.getIntervalsWithSamples();
        boolean bl = false;
        Iterable iterable = map.entrySet();
        boolean bl2 = false;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator.next();
            if (!iterator.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl3 = false;
                long l = ((AnrInterval)it.getValue()).duration();
                do {
                    Object t2 = iterator.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-minByOrNull-AnrStacktraceSampler$findLeastValuableInterval$1 = false;
                    long l2 = ((AnrInterval)it2.getValue()).duration();
                    if (l <= l2) continue;
                    t = t2;
                    l = l2;
                } while (iterator.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = v0;
        if (entry == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map.Entry<kotlin.Long, io.embrace.android.embracesdk.payload.AnrInterval>");
        }
        return entry;
    }

    @Override
    public void cleanCollections() {
        this.anrIntervals = new ConcurrentSkipListMap();
    }

    @VisibleForTesting
    public final boolean reachedAnrCaptureLimit$embrace_android_sdk_release() {
        int limit = this.configService.getAnrBehavior().getMaxAnrIntervalsPerSession();
        int count = this.getIntervalsWithSamples().size() - 1;
        return count >= limit;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnrInterval> getAnrIntervals(long startTime, long endTime, @NotNull ThreadMonitoringState state2, @NotNull Clock clock2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        List results = new ArrayList();
        long safeStartTime = startTime + 10L;
        if (safeStartTime >= endTime) {
            return CollectionsKt.emptyList();
        }
        Collection collection = this.anrIntervals.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"anrIntervals.values");
        Collection intervals = collection;
        if (!this.configService.getAnrBehavior().isBgAnrCaptureEnabled()) {
            Iterable $this$filterTo$iv = intervals;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                AnrInterval it = (AnrInterval)element$iv;
                boolean bl = false;
                if (!(it.getStartTime() >= safeStartTime)) continue;
                ((Collection)results).add(element$iv);
            }
        } else {
            results.addAll(intervals);
        }
        if (state2.getAnrInProgress()) {
            long intervalEndTime = clock2.now();
            long responseMs = state2.getLastTargetThreadResponseMs();
            AnrInterval anrInterval = new AnrInterval(responseMs, intervalEndTime, null, AnrInterval.Type.UI, new AnrSampleList(CollectionsKt.toList((Iterable)this.samples)), null, 32, null);
            results.add(anrInterval);
        }
        Iterable $this$map$iv = results;
        boolean $i$f$map = false;
        Iterable responseMs = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            AnrInterval anrInterval = (AnrInterval)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            AnrInterval anrInterval2 = p1.deepCopy();
            collection2.add(anrInterval2);
        }
        return (List)destination$iv$iv;
    }

    public AnrStacktraceSampler(@NotNull ConfigService configService2, @NotNull Clock clock2, @NotNull Thread targetThread) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)targetThread, (String)"targetThread");
        this.configService = configService2;
        this.clock = clock2;
        this.anrIntervals = new ConcurrentSkipListMap();
        boolean bl = false;
        this.samples = new ArrayList();
        this.threadInfoCollector = new ThreadInfoCollector(targetThread);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/anr/AnrStacktraceSampler$Companion;", "", "()V", "BACKGROUND_ANR_SAFE_INTERVAL_MS", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

