/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr;

import android.app.Activity;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.anr.AnrLockKt;
import io.embrace.android.embracesdk.anr.AnrService;
import io.embrace.android.embracesdk.anr.AnrStacktraceSampler;
import io.embrace.android.embracesdk.anr.BlockedThreadListener;
import io.embrace.android.embracesdk.anr.EmbraceAnrService;
import io.embrace.android.embracesdk.anr.detection.AnrProcessErrorSampler;
import io.embrace.android.embracesdk.anr.detection.AnrProcessErrorStateInfo;
import io.embrace.android.embracesdk.anr.detection.LivenessCheckScheduler;
import io.embrace.android.embracesdk.anr.detection.ThreadMonitoringState;
import io.embrace.android.embracesdk.anr.detection.UnbalancedCallDetector;
import io.embrace.android.embracesdk.anr.sigquit.SigquitDetectionService;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.CacheableValue;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.payload.AnrInterval;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004BM\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0004H\u0016J\b\u00102\u001a\u000200H\u0016J\b\u00103\u001a\u000200H\u0016J\u0010\u00104\u001a\u0002002\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u00105\u001a\u000200H\u0016J\u001e\u00106\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020;0&2\u0006\u00107\u001a\u000208H\u0016J\u0010\u0010<\u001a\u0002002\u0006\u0010=\u001a\u000208H\u0016J \u0010>\u001a\u0002002\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u0002082\u0006\u0010=\u001a\u000208H\u0016J\u0018\u0010B\u001a\u0002002\u0006\u0010C\u001a\u00020-2\u0006\u0010=\u001a\u000208H\u0016J\u0018\u0010D\u001a\u0002002\u0006\u0010C\u001a\u00020-2\u0006\u0010=\u001a\u000208H\u0016J\u0018\u0010E\u001a\u0002002\u0006\u0010C\u001a\u00020-2\u0006\u0010=\u001a\u000208H\u0016J\u0015\u0010F\u001a\u0002002\u0006\u0010=\u001a\u000208H\u0001\u00a2\u0006\u0002\bGJ\b\u0010H\u001a\u000200H\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lio/embrace/android/embracesdk/anr/EmbraceAnrService;", "Lio/embrace/android/embracesdk/anr/AnrService;", "Lio/embrace/android/embracesdk/MemoryCleanerListener;", "Lio/embrace/android/embracesdk/ActivityListener;", "Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "looper", "Landroid/os/Looper;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "sigquitDetectionService", "Lio/embrace/android/embracesdk/anr/sigquit/SigquitDetectionService;", "livenessCheckScheduler", "Lio/embrace/android/embracesdk/anr/detection/LivenessCheckScheduler;", "monitorService", "Ljava/util/concurrent/ScheduledExecutorService;", "state", "Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;", "anrProcessErrorSampler", "Lio/embrace/android/embracesdk/anr/detection/AnrProcessErrorSampler;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "(Lio/embrace/android/embracesdk/config/ConfigService;Landroid/os/Looper;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;Lio/embrace/android/embracesdk/anr/sigquit/SigquitDetectionService;Lio/embrace/android/embracesdk/anr/detection/LivenessCheckScheduler;Ljava/util/concurrent/ScheduledExecutorService;Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;Lio/embrace/android/embracesdk/anr/detection/AnrProcessErrorSampler;Lio/embrace/android/embracesdk/clock/Clock;)V", "getClock", "()Lio/embrace/android/embracesdk/clock/Clock;", "getConfigService", "()Lio/embrace/android/embracesdk/config/ConfigService;", "setConfigService", "(Lio/embrace/android/embracesdk/config/ConfigService;)V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "getListeners$annotations", "()V", "getListeners", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "resultCache", "Lio/embrace/android/embracesdk/internal/CacheableValue;", "", "Lio/embrace/android/embracesdk/payload/AnrInterval;", "stacktraceSampler", "Lio/embrace/android/embracesdk/anr/AnrStacktraceSampler;", "getStacktraceSampler", "()Lio/embrace/android/embracesdk/anr/AnrStacktraceSampler;", "targetThread", "Ljava/lang/Thread;", "targetThreadHeartbeatScheduler", "addBlockedThreadListener", "", "listener", "cleanCollections", "close", "finishInitialization", "forceAnrTrackingStopOnCrash", "getAnrIntervals", "startTime", "", "endTime", "getAnrProcessErrors", "Lio/embrace/android/embracesdk/anr/detection/AnrProcessErrorStateInfo;", "onBackground", "timestamp", "onForeground", "coldStart", "", "startupTime", "onThreadBlocked", "thread", "onThreadBlockedInterval", "onThreadUnblocked", "processAnrTick", "processAnrTick$embrace_android_sdk_release", "startAnrCapture", "embrace-android-sdk_release"})
public final class EmbraceAnrService
implements AnrService,
MemoryCleanerListener,
ActivityListener,
BlockedThreadListener {
    private final ThreadMonitoringState state;
    private final Thread targetThread;
    private final ScheduledExecutorService monitorService;
    @NotNull
    private final AnrStacktraceSampler stacktraceSampler;
    private final InternalEmbraceLogger logger;
    private final SigquitDetectionService sigquitDetectionService;
    private final LivenessCheckScheduler targetThreadHeartbeatScheduler;
    private final CacheableValue<List<AnrInterval>> resultCache;
    @NotNull
    private final CopyOnWriteArrayList<BlockedThreadListener> listeners;
    @NotNull
    private ConfigService configService;
    private final AnrProcessErrorSampler anrProcessErrorSampler;
    @VisibleForTesting
    @NotNull
    private final Clock clock;

    @NotNull
    public final AnrStacktraceSampler getStacktraceSampler() {
        return this.stacktraceSampler;
    }

    @VisibleForTesting
    public static /* synthetic */ void getListeners$annotations() {
    }

    @NotNull
    public final CopyOnWriteArrayList<BlockedThreadListener> getListeners() {
        return this.listeners;
    }

    private final void startAnrCapture() {
        this.targetThreadHeartbeatScheduler.startMonitoringThread();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void finishInitialization(@NotNull ConfigService configService2) {
        void className$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        this.configService = configService2;
        this.stacktraceSampler.setConfigService(configService2);
        this.sigquitDetectionService.setConfigService(configService2);
        this.targetThreadHeartbeatScheduler.setConfigService(configService2);
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceAnrService";
        String msg$iv = "Finish initialization";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        this.sigquitDetectionService.initializeGoogleAnrTracking();
        this.startAnrCapture();
    }

    @Override
    public void addBlockedThreadListener(@NotNull BlockedThreadListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnrInterval> getAnrIntervals(long startTime, long endTime) {
        try {
            return this.resultCache.value((Function0<List<AnrInterval>>)((Function0)new Function0<List<? extends AnrInterval>>(this, startTime, endTime){
                final /* synthetic */ EmbraceAnrService this$0;
                final /* synthetic */ long $startTime;
                final /* synthetic */ long $endTime;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnrInterval> invoke() {
                    void var1_1;
                    List result2 = (List)AnrLockKt.runWithAnrServiceLock((Function0)new Function0<List<? extends AnrInterval>>(this){
                        final /* synthetic */ getAnrIntervals.1 this$0;

                        @NotNull
                        public final List<AnrInterval> invoke() {
                            return this.this$0.this$0.getStacktraceSampler().getAnrIntervals(this.this$0.$startTime, this.this$0.$endTime, EmbraceAnrService.access$getState$p(this.this$0.this$0), this.this$0.this$0.getClock());
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                    boolean bl = false;
                    boolean bl2 = false;
                    bl2 = false;
                    boolean bl3 = false;
                    if (result2 == null) {
                        boolean bl4 = false;
                        String string2 = "Required value was null.";
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    return var1_1;
                }
                {
                    this.this$0 = embraceAnrService;
                    this.$startTime = l;
                    this.$endTime = l2;
                    super(0);
                }
            }));
        }
        catch (Exception exc) {
            void msg$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "Failed to getAnrIntervals()";
            boolean logStacktrace$iv = true;
            boolean $i$f$logError = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.ERROR, exc, logStacktrace$iv);
            List list = CollectionsKt.emptyList();
            return list;
        }
    }

    @Override
    @NotNull
    public List<AnrProcessErrorStateInfo> getAnrProcessErrors(long startTime) {
        return this.anrProcessErrorSampler.getAnrProcessErrors(startTime);
    }

    @Override
    public void forceAnrTrackingStopOnCrash() {
        this.targetThreadHeartbeatScheduler.close();
    }

    @Override
    public void close() {
    }

    @Override
    public void cleanCollections() {
        this.stacktraceSampler.cleanCollections();
        this.sigquitDetectionService.cleanCollections();
    }

    @Override
    public void onThreadBlocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        for (BlockedThreadListener listener : this.listeners) {
            listener.onThreadBlocked(thread, timestamp);
        }
    }

    @Override
    public void onThreadBlockedInterval(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.processAnrTick$embrace_android_sdk_release(timestamp);
    }

    @Override
    public void onThreadUnblocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        for (BlockedThreadListener listener : this.listeners) {
            listener.onThreadUnblocked(thread, timestamp);
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void processAnrTick$embrace_android_sdk_release(long timestamp) {
        if (!this.configService.getAnrBehavior().isAnrCaptureEnabled()) {
            void className$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "EmbraceAnrService";
            String msg$iv = "ANR capture is disabled, ignoring ANR tick";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            return;
        }
        for (BlockedThreadListener listener : this.listeners) {
            listener.onThreadBlockedInterval(this.targetThread, timestamp);
        }
    }

    @Override
    public void onForeground(boolean coldStart, long startupTime, long timestamp) {
        this.state.resetState();
        this.targetThreadHeartbeatScheduler.startMonitoringThread();
    }

    @Override
    public void onBackground(long timestamp) {
        this.targetThreadHeartbeatScheduler.stopMonitoringThread();
    }

    @NotNull
    public final ConfigService getConfigService() {
        return this.configService;
    }

    public final void setConfigService(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"<set-?>");
        this.configService = configService2;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    public EmbraceAnrService(@NotNull ConfigService configService2, @NotNull Looper looper2, @NotNull InternalEmbraceLogger logger, @NotNull SigquitDetectionService sigquitDetectionService2, @NotNull LivenessCheckScheduler livenessCheckScheduler2, @NotNull ScheduledExecutorService monitorService, final @NotNull ThreadMonitoringState state2, @NotNull AnrProcessErrorSampler anrProcessErrorSampler2, @NotNull Clock clock2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)looper2, (String)"looper");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)sigquitDetectionService2, (String)"sigquitDetectionService");
        Intrinsics.checkNotNullParameter((Object)livenessCheckScheduler2, (String)"livenessCheckScheduler");
        Intrinsics.checkNotNullParameter((Object)monitorService, (String)"monitorService");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)anrProcessErrorSampler2, (String)"anrProcessErrorSampler");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        this.configService = configService2;
        this.anrProcessErrorSampler = anrProcessErrorSampler2;
        this.clock = clock2;
        this.listeners = new CopyOnWriteArrayList();
        Thread thread = looper2.getThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"looper.thread");
        this.targetThread = thread;
        this.logger = logger;
        this.sigquitDetectionService = sigquitDetectionService2;
        this.state = state2;
        this.monitorService = monitorService;
        this.targetThreadHeartbeatScheduler = livenessCheckScheduler2;
        this.stacktraceSampler = new AnrStacktraceSampler(this.configService, this.clock, this.targetThread);
        this.resultCache = new CacheableValue((Function0<? extends Object>)((Function0)new Function0<Object>(){

            @NotNull
            public final Object invoke() {
                return this.getStacktraceSampler().size$embrace_android_sdk_release() + Boolean.hashCode(state2.getAnrInProgress());
            }
        }));
        this.listeners.add(this.stacktraceSampler);
        this.listeners.add(new UnbalancedCallDetector(logger));
        this.listeners.add(this.anrProcessErrorSampler);
        livenessCheckScheduler2.setListener(this);
    }

    @Override
    public void applicationStartupComplete() {
        ActivityListener.DefaultImpls.applicationStartupComplete(this);
    }

    @Override
    public void onView(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onView(this, activity);
    }

    @Override
    public void onViewClose(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onViewClose(this, activity);
    }

    @Override
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onActivityCreated(this, activity, bundle);
    }

    public static final /* synthetic */ ThreadMonitoringState access$getState$p(EmbraceAnrService $this) {
        return $this.state;
    }
}

