/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr;

import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.config.behavior.AnrBehavior;
import io.embrace.android.embracesdk.payload.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\u0011J0\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\n2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ \u0010\u001d\u001a\u00020\u00132\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/embrace/android/embracesdk/anr/ThreadInfoCollector;", "", "targetThread", "Ljava/lang/Thread;", "(Ljava/lang/Thread;)V", "currentStacktraceStates", "", "", "Lio/embrace/android/embracesdk/payload/ThreadInfo;", "captureSample", "", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "clearStacktraceCache", "", "getAllowedThreads", "", "getAllowedThreads$embrace_android_sdk_release", "isAllowedByLists", "", "allowList", "Ljava/util/regex/Pattern;", "blockList", "name", "", "isAllowedByPriority", "priority", "", "observedPriority", "matchesList", "allowed", "embrace-android-sdk_release"})
public final class ThreadInfoCollector {
    private final Map<Long, ThreadInfo> currentStacktraceStates;
    private final Thread targetThread;

    public final void clearStacktraceCache() {
        this.currentStacktraceStates.clear();
    }

    @NotNull
    public final List<ThreadInfo> captureSample(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Set<ThreadInfo> threads = this.getAllowedThreads$embrace_android_sdk_release(configService2);
        boolean bl = false;
        List sanitizedThreads = new ArrayList();
        Iterable $this$forEach$iv = threads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThreadInfo threadInfo = (ThreadInfo)element$iv;
            boolean bl2 = false;
            long threadId = threadInfo.getThreadId();
            ThreadInfo cache2 = this.currentStacktraceStates.get(threadId);
            if (cache2 != null && !(Intrinsics.areEqual((Object)threadInfo, (Object)cache2) ^ true)) continue;
            sanitizedThreads.add(threadInfo);
            this.currentStacktraceStates.put(threadId, threadInfo);
        }
        return sanitizedThreads;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final Set<ThreadInfo> getAllowedThreads$embrace_android_sdk_release(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Set allowed = new HashSet();
        AnrBehavior anrBehavior2 = configService2.getAnrBehavior();
        List<Pattern> blockList = anrBehavior2.getBlockPatternList();
        List<Pattern> allowList = anrBehavior2.getAllowPatternList();
        int anrStacktracesMaxLength = anrBehavior2.getStacktraceFrameLimit();
        int priority = anrBehavior2.getMinThreadPriority();
        if (anrBehavior2.shouldCaptureMainThreadOnly()) {
            StackTraceElement[] stackTraceElementArray = this.targetThread.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"targetThread.stackTrace");
            ThreadInfo threadInfo = ThreadInfo.Companion.ofThread(this.targetThread, stackTraceElementArray, anrStacktracesMaxLength);
            allowed.add(threadInfo);
        } else {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            Intrinsics.checkNotNullExpressionValue(map, (String)"Thread.getAllStackTraces()");
            Map<Thread, StackTraceElement[]> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map<Thread, StackTraceElement[]> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<Thread, StackTraceElement[]>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                void thread;
                Map.Entry<Thread, StackTraceElement[]> element$iv;
                Map.Entry<Thread, StackTraceElement[]> $dstr$thread$stacktrace = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<Thread, StackTraceElement[]> entry = $dstr$thread$stacktrace;
                boolean bl3 = false;
                Thread thread2 = entry.getKey();
                entry = $dstr$thread$stacktrace;
                bl3 = false;
                StackTraceElement[] stacktrace = entry.getValue();
                void v2 = thread;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"thread");
                boolean allowedByPriority = this.isAllowedByPriority(priority, v2.getPriority());
                String string2 = thread.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"thread.name");
                boolean allowedByLists = this.isAllowedByLists(allowList, blockList, string2);
                if (!allowedByPriority || !allowedByLists) continue;
                Intrinsics.checkNotNullExpressionValue((Object)stacktrace, (String)"stacktrace");
                allowed.add(ThreadInfo.Companion.ofThread((Thread)thread, stacktrace, anrStacktracesMaxLength));
            }
        }
        return allowed;
    }

    private final boolean isAllowedByLists(List<Pattern> allowList, List<Pattern> blockList, String name) {
        return this.matchesList(allowList, name) || !this.matchesList(blockList, name);
    }

    private final boolean matchesList(List<Pattern> allowed, String name) {
        boolean bl;
        block4: {
            if (allowed == null || allowed.isEmpty()) {
                return false;
            }
            Iterable $this$any$iv = allowed;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pattern pattern = (Pattern)element$iv;
                    boolean bl2 = false;
                    if (!pattern.matcher(name).find()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isAllowedByPriority(int priority, int observedPriority) {
        return observedPriority >= priority;
    }

    public ThreadInfoCollector(@NotNull Thread targetThread) {
        Intrinsics.checkNotNullParameter((Object)targetThread, (String)"targetThread");
        this.targetThread = targetThread;
        this.currentStacktraceStates = new HashMap();
    }
}

