/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr.detection;

import android.app.ActivityManager;
import android.os.Process;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.anr.BlockedThreadListener;
import io.embrace.android.embracesdk.anr.detection.AnrProcessErrorCheckerKt;
import io.embrace.android.embracesdk.anr.detection.AnrProcessErrorStateInfo;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120(2\u0006\u0010)\u001a\u00020\u0011J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u0011H\u0002J\b\u0010.\u001a\u00020/H\u0002J\r\u00100\u001a\u00020/H\u0001\u00a2\u0006\u0002\b1J\u0010\u00102\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0012H\u0002J\u0015\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b5J\u0018\u00106\u001a\u00020+2\u0006\u00107\u001a\u0002082\u0006\u0010-\u001a\u00020\u0011H\u0016J\u0018\u00109\u001a\u00020+2\u0006\u00107\u001a\u0002082\u0006\u0010-\u001a\u00020\u0011H\u0016J\u0018\u0010:\u001a\u00020+2\u0006\u00107\u001a\u0002082\u0006\u0010-\u001a\u00020\u0011H\u0016J\b\u0010;\u001a\u00020+H\u0002J\u0010\u0010<\u001a\u00020+2\u0006\u00104\u001a\u00020\u0011H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001c\u0010\u0014\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R(\u0010!\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0016\n\u0002\u0010'\u0012\u0004\b\"\u0010\u0014\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006="}, d2={"Lio/embrace/android/embracesdk/anr/detection/AnrProcessErrorSampler;", "Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "activityManager", "Landroid/app/ActivityManager;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "anrExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "pid", "", "(Landroid/app/ActivityManager;Lio/embrace/android/embracesdk/config/ConfigService;Ljava/util/concurrent/ScheduledExecutorService;Lio/embrace/android/embracesdk/clock/Clock;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;I)V", "anrProcessErrors", "Ljava/util/NavigableMap;", "", "Lio/embrace/android/embracesdk/anr/detection/AnrProcessErrorStateInfo;", "getAnrProcessErrors$annotations", "()V", "getAnrProcessErrors", "()Ljava/util/NavigableMap;", "setAnrProcessErrors", "(Ljava/util/NavigableMap;)V", "intervalMs", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "getScheduledFuture$annotations", "getScheduledFuture", "()Ljava/util/concurrent/ScheduledFuture;", "setScheduledFuture", "(Ljava/util/concurrent/ScheduledFuture;)V", "threadUnblockedMs", "getThreadUnblockedMs$annotations", "getThreadUnblockedMs", "()Ljava/lang/Long;", "setThreadUnblockedMs", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "", "startTime", "handleProcessErrorState", "", "processErrorStateInfo", "timestamp", "isFeatureEnabled", "", "isSchedulerAllowedToRun", "isSchedulerAllowedToRun$embrace_android_sdk_release", "logDebugInfo", "onSearchForProcessErrors", "threadBlockedTimestamp", "onSearchForProcessErrors$embrace_android_sdk_release", "onThreadBlocked", "thread", "Ljava/lang/Thread;", "onThreadBlockedInterval", "onThreadUnblocked", "reset", "scheduleAnrProcessErrorsChecker", "embrace-android-sdk_release"})
public final class AnrProcessErrorSampler
implements BlockedThreadListener {
    private long intervalMs;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    @NotNull
    private NavigableMap<Long, AnrProcessErrorStateInfo> anrProcessErrors;
    @Nullable
    private Long threadUnblockedMs;
    private final ActivityManager activityManager;
    private final ConfigService configService;
    private final ScheduledExecutorService anrExecutor;
    private final Clock clock;
    private final InternalEmbraceLogger logger;
    private final int pid;

    @VisibleForTesting
    public static /* synthetic */ void getScheduledFuture$annotations() {
    }

    @Nullable
    public final ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    public final void setScheduledFuture(@Nullable ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAnrProcessErrors$annotations() {
    }

    @NotNull
    public final NavigableMap<Long, AnrProcessErrorStateInfo> getAnrProcessErrors() {
        return this.anrProcessErrors;
    }

    public final void setAnrProcessErrors(@NotNull NavigableMap<Long, AnrProcessErrorStateInfo> navigableMap) {
        Intrinsics.checkNotNullParameter(navigableMap, (String)"<set-?>");
        this.anrProcessErrors = navigableMap;
    }

    @VisibleForTesting
    public static /* synthetic */ void getThreadUnblockedMs$annotations() {
    }

    @Nullable
    public final Long getThreadUnblockedMs() {
        return this.threadUnblockedMs;
    }

    public final void setThreadUnblockedMs(@Nullable Long l) {
        this.threadUnblockedMs = l;
    }

    @Override
    public void onThreadBlocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        if (this.isFeatureEnabled()) {
            this.reset();
            this.scheduleAnrProcessErrorsChecker(timestamp);
        }
    }

    @Override
    public void onThreadUnblocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        if (this.isFeatureEnabled()) {
            this.threadUnblockedMs = timestamp;
        }
    }

    @Override
    public void onThreadBlockedInterval(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnrProcessErrorStateInfo> getAnrProcessErrors(long startTime) {
        Collection collection;
        boolean bgAnrCaptureEnabled = this.configService.getAnrBehavior().isBgAnrCaptureEnabled();
        if (!bgAnrCaptureEnabled) {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = this.anrProcessErrors;
            boolean $i$f$filter = false;
            Map map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void var10_8 = $this$filterTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var10_8.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                if (!(((Number)it.getKey()).longValue() >= startTime)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            collection = destination$iv$iv.values();
        } else {
            Collection collection2 = this.anrProcessErrors.values();
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"anrProcessErrors.values");
        }
        Collection filteredProcessErrors = collection;
        return CollectionsKt.toMutableList(filteredProcessErrors);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void onSearchForProcessErrors$embrace_android_sdk_release(long threadBlockedTimestamp) {
        AnrProcessErrorStateInfo anrProcessErrorState;
        String msg$iv;
        InternalEmbraceLogger className$iv;
        Object throwable$iv;
        boolean shouldStopScheduler;
        boolean bl = shouldStopScheduler = !this.isSchedulerAllowedToRun$embrace_android_sdk_release();
        if (shouldStopScheduler) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "EmbraceAnrService";
            String string3 = "Anr process errors scheduler is not allowed to keep running. Stopping it";
            throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)((Object)className$iv) + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, (Throwable)throwable$iv, true);
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
        }
        if ((anrProcessErrorState = AnrProcessErrorCheckerKt.findAnrProcessErrorStateInfo(this.clock, this.activityManager, this.pid)) != null) {
            this.handleProcessErrorState(anrProcessErrorState, threadBlockedTimestamp);
        } else {
            String msg$iv2;
            String className$iv2;
            InternalEmbraceLogger this_$iv;
            className$iv = this.logger;
            msg$iv = "EmbraceAnrService";
            throwable$iv = "Anr process errors were not found. This is expected, report has probably not been generated yet";
            Throwable throwable$iv2 = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + className$iv2 + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
            if (!shouldStopScheduler && this.intervalMs != this.configService.getAnrBehavior().getAnrProcessErrorsIntervalMs()) {
                this_$iv = this.logger;
                className$iv2 = "EmbraceAnrService";
                msg$iv2 = "Different capture anr process errors interval detected, restarting runnable";
                throwable$iv2 = null;
                $i$f$logDeveloper = false;
                this_$iv.log('[' + className$iv2 + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
                ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                this.scheduleAnrProcessErrorsChecker(threadBlockedTimestamp);
            }
        }
    }

    @VisibleForTesting
    public final boolean isSchedulerAllowedToRun$embrace_android_sdk_release() {
        boolean bl;
        Long ms = this.threadUnblockedMs;
        if (ms == null) {
            bl = true;
        } else {
            long l = this.clock.now() - ms;
            boolean bl2 = false;
            bl = Math.abs(l) <= this.configService.getAnrBehavior().getAnrProcessErrorsSchedulerExtraTimeAllowanceMs();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void scheduleAnrProcessErrorsChecker(long threadBlockedTimestamp) {
        try {
            void msg$iv;
            void className$iv;
            void this_$iv;
            Runnable runnable2 = new Runnable(this, threadBlockedTimestamp){
                final /* synthetic */ AnrProcessErrorSampler this$0;
                final /* synthetic */ long $threadBlockedTimestamp;

                public final void run() {
                    this.this$0.onSearchForProcessErrors$embrace_android_sdk_release(this.$threadBlockedTimestamp);
                }
                {
                    this.this$0 = anrProcessErrorSampler2;
                    this.$threadBlockedTimestamp = l;
                }
            };
            long delay = this.configService.getAnrBehavior().getAnrProcessErrorsDelayMs();
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "EmbraceAnrService";
            String string3 = "About to schedule runnable to look for anr process errors, with " + "delay=" + delay + " - intervalMs=" + this.intervalMs;
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            this.intervalMs = this.configService.getAnrBehavior().getAnrProcessErrorsIntervalMs();
            this.scheduledFuture = this.anrExecutor.scheduleAtFixedRate(runnable2, delay, this.intervalMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception exc) {
            void this_$iv;
            String message = "capture ANR process errors initialization failed";
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            boolean logStacktrace$iv = true;
            boolean $i$f$logError = false;
            this_$iv.log(message, EmbraceLogger.Severity.ERROR, exc, logStacktrace$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleProcessErrorState(AnrProcessErrorStateInfo processErrorStateInfo, long timestamp) {
        block0: {
            void msg$iv;
            void className$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "EmbraceAnrService";
            String string3 = "Anr process error state found. Cancelled scheduler so to stop looking for it.";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            ((Map)this.anrProcessErrors).put(timestamp, processErrorStateInfo);
            this.logDebugInfo(processErrorStateInfo);
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logDebugInfo(AnrProcessErrorStateInfo processErrorStateInfo) {
        void msg$iv;
        void className$iv;
        void this_$iv;
        boolean bl = false;
        boolean bl2 = false;
        AnrProcessErrorStateInfo $this$with = processErrorStateInfo;
        boolean bl3 = false;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceAnrService";
        String string3 = StringsKt.trimMargin$default((String)("AnrProcessErrorStateInfo=\n                |tag=" + $this$with.getTag() + "\n                |shortMsg=" + $this$with.getShortMsg() + "\n                |longMsg=" + $this$with.getLongMsg() + "\n                |stacktrace=" + $this$with.getStackTrace() + "\n                "), null, (int)1, null);
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void reset() {
        block0: {
            void className$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "EmbraceAnrService";
            String msg$iv = "Resetting AnrProcessErrorSampler scheduler state";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            this.threadUnblockedMs = null;
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isFeatureEnabled() {
        boolean bl;
        if (!this.configService.getAnrBehavior().isAnrProcessErrorsCaptureEnabled()) {
            void className$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "EmbraceAnrService";
            String msg$iv = "ANR process errors capture is disabled";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public AnrProcessErrorSampler(@Nullable ActivityManager activityManager2, @NotNull ConfigService configService2, @NotNull ScheduledExecutorService anrExecutor, @NotNull Clock clock2, @NotNull InternalEmbraceLogger logger, int pid) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)anrExecutor, (String)"anrExecutor");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.activityManager = activityManager2;
        this.configService = configService2;
        this.anrExecutor = anrExecutor;
        this.clock = clock2;
        this.logger = logger;
        this.pid = pid;
        this.intervalMs = this.configService.getAnrBehavior().getAnrProcessErrorsIntervalMs();
        this.anrProcessErrors = new ConcurrentSkipListMap();
    }

    public /* synthetic */ AnrProcessErrorSampler(ActivityManager activityManager2, ConfigService configService2, ScheduledExecutorService scheduledExecutorService, Clock clock2, InternalEmbraceLogger internalEmbraceLogger, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
        }
        if ((n2 & 0x20) != 0) {
            n = Process.myPid();
        }
        this(activityManager2, configService2, scheduledExecutorService, clock2, internalEmbraceLogger, n);
    }
}

