/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr.detection;

import android.os.Debug;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.anr.AnrLockKt;
import io.embrace.android.embracesdk.anr.BlockedThreadListener;
import io.embrace.android.embracesdk.anr.detection.ThreadMonitoringState;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u0018H\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0015\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/embrace/android/embracesdk/anr/detection/BlockedThreadDetector;", "", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "listener", "Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "state", "Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;", "targetThread", "Ljava/lang/Thread;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "(Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/clock/Clock;Lio/embrace/android/embracesdk/anr/BlockedThreadListener;Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;Ljava/lang/Thread;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;)V", "getConfigService", "()Lio/embrace/android/embracesdk/config/ConfigService;", "setConfigService", "(Lio/embrace/android/embracesdk/config/ConfigService;)V", "getListener$embrace_android_sdk_release", "()Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "setListener$embrace_android_sdk_release", "(Lio/embrace/android/embracesdk/anr/BlockedThreadListener;)V", "isAnrDurationThresholdExceeded", "", "timestamp", "", "isAnrDurationThresholdExceeded$embrace_android_sdk_release", "isDebuggerEnabled", "onMonitorThreadHeartbeat", "", "onTargetThreadResponse", "shouldAttemptAnrSample", "shouldAttemptAnrSample$embrace_android_sdk_release", "embrace-android-sdk_release"})
public final class BlockedThreadDetector {
    @NotNull
    private ConfigService configService;
    private final Clock clock;
    @Nullable
    private BlockedThreadListener listener;
    private final ThreadMonitoringState state;
    private final Thread targetThread;
    private final InternalEmbraceLogger logger;

    public final void onTargetThreadResponse() {
        if (this.isDebuggerEnabled()) {
            return;
        }
        AnrLockKt.runWithAnrServiceLock((Function0)new Function0<Unit>(this){
            final /* synthetic */ BlockedThreadDetector this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                block1: {
                    void this_$iv;
                    long timestamp = BlockedThreadDetector.access$getState$p(this.this$0).getLastTargetThreadResponseMs();
                    if (!BlockedThreadDetector.access$getState$p(this.this$0).getAnrInProgress()) break block1;
                    InternalEmbraceLogger internalEmbraceLogger = BlockedThreadDetector.access$getLogger$p(this.this$0);
                    String msg$iv = "Main thread recovered from not responding for > 1s";
                    Throwable throwable$iv = null;
                    boolean $i$f$logDebug = false;
                    this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
                    BlockedThreadDetector.access$getState$p(this.this$0).setAnrInProgress(false);
                    BlockedThreadListener blockedThreadListener = this.this$0.getListener$embrace_android_sdk_release();
                    if (blockedThreadListener != null) {
                        blockedThreadListener.onThreadUnblocked(BlockedThreadDetector.access$getTargetThread$p(this.this$0), timestamp);
                    }
                }
            }
            {
                this.this$0 = blockedThreadDetector2;
                super(0);
            }
        });
    }

    public final void onMonitorThreadHeartbeat(long timestamp) {
        if (this.isDebuggerEnabled()) {
            return;
        }
        AnrLockKt.runWithAnrServiceLock((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ BlockedThreadDetector this$0;
            final /* synthetic */ long $timestamp;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                if (!BlockedThreadDetector.access$getState$p(this.this$0).getAnrInProgress() && this.this$0.isAnrDurationThresholdExceeded$embrace_android_sdk_release(this.$timestamp)) {
                    void this_$iv;
                    InternalEmbraceLogger internalEmbraceLogger = BlockedThreadDetector.access$getLogger$p(this.this$0);
                    String msg$iv = "Main thread not responding for > 1s";
                    Throwable throwable$iv = null;
                    boolean $i$f$logDebug = false;
                    this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
                    BlockedThreadDetector.access$getState$p(this.this$0).setAnrInProgress(true);
                    BlockedThreadListener blockedThreadListener = this.this$0.getListener$embrace_android_sdk_release();
                    if (blockedThreadListener != null) {
                        blockedThreadListener.onThreadBlocked(BlockedThreadDetector.access$getTargetThread$p(this.this$0), BlockedThreadDetector.access$getState$p(this.this$0).getLastTargetThreadResponseMs());
                    }
                }
                if (BlockedThreadDetector.access$getState$p(this.this$0).getAnrInProgress() && this.this$0.shouldAttemptAnrSample$embrace_android_sdk_release(this.$timestamp)) {
                    BlockedThreadListener blockedThreadListener = this.this$0.getListener$embrace_android_sdk_release();
                    if (blockedThreadListener != null) {
                        blockedThreadListener.onThreadBlockedInterval(BlockedThreadDetector.access$getTargetThread$p(this.this$0), this.$timestamp);
                    }
                    BlockedThreadDetector.access$getState$p(this.this$0).setLastSampleAttemptMs(BlockedThreadDetector.access$getClock$p(this.this$0).now());
                }
                BlockedThreadDetector.access$getState$p(this.this$0).setLastMonitorThreadResponseMs(BlockedThreadDetector.access$getClock$p(this.this$0).now());
            }
            {
                this.this$0 = blockedThreadDetector2;
                this.$timestamp = l;
                super(0);
            }
        });
    }

    @VisibleForTesting
    public final boolean shouldAttemptAnrSample$embrace_android_sdk_release(long timestamp) {
        long intervalMs;
        long lastMonitorThreadResponseMs = this.state.getLastMonitorThreadResponseMs();
        long delta = timestamp - lastMonitorThreadResponseMs;
        return (double)delta > (double)(intervalMs = this.configService.getAnrBehavior().getSamplingIntervalMs()) * 0.5;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final boolean isAnrDurationThresholdExceeded$embrace_android_sdk_release(long timestamp) {
        long monitorThreadLag = timestamp - this.state.getLastMonitorThreadResponseMs();
        long targetThreadLag = timestamp - this.state.getLastTargetThreadResponseMs();
        if (monitorThreadLag > 60000L) {
            void className$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "EmbraceAnrService";
            String msg$iv = "Exceeded monitor thread timeout";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            long now = this.clock.now();
            this.state.setLastTargetThreadResponseMs(now);
            this.state.setLastMonitorThreadResponseMs(now);
            return false;
        }
        int minTriggerDuration = this.configService.getAnrBehavior().getMinDuration();
        return targetThreadLag > (long)minTriggerDuration;
    }

    private final boolean isDebuggerEnabled() {
        return Debug.isDebuggerConnected() || Debug.waitingForDebugger();
    }

    @NotNull
    public final ConfigService getConfigService() {
        return this.configService;
    }

    public final void setConfigService(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"<set-?>");
        this.configService = configService2;
    }

    @Nullable
    public final BlockedThreadListener getListener$embrace_android_sdk_release() {
        return this.listener;
    }

    public final void setListener$embrace_android_sdk_release(@Nullable BlockedThreadListener blockedThreadListener) {
        this.listener = blockedThreadListener;
    }

    public BlockedThreadDetector(@NotNull ConfigService configService2, @NotNull Clock clock2, @Nullable BlockedThreadListener listener, @NotNull ThreadMonitoringState state2, @NotNull Thread targetThread, @NotNull InternalEmbraceLogger logger) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)targetThread, (String)"targetThread");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.configService = configService2;
        this.clock = clock2;
        this.listener = listener;
        this.state = state2;
        this.targetThread = targetThread;
        this.logger = logger;
    }

    public /* synthetic */ BlockedThreadDetector(ConfigService configService2, Clock clock2, BlockedThreadListener blockedThreadListener, ThreadMonitoringState threadMonitoringState, Thread thread, InternalEmbraceLogger internalEmbraceLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
        }
        this(configService2, clock2, blockedThreadListener, threadMonitoringState, thread, internalEmbraceLogger);
    }

    public static final /* synthetic */ ThreadMonitoringState access$getState$p(BlockedThreadDetector $this) {
        return $this.state;
    }

    public static final /* synthetic */ InternalEmbraceLogger access$getLogger$p(BlockedThreadDetector $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Thread access$getTargetThread$p(BlockedThreadDetector $this) {
        return $this.targetThread;
    }

    public static final /* synthetic */ Clock access$getClock$p(BlockedThreadDetector $this) {
        return $this.clock;
    }
}

