/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr.detection;

import android.os.Handler;
import android.os.Message;
import android.os.Process;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.anr.BlockedThreadListener;
import io.embrace.android.embracesdk.anr.detection.BlockedThreadDetector;
import io.embrace.android.embracesdk.anr.detection.LivenessCheckScheduler$sam$java_lang_Runnable$0;
import io.embrace.android.embracesdk.anr.detection.TargetThreadHandler;
import io.embrace.android.embracesdk.anr.detection.ThreadMonitoringState;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.io.Closeable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001BA\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010 \u001a\u00020!H\u0016J\r\u0010\"\u001a\u00020!H\u0001\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020!H\u0002J\b\u0010%\u001a\u00020!H\u0002J\u0006\u0010&\u001a\u00020!J\u0006\u0010'\u001a\u00020!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/embrace/android/embracesdk/anr/detection/LivenessCheckScheduler;", "Ljava/io/Closeable;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "anrExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "state", "Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;", "targetThreadHandler", "Lio/embrace/android/embracesdk/anr/detection/TargetThreadHandler;", "blockedThreadDetector", "Lio/embrace/android/embracesdk/anr/detection/BlockedThreadDetector;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "(Lio/embrace/android/embracesdk/config/ConfigService;Ljava/util/concurrent/ScheduledExecutorService;Lio/embrace/android/embracesdk/clock/Clock;Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;Lio/embrace/android/embracesdk/anr/detection/TargetThreadHandler;Lio/embrace/android/embracesdk/anr/detection/BlockedThreadDetector;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;)V", "value", "getConfigService", "()Lio/embrace/android/embracesdk/config/ConfigService;", "setConfigService", "(Lio/embrace/android/embracesdk/config/ConfigService;)V", "intervalMs", "", "Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "listener", "getListener", "()Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "setListener", "(Lio/embrace/android/embracesdk/anr/BlockedThreadListener;)V", "monitorFuture", "Ljava/util/concurrent/ScheduledFuture;", "close", "", "onMonitorThreadHeartbeat", "onMonitorThreadHeartbeat$embrace_android_sdk_release", "scheduleRegularHeartbeats", "sendHeartbeatMessage", "startMonitoringThread", "stopMonitoringThread", "embrace-android-sdk_release"})
public final class LivenessCheckScheduler
implements Closeable {
    private long intervalMs;
    private ScheduledFuture<?> monitorFuture;
    private final ScheduledExecutorService anrExecutor;
    private final Clock clock;
    private final ThreadMonitoringState state;
    private final TargetThreadHandler targetThreadHandler;
    private final BlockedThreadDetector blockedThreadDetector;
    private final InternalEmbraceLogger logger;

    @NotNull
    public final ConfigService getConfigService() {
        return this.blockedThreadDetector.getConfigService();
    }

    public final void setConfigService(@NotNull ConfigService value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.blockedThreadDetector.setConfigService(value);
    }

    @Nullable
    public final BlockedThreadListener getListener() {
        return this.blockedThreadDetector.getListener$embrace_android_sdk_release();
    }

    public final void setListener(@Nullable BlockedThreadListener value) {
        this.blockedThreadDetector.setListener$embrace_android_sdk_release(value);
    }

    /*
     * WARNING - void declaration
     */
    public final void startMonitoringThread() {
        if (!this.state.started.getAndSet(true)) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv = "Started heartbeats to capture ANRs.";
            boolean $i$f$logInfo = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
            this.scheduleRegularHeartbeats();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void stopMonitoringThread() {
        if (this.state.started.get()) {
            ScheduledFuture<?> scheduledFuture = this.monitorFuture;
            if (scheduledFuture != null) {
                ScheduledFuture<?> scheduledFuture2 = scheduledFuture;
                boolean bl = false;
                boolean bl2 = false;
                ScheduledFuture<?> monitorTask = scheduledFuture2;
                boolean bl3 = false;
                monitorTask.cancel(false);
                if (monitorTask.isDone()) {
                    void this_$iv;
                    InternalEmbraceLogger internalEmbraceLogger = this.logger;
                    String msg$iv = "Stopped heartbeats to capture ANRs.";
                    boolean $i$f$logInfo = false;
                    this_$iv.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
                    this.state.started.set(false);
                } else {
                    InternalEmbraceLogger this_$iv = this.logger;
                    String msg$iv = "Scheduled heartbeat could not be stopped.";
                    Throwable throwable$iv = null;
                    boolean logStacktrace$iv = false;
                    boolean $i$f$logError = false;
                    this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
                }
            } else {
                void this_$iv;
                InternalEmbraceLogger internalEmbraceLogger = this.logger;
                String msg$iv = "Scheduled heartbeat could not be stopped. monitorFuture is null";
                Throwable throwable$iv = null;
                boolean logStacktrace$iv = false;
                boolean $i$f$logError = false;
                this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void scheduleRegularHeartbeats() {
        this.intervalMs = this.getConfigService().getAnrBehavior().getSamplingIntervalMs();
        Object object = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((LivenessCheckScheduler)this.receiver).onMonitorThreadHeartbeat$embrace_android_sdk_release();
            }
        };
        Runnable runnable2 = new LivenessCheckScheduler$sam$java_lang_Runnable$0((Function0)object);
        try {
            void className$iv;
            void this_$iv;
            object = this.logger;
            String string2 = "EmbraceAnrService";
            String msg$iv = "Heartbeat Interval: " + this.intervalMs;
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            this.monitorFuture = this.anrExecutor.scheduleAtFixedRate(runnable2, 0L, this.intervalMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception exc) {
            void this_$iv;
            String message = "ANR capture initialization failed";
            InternalEmbraceLogger msg$iv = this.logger;
            boolean logStacktrace$iv = true;
            boolean $i$f$logError = false;
            this_$iv.log(message, EmbraceLogger.Severity.ERROR, exc, logStacktrace$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void onMonitorThreadHeartbeat$embrace_android_sdk_release() {
        try {
            int n = this.getConfigService().getAnrBehavior().getMonitorThreadPriority();
            boolean bl = false;
            boolean bl2 = false;
            int $this$with = n;
            boolean bl3 = false;
            Process.setThreadPriority((int)$this$with);
            if (this.intervalMs != this.getConfigService().getAnrBehavior().getSamplingIntervalMs()) {
                void className$iv;
                void this_$iv;
                InternalEmbraceLogger internalEmbraceLogger = this.logger;
                String string2 = "EmbraceAnrService";
                String msg$iv = "Different interval detected, restarting runnable";
                Throwable throwable$iv = null;
                boolean $i$f$logDeveloper = false;
                this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                ScheduledFuture<?> scheduledFuture = this.monitorFuture;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                this.scheduleRegularHeartbeats();
            } else {
                long now = this.clock.now();
                if (!this.targetThreadHandler.hasMessages(34593)) {
                    this.sendHeartbeatMessage();
                }
                this.blockedThreadDetector.onMonitorThreadHeartbeat(now);
            }
        }
        catch (Exception exc) {
            void this_$iv;
            InternalEmbraceLogger className$iv = this.logger;
            String msg$iv = "Failed to process ANR monitor thread heartbeat";
            boolean logStacktrace$iv = true;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, exc, logStacktrace$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendHeartbeatMessage() {
        Message heartbeatMessage = Message.obtain((Handler)this.targetThreadHandler, (int)34593);
        if (!this.targetThreadHandler.sendMessage(heartbeatMessage)) {
            void logStacktrace$iv;
            void throwable$iv;
            void msg$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "Failed to send message to targetHandler, main thread likely shutting down.";
            Throwable throwable = new IllegalStateException("Failed to send message to targetHandler");
            boolean bl = true;
            boolean $i$f$logError = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.ERROR, (Throwable)throwable$iv, (boolean)logStacktrace$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        try {
            this.anrExecutor.shutdown();
            if (!this.anrExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                void this_$iv;
                InternalEmbraceLogger internalEmbraceLogger = this.logger;
                String msg$iv2 = "Timed out shutting down EmbraceAnrService after 1s";
                Throwable throwable$iv = null;
                boolean $i$f$logDebug = false;
                this_$iv.log(msg$iv2, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
            }
        }
        catch (Exception ex) {
            void msg$iv;
            void this_$iv;
            InternalEmbraceLogger msg$iv2 = this.logger;
            String throwable$iv = "Failed to cleanly shut down EmbraceAnrService";
            boolean logStacktrace$iv = true;
            boolean $i$f$logError = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.ERROR, ex, logStacktrace$iv);
        }
    }

    public LivenessCheckScheduler(@NotNull ConfigService configService2, @NotNull ScheduledExecutorService anrExecutor, @NotNull Clock clock2, @NotNull ThreadMonitoringState state2, @NotNull TargetThreadHandler targetThreadHandler2, @NotNull BlockedThreadDetector blockedThreadDetector2, @NotNull InternalEmbraceLogger logger) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)anrExecutor, (String)"anrExecutor");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)targetThreadHandler2), (String)"targetThreadHandler");
        Intrinsics.checkNotNullParameter((Object)blockedThreadDetector2, (String)"blockedThreadDetector");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.anrExecutor = anrExecutor;
        this.clock = clock2;
        this.state = state2;
        this.targetThreadHandler = targetThreadHandler2;
        this.blockedThreadDetector = blockedThreadDetector2;
        this.logger = logger;
        this.intervalMs = configService2.getAnrBehavior().getSamplingIntervalMs();
        this.targetThreadHandler.setAction((Function0<Unit>)((Function0)new Function0<Unit>(this.blockedThreadDetector){

            public final void invoke() {
                ((BlockedThreadDetector)this.receiver).onTargetThreadResponse();
            }
        }));
        this.targetThreadHandler.start();
    }

    public /* synthetic */ LivenessCheckScheduler(ConfigService configService2, ScheduledExecutorService scheduledExecutorService, Clock clock2, ThreadMonitoringState threadMonitoringState, TargetThreadHandler targetThreadHandler2, BlockedThreadDetector blockedThreadDetector2, InternalEmbraceLogger internalEmbraceLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
        }
        this(configService2, scheduledExecutorService, clock2, threadMonitoringState, targetThreadHandler2, blockedThreadDetector2, internalEmbraceLogger);
    }
}

