/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr.detection;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.anr.detection.LooperCompat;
import io.embrace.android.embracesdk.anr.detection.TargetThreadHandler$sam$android_os_MessageQueue_IdleHandler$0;
import io.embrace.android.embracesdk.anr.detection.ThreadMonitoringState;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\r\u0010\u001d\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020\u000fH\u0002J\u0006\u0010 \u001a\u00020\u000fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/embrace/android/embracesdk/anr/detection/TargetThreadHandler;", "Landroid/os/Handler;", "looper", "Landroid/os/Looper;", "state", "Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "messageQueue", "Landroid/os/MessageQueue;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "(Landroid/os/Looper;Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;Lio/embrace/android/embracesdk/config/ConfigService;Landroid/os/MessageQueue;Lio/embrace/android/embracesdk/clock/Clock;)V", "action", "Lkotlin/Function0;", "", "getAction", "()Lkotlin/jvm/functions/Function0;", "setAction", "(Lkotlin/jvm/functions/Function0;)V", "installed", "", "getInstalled", "()Z", "setInstalled", "(Z)V", "handleMessage", "msg", "Landroid/os/Message;", "onIdleThread", "onIdleThread$embrace_android_sdk_release", "onMainThreadUnblocked", "start", "Companion", "embrace-android-sdk_release"})
public final class TargetThreadHandler
extends Handler {
    public Function0<Unit> action;
    private volatile boolean installed;
    private final ThreadMonitoringState state;
    private final ConfigService configService;
    private final MessageQueue messageQueue;
    private final Clock clock;
    public static final int HEARTBEAT_REQUEST = 34593;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Function0<Unit> getAction() {
        Function0<Unit> function0 = this.action;
        if (function0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"action");
        }
        return function0;
    }

    public final void setAction(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.action = function0;
    }

    public final boolean getInstalled() {
        return this.installed;
    }

    public final void setInstalled(boolean bl) {
        this.installed = bl;
    }

    public final void start() {
        if (this.configService.getAnrBehavior().isIdleHandlerEnabled()) {
            MessageQueue messageQueue = this.messageQueue;
            if (messageQueue != null) {
                Function0 function0 = (Function0)new Function0<Boolean>(this){

                    public final boolean invoke() {
                        return ((TargetThreadHandler)((Object)this.receiver)).onIdleThread$embrace_android_sdk_release();
                    }
                };
                messageQueue.addIdleHandler((MessageQueue.IdleHandler)new TargetThreadHandler$sam$android_os_MessageQueue_IdleHandler$0(function0));
            }
            this.installed = true;
        }
    }

    @VisibleForTesting
    public final boolean onIdleThread$embrace_android_sdk_release() {
        this.onMainThreadUnblocked();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            if (!(msg.what != 34593 || this.messageQueue != null && this.installed)) {
                InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                String msg$iv = "Failed to obtain main thread MessageQueue - using fallback ANR strategy.";
                Throwable throwable$iv = null;
                boolean $i$f$logDebug = false;
                companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
                this.onMainThreadUnblocked();
            }
        }
        catch (Exception ex) {
            void msg$iv;
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String throwable$iv = "ANR healthcheck failed in main (monitored) thread";
            boolean logStacktrace$iv = true;
            boolean $i$f$logError = false;
            companion.log((String)msg$iv, EmbraceLogger.Severity.ERROR, ex, logStacktrace$iv);
        }
    }

    private final void onMainThreadUnblocked() {
        this.state.setLastTargetThreadResponseMs(this.clock.now());
        Function0<Unit> function0 = this.action;
        if (function0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"action");
        }
        function0.invoke();
    }

    public TargetThreadHandler(@NotNull Looper looper2, @NotNull ThreadMonitoringState state2, @NotNull ConfigService configService2, @Nullable MessageQueue messageQueue, @NotNull Clock clock2) {
        Intrinsics.checkNotNullParameter((Object)looper2, (String)"looper");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        super(looper2);
        this.state = state2;
        this.configService = configService2;
        this.messageQueue = messageQueue;
        this.clock = clock2;
    }

    public /* synthetic */ TargetThreadHandler(Looper looper2, ThreadMonitoringState threadMonitoringState, ConfigService configService2, MessageQueue messageQueue, Clock clock2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            messageQueue = LooperCompat.getMessageQueue(looper2);
        }
        this(looper2, threadMonitoringState, configService2, messageQueue, clock2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/anr/detection/TargetThreadHandler$Companion;", "", "()V", "HEARTBEAT_REQUEST", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

