/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr.detection;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.anr.BlockedThreadListener;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/embrace/android/embracesdk/anr/detection/UnbalancedCallDetector;", "Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "(Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;)V", "blocked", "", "lastTimestamp", "", "checkTimeTravel", "", "name", "", "timestamp", "checkUnbalancedCall", "expected", "onThreadBlocked", "thread", "Ljava/lang/Thread;", "onThreadBlockedInterval", "onThreadUnblocked", "embrace-android-sdk_release"})
public final class UnbalancedCallDetector
implements BlockedThreadListener {
    private volatile boolean blocked;
    private volatile long lastTimestamp;
    private final InternalEmbraceLogger logger;

    @Override
    public void onThreadBlocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.checkUnbalancedCall("onThreadBlocked()", false);
        this.blocked = true;
        this.checkTimeTravel("onThreadBlocked()", timestamp);
    }

    @Override
    public void onThreadBlockedInterval(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.checkUnbalancedCall("onThreadBlockedInterval()", true);
        this.checkTimeTravel("onThreadBlockedInterval()", timestamp);
    }

    @Override
    public void onThreadUnblocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.checkUnbalancedCall("onThreadUnblocked()", true);
        this.blocked = false;
        this.checkTimeTravel("onThreadUnblocked()", timestamp);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTimeTravel(String name, long timestamp) {
        if (this.lastTimestamp > timestamp) {
            void logStacktrace$iv;
            void throwable$iv;
            void msg$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "Time travel in " + name + '.';
            Throwable throwable = new IllegalStateException(this.lastTimestamp + " to " + timestamp);
            boolean bl = true;
            boolean $i$f$logError = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.ERROR, (Throwable)throwable$iv, (boolean)logStacktrace$iv);
        }
        this.lastTimestamp = timestamp;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkUnbalancedCall(String name, boolean expected) {
        if (this.blocked != expected) {
            void throwable$iv;
            void this_$iv;
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
            String threadName = thread.getName();
            String msg = "Unbalanced call to " + name + " in ANR detection. Thread=" + threadName;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            Throwable throwable = new IllegalStateException(msg);
            boolean logStacktrace$iv = true;
            boolean $i$f$logError = false;
            this_$iv.log(msg, EmbraceLogger.Severity.ERROR, (Throwable)throwable$iv, logStacktrace$iv);
        }
    }

    public UnbalancedCallDetector(@NotNull InternalEmbraceLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    public /* synthetic */ UnbalancedCallDetector(InternalEmbraceLogger internalEmbraceLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
        }
        this(internalEmbraceLogger);
    }

    public UnbalancedCallDetector() {
        this(null, 1, null);
    }
}

