/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr.ndk;

import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.anr.ndk.NativeThreadSamplerNdkDelegate;
import io.embrace.android.embracesdk.anr.ndk.NativeThreadSamplerService;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.config.behavior.AnrBehavior;
import io.embrace.android.embracesdk.config.remote.AnrRemoteConfig;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.payload.NativeThreadAnrInterval;
import io.embrace.android.embracesdk.payload.NativeThreadAnrSample;
import io.embrace.android.embracesdk.payload.ThreadStateKt;
import io.embrace.android.embracesdk.utils.NativeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0007\b\u0000\u0018\u0000 O2\u00020\u0001:\u0002OPBQ\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u00106\u001a\u000207H\u0016J%\u00108\u001a\u00020#2\u0006\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<H\u0001\u00a2\u0006\u0004\b>\u0010?J\b\u0010@\u001a\u000207H\u0002J\u001f\u0010A\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010B2\b\u0010C\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010DJ\u0016\u0010E\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0016J\b\u0010F\u001a\u00020#H\u0016J\u0018\u0010G\u001a\u0002072\u0006\u0010H\u001a\u0002052\u0006\u0010I\u001a\u00020JH\u0016J\u0018\u0010K\u001a\u0002072\u0006\u0010H\u001a\u0002052\u0006\u0010I\u001a\u00020JH\u0016J\u0018\u0010L\u001a\u0002072\u0006\u0010H\u001a\u0002052\u0006\u0010I\u001a\u00020JH\u0016J\b\u0010M\u001a\u00020#H\u0016J\u0010\u0010N\u001a\u00020#2\u0006\u00109\u001a\u00020:H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00128\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0014\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u00128\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001f\u0010\u0014\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R$\u0010\"\u001a\u00020#8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b$\u0010\u0014\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R*\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0*8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b+\u0010\u0014\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00100\u001a\u00020#8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b1\u0010\u0014\u001a\u0004\b2\u0010&\"\u0004\b3\u0010(R\"\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lio/embrace/android/embracesdk/anr/ndk/EmbraceNativeThreadSamplerService;", "Lio/embrace/android/embracesdk/anr/ndk/NativeThreadSamplerService;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "symbols", "Lkotlin/Lazy;", "", "", "random", "Ljava/util/Random;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "delegate", "Lio/embrace/android/embracesdk/anr/ndk/EmbraceNativeThreadSamplerService$NdkDelegate;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lio/embrace/android/embracesdk/config/ConfigService;Lkotlin/Lazy;Ljava/util/Random;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;Lio/embrace/android/embracesdk/anr/ndk/EmbraceNativeThreadSamplerService$NdkDelegate;Ljava/util/concurrent/ScheduledExecutorService;)V", "count", "", "getCount$embrace_android_sdk_release$annotations", "()V", "getCount$embrace_android_sdk_release", "()I", "setCount$embrace_android_sdk_release", "(I)V", "currentInterval", "Lio/embrace/android/embracesdk/payload/NativeThreadAnrInterval;", "getCurrentInterval$embrace_android_sdk_release$annotations", "getCurrentInterval$embrace_android_sdk_release", "()Lio/embrace/android/embracesdk/payload/NativeThreadAnrInterval;", "factor", "getFactor$embrace_android_sdk_release$annotations", "getFactor$embrace_android_sdk_release", "setFactor$embrace_android_sdk_release", "ignored", "", "getIgnored$embrace_android_sdk_release$annotations", "getIgnored$embrace_android_sdk_release", "()Z", "setIgnored$embrace_android_sdk_release", "(Z)V", "intervals", "", "getIntervals$embrace_android_sdk_release$annotations", "getIntervals$embrace_android_sdk_release", "()Ljava/util/List;", "setIntervals$embrace_android_sdk_release", "(Ljava/util/List;)V", "sampling", "getSampling$embrace_android_sdk_release$annotations", "getSampling$embrace_android_sdk_release", "setSampling$embrace_android_sdk_release", "targetThread", "Ljava/lang/Thread;", "cleanCollections", "", "containsAllowedStackframes", "anrBehavior", "Lio/embrace/android/embracesdk/config/behavior/AnrBehavior;", "stacktrace", "", "Ljava/lang/StackTraceElement;", "containsAllowedStackframes$embrace_android_sdk_release", "(Lio/embrace/android/embracesdk/config/behavior/AnrBehavior;[Ljava/lang/StackTraceElement;)Z", "fetchIntervals", "getCapturedIntervals", "", "receivedTermination", "(Ljava/lang/Boolean;)Ljava/util/List;", "getNativeSymbols", "monitorCurrentThread", "onThreadBlocked", "thread", "timestamp", "", "onThreadBlockedInterval", "onThreadUnblocked", "setupNativeSampler", "shouldSkipNewSample", "Companion", "NdkDelegate", "embrace-android-sdk_release"})
public final class EmbraceNativeThreadSamplerService
implements NativeThreadSamplerService {
    private boolean ignored;
    private boolean sampling;
    private int count;
    private int factor;
    @NotNull
    private List<NativeThreadAnrInterval> intervals;
    private Thread targetThread;
    private final ConfigService configService;
    private final Lazy<Map<String, String>> symbols;
    private final Random random;
    private final InternalEmbraceLogger logger;
    private final NdkDelegate delegate;
    private final ScheduledExecutorService executorService;
    public static final int MAX_NATIVE_SAMPLES = 10;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void getIgnored$embrace_android_sdk_release$annotations() {
    }

    public final boolean getIgnored$embrace_android_sdk_release() {
        return this.ignored;
    }

    public final void setIgnored$embrace_android_sdk_release(boolean bl) {
        this.ignored = bl;
    }

    @VisibleForTesting
    public static /* synthetic */ void getSampling$embrace_android_sdk_release$annotations() {
    }

    public final boolean getSampling$embrace_android_sdk_release() {
        return this.sampling;
    }

    public final void setSampling$embrace_android_sdk_release(boolean bl) {
        this.sampling = bl;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCount$embrace_android_sdk_release$annotations() {
    }

    public final int getCount$embrace_android_sdk_release() {
        return this.count;
    }

    public final void setCount$embrace_android_sdk_release(int n) {
        this.count = n;
    }

    @VisibleForTesting
    public static /* synthetic */ void getFactor$embrace_android_sdk_release$annotations() {
    }

    public final int getFactor$embrace_android_sdk_release() {
        return this.factor;
    }

    public final void setFactor$embrace_android_sdk_release(int n) {
        this.factor = n;
    }

    @VisibleForTesting
    public static /* synthetic */ void getIntervals$embrace_android_sdk_release$annotations() {
    }

    @NotNull
    public final List<NativeThreadAnrInterval> getIntervals$embrace_android_sdk_release() {
        return this.intervals;
    }

    public final void setIntervals$embrace_android_sdk_release(@NotNull List<NativeThreadAnrInterval> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.intervals = list;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCurrentInterval$embrace_android_sdk_release$annotations() {
    }

    @Nullable
    public final NativeThreadAnrInterval getCurrentInterval$embrace_android_sdk_release() {
        return (NativeThreadAnrInterval)CollectionsKt.lastOrNull(this.intervals);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setupNativeSampler() {
        void className$iv;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceNativeThreadSamplerService";
        String msg$iv = "Target thread found, attempting to install NativeThreadSampler";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        return this.delegate.setupNativeThreadSampler(NativeUtils.Companion.is32BitDevice());
    }

    @Override
    public boolean monitorCurrentThread() {
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
        this.targetThread = thread;
        return this.delegate.monitorCurrentThread();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onThreadBlocked(@NotNull Thread thread, long timestamp) {
        void className$iv;
        void this_$iv;
        InternalEmbraceLogger msg$iv;
        InternalEmbraceLogger className$iv2;
        void this_$iv2;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceNativeThreadSamplerService";
        String msg$iv2 = "onThreadBlocked";
        Object throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv2.log('[' + (String)((Object)className$iv2) + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, (Throwable)throwable$iv, true);
        AnrBehavior anrBehavior2 = this.configService.getAnrBehavior();
        StackTraceElement[] stackTraceElementArray = this.targetThread.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"targetThread.stackTrace");
        boolean bl = this.ignored = !this.containsAllowedStackframes$embrace_android_sdk_release(anrBehavior2, stackTraceElementArray);
        if (this.ignored || this.shouldSkipNewSample(anrBehavior2)) {
            void className$iv3;
            void this_$iv3;
            className$iv2 = this.logger;
            msg$iv2 = "NativeThreadSamplerInstaller";
            throwable$iv = "Data capture limit reached. Ignoring thread blocked intervals.";
            Throwable throwable$iv2 = null;
            boolean $i$f$logDeveloper2 = false;
            this_$iv3.log('[' + (String)className$iv3 + "] " + (String)((Object)msg$iv), EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
            this.ignored = true;
            return;
        }
        AnrRemoteConfig.Unwinder unwinder = anrBehavior2.getNativeThreadAnrSamplingUnwinder();
        this.factor = anrBehavior2.getNativeThreadAnrSamplingFactor();
        int offset = this.random.nextInt(this.factor);
        this.count = (this.factor - offset) % this.factor;
        msg$iv = this.logger;
        String throwable$iv2 = "EmbraceNativeThreadSamplerService";
        String msg$iv3 = "add NativeThreadSample samples";
        Throwable throwable$iv3 = null;
        boolean $i$f$logDeveloper3 = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv3, EmbraceLogger.Severity.DEVELOPER, throwable$iv3, true);
        Long l = this.targetThread.getId();
        String string3 = this.targetThread.getName();
        Integer n = this.targetThread.getPriority();
        Long l2 = (long)offset * anrBehavior2.getSamplingIntervalMs();
        Long l3 = timestamp;
        boolean bl2 = false;
        List list = new ArrayList();
        Thread.State state2 = this.targetThread.getState();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)state2), (String)"targetThread.state");
        this.intervals.add(new NativeThreadAnrInterval(l, string3, n, l2, l3, list, ThreadStateKt.mapThreadState(state2), unwinder));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onThreadBlockedInterval(@NotNull Thread thread, long timestamp) {
        String msg$iv;
        String className$iv;
        InternalEmbraceLogger this_$iv;
        InternalEmbraceLogger className$iv2;
        void this_$iv2;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceNativeThreadSamplerService";
        String msg$iv2 = "onThreadBlockedInterval";
        Object throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv2.log('[' + (String)((Object)className$iv2) + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, (Throwable)throwable$iv, true);
        int limit = this.configService.getAnrBehavior().getMaxStacktracesPerInterval();
        if (this.count >= limit) {
            className$iv2 = this.logger;
            msg$iv2 = "ANR stacktrace not captured. Maximum allowed ticks per ANR interval reached.";
            throwable$iv = null;
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv2, EmbraceLogger.Severity.DEBUG, (Throwable)throwable$iv, true);
            return;
        }
        if (this.ignored || !this.configService.getAnrBehavior().isNativeThreadAnrSamplingEnabled()) {
            this_$iv = this.logger;
            msg$iv2 = "NativeThreadSamplerInstaller";
            throwable$iv = "Ignoring thread blocked interval";
            Throwable throwable$iv2 = null;
            boolean $i$f$logDeveloper2 = false;
            this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
            return;
        }
        if (this.count % this.factor == 0) {
            this.count = 0;
            if (!this.sampling) {
                this.sampling = true;
                this_$iv = this.logger;
                className$iv = "EmbraceNativeThreadSamplerService";
                msg$iv = "Initiating sampling of the target thread";
                Throwable throwable$iv3 = null;
                boolean $i$f$logDeveloper3 = false;
                this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv3, true);
                AnrBehavior anrBehavior2 = this.configService.getAnrBehavior();
                AnrRemoteConfig.Unwinder unwinder = anrBehavior2.getNativeThreadAnrSamplingUnwinder();
                long intervalMs = anrBehavior2.getNativeThreadAnrSamplingIntervalMs();
                this.delegate.startSampling(unwinder.getCode$embrace_android_sdk_release(), intervalMs);
                this.executorService.schedule(new Runnable(this){
                    final /* synthetic */ EmbraceNativeThreadSamplerService this$0;

                    public final void run() {
                        EmbraceNativeThreadSamplerService.access$fetchIntervals(this.this$0);
                    }
                    {
                        this.this$0 = embraceNativeThreadSamplerService;
                    }
                }, intervalMs * (long)10, TimeUnit.MILLISECONDS);
            }
        }
        int n = this.count;
        this.count = n + 1;
    }

    @Override
    public void onThreadUnblocked(@NotNull Thread thread, long timestamp) {
        String msg$iv;
        String className$iv;
        InternalEmbraceLogger this_$iv;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceNativeThreadSamplerService";
        String string3 = "Thread unblocked: " + thread.getId();
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        if (this.sampling) {
            this.executorService.submit(new Runnable(this){
                final /* synthetic */ EmbraceNativeThreadSamplerService this$0;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    void className$iv;
                    void this_$iv;
                    InternalEmbraceLogger internalEmbraceLogger = EmbraceNativeThreadSamplerService.access$getLogger$p(this.this$0);
                    String string2 = "EmbraceNativeThreadSamplerService";
                    String msg$iv = "Fetching samples on JVM bg thread";
                    Throwable throwable$iv = null;
                    boolean $i$f$logDeveloper = false;
                    this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                    EmbraceNativeThreadSamplerService.access$fetchIntervals(this.this$0);
                }
                {
                    this.this$0 = embraceNativeThreadSamplerService;
                }
            });
        } else {
            this_$iv = this.logger;
            className$iv = "NativeThreadSamplerInstaller";
            msg$iv = "Ignoring thread blocked interval";
            throwable$iv = null;
            $i$f$logDeveloper = false;
            this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        }
        this.ignored = true;
        this.sampling = false;
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchIntervals() {
        block2: {
            NativeThreadAnrInterval nativeThreadAnrInterval = this.getCurrentInterval$embrace_android_sdk_release();
            if (nativeThreadAnrInterval == null) break block2;
            NativeThreadAnrInterval nativeThreadAnrInterval2 = nativeThreadAnrInterval;
            boolean bl = false;
            boolean bl2 = false;
            NativeThreadAnrInterval interval = nativeThreadAnrInterval2;
            boolean bl3 = false;
            List<NativeThreadAnrSample> list = this.delegate.finishSampling();
            if (list != null) {
                void msg$iv;
                void className$iv;
                void this_$iv;
                List<NativeThreadAnrSample> list2 = list;
                boolean bl4 = false;
                boolean bl5 = false;
                List<NativeThreadAnrSample> samples = list2;
                boolean bl6 = false;
                Object object = this.logger;
                String string2 = "EmbraceNativeThreadSamplerService";
                String string3 = "Fetched samples. Count=" + samples.size();
                Throwable throwable$iv = null;
                boolean $i$f$logDeveloper = false;
                this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                List<NativeThreadAnrSample> list3 = interval.getSamples$embrace_android_sdk_release();
                if (list3 != null) {
                    object = list3;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Object $this$run = object;
                    boolean bl9 = false;
                    $this$run.clear();
                    $this$run.addAll((Collection)samples);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanCollections() {
        void className$iv;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceNativeThreadSamplerService";
        String msg$iv = "Clean collections";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        boolean bl = false;
        this.intervals = new ArrayList();
    }

    private final boolean shouldSkipNewSample(AnrBehavior anrBehavior2) {
        int sessionLimit = anrBehavior2.getMaxAnrIntervalsPerSession();
        return !this.configService.getAnrBehavior().isNativeThreadAnrSamplingEnabled() || this.intervals.size() >= sessionLimit;
    }

    @Override
    @Nullable
    public Map<String, String> getNativeSymbols() {
        return (Map)this.symbols.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<NativeThreadAnrInterval> getCapturedIntervals(@Nullable Boolean receivedTermination) {
        void $this$filterTo$iv$iv;
        if (!this.configService.getAnrBehavior().isNativeThreadAnrSamplingEnabled()) {
            void msg$iv;
            void className$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "EmbraceNativeThreadSamplerService";
            String string3 = "Native thread Sampling not enabled";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            return null;
        }
        if (this.sampling && Intrinsics.areEqual((Object)receivedTermination, (Object)false)) {
            this.fetchIntervals();
        }
        Iterable $this$filter$iv = CollectionsKt.toList((Iterable)this.intervals);
        boolean $i$f$filter = false;
        Iterable throwable$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            NativeThreadAnrInterval it = (NativeThreadAnrInterval)element$iv$iv;
            boolean bl2 = false;
            List<NativeThreadAnrSample> list = it.getSamples$embrace_android_sdk_release();
            if (list != null) {
                Collection collection = list;
                boolean bl3 = false;
                bl = !collection.isEmpty();
            } else {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List usefulSamples = (List)destination$iv$iv;
        if (usefulSamples.isEmpty()) {
            return null;
        }
        return CollectionsKt.toList((Iterable)usefulSamples);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final boolean containsAllowedStackframes$embrace_android_sdk_release(@NotNull AnrBehavior anrBehavior2, @NotNull StackTraceElement[] stacktrace) {
        boolean bl;
        block6: {
            void msg$iv;
            void className$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)anrBehavior2, (String)"anrBehavior");
            Intrinsics.checkNotNullParameter((Object)stacktrace, (String)"stacktrace");
            if (anrBehavior2.isNativeThreadAnrSamplingAllowlistIgnored()) {
                void msg$iv2;
                void className$iv2;
                void this_$iv2;
                InternalEmbraceLogger internalEmbraceLogger = this.logger;
                String string2 = "EmbraceNativeThreadSamplerService";
                String string3 = "Ignore native thread ANR sampling allow list";
                Throwable throwable$iv = null;
                boolean $i$f$logDeveloper = false;
                this_$iv2.log('[' + (String)className$iv2 + "] " + (String)msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                return true;
            }
            List<AnrRemoteConfig.AllowedNdkSampleMethod> allowlist = anrBehavior2.getNativeThreadAnrSamplingAllowlist();
            InternalEmbraceLogger className$iv2 = this.logger;
            String msg$iv2 = "EmbraceNativeThreadSamplerService";
            String throwable$iv = "getNativeThreadAnrSamplingAllowlist size: " + allowlist.size();
            Throwable throwable$iv2 = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
            StackTraceElement[] $this$any$iv = stacktrace;
            boolean $i$f$any = false;
            StackTraceElement[] stackTraceElementArray = $this$any$iv;
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                block5: {
                    StackTraceElement element$iv;
                    StackTraceElement frame = element$iv = stackTraceElementArray[i];
                    boolean bl3 = false;
                    Iterable $this$any$iv2 = allowlist;
                    boolean $i$f$any2 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv2) {
                            AnrRemoteConfig.AllowedNdkSampleMethod allowed = (AnrRemoteConfig.AllowedNdkSampleMethod)element$iv2;
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual((Object)frame.getMethodName(), (Object)allowed.getMethod()) && Intrinsics.areEqual((Object)frame.getClassName(), (Object)allowed.getClz()))) continue;
                            bl2 = true;
                            break block5;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    @JvmOverloads
    public EmbraceNativeThreadSamplerService(@NotNull ConfigService configService2, @NotNull Lazy<? extends Map<String, String>> symbols, @NotNull Random random, @NotNull InternalEmbraceLogger logger, @NotNull NdkDelegate delegate, @NotNull ScheduledExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.configService = configService2;
        this.symbols = symbols;
        this.random = random;
        this.logger = logger;
        this.delegate = delegate;
        this.executorService = executorService;
        this.ignored = true;
        this.count = -1;
        this.factor = -1;
        boolean bl = false;
        this.intervals = new ArrayList();
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
        this.targetThread = thread;
    }

    public /* synthetic */ EmbraceNativeThreadSamplerService(ConfigService configService2, Lazy lazy, Random random, InternalEmbraceLogger internalEmbraceLogger, NdkDelegate ndkDelegate, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            random = new Random();
        }
        if ((n & 8) != 0) {
            internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
        }
        if ((n & 0x10) != 0) {
            ndkDelegate = new NativeThreadSamplerNdkDelegate();
        }
        this(configService2, (Lazy<? extends Map<String, String>>)lazy, random, internalEmbraceLogger, ndkDelegate, scheduledExecutorService);
    }

    @JvmOverloads
    public EmbraceNativeThreadSamplerService(@NotNull ConfigService configService2, @NotNull Lazy<? extends Map<String, String>> symbols, @NotNull Random random, @NotNull InternalEmbraceLogger logger, @NotNull ScheduledExecutorService executorService) {
        this(configService2, symbols, random, logger, null, executorService, 16, null);
    }

    @JvmOverloads
    public EmbraceNativeThreadSamplerService(@NotNull ConfigService configService2, @NotNull Lazy<? extends Map<String, String>> symbols, @NotNull Random random, @NotNull ScheduledExecutorService executorService) {
        this(configService2, symbols, random, null, null, executorService, 24, null);
    }

    @JvmOverloads
    public EmbraceNativeThreadSamplerService(@NotNull ConfigService configService2, @NotNull Lazy<? extends Map<String, String>> symbols, @NotNull ScheduledExecutorService executorService) {
        this(configService2, symbols, null, null, null, executorService, 28, null);
    }

    public static final /* synthetic */ void access$fetchIntervals(EmbraceNativeThreadSamplerService $this) {
        $this.fetchIntervals();
    }

    public static final /* synthetic */ InternalEmbraceLogger access$getLogger$p(EmbraceNativeThreadSamplerService $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H&J\b\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H&J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&\u00a8\u0006\u000f"}, d2={"Lio/embrace/android/embracesdk/anr/ndk/EmbraceNativeThreadSamplerService$NdkDelegate;", "", "finishSampling", "", "Lio/embrace/android/embracesdk/payload/NativeThreadAnrSample;", "monitorCurrentThread", "", "setupNativeThreadSampler", "is32Bit", "startSampling", "", "unwinderOrdinal", "", "intervalMs", "", "embrace-android-sdk_release"})
    public static interface NdkDelegate {
        public boolean setupNativeThreadSampler(boolean var1);

        public boolean monitorCurrentThread();

        public void startSampling(int var1, long var2);

        @Nullable
        public List<NativeThreadAnrSample> finishSampling();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/anr/ndk/EmbraceNativeThreadSamplerService$Companion;", "", "()V", "MAX_NATIVE_SAMPLES", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

