/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr.ndk;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.anr.AnrService;
import io.embrace.android.embracesdk.anr.ndk.NativeThreadSamplerService;
import io.embrace.android.embracesdk.config.ConfigListener;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0002R&\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/embrace/android/embracesdk/anr/ndk/NativeThreadSamplerInstaller;", "", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "(Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;)V", "currentThread", "Ljava/lang/Thread;", "getCurrentThread$embrace_android_sdk_release$annotations", "()V", "getCurrentThread$embrace_android_sdk_release", "()Ljava/lang/Thread;", "setCurrentThread$embrace_android_sdk_release", "(Ljava/lang/Thread;)V", "isMonitoring", "Ljava/util/concurrent/atomic/AtomicBoolean;", "targetHandler", "Landroid/os/Handler;", "isMonitoringCurrentThread", "", "monitorCurrentThread", "", "sampler", "Lio/embrace/android/embracesdk/anr/ndk/NativeThreadSamplerService;", "anrService", "Lio/embrace/android/embracesdk/anr/AnrService;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "onConfigChange", "prepareTargetHandler", "embrace-android-sdk_release"})
public final class NativeThreadSamplerInstaller {
    private final AtomicBoolean isMonitoring;
    private Handler targetHandler;
    @Nullable
    private Thread currentThread;
    private final InternalEmbraceLogger logger;

    @VisibleForTesting
    public static /* synthetic */ void getCurrentThread$embrace_android_sdk_release$annotations() {
    }

    @Nullable
    public final Thread getCurrentThread$embrace_android_sdk_release() {
        return this.currentThread;
    }

    public final void setCurrentThread$embrace_android_sdk_release(@Nullable Thread thread) {
        this.currentThread = thread;
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareTargetHandler() {
        Looper looper2;
        if (Looper.myLooper() == null) {
            Looper.prepare();
        }
        Handler handler = this.targetHandler = (looper2 = Looper.myLooper()) != null ? new Handler(looper2) : null;
        if (this.targetHandler == null) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv = "Native thread sampler init failed: Failed to create Handler for target native thread";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void monitorCurrentThread(@NotNull NativeThreadSamplerService sampler, @NotNull ConfigService configService2, @NotNull AnrService anrService2) {
        Intrinsics.checkNotNullParameter((Object)sampler, (String)"sampler");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)anrService2, (String)"anrService");
        if (this.isMonitoringCurrentThread()) {
            void msg$iv;
            void className$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "NativeThreadSamplerInstaller";
            String string3 = "Skipping monitorCurrentThread as current thread already monitored.";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            return;
        }
        this.isMonitoring.set(false);
        this.currentThread = Thread.currentThread();
        this.prepareTargetHandler();
        if (configService2.getAnrBehavior().isNativeThreadAnrSamplingEnabled()) {
            this.monitorCurrentThread(sampler, anrService2);
        } else {
            InternalStaticEmbraceLogger.Companion this_$iv = InternalStaticEmbraceLogger.Companion;
            String className$iv = "NativeThreadSamplerInstaller";
            String msg$iv = "isNativeThreadAnrSamplingEnabled disabled.";
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        }
        configService2.addListener(new ConfigListener(this, configService2, sampler, anrService2){
            final /* synthetic */ NativeThreadSamplerInstaller this$0;
            final /* synthetic */ ConfigService $configService;
            final /* synthetic */ NativeThreadSamplerService $sampler;
            final /* synthetic */ AnrService $anrService;

            public final void onConfigChange(@NotNull ConfigService it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NativeThreadSamplerInstaller.access$onConfigChange(this.this$0, this.$configService, this.$sampler, this.$anrService);
            }
            {
                this.this$0 = nativeThreadSamplerInstaller2;
                this.$configService = configService2;
                this.$sampler = nativeThreadSamplerService2;
                this.$anrService = anrService2;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMonitoringCurrentThread() {
        if (!this.isMonitoring.get()) return false;
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
        Thread thread2 = this.currentThread;
        if (thread2 == null) return false;
        if (thread.getId() != thread2.getId()) return false;
        return true;
    }

    private final void onConfigChange(ConfigService configService2, NativeThreadSamplerService sampler, AnrService anrService2) {
        block0: {
            Handler handler = this.targetHandler;
            if (handler == null) break block0;
            handler.post(new Runnable(this, configService2, sampler, anrService2){
                final /* synthetic */ NativeThreadSamplerInstaller this$0;
                final /* synthetic */ ConfigService $configService;
                final /* synthetic */ NativeThreadSamplerService $sampler;
                final /* synthetic */ AnrService $anrService;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    if (this.$configService.getAnrBehavior().isNativeThreadAnrSamplingEnabled() && !NativeThreadSamplerInstaller.access$isMonitoring$p(this.this$0).get()) {
                        void className$iv;
                        void this_$iv;
                        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                        String string2 = "NativeThreadSamplerInstaller";
                        String msg$iv = "Native Thread ANR Sampling Enabled, proceed to install";
                        boolean $i$f$logDeveloper = false;
                        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                        NativeThreadSamplerInstaller.access$monitorCurrentThread(this.this$0, this.$sampler, this.$anrService);
                    }
                }
                {
                    this.this$0 = nativeThreadSamplerInstaller2;
                    this.$configService = configService2;
                    this.$sampler = nativeThreadSamplerService2;
                    this.$anrService = anrService2;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void monitorCurrentThread(NativeThreadSamplerService sampler, AnrService anrService2) {
        NativeThreadSamplerInstaller nativeThreadSamplerInstaller2 = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (nativeThreadSamplerInstaller2) {
            boolean bl3 = false;
            if (!this.isMonitoring.get()) {
                InternalStaticEmbraceLogger.Companion this_$iv;
                InternalEmbraceLogger internalEmbraceLogger = this.logger;
                StringBuilder stringBuilder = new StringBuilder().append("Installing native sampling on '");
                Thread thread = Thread.currentThread();
                Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
                String msg$iv = stringBuilder.append(thread.getName()).append('\'').toString();
                boolean $i$f$logInfo2 = false;
                ((InternalEmbraceLogger)((Object)this_$iv)).log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
                if (sampler.monitorCurrentThread()) {
                    void msg$iv2;
                    void className$iv;
                    this_$iv = InternalStaticEmbraceLogger.Companion;
                    msg$iv = "NativeThreadSamplerInstaller";
                    String $i$f$logInfo2 = "Native sampler installed";
                    boolean $i$f$logDeveloper = false;
                    this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
                    anrService2.addBlockedThreadListener(sampler);
                    this.isMonitoring.set(true);
                }
            } else {
                InternalStaticEmbraceLogger.Companion this_$iv = InternalStaticEmbraceLogger.Companion;
                String className$iv = "NativeThreadSamplerInstaller";
                String msg$iv2 = "NativeThreadSamplerService already installed";
                boolean $i$f$logDeveloper = false;
                this_$iv.log('[' + className$iv + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public NativeThreadSamplerInstaller(@NotNull InternalEmbraceLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.isMonitoring = new AtomicBoolean(false);
    }

    public /* synthetic */ NativeThreadSamplerInstaller(InternalEmbraceLogger internalEmbraceLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
        }
        this(internalEmbraceLogger);
    }

    public NativeThreadSamplerInstaller() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$onConfigChange(NativeThreadSamplerInstaller $this, ConfigService configService2, NativeThreadSamplerService sampler, AnrService anrService2) {
        $this.onConfigChange(configService2, sampler, anrService2);
    }

    public static final /* synthetic */ AtomicBoolean access$isMonitoring$p(NativeThreadSamplerInstaller $this) {
        return $this.isMonitoring;
    }

    public static final /* synthetic */ void access$monitorCurrentThread(NativeThreadSamplerInstaller $this, NativeThreadSamplerService sampler, AnrService anrService2) {
        $this.monitorCurrentThread(sampler, anrService2);
    }
}

