/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr.sigquit;

import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.SharedObjectLoader;
import io.embrace.android.embracesdk.anr.sigquit.FindGoogleThread;
import io.embrace.android.embracesdk.anr.sigquit.GoogleAnrHandlerNativeDelegate;
import io.embrace.android.embracesdk.anr.sigquit.GoogleAnrTimestampRepository;
import io.embrace.android.embracesdk.config.ConfigListener;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.utils.ThreadUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0007J\b\u0010\u001c\u001a\u00020\u0016H\u0002R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/embrace/android/embracesdk/anr/sigquit/SigquitDetectionService;", "Lio/embrace/android/embracesdk/MemoryCleanerListener;", "sharedObjectLoader", "Lio/embrace/android/embracesdk/SharedObjectLoader;", "findGoogleThread", "Lio/embrace/android/embracesdk/anr/sigquit/FindGoogleThread;", "googleAnrHandlerNativeDelegate", "Lio/embrace/android/embracesdk/anr/sigquit/GoogleAnrHandlerNativeDelegate;", "googleAnrTimestampRepository", "Lio/embrace/android/embracesdk/anr/sigquit/GoogleAnrTimestampRepository;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "(Lio/embrace/android/embracesdk/SharedObjectLoader;Lio/embrace/android/embracesdk/anr/sigquit/FindGoogleThread;Lio/embrace/android/embracesdk/anr/sigquit/GoogleAnrHandlerNativeDelegate;Lio/embrace/android/embracesdk/anr/sigquit/GoogleAnrTimestampRepository;Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;)V", "getConfigService", "()Lio/embrace/android/embracesdk/config/ConfigService;", "setConfigService", "(Lio/embrace/android/embracesdk/config/ConfigService;)V", "googleAnrTrackerInstalled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cleanCollections", "", "initializeGoogleAnrTracking", "installGoogleAnrHandler", "googleThreadId", "", "setupGoogleAnrHandler", "setupGoogleAnrTracking", "embrace-android-sdk_release"})
public final class SigquitDetectionService
implements MemoryCleanerListener {
    private final AtomicBoolean googleAnrTrackerInstalled;
    private final SharedObjectLoader sharedObjectLoader;
    private final FindGoogleThread findGoogleThread;
    private final GoogleAnrHandlerNativeDelegate googleAnrHandlerNativeDelegate;
    private final GoogleAnrTimestampRepository googleAnrTimestampRepository;
    @NotNull
    private ConfigService configService;
    private final InternalEmbraceLogger logger;

    /*
     * WARNING - void declaration
     */
    private final void installGoogleAnrHandler(int googleThreadId) {
        int res = this.googleAnrHandlerNativeDelegate.install(googleThreadId);
        if (res > 0) {
            void msg$iv;
            void this_$iv;
            this.googleAnrTrackerInstalled.set(false);
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            Object object = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            String string2 = "Could not initialize Google ANR tracking {code=%d}";
            Object[] objectArray = new Object[]{res};
            boolean bl = false;
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            object = string3;
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
        } else {
            InternalEmbraceLogger this_$iv = this.logger;
            String msg$iv = "Google Anr Tracker handler installed successfully";
            boolean $i$f$logInfo = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.INFO, null, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void initializeGoogleAnrTracking() {
        void className$iv;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceAnrService";
        String msg$iv = "Deciding whether to initialize Google ANR Tracking";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        if (this.configService.getAnrBehavior().isGoogleAnrCaptureEnabled()) {
            this.setupGoogleAnrTracking();
        } else {
            this.configService.addListener(new ConfigListener(this){
                final /* synthetic */ SigquitDetectionService this$0;

                public final void onConfigChange(@NotNull ConfigService it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SigquitDetectionService.access$setupGoogleAnrTracking(this.this$0);
                }
                {
                    this.this$0 = sigquitDetectionService2;
                }
            });
        }
    }

    private final void setupGoogleAnrTracking() {
        if (this.configService.getAnrBehavior().isGoogleAnrCaptureEnabled() && !this.googleAnrTrackerInstalled.getAndSet(true)) {
            ThreadUtils.INSTANCE.runOnMainThread(new Runnable(this){
                final /* synthetic */ SigquitDetectionService this$0;

                public final void run() {
                    this.this$0.setupGoogleAnrHandler();
                }
                {
                    this.this$0 = sigquitDetectionService2;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void setupGoogleAnrHandler() {
        InternalEmbraceLogger className$iv;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceAnrService";
        String msg$iv = "Setting up Google ANR Handler";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)((Object)className$iv) + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        if (!this.sharedObjectLoader.loadEmbraceNative()) {
            this.googleAnrTrackerInstalled.set(false);
            return;
        }
        int googleThreadId = this.findGoogleThread.invoke();
        if (googleThreadId <= 0) {
            void this_$iv2;
            className$iv = this.logger;
            msg$iv = "Could not initialize Google ANR tracking: Google thread not found.";
            throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv2.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
            this.googleAnrTrackerInstalled.set(false);
            return;
        }
        this.installGoogleAnrHandler(googleThreadId);
    }

    @Override
    public void cleanCollections() {
        this.googleAnrTimestampRepository.clear();
    }

    @NotNull
    public final ConfigService getConfigService() {
        return this.configService;
    }

    public final void setConfigService(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"<set-?>");
        this.configService = configService2;
    }

    public SigquitDetectionService(@NotNull SharedObjectLoader sharedObjectLoader2, @NotNull FindGoogleThread findGoogleThread, @NotNull GoogleAnrHandlerNativeDelegate googleAnrHandlerNativeDelegate, @NotNull GoogleAnrTimestampRepository googleAnrTimestampRepository2, @NotNull ConfigService configService2, @NotNull InternalEmbraceLogger logger) {
        Intrinsics.checkNotNullParameter((Object)sharedObjectLoader2, (String)"sharedObjectLoader");
        Intrinsics.checkNotNullParameter((Object)findGoogleThread, (String)"findGoogleThread");
        Intrinsics.checkNotNullParameter((Object)googleAnrHandlerNativeDelegate, (String)"googleAnrHandlerNativeDelegate");
        Intrinsics.checkNotNullParameter((Object)googleAnrTimestampRepository2, (String)"googleAnrTimestampRepository");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.sharedObjectLoader = sharedObjectLoader2;
        this.findGoogleThread = findGoogleThread;
        this.googleAnrHandlerNativeDelegate = googleAnrHandlerNativeDelegate;
        this.googleAnrTimestampRepository = googleAnrTimestampRepository2;
        this.configService = configService2;
        this.logger = logger;
        this.googleAnrTrackerInstalled = new AtomicBoolean(false);
    }

    public static final /* synthetic */ void access$setupGoogleAnrTracking(SigquitDetectionService $this) {
        $this.setupGoogleAnrTracking();
    }
}

