/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.aei;

import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.capture.aei.ApplicationExitInfoService;
import io.embrace.android.embracesdk.config.ConfigListener;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.config.behavior.AppExitInfoBehavior;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.payload.AppExitInfoData;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\"\u001a\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f #*\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e0\u000e\u0018\u00010\rH\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/embrace/android/embracesdk/capture/aei/EmbraceApplicationExitInfoService;", "Lio/embrace/android/embracesdk/capture/aei/ApplicationExitInfoService;", "Lio/embrace/android/embracesdk/config/ConfigListener;", "worker", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "am", "Landroid/app/ActivityManager;", "preferencesService", "Lio/embrace/android/embracesdk/PreferencesService;", "(Lio/embrace/android/embracesdk/worker/BackgroundWorker;Lio/embrace/android/embracesdk/config/ConfigService;Landroid/app/ActivityManager;Lio/embrace/android/embracesdk/PreferencesService;)V", "appExitInfoList", "Ljava/util/concurrent/Future;", "", "Lio/embrace/android/embracesdk/payload/AppExitInfoData;", "getAppExitInfoList$annotations", "()V", "getAppExitInfoList", "()Ljava/util/concurrent/Future;", "setAppExitInfoList", "(Ljava/util/concurrent/Future;)V", "buildAppExitInfoData", "appExitInfo", "Landroid/app/ApplicationExitInfo;", "cleanCollections", "", "collectExitInfoTraces", "Lio/embrace/android/embracesdk/config/behavior/AppExitInfoBehavior$CollectTracesResult;", "endService", "generateUniqueHash", "", "getCapturedData", "onConfigChange", "startService", "kotlin.jvm.PlatformType", "trackAppExitInfo", "embrace-android-sdk_release"})
@RequiresApi(value=30)
public final class EmbraceApplicationExitInfoService
implements ApplicationExitInfoService,
ConfigListener {
    @Nullable
    private Future<List<AppExitInfoData>> appExitInfoList;
    private final BackgroundWorker worker;
    private final ConfigService configService;
    private final ActivityManager am;
    private final PreferencesService preferencesService;

    @VisibleForTesting
    public static /* synthetic */ void getAppExitInfoList$annotations() {
    }

    @Nullable
    public final Future<List<AppExitInfoData>> getAppExitInfoList() {
        return this.appExitInfoList;
    }

    public final void setAppExitInfoList(@Nullable Future<List<AppExitInfoData>> future) {
        this.appExitInfoList = future;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<AppExitInfoData> trackAppExitInfo() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Object applicationExitInfo;
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String msg$iv = "App exit Info - trackAppExitInfo ";
        Throwable throwable$iv = null;
        boolean $i$f$logDebug = false;
        companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
        int pid = 0;
        int maxNum = 5;
        Object object2 = this.am;
        if (object2 == null || (object2 = object2.getHistoricalProcessExitReasons(null, pid, maxNum)) == null) {
            object2 = applicationExitInfo = CollectionsKt.emptyList();
        }
        if (applicationExitInfo.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = (Iterable)applicationExitInfo;
        EmbraceApplicationExitInfoService embraceApplicationExitInfoService = this;
        boolean $i$f$map = false;
        void var8_12 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator p1;
            ApplicationExitInfo applicationExitInfo2 = (ApplicationExitInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = embraceApplicationExitInfoService.generateUniqueHash((ApplicationExitInfo)p1);
            collection.add(object);
        }
        Set allAeiHashCodes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set set = this.preferencesService.getApplicationExitInfoHistory();
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Set deliveredHashCodes = set;
        Set unsentHashCodes = CollectionsKt.subtract((Iterable)allAeiHashCodes, (Iterable)deliveredHashCodes);
        this.preferencesService.setApplicationExitInfoHistory(allAeiHashCodes);
        Iterable $this$filter$iv = (Iterable)applicationExitInfo;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ApplicationExitInfo it = (ApplicationExitInfo)element$iv$iv;
            boolean bl = false;
            if (!unsentHashCodes.contains(this.generateUniqueHash(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List unsentAeiObjects = (List)destination$iv$iv2;
        $this$filter$iv = unsentAeiObjects;
        EmbraceApplicationExitInfoService embraceApplicationExitInfoService2 = this;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            ApplicationExitInfo bl = (ApplicationExitInfo)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl2 = false;
            object = embraceApplicationExitInfoService2.buildAppExitInfoData((ApplicationExitInfo)p1);
            collection.add(object);
        }
        return (List)destination$iv$iv3;
    }

    @VisibleForTesting
    @NotNull
    public final AppExitInfoBehavior.CollectTracesResult collectExitInfoTraces(@NotNull ApplicationExitInfo appExitInfo) {
        Intrinsics.checkNotNullParameter((Object)appExitInfo, (String)"appExitInfo");
        try {
            InputStream inputStream = appExitInfo.getTraceInputStream();
            if (inputStream != null) {
                AppExitInfoBehavior.CollectTracesResult collectTracesResult;
                InputStream inputStream2 = inputStream;
                boolean bl = false;
                boolean bl2 = false;
                InputStream traces = inputStream2;
                boolean bl3 = false;
                InputStream inputStream3 = traces;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"traces");
                byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream3);
                int size = bytes.length;
                if (size <= this.configService.getAppExitInfoBehavior().getTracesMaxLimit()) {
                    Charset charset = Charset.forName("UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(\"UTF-8\")");
                    Charset charset2 = charset;
                    boolean bl4 = false;
                    collectTracesResult = new AppExitInfoBehavior.CollectTracesResult.Success(new String(bytes, charset2));
                } else {
                    collectTracesResult = new AppExitInfoBehavior.CollectTracesResult.TooLarge("too_large: size= " + size);
                }
                return collectTracesResult;
            }
        }
        catch (IOException e) {
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "AEI - IOException: " + e.getMessage();
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            companion.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
            return new AppExitInfoBehavior.CollectTracesResult.TraceException("ioexception: " + e.getMessage());
        }
        catch (OutOfMemoryError e) {
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "AEI - Out of Memory: " + e.getMessage();
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            companion.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
            return new AppExitInfoBehavior.CollectTracesResult.TraceException("oom: " + e.getMessage());
        }
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String msg$iv = "AEI - Not info traces collected";
        Throwable throwable$iv = null;
        boolean logStacktrace$iv = false;
        boolean $i$f$logError = false;
        companion.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
        return new AppExitInfoBehavior.CollectTracesResult.TracesNull("Not info traces collected");
    }

    @VisibleForTesting
    @NotNull
    public final AppExitInfoData buildAppExitInfoData(@NotNull ApplicationExitInfo appExitInfo) {
        AppExitInfoBehavior.CollectTracesResult tracesResult;
        Intrinsics.checkNotNullParameter((Object)appExitInfo, (String)"appExitInfo");
        AppExitInfoBehavior.CollectTracesResult collectTracesResult = tracesResult = this.collectExitInfoTraces(appExitInfo);
        String traces = collectTracesResult instanceof AppExitInfoBehavior.CollectTracesResult.Success ? tracesResult.getResult() : null;
        Object object = tracesResult;
        String traceException = object instanceof AppExitInfoBehavior.CollectTracesResult.Success ? null : tracesResult.getResult();
        byte[] byArray = appExitInfo.getProcessStateSummary();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"appExitInfo.processStateSummary ?: ByteArray(0)");
        object = byArray;
        boolean bl = false;
        return new AppExitInfoData(new String((byte[])object, Charsets.UTF_8), appExitInfo.getImportance(), appExitInfo.getPss(), appExitInfo.getReason(), appExitInfo.getRss(), appExitInfo.getStatus(), appExitInfo.getTimestamp(), traces, appExitInfo.getDescription(), traceException);
    }

    private final String generateUniqueHash(ApplicationExitInfo appExitInfo) {
        return String.valueOf(appExitInfo.getTimestamp()) + "_" + appExitInfo.getPid();
    }

    @Override
    public void cleanCollections() {
    }

    @Override
    @NotNull
    public List<AppExitInfoData> getCapturedData() {
        Future<List<AppExitInfoData>> future;
        try {
            Future<List<AppExitInfoData>> future2 = this.appExitInfoList;
            if (future2 == null || (future2 = future2.get()) == null) {
                future2 = new ArrayList();
            }
            future = future2;
        }
        catch (Exception e) {
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "Failed to get App Exit info data";
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            companion.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
            future = new ArrayList();
        }
        return future;
    }

    @Override
    public void onConfigChange(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        if (this.appExitInfoList == null && configService2.isAppExitInfoCaptureEnabled()) {
            this.appExitInfoList = this.startService();
        } else if (!configService2.isAppExitInfoCaptureEnabled()) {
            this.endService();
        }
    }

    private final void endService() {
        try {
            Future<List<AppExitInfoData>> future = this.appExitInfoList;
            if (future != null) {
                future.cancel(true);
            }
            this.appExitInfoList = null;
        }
        catch (Exception e) {
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "Failed to disable EmbraceApplicationExitInfoService work";
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            companion.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
        }
    }

    private final Future<List<AppExitInfoData>> startService() {
        Future<List<AppExitInfoData>> future;
        try {
            future = this.worker.submit((Callable)new Callable<List<? extends AppExitInfoData>>(this){
                final /* synthetic */ EmbraceApplicationExitInfoService this$0;

                public final List<AppExitInfoData> call() {
                    return this.this$0.trackAppExitInfo();
                }
                {
                    this.this$0 = embraceApplicationExitInfoService;
                }
            });
        }
        catch (Exception e) {
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "AEI - trackAppExitInfo submit error";
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            companion.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
            future = null;
        }
        return future;
    }

    public EmbraceApplicationExitInfoService(@NotNull BackgroundWorker worker, @NotNull ConfigService configService2, @Nullable ActivityManager am, @NotNull PreferencesService preferencesService2) {
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)preferencesService2, (String)"preferencesService");
        this.worker = worker;
        this.configService = configService2;
        this.am = am;
        this.preferencesService = preferencesService2;
        this.configService.addListener(this);
        if (this.configService.isAppExitInfoCaptureEnabled()) {
            this.appExitInfoList = this.startService();
        }
    }
}

