/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.NetworkConnectivityListener;
import io.embrace.android.embracesdk.capture.connectivity.NetworkConnectivityService;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.comms.NetworkStatus;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.payload.Interval;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0018H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010!\u001a\u00020\u001eH\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J\u001a\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u001bH\u0002J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001bH\u0016J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001cH\u0002J\u0018\u0010/\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u001eH\u0002J\u0010\u00103\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0018H\u0016J\u0018\u00104\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001cH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/embrace/android/embracesdk/capture/connectivity/EmbraceNetworkConnectivityService;", "Landroid/content/BroadcastReceiver;", "Lio/embrace/android/embracesdk/capture/connectivity/NetworkConnectivityService;", "context", "Landroid/content/Context;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "bgRegistrationWorker", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "connectivityManager", "Landroid/net/ConnectivityManager;", "(Landroid/content/Context;Lio/embrace/android/embracesdk/clock/Clock;Lio/embrace/android/embracesdk/worker/BackgroundWorker;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;Landroid/net/ConnectivityManager;)V", "intentFilter", "Landroid/content/IntentFilter;", "ipAddress", "", "getIpAddress", "()Ljava/lang/String;", "ipAddress$delegate", "Lkotlin/Lazy;", "networkConnectivityListeners", "", "Lio/embrace/android/embracesdk/NetworkConnectivityListener;", "networkReachable", "Ljava/util/NavigableMap;", "", "Lio/embrace/android/embracesdk/comms/NetworkStatus;", "addNetworkConnectivityListener", "", "listener", "calculateIpAddress", "cleanCollections", "close", "getCapturedData", "", "Lio/embrace/android/embracesdk/payload/Interval;", "getCurrentNetworkStatus", "handleNetworkStatus", "notifyListeners", "", "timestamp", "networkStatusOnSessionStarted", "startTime", "notifyNetworkConnectivityListeners", "status", "onReceive", "intent", "Landroid/content/Intent;", "registerConnectivityActionReceiver", "removeNetworkConnectivityListener", "saveStatus", "networkStatus", "embrace-android-sdk_release"})
public final class EmbraceNetworkConnectivityService
extends BroadcastReceiver
implements NetworkConnectivityService {
    private final IntentFilter intentFilter;
    private final NavigableMap<Long, NetworkStatus> networkReachable;
    private final List<NetworkConnectivityListener> networkConnectivityListeners;
    @Nullable
    private final Lazy ipAddress$delegate;
    private final Context context;
    private final Clock clock;
    private final BackgroundWorker bgRegistrationWorker;
    private final InternalEmbraceLogger logger;
    private final ConnectivityManager connectivityManager;

    @Override
    @Nullable
    public String getIpAddress() {
        Lazy lazy = this.ipAddress$delegate;
        EmbraceNetworkConnectivityService embraceNetworkConnectivityService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    public void onReceive(@NotNull Context context2, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        EmbraceNetworkConnectivityService.handleNetworkStatus$default(this, true, 0L, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Interval> getCapturedData() {
        void className$iv;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceNetworkConnectivityService";
        String msg$iv = "getNetworkInterfaceIntervals";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        long endTime = this.clock.now();
        EmbraceNetworkConnectivityService embraceNetworkConnectivityService = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (embraceNetworkConnectivityService) {
            boolean bl3 = false;
            List results = new ArrayList();
            SortedMap<Long, NetworkStatus> sortedMap = this.networkReachable.subMap(0L, endTime);
            Intrinsics.checkNotNullExpressionValue(sortedMap, (String)"networkReachable.subMap(0, endTime)");
            Map $this$forEach$iv = sortedMap;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl4 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                void currentTime;
                Map.Entry element$iv;
                Map.Entry $dstr$currentTime$value = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry entry = $dstr$currentTime$value;
                boolean bl6 = false;
                Long l = (Long)entry.getKey();
                entry = $dstr$currentTime$value;
                bl6 = false;
                NetworkStatus value = (NetworkStatus)((Object)entry.getValue());
                Long next = this.networkReachable.higherKey((Long)currentTime);
                void v1 = currentTime;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"currentTime");
                Long l2 = next;
                results.add(new Interval(v1.longValue(), l2 != null ? l2 : endTime, value.getValue()));
            }
            List list = results;
            return list;
        }
    }

    @Override
    public void networkStatusOnSessionStarted(long startTime) {
        this.handleNetworkStatus(false, startTime);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleNetworkStatus(boolean notifyListeners, long timestamp) {
        try {
            void className$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "EmbraceNetworkConnectivityService";
            Object msg$iv = "handleNetworkStatus";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            NetworkStatus networkStatus = this.getCurrentNetworkStatus();
            boolean savedStatus = this.saveStatus(timestamp, networkStatus);
            if (savedStatus && notifyListeners) {
                void this_$iv2;
                msg$iv = this.logger;
                String msg$iv2 = "Network status changed to: " + networkStatus.name();
                boolean $i$f$logInfo = false;
                this_$iv2.log(msg$iv2, EmbraceLogger.Severity.INFO, null, true);
                this.notifyNetworkConnectivityListeners(networkStatus);
            }
        }
        catch (Exception ex) {
            void this_$iv;
            InternalEmbraceLogger savedStatus = this.logger;
            String msg$iv = "Failed to record network connectivity";
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, ex, true);
        }
    }

    static /* synthetic */ void handleNetworkStatus$default(EmbraceNetworkConnectivityService embraceNetworkConnectivityService, boolean bl, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = embraceNetworkConnectivityService.clock.now();
        }
        embraceNetworkConnectivityService.handleNetworkStatus(bl, l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NetworkStatus getCurrentNetworkStatus() {
        NetworkStatus networkStatus = null;
        try {
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager2 = this.connectivityManager;
            Object object = networkInfo = connectivityManager2 != null ? connectivityManager2.getActiveNetworkInfo() : null;
            if (networkInfo != null && networkInfo.isConnected()) {
                switch (networkInfo.getType()) {
                    case 1: {
                        void msg$iv;
                        void className$iv;
                        void this_$iv;
                        InternalEmbraceLogger internalEmbraceLogger = this.logger;
                        String string2 = "EmbraceNetworkConnectivityService";
                        String string3 = "Network connected to WIFI";
                        Throwable throwable$iv = null;
                        boolean $i$f$logDeveloper = false;
                        this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                        networkStatus = NetworkStatus.WIFI;
                        break;
                    }
                    case 0: {
                        InternalEmbraceLogger this_$iv = this.logger;
                        String className$iv = "EmbraceNetworkConnectivityService";
                        String msg$iv = "Network connected to MOBILE";
                        Throwable throwable$iv = null;
                        boolean $i$f$logDeveloper = false;
                        this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                        networkStatus = NetworkStatus.WAN;
                        break;
                    }
                    default: {
                        InternalEmbraceLogger this_$iv = this.logger;
                        String className$iv = "EmbraceNetworkConnectivityService";
                        String msg$iv = "Network is reachable but type is not WIFI or MOBILE";
                        Throwable throwable$iv = null;
                        boolean $i$f$logDeveloper = false;
                        this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                        networkStatus = NetworkStatus.UNKNOWN;
                        break;
                    }
                }
            } else {
                InternalEmbraceLogger this_$iv = this.logger;
                String className$iv = "EmbraceNetworkConnectivityService";
                String msg$iv = "Network not reachable";
                Throwable throwable$iv = null;
                boolean $i$f$logDeveloper = false;
                this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                networkStatus = NetworkStatus.NOT_REACHABLE;
            }
        }
        catch (Exception e) {
            InternalEmbraceLogger this_$iv = this.logger;
            String msg$iv = "Error while trying to get connectivity status.";
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
            networkStatus = NetworkStatus.UNKNOWN;
        }
        return networkStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean saveStatus(long timestamp, NetworkStatus networkStatus) {
        EmbraceNetworkConnectivityService embraceNetworkConnectivityService = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (embraceNetworkConnectivityService) {
            block5: {
                boolean bl3 = false;
                if (!this.networkReachable.isEmpty()) {
                    Map.Entry<Long, NetworkStatus> entry = this.networkReachable.lastEntry();
                    if ((entry != null ? entry.getValue() : null) == networkStatus) break block5;
                }
                ((Map)this.networkReachable).put(timestamp, networkStatus);
                boolean bl4 = true;
                return bl4;
            }
            Unit unit = Unit.INSTANCE;
        }
        return false;
    }

    private final void registerConnectivityActionReceiver() {
        this.bgRegistrationWorker.submit((Callable)new Callable<Object>(this){
            final /* synthetic */ EmbraceNetworkConnectivityService this$0;

            /*
             * WARNING - void declaration
             */
            public final Object call() {
                try {
                    EmbraceNetworkConnectivityService.access$getContext$p(this.this$0).registerReceiver((BroadcastReceiver)this.this$0, EmbraceNetworkConnectivityService.access$getIntentFilter$p(this.this$0));
                }
                catch (Exception ex) {
                    void this_$iv;
                    InternalEmbraceLogger internalEmbraceLogger = EmbraceNetworkConnectivityService.access$getLogger$p(this.this$0);
                    String msg$iv = "Failed to register EmbraceNetworkConnectivityService broadcast receiver. Connectivity status will be unavailable.";
                    boolean $i$f$logDebug = false;
                    this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, ex, true);
                }
                return null;
            }
            {
                this.this$0 = embraceNetworkConnectivityService;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void className$iv;
        void this_$iv;
        this.context.unregisterReceiver((BroadcastReceiver)this);
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceNetworkConnectivityService";
        String msg$iv = "closed";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanCollections() {
        void className$iv;
        void this_$iv;
        this.networkReachable.clear();
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = "EmbraceNetworkConnectivityService";
        String msg$iv = "Collections cleaned";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
    }

    @Override
    public void addNetworkConnectivityListener(@NotNull NetworkConnectivityListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.networkConnectivityListeners.add(listener);
    }

    @Override
    public void removeNetworkConnectivityListener(@NotNull NetworkConnectivityListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.networkConnectivityListeners.remove(listener);
    }

    private final void notifyNetworkConnectivityListeners(NetworkStatus status) {
        for (NetworkConnectivityListener listener : this.networkConnectivityListeners) {
            listener.onNetworkConnectivityStatusChanged(status);
        }
    }

    private final String calculateIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf;
                NetworkInterface networkInterface = intf = en.nextElement();
                Intrinsics.checkNotNullExpressionValue((Object)networkInterface, (String)"intf");
                Enumeration<InetAddress> enumIpAddr = networkInterface.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress;
                    InetAddress inetAddress2 = inetAddress = enumIpAddr.nextElement();
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"inetAddress");
                    if (inetAddress2.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "Cannot get IP Address";
            Throwable throwable$iv = null;
            boolean $i$f$logDebug = false;
            companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
        }
        return null;
    }

    public EmbraceNetworkConnectivityService(@NotNull Context context2, @NotNull Clock clock2, @NotNull BackgroundWorker bgRegistrationWorker, @NotNull InternalEmbraceLogger logger, @Nullable ConnectivityManager connectivityManager2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)bgRegistrationWorker, (String)"bgRegistrationWorker");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context2;
        this.clock = clock2;
        this.bgRegistrationWorker = bgRegistrationWorker;
        this.logger = logger;
        this.connectivityManager = connectivityManager2;
        this.intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.networkReachable = new TreeMap();
        boolean bl = false;
        this.networkConnectivityListeners = new ArrayList();
        this.ipAddress$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ EmbraceNetworkConnectivityService this$0;

            @Nullable
            public final String invoke() {
                return EmbraceNetworkConnectivityService.access$calculateIpAddress(this.this$0);
            }
            {
                this.this$0 = embraceNetworkConnectivityService;
                super(0);
            }
        }));
        this.registerConnectivityActionReceiver();
    }

    public static final /* synthetic */ Context access$getContext$p(EmbraceNetworkConnectivityService $this) {
        return $this.context;
    }

    public static final /* synthetic */ IntentFilter access$getIntentFilter$p(EmbraceNetworkConnectivityService $this) {
        return $this.intentFilter;
    }

    public static final /* synthetic */ InternalEmbraceLogger access$getLogger$p(EmbraceNetworkConnectivityService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$calculateIpAddress(EmbraceNetworkConnectivityService $this) {
        return $this.calculateIpAddress();
    }
}

