/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.crash;

import io.embrace.android.embracesdk.BackgroundActivityService;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.NdkService;
import io.embrace.android.embracesdk.SessionService;
import io.embrace.android.embracesdk.Uuid;
import io.embrace.android.embracesdk.anr.AnrService;
import io.embrace.android.embracesdk.capture.crash.CrashService;
import io.embrace.android.embracesdk.capture.crash.EmbraceUncaughtExceptionHandler;
import io.embrace.android.embracesdk.capture.user.UserService;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.comms.delivery.DeliveryService;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.gating.GatingService;
import io.embrace.android.embracesdk.internal.ApkToolsConfig;
import io.embrace.android.embracesdk.internal.crash.CrashFileMarker;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.payload.Crash;
import io.embrace.android.embracesdk.payload.JsException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020 2\u0006\u0010#\u001a\u00020\u001cH\u0016J\b\u0010&\u001a\u00020 H\u0002R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/embrace/android/embracesdk/capture/crash/EmbraceCrashService;", "Lio/embrace/android/embracesdk/capture/crash/CrashService;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "sessionService", "Lio/embrace/android/embracesdk/SessionService;", "metadataService", "Lio/embrace/android/embracesdk/MetadataService;", "deliveryService", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;", "userService", "Lio/embrace/android/embracesdk/capture/user/UserService;", "eventService", "Lio/embrace/android/embracesdk/EventService;", "anrService", "Lio/embrace/android/embracesdk/anr/AnrService;", "ndkService", "Lio/embrace/android/embracesdk/NdkService;", "gatingService", "Lio/embrace/android/embracesdk/gating/GatingService;", "backgroundActivityService", "Lio/embrace/android/embracesdk/BackgroundActivityService;", "crashMarker", "Lio/embrace/android/embracesdk/internal/crash/CrashFileMarker;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "(Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/SessionService;Lio/embrace/android/embracesdk/MetadataService;Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;Lio/embrace/android/embracesdk/capture/user/UserService;Lio/embrace/android/embracesdk/EventService;Lio/embrace/android/embracesdk/anr/AnrService;Lio/embrace/android/embracesdk/NdkService;Lio/embrace/android/embracesdk/gating/GatingService;Lio/embrace/android/embracesdk/BackgroundActivityService;Lio/embrace/android/embracesdk/internal/crash/CrashFileMarker;Lio/embrace/android/embracesdk/clock/Clock;)V", "jsException", "Lio/embrace/android/embracesdk/payload/JsException;", "mainCrashHandled", "", "handleCrash", "", "thread", "Ljava/lang/Thread;", "exception", "", "logUnhandledJsException", "registerExceptionHandler", "Companion", "embrace-android-sdk_release"})
public final class EmbraceCrashService
implements CrashService {
    private boolean mainCrashHandled;
    private JsException jsException;
    private final SessionService sessionService;
    private final MetadataService metadataService;
    private final DeliveryService deliveryService;
    private final UserService userService;
    private final EventService eventService;
    private final AnrService anrService;
    private final NdkService ndkService;
    private final GatingService gatingService;
    private final BackgroundActivityService backgroundActivityService;
    private final CrashFileMarker crashMarker;
    private final Clock clock;
    private static final String CRASH_REPORT_EVENT_NAME = "_crash_report";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleCrash(@NotNull Thread thread, @NotNull Throwable exception) {
        String className$iv;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string2 = "EmbraceCrashService";
        Object msg$iv = "Attempting to handle crash";
        boolean $i$f$logDeveloper = false;
        companion.log('[' + className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        if (!this.mainCrashHandled) {
            void className$iv2;
            String string3;
            String className$iv3;
            boolean $i$f$logDeveloper2;
            String msg$iv2;
            Crash crash;
            Object msg$iv3;
            boolean $i$f$logDeveloper3;
            this.mainCrashHandled = true;
            AnrService anrService2 = this.anrService;
            if (anrService2 != null) {
                anrService2.forceAnrTrackingStopOnCrash();
            }
            companion = InternalStaticEmbraceLogger.Companion;
            className$iv = "EmbraceCrashService";
            msg$iv = "JsException is present: " + (this.jsException != null ? "true" : "false");
            $i$f$logDeveloper = false;
            companion.log('[' + className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            String unityCrashId = this.ndkService.getUnityCrashId();
            if (unityCrashId != null) {
                void className$iv4;
                msg$iv = InternalStaticEmbraceLogger.Companion;
                String $i$f$logDeveloper4 = "EmbraceCrashService";
                String string4 = "unityCrashId is " + unityCrashId;
                $i$f$logDeveloper3 = false;
                ((InternalStaticEmbraceLogger.Companion)msg$iv).log('[' + (String)className$iv4 + "] " + (String)msg$iv3, EmbraceLogger.Severity.DEVELOPER, null, true);
                crash = Crash.Companion.ofThrowable(exception, this.jsException, unityCrashId);
            } else {
                crash = Crash.Companion.ofThrowable$default(Crash.Companion, exception, this.jsException, null, 4, null);
            }
            Crash crash2 = crash;
            msg$iv = InternalStaticEmbraceLogger.Companion;
            String className$iv4 = "EmbraceCrashService";
            msg$iv3 = "crashId = " + crash2.crashId;
            $i$f$logDeveloper3 = false;
            ((InternalStaticEmbraceLogger.Companion)msg$iv).log('[' + className$iv4 + "] " + (String)msg$iv3, EmbraceLogger.Severity.DEVELOPER, null, true);
            String optionalSessionId = this.metadataService.getActiveSessionId();
            if (optionalSessionId != null) {
                msg$iv3 = InternalStaticEmbraceLogger.Companion;
                String $i$f$logDeveloper5 = "EmbraceCrashService";
                msg$iv2 = "Session id is present:" + optionalSessionId;
                $i$f$logDeveloper2 = false;
                ((InternalStaticEmbraceLogger.Companion)msg$iv3).log('[' + className$iv3 + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
                string3 = optionalSessionId;
            } else {
                msg$iv3 = InternalStaticEmbraceLogger.Companion;
                className$iv3 = "EmbraceCrashService";
                msg$iv2 = "Session id is not present:";
                $i$f$logDeveloper2 = false;
                ((InternalStaticEmbraceLogger.Companion)msg$iv3).log('[' + className$iv3 + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
                string3 = null;
            }
            String sessionId = string3;
            Event event = new Event(CRASH_REPORT_EVENT_NAME, null, Uuid.getEmbUuid$default(null, 1, null), sessionId, EmbraceEvent.Type.CRASH, this.clock.now(), null, false, null, this.metadataService.getAppState(), null, this.sessionService.getProperties(), this.eventService.getActiveEventIds(), null, null, null, null);
            EventMessage versionedEvent = new EventMessage(event, crash2, this.metadataService.getDeviceInfo(), this.metadataService.getAppInfo(), this.userService.getUserInfo(), null, null, 13, null);
            EventMessage crashEvent = this.gatingService.gateEventMessage(versionedEvent);
            InternalStaticEmbraceLogger.Companion companion2 = InternalStaticEmbraceLogger.Companion;
            String string5 = "EmbraceCrashService";
            String msg$iv4 = "Attempting to send event...";
            boolean $i$f$logDeveloper6 = false;
            companion2.log('[' + (String)className$iv2 + "] " + msg$iv4, EmbraceLogger.Severity.DEVELOPER, null, true);
            this.deliveryService.saveCrash(crashEvent);
            this.sessionService.handleCrash(crash2.crashId);
            BackgroundActivityService backgroundActivityService2 = this.backgroundActivityService;
            if (backgroundActivityService2 != null) {
                backgroundActivityService2.handleCrash(crash2.crashId);
            }
            this.deliveryService.sendCrash(crashEvent);
            this.crashMarker.mark();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerExceptionHandler() {
        void className$iv;
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string2 = "EmbraceCrashService";
        String msg$iv = "registerExceptionHandler";
        boolean $i$f$logDeveloper = false;
        companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        EmbraceUncaughtExceptionHandler embraceHandler = new EmbraceUncaughtExceptionHandler(defaultHandler, this);
        Thread.setDefaultUncaughtExceptionHandler(embraceHandler);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logUnhandledJsException(@NotNull JsException exception) {
        void className$iv;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String string2 = "EmbraceCrashService";
        String msg$iv = "logUnhandledJsException";
        boolean $i$f$logDeveloper = false;
        companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        this.jsException = exception;
    }

    /*
     * WARNING - void declaration
     */
    public EmbraceCrashService(@NotNull ConfigService configService2, @NotNull SessionService sessionService2, @NotNull MetadataService metadataService2, @NotNull DeliveryService deliveryService2, @NotNull UserService userService2, @NotNull EventService eventService2, @Nullable AnrService anrService2, @NotNull NdkService ndkService2, @NotNull GatingService gatingService2, @Nullable BackgroundActivityService backgroundActivityService2, @NotNull CrashFileMarker crashMarker2, @NotNull Clock clock2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)sessionService2, (String)"sessionService");
        Intrinsics.checkNotNullParameter((Object)metadataService2, (String)"metadataService");
        Intrinsics.checkNotNullParameter((Object)deliveryService2, (String)"deliveryService");
        Intrinsics.checkNotNullParameter((Object)userService2, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)eventService2, (String)"eventService");
        Intrinsics.checkNotNullParameter((Object)ndkService2, (String)"ndkService");
        Intrinsics.checkNotNullParameter((Object)gatingService2, (String)"gatingService");
        Intrinsics.checkNotNullParameter((Object)crashMarker2, (String)"crashMarker");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        this.sessionService = sessionService2;
        this.metadataService = metadataService2;
        this.deliveryService = deliveryService2;
        this.userService = userService2;
        this.eventService = eventService2;
        this.anrService = anrService2;
        this.ndkService = ndkService2;
        this.gatingService = gatingService2;
        this.backgroundActivityService = backgroundActivityService2;
        this.crashMarker = crashMarker2;
        this.clock = clock2;
        if (configService2.getAutoDataCaptureBehavior().isUncaughtExceptionHandlerEnabled() && !ApkToolsConfig.IS_EXCEPTION_CAPTURE_DISABLED) {
            void className$iv;
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String string2 = "EmbraceCrashService";
            String msg$iv = "crash handler enabled";
            boolean $i$f$logDeveloper = false;
            companion.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
            this.registerExceptionHandler();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/capture/crash/EmbraceCrashService$Companion;", "", "()V", "CRASH_REPORT_EVENT_NAME", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

