/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.screenshot;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import android.view.Window;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.capture.screenshot.ScreenshotService;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.comms.delivery.DeliveryService;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001c\u0010\u0013\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/embrace/android/embracesdk/capture/screenshot/EmbraceScreenshotService;", "Lio/embrace/android/embracesdk/capture/screenshot/ScreenshotService;", "activityService", "Lio/embrace/android/embracesdk/ActivityService;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "deliveryService", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "(Lio/embrace/android/embracesdk/ActivityService;Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;Lio/embrace/android/embracesdk/clock/Clock;)V", "lastScreenshot", "", "screenshot", "", "activity", "Landroid/app/Activity;", "takeScreenshot", "Landroid/graphics/Bitmap;", "", "logId", "", "eventId", "takeScreenshotLogEvent", "takeScreenshotMoment", "Companion", "embrace-android-sdk_release"})
public final class EmbraceScreenshotService
implements ScreenshotService {
    private volatile long lastScreenshot;
    private final ActivityService activityService;
    private final ConfigService configService;
    private final DeliveryService deliveryService;
    private final InternalEmbraceLogger logger;
    private final Clock clock;
    private static final long SCREENSHOT_COOLDOWN = 3000L;
    private static final int SCREENSHOT_JPEG_COMPRESSION_VALUE = 70;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean takeScreenshotLogEvent(@NotNull String logId) {
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        return this.takeScreenshot(logId, null);
    }

    @Override
    public boolean takeScreenshotMoment(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        return this.takeScreenshot(null, eventId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean takeScreenshot(String logId, String eventId) {
        EmbraceScreenshotService embraceScreenshotService = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (embraceScreenshotService) {
            void this_$iv;
            Object screenshot;
            boolean bl3 = false;
            long timestamp = this.clock.now();
            if (this.activityService.isInBackground() || !this.configService.getAutoDataCaptureBehavior().isScreenshotCaptureEnabled() || timestamp - this.lastScreenshot < 3000L) {
                void this_$iv2;
                InternalEmbraceLogger internalEmbraceLogger = this.logger;
                String msg$iv = "Screenshots are disabled, app is backgrounded, or cooling down";
                Throwable throwable$iv = null;
                boolean $i$f$logDebug = false;
                this_$iv2.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
                return false;
            }
            Activity optionalActivity = this.activityService.getForegroundActivity();
            if (optionalActivity != null) {
                String className$iv;
                InternalEmbraceLogger this_$iv32;
                screenshot = this.screenshot(optionalActivity);
                this.lastScreenshot = timestamp;
                if (screenshot == null) {
                    void this_$iv32;
                    InternalEmbraceLogger throwable$iv = this.logger;
                    String msg$iv2 = "Could not take screenshot";
                    Throwable throwable$iv2 = null;
                    boolean $i$f$logDebug = false;
                    this_$iv32.log(msg$iv2, EmbraceLogger.Severity.DEBUG, throwable$iv2, true);
                    return false;
                }
                if (eventId != null) {
                    String msg$iv;
                    this_$iv32 = this.logger;
                    String msg$iv2 = "EmbraceScreenshotService";
                    String throwable$iv2 = "Attempting to send moment screenshot";
                    Throwable throwable$iv = null;
                    boolean $i$f$logDeveloper = false;
                    this_$iv32.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                    this.deliveryService.sendMomentScreenshot((byte[])screenshot, eventId);
                    this_$iv32 = this.logger;
                    className$iv = "EmbraceScreenshotService";
                    msg$iv = "Send moment screenshot running on background";
                    throwable$iv = null;
                    $i$f$logDeveloper = false;
                    this_$iv32.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                    return true;
                } else {
                    if (logId == null) {
                        InternalEmbraceLogger this_$iv4 = this.logger;
                        String className$iv2 = "EmbraceScreenshotService";
                        String msg$iv = "Foreground activity not present";
                        Throwable throwable$iv = null;
                        boolean $i$f$logDeveloper = false;
                        this_$iv4.log('[' + className$iv2 + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                        return false;
                    }
                    this_$iv32 = this.logger;
                    className$iv = "EmbraceScreenshotService";
                    String msg$iv = "Attempting to send log screenshot";
                    Throwable throwable$iv = null;
                    boolean $i$f$logDeveloper = false;
                    this_$iv32.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                    this.deliveryService.sendLogScreenshot((byte[])screenshot, logId);
                    this_$iv32 = this.logger;
                    className$iv = "EmbraceScreenshotService";
                    msg$iv = "Send Log screenshot running on background";
                    throwable$iv = null;
                    $i$f$logDeveloper = false;
                    this_$iv32.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                }
                return true;
            }
            screenshot = this.logger;
            String msg$iv = "Screenshot cannot be taken as there is no active activity";
            Throwable throwable$iv = null;
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Bitmap takeScreenshot(Activity activity) {
        if (activity != null) {
            Object v2;
            Window window = activity.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
            View view = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
            View view2 = view;
            if (view2 != null) {
                if (view2.getWidth() > 0 && view2.getHeight() > 0) {
                    Object var3_3;
                    try {
                        void className$iv;
                        void this_$iv;
                        Bitmap screenshot = Bitmap.createBitmap((int)view2.getWidth(), (int)view2.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        InternalEmbraceLogger internalEmbraceLogger = this.logger;
                        String string2 = "EmbraceScreenshotService";
                        String msg$iv = "Bitmap created";
                        Throwable throwable$iv = null;
                        boolean $i$f$logDeveloper = false;
                        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                        view2.draw(new Canvas(screenshot));
                    }
                    catch (OutOfMemoryError e) {
                        Embrace.getInstance().logInternalError("Empty screenshot 01 - Out of memory drawing screenshot", "Run out of memory while creating the bitmap and drawing the screenshot");
                        var3_3 = null;
                    }
                    v2 = var3_3;
                } else {
                    Embrace.getInstance().logInternalError("Empty screenshot 02 - decor view is 0 or lower", "Height: " + view2.getHeight() + ". Width: " + view2.getWidth());
                    v2 = null;
                }
            } else {
                Embrace.getInstance().logInternalError("Empty screenshot 03 - decor view is null", "activity.getWindow().getDecorView() returned null");
                v2 = null;
            }
            return v2;
        }
        Embrace.getInstance().logInternalError("Empty screenshot 04 - activity is null", "Null activity");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] screenshot(Activity activity) {
        String this_$iv;
        InternalEmbraceLogger className$iv;
        void this_$iv2;
        boolean $i$f$logDeveloper;
        Throwable throwable$iv;
        String msg$iv;
        void this_$iv3;
        Bitmap screenshot = this.takeScreenshot(activity);
        if (screenshot == null) {
            Embrace.getInstance().logInternalError("Empty screenshot 05 - null bitmap", "Created bitmap was null");
            return null;
        }
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        Object msg$iv2 = "Compressing screenshot";
        Object throwable$iv2 = null;
        boolean $i$f$logDebug = false;
        this_$iv3.log((String)msg$iv2, EmbraceLogger.Severity.DEBUG, (Throwable)throwable$iv2, true);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            screenshot.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)stream);
            msg$iv2 = this.logger;
            throwable$iv2 = "EmbraceScreenshotService";
            msg$iv = "Screenshot compressed";
            throwable$iv = null;
            $i$f$logDeveloper = false;
            this_$iv2.log('[' + (String)((Object)className$iv) + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        }
        catch (OutOfMemoryError e) {
            className$iv = this.logger;
            String msg$iv3 = "Failed to compress screenshot due insufficient memory.";
            boolean $i$f$logDebug2 = false;
            ((InternalEmbraceLogger)((Object)this_$iv)).log(msg$iv3, EmbraceLogger.Severity.DEBUG, e, true);
            Embrace.getInstance().logInternalError("Empty screenshot 06 - compress OOM", "Failed to compress screenshot. Cause: OOM");
            return null;
        }
        screenshot.recycle();
        InternalEmbraceLogger e = this.logger;
        this_$iv = "EmbraceScreenshotService";
        msg$iv = "Screenshot recycled";
        throwable$iv = null;
        $i$f$logDeveloper = false;
        this_$iv2.log('[' + (String)((Object)className$iv) + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        return stream.toByteArray();
    }

    public EmbraceScreenshotService(@NotNull ActivityService activityService2, @NotNull ConfigService configService2, @NotNull DeliveryService deliveryService2, @NotNull InternalEmbraceLogger logger, @NotNull Clock clock2) {
        Intrinsics.checkNotNullParameter((Object)activityService2, (String)"activityService");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)deliveryService2, (String)"deliveryService");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        this.activityService = activityService2;
        this.configService = configService2;
        this.deliveryService = deliveryService2;
        this.logger = logger;
        this.clock = clock2;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/embrace/android/embracesdk/capture/screenshot/EmbraceScreenshotService$Companion;", "", "()V", "SCREENSHOT_COOLDOWN", "", "SCREENSHOT_JPEG_COMPRESSION_VALUE", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

