/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.thermalstate;

import android.os.PowerManager;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.capture.thermalstate.ThermalStatusService;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.payload.ThermalState;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0016J\u0017\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/embrace/android/embracesdk/capture/thermalstate/EmbraceThermalStatusService;", "Lio/embrace/android/embracesdk/capture/thermalstate/ThermalStatusService;", "executor", "Ljava/util/concurrent/Executor;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "pm", "Landroid/os/PowerManager;", "(Ljava/util/concurrent/Executor;Lio/embrace/android/embracesdk/clock/Clock;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;Landroid/os/PowerManager;)V", "thermalStates", "Ljava/util/LinkedList;", "Lio/embrace/android/embracesdk/payload/ThermalState;", "thermalStatusListener", "Landroid/os/PowerManager$OnThermalStatusChangedListener;", "cleanCollections", "", "close", "getCapturedData", "", "handleThermalStateChange", "status", "", "(Ljava/lang/Integer;)V", "embrace-android-sdk_release"})
@RequiresApi(value=29)
public final class EmbraceThermalStatusService
implements ThermalStatusService {
    private final LinkedList<ThermalState> thermalStates;
    private final PowerManager.OnThermalStatusChangedListener thermalStatusListener;
    private final Clock clock;
    private final InternalEmbraceLogger logger;
    private final PowerManager pm;

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void handleThermalStateChange(@Nullable Integer status) {
        if (status == null) {
            void className$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "ThermalStatusService";
            String msg$iv = "Null thermal status, no-oping.";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            return;
        }
        InternalEmbraceLogger this_$iv = this.logger;
        String className$iv = "ThermalStatusService";
        String msg$iv = "Thermal status change: " + status;
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        this.thermalStates.add(new ThermalState(this.clock.now(), status));
        if (this.thermalStates.size() > 100) {
            this_$iv = this.logger;
            className$iv = "ThermalStatusService";
            msg$iv = "Exceeded capture limit, removing oldest thermal status sample.";
            throwable$iv = null;
            $i$f$logDeveloper = false;
            this_$iv.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            this.thermalStates.removeFirst();
        }
    }

    @Override
    public void cleanCollections() {
        this.thermalStates.clear();
    }

    @Override
    @NotNull
    public List<ThermalState> getCapturedData() {
        return this.thermalStates;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        block0: {
            void className$iv;
            void this_$iv;
            PowerManager powerManager2 = this.pm;
            if (powerManager2 == null) break block0;
            PowerManager powerManager3 = powerManager2;
            boolean bl = false;
            boolean bl2 = false;
            PowerManager it = powerManager3;
            boolean bl3 = false;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "ThermalStatusService";
            String msg$iv = "Removing thermal status listener";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            it.removeThermalStatusListener(this.thermalStatusListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    public EmbraceThermalStatusService(@NotNull Executor executor, @NotNull Clock clock2, @NotNull InternalEmbraceLogger logger, @Nullable PowerManager pm) {
        block0: {
            void className$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.clock = clock2;
            this.logger = logger;
            this.pm = pm;
            this.thermalStates = new LinkedList();
            this.thermalStatusListener = new PowerManager.OnThermalStatusChangedListener(this){
                final /* synthetic */ EmbraceThermalStatusService this$0;

                public final void onThermalStatusChanged(int it) {
                    this.this$0.handleThermalStateChange(it);
                }
                {
                    this.this$0 = embraceThermalStatusService;
                }
            };
            PowerManager powerManager2 = this.pm;
            if (powerManager2 == null) break block0;
            PowerManager powerManager3 = powerManager2;
            boolean bl = false;
            boolean bl2 = false;
            PowerManager it = powerManager3;
            boolean bl3 = false;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "ThermalStatusService";
            String msg$iv = "Adding thermal status listener";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            it.addThermalStatusListener(executor, this.thermalStatusListener);
        }
    }
}

