/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.user;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.capture.user.UserService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.payload.UserInfo;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\r\b\u0000\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0012\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\u0012\u0010\u001d\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u001f\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010!\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010\u0018H\u0016R$\u0010\b\u001a\u00020\t8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/embrace/android/embracesdk/capture/user/EmbraceUserService;", "Lio/embrace/android/embracesdk/ActivityListener;", "Lio/embrace/android/embracesdk/capture/user/UserService;", "preferencesService", "Lio/embrace/android/embracesdk/PreferencesService;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "(Lio/embrace/android/embracesdk/PreferencesService;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;)V", "info", "Lio/embrace/android/embracesdk/payload/UserInfo;", "getInfo$embrace_android_sdk_release$annotations", "()V", "getInfo$embrace_android_sdk_release", "()Lio/embrace/android/embracesdk/payload/UserInfo;", "setInfo$embrace_android_sdk_release", "(Lio/embrace/android/embracesdk/payload/UserInfo;)V", "clearAllUserInfo", "", "clearAllUserPersonas", "clearUserAsPayer", "clearUserEmail", "clearUserIdentifier", "clearUserPersona", "persona", "", "clearUsername", "getUserInfo", "loadUserInfoFromDisk", "setUserAsPayer", "setUserEmail", "email", "setUserIdentifier", "userId", "setUserPersona", "setUsername", "username", "Companion", "embrace-android-sdk_release"})
public final class EmbraceUserService
implements ActivityListener,
UserService {
    @NotNull
    private volatile UserInfo info;
    private final PreferencesService preferencesService;
    private final InternalEmbraceLogger logger;
    @NotNull
    private static final Pattern VALID_PERSONA;
    public static final int PERSONA_LIMIT = 10;
    @NotNull
    public static final Companion Companion;

    @VisibleForTesting
    public static /* synthetic */ void getInfo$embrace_android_sdk_release$annotations() {
    }

    @NotNull
    public final UserInfo getInfo$embrace_android_sdk_release() {
        return this.info;
    }

    public final void setInfo$embrace_android_sdk_release(@NotNull UserInfo userInfo2) {
        Intrinsics.checkNotNullParameter((Object)userInfo2, (String)"<set-?>");
        this.info = userInfo2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public UserInfo loadUserInfoFromDisk() {
        UserInfo userInfo2;
        try {
            userInfo2 = UserInfo.Companion.ofStored(this.preferencesService);
        }
        catch (Exception ex) {
            void msg$iv;
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = "Failed to load user info from persistent storage.";
            boolean logStacktrace$iv = true;
            boolean $i$f$logError = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.ERROR, ex, logStacktrace$iv);
            userInfo2 = null;
        }
        return userInfo2;
    }

    @Override
    @NotNull
    public UserInfo getUserInfo() {
        return UserInfo.copy$default(this.info, null, null, null, null, 15, null);
    }

    @Override
    public void setUserIdentifier(@Nullable String userId) {
        String currentUserId = this.info.getUserId();
        if (currentUserId != null && Intrinsics.areEqual((Object)currentUserId, (Object)userId)) {
            return;
        }
        this.info = UserInfo.copy$default(this.info, userId, null, null, null, 14, null);
        this.preferencesService.setUserIdentifier(userId);
    }

    @Override
    public void clearUserIdentifier() {
        this.setUserIdentifier(null);
    }

    @Override
    public void setUsername(@Nullable String username) {
        String currentUserName = this.info.getUsername();
        if (currentUserName != null && Intrinsics.areEqual((Object)currentUserName, (Object)username)) {
            return;
        }
        this.info = UserInfo.copy$default(this.info, null, null, username, null, 11, null);
        this.preferencesService.setUsername(username);
    }

    @Override
    public void clearUsername() {
        this.setUsername(null);
    }

    @Override
    public void setUserEmail(@Nullable String email) {
        String currentEmail = this.info.getEmail();
        if (currentEmail != null && Intrinsics.areEqual((Object)currentEmail, (Object)email)) {
            return;
        }
        this.info = UserInfo.copy$default(this.info, null, email, null, null, 13, null);
        this.preferencesService.setUserEmailAddress(email);
    }

    @Override
    public void clearUserEmail() {
        this.setUserEmail(null);
    }

    @Override
    public void setUserAsPayer() {
        this.setUserPersona("payer");
    }

    @Override
    public void clearUserAsPayer() {
        this.clearUserPersona("payer");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setUserPersona(@Nullable String persona) {
        Set set;
        if (persona == null) {
            return;
        }
        if (!VALID_PERSONA.matcher(persona).matches()) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv = "Ignoring persona " + persona + " as it does not match " + VALID_PERSONA.pattern();
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
            return;
        }
        Set<String> currentPersonas = this.info.getPersonas();
        if (currentPersonas != null) {
            if (currentPersonas.size() >= 10) {
                void this_$iv;
                InternalEmbraceLogger msg$iv = this.logger;
                String msg$iv2 = "Cannot set persona as the limit of 10 has been reached";
                Throwable throwable$iv = null;
                boolean logStacktrace$iv = false;
                boolean $i$f$logWarning = false;
                this_$iv.log(msg$iv2, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
                return;
            }
            if (currentPersonas.contains(persona)) {
                return;
            }
        }
        if ((set = this.info.getPersonas()) == null || (set = SetsKt.plus(set, (Object)persona)) == null) {
            set = SetsKt.mutableSetOf((Object[])new String[]{persona});
        }
        Set newPersonas = set;
        this.info = UserInfo.copy$default(this.info, null, null, null, newPersonas, 7, null);
        this.preferencesService.setUserPersonas(newPersonas);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearUserPersona(@Nullable String persona) {
        if (persona == null) {
            return;
        }
        Set<String> currentPersonas = this.info.getPersonas();
        if (currentPersonas != null && !currentPersonas.contains(persona)) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv = "Persona '" + persona + "' is not set";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
            return;
        }
        Set set = this.info.getPersonas();
        if (set == null || (set = SetsKt.minus(set, (Object)persona)) == null) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        Set newPersonas = set;
        this.info = UserInfo.copy$default(this.info, null, null, null, newPersonas, 7, null);
        this.preferencesService.setUserPersonas(newPersonas);
    }

    @Override
    public void clearAllUserPersonas() {
        Set<String> currentPersonas = this.info.getPersonas();
        if (currentPersonas != null && currentPersonas.isEmpty()) {
            return;
        }
        Set personas = new HashSet();
        if (this.preferencesService.getUserPayer()) {
            personas.add("payer");
        }
        if (this.preferencesService.isUsersFirstDay()) {
            personas.add("first_day");
        }
        this.info = UserInfo.copy$default(this.info, null, null, null, personas, 7, null);
        this.preferencesService.setUserPersonas(personas);
    }

    @Override
    public void clearAllUserInfo() {
        this.clearUserIdentifier();
        this.clearUserEmail();
        this.clearUsername();
        this.clearAllUserPersonas();
    }

    public EmbraceUserService(@NotNull PreferencesService preferencesService2, @NotNull InternalEmbraceLogger logger) {
        Intrinsics.checkNotNullParameter((Object)preferencesService2, (String)"preferencesService");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.preferencesService = preferencesService2;
        this.logger = logger;
        this.info = UserInfo.Companion.ofStored(this.preferencesService);
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_]{1,32}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\"^[a-zA-Z0-9_]{1,32}$\")");
        VALID_PERSONA = pattern;
    }

    @Override
    public void onBackground(long timestamp) {
        ActivityListener.DefaultImpls.onBackground(this, timestamp);
    }

    @Override
    public void onForeground(boolean coldStart, long startupTime, long timestamp) {
        ActivityListener.DefaultImpls.onForeground(this, coldStart, startupTime, timestamp);
    }

    @Override
    public void applicationStartupComplete() {
        ActivityListener.DefaultImpls.applicationStartupComplete(this);
    }

    @Override
    public void onView(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onView(this, activity);
    }

    @Override
    public void onViewClose(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onViewClose(this, activity);
    }

    @Override
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ActivityListener.DefaultImpls.onActivityCreated(this, activity, bundle);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/embrace/android/embracesdk/capture/user/EmbraceUserService$Companion;", "", "()V", "PERSONA_LIMIT", "", "VALID_PERSONA", "Ljava/util/regex/Pattern;", "getVALID_PERSONA", "()Ljava/util/regex/Pattern;", "embrace-android-sdk_release"})
    public static final class Companion {
        @NotNull
        public final Pattern getVALID_PERSONA() {
            return VALID_PERSONA;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

