/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.webview;

import com.google.gson.reflect.TypeToken;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSerializer;
import io.embrace.android.embracesdk.capture.webview.EmbraceWebViewService$WhenMappings;
import io.embrace.android.embracesdk.capture.webview.WebViewService;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.payload.WebViewInfo;
import io.embrace.android.embracesdk.payload.WebVital;
import io.embrace.android.embracesdk.payload.WebVitalType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/embrace/android/embracesdk/capture/webview/EmbraceWebViewService;", "Lio/embrace/android/embracesdk/capture/webview/WebViewService;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "serializer", "Lio/embrace/android/embracesdk/EmbraceSerializer;", "(Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/EmbraceSerializer;)V", "getConfigService", "()Lio/embrace/android/embracesdk/config/ConfigService;", "webViewInfoMap", "Ljava/util/HashMap;", "", "Lio/embrace/android/embracesdk/payload/WebViewInfo;", "Lkotlin/collections/HashMap;", "webVitalType", "Ljava/lang/reflect/Type;", "kotlin.jvm.PlatformType", "cleanCollections", "", "collectWebData", "tag", "message", "collectWebVital", "getCapturedData", "", "parseWebVital", "processVitalList", "newMessage", "storedMessage", "Companion", "embrace-android-sdk_release"})
public final class EmbraceWebViewService
implements WebViewService {
    private final HashMap<String, WebViewInfo> webViewInfoMap;
    private final Type webVitalType;
    @NotNull
    private final ConfigService configService;
    private final EmbraceSerializer serializer;
    private static final int SCRIPT_MESSAGE_MAXIMUM_ALLOWED_LENGTH = 2000;
    private static final String MESSAGE_KEY_FOR_METRICS = "EMBRACE_METRIC";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void collectWebData(@NotNull String tag, @NotNull String message) {
        void className$iv;
        InternalEmbraceLogger this_$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
        String string2 = "EmbraceWebViewService";
        String msg$iv = "Collecting WebView log: " + message;
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        if (StringsKt.contains$default((CharSequence)message, (CharSequence)MESSAGE_KEY_FOR_METRICS, (boolean)false, (int)2, null)) {
            this.collectWebVital(message, tag);
        } else {
            this_$iv = InternalStaticEmbraceLogger.logger;
            String msg$iv2 = "WebView console message ignored.";
            Throwable throwable$iv2 = null;
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv2, EmbraceLogger.Severity.DEBUG, throwable$iv2, true);
        }
    }

    @Override
    @NotNull
    public List<WebViewInfo> getCapturedData() {
        Collection<WebViewInfo> collection = this.webViewInfoMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"webViewInfoMap.values");
        return CollectionsKt.take((Iterable)CollectionsKt.toList((Iterable)collection), (int)this.configService.getWebViewVitalsBehavior().getMaxWebViewVitals());
    }

    /*
     * WARNING - void declaration
     */
    private final void collectWebVital(String message, String tag) {
        block2: {
            void this_$iv;
            WebViewInfo collectedWebVitals;
            void className$iv;
            InternalEmbraceLogger this_$iv2;
            InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
            Object object = "EmbraceWebViewService";
            String msg$iv = "Collecting web metric";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv2.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            if (this.webViewInfoMap.size() >= this.configService.getWebViewVitalsBehavior().getMaxWebViewVitals()) {
                this_$iv2 = InternalStaticEmbraceLogger.logger;
                String msg$iv2 = "Max webview vitals per session exceeded";
                Throwable throwable$iv2 = null;
                boolean $i$f$logDebug = false;
                this_$iv2.log(msg$iv2, EmbraceLogger.Severity.DEBUG, throwable$iv2, true);
                return;
            }
            WebViewInfo webViewInfo = collectedWebVitals = this.parseWebVital(message);
            if (webViewInfo == null) break block2;
            object = webViewInfo;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            if (this.webViewInfoMap.get(((WebViewInfo)it).getUrl() + ((WebViewInfo)it).getStartTime()) == null) {
                ((Map)this.webViewInfoMap).put(((WebViewInfo)it).getUrl() + ((WebViewInfo)it).getStartTime(), WebViewInfo.copy$default((WebViewInfo)it, tag, null, null, 0L, new EnumMap(WebVitalType.class), 14, null));
            }
            Map map = this.webViewInfoMap;
            String string2 = ((WebViewInfo)it).getUrl() + ((WebViewInfo)it).getStartTime();
            WebViewInfo webViewInfo2 = this.webViewInfoMap.get(((WebViewInfo)it).getUrl() + ((WebViewInfo)it).getStartTime());
            Intrinsics.checkNotNull((Object)webViewInfo2);
            Intrinsics.checkNotNullExpressionValue((Object)webViewInfo2, (String)"webViewInfoMap[it.url + it.startTime]!!");
            map.put(string2, this.processVitalList((WebViewInfo)it, webViewInfo2));
            InternalEmbraceLogger internalEmbraceLogger2 = InternalStaticEmbraceLogger.logger;
            String msg$iv3 = "Collected WebView core vital: " + message;
            Throwable throwable$iv3 = null;
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv3, EmbraceLogger.Severity.DEBUG, throwable$iv3, true);
        }
    }

    private final WebViewInfo processVitalList(WebViewInfo newMessage, WebViewInfo storedMessage) {
        Iterable $this$forEach$iv = newMessage.getWebVitals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebVital newVital = (WebVital)element$iv;
            boolean bl = false;
            WebVital webVital = storedMessage.getWebVitalMap().get((Object)newVital.getType());
            boolean bl2 = false;
            boolean bl3 = false;
            WebVital it = webVital;
            boolean bl4 = false;
            if (it == null) {
                storedMessage.getWebVitalMap().put(newVital.getType(), newVital);
                continue;
            }
            switch (EmbraceWebViewService$WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()]) {
                case 1: {
                    if (newVital.getDuration() <= it.getDuration()) break;
                    storedMessage.getWebVitalMap().put(it.getType(), newVital);
                    break;
                }
                case 2: {
                    if (newVital.getStartTime() <= it.getStartTime()) break;
                    storedMessage.getWebVitalMap().put(it.getType(), newVital);
                    break;
                }
            }
        }
        return WebViewInfo.copy$default(storedMessage, null, CollectionsKt.toMutableList(storedMessage.getWebVitalMap().values()), null, 0L, null, 29, null);
    }

    /*
     * WARNING - void declaration
     */
    private final WebViewInfo parseWebVital(String message) {
        try {
            void this_$iv;
            if (message.length() < 2000) {
                Type type2 = this.webVitalType;
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"webVitalType");
                return (WebViewInfo)this.serializer.fromJson(message, type2);
            }
            InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
            String msg$iv = "Web Vital info is too large to parse";
            Throwable throwable$iv = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
        }
        catch (Exception e) {
            void this_$iv;
            InternalEmbraceLogger msg$iv = InternalStaticEmbraceLogger.logger;
            String msg$iv2 = "Cannot parse Web Vital";
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv2, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
        }
        return null;
    }

    @Override
    public void cleanCollections() {
        this.webViewInfoMap.clear();
    }

    @NotNull
    public final ConfigService getConfigService() {
        return this.configService;
    }

    public EmbraceWebViewService(@NotNull ConfigService configService2, @NotNull EmbraceSerializer serializer) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        this.configService = configService2;
        this.serializer = serializer;
        boolean bl = false;
        this.webViewInfoMap = new HashMap();
        this.webVitalType = new TypeToken<WebViewInfo>(){}.getType();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/embrace/android/embracesdk/capture/webview/EmbraceWebViewService$Companion;", "", "()V", "MESSAGE_KEY_FOR_METRICS", "", "SCRIPT_MESSAGE_MAXIMUM_ALLOWED_LENGTH", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

