/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.comms.delivery;

import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.BackgroundActivityMessage;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSerializer;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.SessionMessage;
import io.embrace.android.embracesdk.SessionMessageSerializer;
import io.embrace.android.embracesdk.Uuid;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.comms.delivery.CacheService;
import io.embrace.android.embracesdk.comms.delivery.DeliveryFailedApiCalls;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 :2\u00020\u0001:\u00029:B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0018J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u000fJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0 J\u0010\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u000fJ\b\u0010$\u001a\u0004\u0018\u00010%J\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001c\u001a\u00020\u000fJ\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u0010H\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u001e\u001a\u00020\u000fJ\u0010\u0010,\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001e\u001a\u00020\u000fJ\u0010\u0010-\u001a\u0004\u0018\u00010\"2\u0006\u0010.\u001a\u00020/J\u0018\u00100\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\"H\u0002J\u000e\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020%J\u000e\u00104\u001a\u00020\u00182\u0006\u00105\u001a\u00020'J\u000e\u00106\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\"J\u0010\u00107\u001a\u0004\u0018\u00010\"2\u0006\u00108\u001a\u00020*R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lio/embrace/android/embracesdk/comms/delivery/DeliveryCacheManager;", "Ljava/io/Closeable;", "cacheService", "Lio/embrace/android/embracesdk/comms/delivery/CacheService;", "worker", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "serializer", "Lio/embrace/android/embracesdk/EmbraceSerializer;", "(Lio/embrace/android/embracesdk/comms/delivery/CacheService;Lio/embrace/android/embracesdk/worker/BackgroundWorker;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;Lio/embrace/android/embracesdk/clock/Clock;Lio/embrace/android/embracesdk/EmbraceSerializer;)V", "cachedSessions", "", "", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryCacheManager$CachedSession;", "sessionMessageSerializer", "Lio/embrace/android/embracesdk/SessionMessageSerializer;", "getSessionMessageSerializer", "()Lio/embrace/android/embracesdk/SessionMessageSerializer;", "sessionMessageSerializer$delegate", "Lkotlin/Lazy;", "close", "", "deleteCrash", "deleteOldestSessions", "deletePayload", "name", "deleteSession", "sessionId", "getAllCachedSessionIds", "", "loadBackgroundActivity", "", "backgroundActivityId", "loadCrash", "Lio/embrace/android/embracesdk/EventMessage;", "loadFailedApiCalls", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryFailedApiCalls;", "loadPayload", "loadSession", "Lio/embrace/android/embracesdk/SessionMessage;", "cachedSession", "loadSessionBytes", "saveBackgroundActivity", "backgroundActivityMessage", "Lio/embrace/android/embracesdk/BackgroundActivityMessage;", "saveBytes", "bytes", "saveCrash", "crash", "saveFailedApiCalls", "failedApiCalls", "savePayload", "saveSession", "sessionMessage", "CachedSession", "Companion", "embrace-android-sdk_release"})
public final class DeliveryCacheManager
implements Closeable {
    private final Lazy sessionMessageSerializer$delegate;
    private final Map<String, CachedSession> cachedSessions;
    private final CacheService cacheService;
    private final BackgroundWorker worker;
    private final InternalEmbraceLogger logger;
    private final Clock clock;
    private final EmbraceSerializer serializer;
    private static final String SESSION_FILE_PREFIX = "last_session";
    private static final String OLD_VERSION_FILE_NAME = "last_session.json";
    private static final String CRASH_FILE_NAME = "crash.json";
    private static final String FAILED_API_CALLS_FILE_NAME = "failed_api_calls.json";
    public static final int MAX_SESSIONS_CACHED = 64;
    private static final String TAG = "DeliveryCacheManager";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final SessionMessageSerializer getSessionMessageSerializer() {
        Lazy lazy = this.sessionMessageSerializer$delegate;
        DeliveryCacheManager deliveryCacheManager2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SessionMessageSerializer)lazy.getValue();
    }

    @Nullable
    public final byte[] saveSession(@NotNull SessionMessage sessionMessage2) {
        Intrinsics.checkNotNullParameter((Object)sessionMessage2, (String)"sessionMessage");
        if (this.cachedSessions.size() >= 64) {
            this.deleteOldestSessions();
        }
        String string2 = this.getSessionMessageSerializer().serialize(sessionMessage2);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] sessionBytes = byArray;
        this.saveBytes(sessionMessage2.getSession().getSessionId(), sessionBytes);
        return sessionBytes;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SessionMessage loadSession(@NotNull String sessionId) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        CachedSession cachedSession = this.cachedSessions.get(sessionId);
        if (cachedSession != null) {
            CachedSession cachedSession2 = cachedSession;
            boolean bl = false;
            boolean bl2 = false;
            CachedSession cachedSession3 = cachedSession2;
            boolean bl3 = false;
            return this.loadSession(cachedSession3);
        }
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String msg$iv = "Session " + sessionId + " is not in cache";
        Throwable throwable$iv = null;
        boolean logStacktrace$iv = false;
        boolean $i$f$logError = false;
        this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final byte[] loadSessionBytes(@NotNull String sessionId) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        CachedSession cachedSession = this.cachedSessions.get(sessionId);
        if (cachedSession != null) {
            CachedSession cachedSession2 = cachedSession;
            boolean bl = false;
            boolean bl2 = false;
            CachedSession cachedSession3 = cachedSession2;
            boolean bl3 = false;
            return (byte[])this.worker.submit((Callable)new Callable<byte[]>(cachedSession3, this){
                final /* synthetic */ CachedSession $cachedSession;
                final /* synthetic */ DeliveryCacheManager this$0;
                {
                    this.$cachedSession = cachedSession;
                    this.this$0 = deliveryCacheManager2;
                }

                @Nullable
                public final byte[] call() {
                    return this.this$0.loadPayload(this.$cachedSession.getFilename());
                }
            }).get();
        }
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String msg$iv = "Session " + sessionId + " is not in cache";
        Throwable throwable$iv = null;
        boolean logStacktrace$iv = false;
        boolean $i$f$logError = false;
        this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
        return null;
    }

    public final void deleteSession(@NotNull String sessionId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            CachedSession cachedSession = this.cachedSessions.get(sessionId);
            if (cachedSession == null) break block0;
            CachedSession cachedSession2 = cachedSession;
            boolean bl = false;
            boolean bl2 = false;
            CachedSession cachedSession3 = cachedSession2;
            boolean bl3 = false;
            this.worker.submit((Callable)new Callable<Object>(cachedSession3, this, sessionId){
                final /* synthetic */ CachedSession $cachedSession;
                final /* synthetic */ DeliveryCacheManager this$0;
                final /* synthetic */ String $sessionId$inlined;
                {
                    this.$cachedSession = cachedSession;
                    this.this$0 = deliveryCacheManager2;
                    this.$sessionId$inlined = string2;
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final Object call() {
                    Object object;
                    try {
                        DeliveryCacheManager.access$getCacheService$p(this.this$0).deleteFile(this.$cachedSession.getFilename());
                        object = DeliveryCacheManager.access$getCachedSessions$p(this.this$0).remove(this.$sessionId$inlined);
                    }
                    catch (Exception ex) {
                        void this_$iv;
                        InternalEmbraceLogger internalEmbraceLogger = DeliveryCacheManager.access$getLogger$p(this.this$0);
                        String msg$iv = "Could not remove session from cache: " + this.$sessionId$inlined;
                        Throwable throwable$iv = null;
                        boolean logStacktrace$iv = false;
                        boolean $i$f$logError = false;
                        this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
                        object = Unit.INSTANCE;
                    }
                    return object;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAllCachedSessionIds() {
        List<String> allSessions;
        List<String> list = allSessions = this.cacheService.listFilenamesByPrefix(SESSION_FILE_PREFIX);
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void this_$iv;
                boolean bl;
                Object object;
                List values;
                InternalEmbraceLogger internalEmbraceLogger;
                boolean bl2;
                SessionMessage previousSdkSession;
                String filename = (String)element$iv;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)filename, (Object)OLD_VERSION_FILE_NAME) && (previousSdkSession = this.cacheService.loadObject(filename, SessionMessage.class)) != null) {
                    boolean bl4 = false;
                    bl2 = false;
                    SessionMessage it = internalEmbraceLogger;
                    boolean bl5 = false;
                    this.saveSession(it);
                    this.worker.submit((Callable)new Callable<Boolean>(filename, this){
                        final /* synthetic */ String $filename$inlined;
                        final /* synthetic */ DeliveryCacheManager this$0;
                        {
                            this.$filename$inlined = string2;
                            this.this$0 = deliveryCacheManager2;
                        }

                        public final Boolean call() {
                            return DeliveryCacheManager.access$getCacheService$p(this.this$0).deleteFile(this.$filename$inlined);
                        }
                    });
                }
                if ((values = StringsKt.split$default((CharSequence)filename, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null)).size() != 4) {
                    void this_$iv2;
                    internalEmbraceLogger = this.logger;
                    String msg$iv = "Unrecognized cached file: " + filename;
                    Throwable throwable$iv = null;
                    boolean logStacktrace$iv = false;
                    boolean $i$f$logError = false;
                    this_$iv2.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
                    continue;
                }
                Long timestamp = StringsKt.toLongOrNull((String)((String)values.get(1)));
                Object object2 = timestamp;
                if (object2 != null) {
                    object = object2;
                    bl2 = false;
                    bl = false;
                    long it = ((Number)object).longValue();
                    boolean bl6 = false;
                    String sessionId = (String)values.get(2);
                    this.cachedSessions.put(sessionId, new CachedSession(sessionId, it));
                    object2 = object;
                    if (object2 != null) continue;
                }
                object = this;
                bl2 = false;
                bl = false;
                DeliveryCacheManager $this$run = (DeliveryCacheManager)object;
                boolean bl7 = false;
                InternalEmbraceLogger bl6 = $this$run.logger;
                String msg$iv = "Could not parse timestamp " + (String)values.get(2);
                Throwable throwable$iv = null;
                boolean logStacktrace$iv = false;
                boolean $i$f$logError = false;
                this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, throwable$iv, logStacktrace$iv);
                object2 = Unit.INSTANCE;
            }
        }
        return CollectionsKt.toList((Iterable)this.cachedSessions.keySet());
    }

    @Nullable
    public final byte[] saveBackgroundActivity(@NotNull BackgroundActivityMessage backgroundActivityMessage) {
        byte[] baBytes;
        block0: {
            Intrinsics.checkNotNullParameter((Object)backgroundActivityMessage, (String)"backgroundActivityMessage");
            String baId = backgroundActivityMessage.getBackgroundActivity().getSessionId();
            baBytes = this.serializer.bytesFromPayload(backgroundActivityMessage, BackgroundActivityMessage.class);
            if (this.cachedSessions.size() >= 64 && !this.cachedSessions.containsKey(baId) || baBytes == null) break block0;
            byte[] byArray = baBytes;
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray;
            boolean bl3 = false;
            this.saveBytes(baId, it);
        }
        return baBytes;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final byte[] loadBackgroundActivity(@NotNull String backgroundActivityId) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)backgroundActivityId, (String)"backgroundActivityId");
        CachedSession cachedSession = this.cachedSessions.get(backgroundActivityId);
        if (cachedSession != null) {
            CachedSession cachedSession2 = cachedSession;
            boolean bl = false;
            boolean bl2 = false;
            CachedSession cachedSession3 = cachedSession2;
            boolean bl3 = false;
            return (byte[])this.worker.submit((Callable)new Callable<byte[]>(cachedSession3, this){
                final /* synthetic */ CachedSession $cachedSession;
                final /* synthetic */ DeliveryCacheManager this$0;
                {
                    this.$cachedSession = cachedSession;
                    this.this$0 = deliveryCacheManager2;
                }

                @Nullable
                public final byte[] call() {
                    return this.this$0.loadPayload(this.$cachedSession.getFilename());
                }
            }).get();
        }
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String msg$iv = "Background activity " + backgroundActivityId + " is not in cache";
        Throwable throwable$iv = null;
        boolean logStacktrace$iv = false;
        boolean $i$f$logWarning = false;
        this_$iv.log(msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv, logStacktrace$iv);
        return null;
    }

    public final void saveCrash(@NotNull EventMessage crash) {
        Intrinsics.checkNotNullParameter((Object)crash, (String)"crash");
        this.cacheService.cacheObject(CRASH_FILE_NAME, crash, EventMessage.class);
    }

    @Nullable
    public final EventMessage loadCrash() {
        return this.cacheService.loadObject(CRASH_FILE_NAME, EventMessage.class);
    }

    public final void deleteCrash() {
        this.cacheService.deleteFile(CRASH_FILE_NAME);
    }

    @NotNull
    public final String savePayload(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String name = "payload_" + Uuid.getEmbUuid$default(null, 1, null);
        this.worker.submit((Callable)new Callable<Unit>(this, name, bytes){
            final /* synthetic */ DeliveryCacheManager this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ byte[] $bytes;

            public final void call() {
                DeliveryCacheManager.access$getCacheService$p(this.this$0).cacheBytes(this.$name, this.$bytes);
            }
            {
                this.this$0 = deliveryCacheManager2;
                this.$name = string2;
                this.$bytes = byArray;
            }
        });
        return name;
    }

    @Nullable
    public final byte[] loadPayload(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.cacheService.loadBytes(name);
    }

    public final void deletePayload(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.worker.submit((Callable)new Callable<Boolean>(this, name){
            final /* synthetic */ DeliveryCacheManager this$0;
            final /* synthetic */ String $name;

            public final Boolean call() {
                return DeliveryCacheManager.access$getCacheService$p(this.this$0).deleteFile(this.$name);
            }
            {
                this.this$0 = deliveryCacheManager2;
                this.$name = string2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void saveFailedApiCalls(@NotNull DeliveryFailedApiCalls failedApiCalls) {
        block0: {
            void className$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)failedApiCalls, (String)"failedApiCalls");
            Object object = this.logger;
            String string2 = TAG;
            String msg$iv = "Saving failed api calls";
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            byte[] byArray = this.serializer.bytesFromPayload(failedApiCalls, DeliveryFailedApiCalls.class);
            if (byArray == null) break block0;
            object = byArray;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            this.worker.submit((Callable)new Callable<Unit>((byte[])it, this){
                final /* synthetic */ byte[] $it;
                final /* synthetic */ DeliveryCacheManager this$0;
                {
                    this.$it = byArray;
                    this.this$0 = deliveryCacheManager2;
                }

                public final void call() {
                    DeliveryCacheManager.access$getCacheService$p(this.this$0).cacheBytes("failed_api_calls.json", this.$it);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DeliveryFailedApiCalls loadFailedApiCalls() {
        DeliveryFailedApiCalls deliveryFailedApiCalls;
        InternalEmbraceLogger className$iv;
        void this_$iv;
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String msg$iv = "Loading failed api calls";
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)((Object)className$iv) + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        DeliveryFailedApiCalls cached2 = (DeliveryFailedApiCalls)this.worker.submit((Callable)new Callable<DeliveryFailedApiCalls>(this){
            final /* synthetic */ DeliveryCacheManager this$0;

            @Nullable
            public final DeliveryFailedApiCalls call() {
                return DeliveryCacheManager.access$getCacheService$p(this.this$0).loadObject("failed_api_calls.json", DeliveryFailedApiCalls.class);
            }
            {
                this.this$0 = deliveryCacheManager2;
            }
        }).get();
        if (cached2 != null) {
            deliveryFailedApiCalls = cached2;
        } else {
            void className$iv2;
            void this_$iv2;
            className$iv = this.logger;
            msg$iv = TAG;
            String msg$iv2 = "No failed api calls cache found";
            Throwable throwable$iv2 = null;
            boolean $i$f$logDeveloper2 = false;
            this_$iv2.log('[' + (String)className$iv2 + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
            deliveryFailedApiCalls = new DeliveryFailedApiCalls();
        }
        return deliveryFailedApiCalls;
    }

    @Override
    public void close() {
    }

    private final SessionMessage loadSession(CachedSession cachedSession) {
        return (SessionMessage)this.worker.submit((Callable)new Callable<SessionMessage>(this, cachedSession){
            final /* synthetic */ DeliveryCacheManager this$0;
            final /* synthetic */ CachedSession $cachedSession;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final SessionMessage call() {
                try {
                    SessionMessage sessionMessage2 = DeliveryCacheManager.access$getCacheService$p(this.this$0).loadObject(this.$cachedSession.getFilename(), SessionMessage.class);
                    if (sessionMessage2 != null) {
                        void className$iv;
                        void this_$iv;
                        InternalEmbraceLogger internalEmbraceLogger = DeliveryCacheManager.access$getLogger$p(this.this$0);
                        String string2 = "DeliveryCacheManager";
                        String msg$iv = "Successfully fetched previous session message.";
                        Throwable throwable$iv = null;
                        boolean $i$f$logDeveloper = false;
                        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                        return sessionMessage2;
                    }
                }
                catch (Exception ex) {
                    InternalEmbraceLogger this_$iv = DeliveryCacheManager.access$getLogger$p(this.this$0);
                    String msg$iv = "Failed to load previous cached session message";
                    boolean logStacktrace$iv = false;
                    boolean $i$f$logError = false;
                    this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, ex, logStacktrace$iv);
                }
                return null;
            }
            {
                this.this$0 = deliveryCacheManager2;
                this.$cachedSession = cachedSession;
            }
        }).get();
    }

    private final void deleteOldestSessions() {
        Iterable $this$sortedBy$iv = this.cachedSessions.values();
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                CachedSession it = (CachedSession)a;
                boolean bl2 = false;
                Comparable comparable = it.getTimestamp();
                it = (CachedSession)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTimestamp();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        }), (int)(this.cachedSessions.size() - 64 + 1));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CachedSession it = (CachedSession)element$iv;
            boolean bl2 = false;
            this.deleteSession(it.getSessionId());
        }
    }

    private final void saveBytes(String sessionId, byte[] bytes) {
        this.worker.submit((Callable)new Callable<Unit>(this, sessionId, bytes){
            final /* synthetic */ DeliveryCacheManager this$0;
            final /* synthetic */ String $sessionId;
            final /* synthetic */ byte[] $bytes;

            /*
             * WARNING - void declaration
             */
            public final void call() {
                try {
                    void className$iv;
                    void this_$iv;
                    Object object = DeliveryCacheManager.access$getCachedSessions$p(this.this$0);
                    String string2 = this.$sessionId;
                    boolean bl = false;
                    Object object2 = object.get(string2);
                    if (object2 == null) {
                        boolean bl2 = false;
                        object2 = new CachedSession(this.$sessionId, DeliveryCacheManager.access$getClock$p(this.this$0).now());
                    }
                    CachedSession cachedSession = (CachedSession)object2;
                    DeliveryCacheManager.access$getCacheService$p(this.this$0).cacheBytes(cachedSession.getFilename(), this.$bytes);
                    if (!DeliveryCacheManager.access$getCachedSessions$p(this.this$0).containsKey(cachedSession.getSessionId())) {
                        DeliveryCacheManager.access$getCachedSessions$p(this.this$0).put(cachedSession.getSessionId(), cachedSession);
                    }
                    object = DeliveryCacheManager.access$getLogger$p(this.this$0);
                    string2 = "DeliveryCacheManager";
                    String msg$iv = "Session message successfully cached.";
                    Throwable throwable$iv = null;
                    boolean $i$f$logDeveloper = false;
                    this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                }
                catch (Exception ex) {
                    InternalEmbraceLogger this_$iv = DeliveryCacheManager.access$getLogger$p(this.this$0);
                    String msg$iv = "Failed to cache current active session";
                    boolean logStacktrace$iv = false;
                    boolean $i$f$logError = false;
                    this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, ex, logStacktrace$iv);
                }
            }
            {
                this.this$0 = deliveryCacheManager2;
                this.$sessionId = string2;
                this.$bytes = byArray;
            }
        });
    }

    public DeliveryCacheManager(@NotNull CacheService cacheService2, @NotNull BackgroundWorker worker, @NotNull InternalEmbraceLogger logger, @NotNull Clock clock2, @NotNull EmbraceSerializer serializer) {
        Intrinsics.checkNotNullParameter((Object)cacheService2, (String)"cacheService");
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        this.cacheService = cacheService2;
        this.worker = worker;
        this.logger = logger;
        this.clock = clock2;
        this.serializer = serializer;
        this.sessionMessageSerializer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SessionMessageSerializer>(this){
            final /* synthetic */ DeliveryCacheManager this$0;

            @NotNull
            public final SessionMessageSerializer invoke() {
                return new SessionMessageSerializer(DeliveryCacheManager.access$getSerializer$p(this.this$0));
            }
            {
                this.this$0 = deliveryCacheManager2;
                super(0);
            }
        }));
        boolean bl = false;
        this.cachedSessions = new LinkedHashMap();
    }

    public static final /* synthetic */ CacheService access$getCacheService$p(DeliveryCacheManager $this) {
        return $this.cacheService;
    }

    public static final /* synthetic */ Map access$getCachedSessions$p(DeliveryCacheManager $this) {
        return $this.cachedSessions;
    }

    public static final /* synthetic */ InternalEmbraceLogger access$getLogger$p(DeliveryCacheManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Clock access$getClock$p(DeliveryCacheManager $this) {
        return $this.clock;
    }

    public static final /* synthetic */ EmbraceSerializer access$getSerializer$p(DeliveryCacheManager $this) {
        return $this.serializer;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ.\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lio/embrace/android/embracesdk/comms/delivery/DeliveryCacheManager$CachedSession;", "", "sessionId", "", "timestamp", "", "(Ljava/lang/String;J)V", "filename", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)V", "getFilename", "()Ljava/lang/String;", "getSessionId", "getTimestamp", "()Ljava/lang/Long;", "Ljava/lang/Long;", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)Lio/embrace/android/embracesdk/comms/delivery/DeliveryCacheManager$CachedSession;", "equals", "", "other", "hashCode", "", "toString", "embrace-android-sdk_release"})
    @VisibleForTesting
    public static final class CachedSession {
        @NotNull
        private final String filename;
        @NotNull
        private final String sessionId;
        @Nullable
        private final Long timestamp;

        @NotNull
        public final String getFilename() {
            return this.filename;
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        @Nullable
        public final Long getTimestamp() {
            return this.timestamp;
        }

        public CachedSession(@NotNull String filename, @NotNull String sessionId, @Nullable Long timestamp) {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            this.filename = filename;
            this.sessionId = sessionId;
            this.timestamp = timestamp;
        }

        public CachedSession(@NotNull String sessionId, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            this("last_session." + timestamp + '.' + sessionId + ".json", sessionId, timestamp);
        }

        @NotNull
        public final String component1() {
            return this.filename;
        }

        @NotNull
        public final String component2() {
            return this.sessionId;
        }

        @Nullable
        public final Long component3() {
            return this.timestamp;
        }

        @NotNull
        public final CachedSession copy(@NotNull String filename, @NotNull String sessionId, @Nullable Long timestamp) {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            return new CachedSession(filename, sessionId, timestamp);
        }

        public static /* synthetic */ CachedSession copy$default(CachedSession cachedSession, String string2, String string3, Long l, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = cachedSession.filename;
            }
            if ((n & 2) != 0) {
                string3 = cachedSession.sessionId;
            }
            if ((n & 4) != 0) {
                l = cachedSession.timestamp;
            }
            return cachedSession.copy(string2, string3, l);
        }

        @NotNull
        public String toString() {
            return "CachedSession(filename=" + this.filename + ", sessionId=" + this.sessionId + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            String string2 = this.filename;
            String string3 = this.sessionId;
            Long l = this.timestamp;
            return ((string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (l != null ? ((Object)l).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CachedSession)) break block3;
                    CachedSession cachedSession = (CachedSession)object;
                    if (!Intrinsics.areEqual((Object)this.filename, (Object)cachedSession.filename) || !Intrinsics.areEqual((Object)this.sessionId, (Object)cachedSession.sessionId) || !Intrinsics.areEqual((Object)this.timestamp, (Object)cachedSession.timestamp)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/embrace/android/embracesdk/comms/delivery/DeliveryCacheManager$Companion;", "", "()V", "CRASH_FILE_NAME", "", "FAILED_API_CALLS_FILE_NAME", "MAX_SESSIONS_CACHED", "", "getMAX_SESSIONS_CACHED$annotations", "OLD_VERSION_FILE_NAME", "SESSION_FILE_PREFIX", "TAG", "embrace-android-sdk_release"})
    public static final class Companion {
        @VisibleForTesting
        public static /* synthetic */ void getMAX_SESSIONS_CACHED$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

