/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.comms.delivery;

import android.content.Context;
import com.google.gson.stream.JsonReader;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSerializer;
import io.embrace.android.embracesdk.comms.delivery.CacheService;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J1\u0010\u0012\u001a\u00020\r\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u0002H\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0018\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J+\u0010!\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016H\u0016\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000fH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/embrace/android/embracesdk/comms/delivery/EmbraceCacheService;", "Lio/embrace/android/embracesdk/comms/delivery/CacheService;", "context", "Landroid/content/Context;", "serializer", "Lio/embrace/android/embracesdk/EmbraceSerializer;", "logger", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "(Landroid/content/Context;Lio/embrace/android/embracesdk/EmbraceSerializer;Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;)V", "cacheDir", "Lkotlin/Lazy;", "Ljava/io/File;", "cacheBytes", "", "name", "", "bytes", "", "cacheObject", "T", "objectToCache", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "deleteFile", "", "deleteObject", "deleteObjectsByRegex", "regex", "listFilenamesByPrefix", "", "prefix", "loadBytes", "loadObject", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "moveObject", "src", "dst", "Companion", "embrace-android-sdk_release"})
public final class EmbraceCacheService
implements CacheService {
    private final Lazy<File> cacheDir;
    private final InternalEmbraceLogger logger;
    private final EmbraceSerializer serializer;
    private static final String EMBRACE_PREFIX = "emb_";
    private static final String TAG = "EmbraceCacheService";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void cacheBytes(@NotNull String name, @Nullable byte[] bytes) {
        Object file;
        InternalEmbraceLogger className$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String msg$iv = "Attempting to write bytes to " + name;
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)((Object)className$iv) + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        if (bytes != null) {
            InternalEmbraceLogger className$iv2;
            String msg$iv2;
            file = new File((File)this.cacheDir.getValue(), EMBRACE_PREFIX + name);
            try {
                void this_$iv2;
                FilesKt.writeBytes((File)file, (byte[])bytes);
                className$iv = this.logger;
                msg$iv = TAG;
                msg$iv2 = "Bytes cached";
                Throwable throwable$iv2 = null;
                boolean $i$f$logDeveloper2 = false;
                this_$iv2.log('[' + (String)((Object)className$iv2) + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
            }
            catch (Exception ex) {
                void this_$iv3;
                className$iv2 = this.logger;
                msg$iv2 = "Failed to store cache object " + ((File)file).getPath();
                boolean logStacktrace$iv = false;
                boolean $i$f$logWarning = false;
                this_$iv3.log(msg$iv2, EmbraceLogger.Severity.WARNING, ex, logStacktrace$iv);
            }
        } else {
            file = this.logger;
            String msg$iv3 = "No bytes to save to file " + name;
            Throwable throwable$iv3 = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv.log(msg$iv3, EmbraceLogger.Severity.WARNING, throwable$iv3, logStacktrace$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public byte[] loadBytes(@NotNull String name) {
        InternalEmbraceLogger this_$iv;
        String msg$iv;
        void className$iv;
        void this_$iv2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        Object msg$iv2 = "Attempting to read bytes from " + name;
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv2.log('[' + (String)className$iv + "] " + (String)msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        File file = new File((File)this.cacheDir.getValue(), EMBRACE_PREFIX + name);
        try {
            return FilesKt.readBytes((File)file);
        }
        catch (FileNotFoundException ex) {
            msg$iv2 = this.logger;
            msg$iv = "Cache file cannot be found " + file.getPath();
            Throwable throwable$iv2 = null;
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv2, logStacktrace$iv);
        }
        catch (Exception ex) {
            this_$iv = this.logger;
            msg$iv = "Failed to read cache object " + file.getPath();
            boolean logStacktrace$iv = false;
            boolean $i$f$logWarning = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.WARNING, ex, logStacktrace$iv);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <T> void cacheObject(@NotNull String name, T objectToCache, @NotNull Class<T> clazz) {
        Object className$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        Object msg$iv2 = "Attempting to cache object: " + name;
        Throwable throwable$iv222 = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv222, true);
        File file = new File((File)this.cacheDir.getValue(), EMBRACE_PREFIX + name);
        try {
            className$iv = file;
            msg$iv2 = Charsets.UTF_8;
            int throwable$iv222 = 8192;
            $i$f$logDeveloper = false;
            Object object = className$iv;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            object2 = new FileOutputStream((File)object2);
            bl2 = false;
            object = new OutputStreamWriter((OutputStream)object2, (Charset)msg$iv2);
            bl = false;
            className$iv = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, throwable$iv222);
            boolean msg$iv2 = false;
            throwable$iv222 = 0;
            Throwable throwable$iv222 = null;
            try {
                BufferedWriter it22 = (BufferedWriter)className$iv;
                boolean bl3 = false;
                boolean it22 = this.serializer.writeToFile(objectToCache, clazz, it22);
            }
            catch (Throwable it22) {
                throwable$iv222 = it22;
                throw it22;
            }
            finally {
                CloseableKt.closeFinally((Closeable)className$iv, (Throwable)throwable$iv222);
            }
        }
        catch (Exception ex) {
            void this_$iv2;
            msg$iv2 = this.logger;
            String msg$iv3 = "Failed to store cache object " + file.getPath();
            boolean $i$f$logDebug = false;
            this_$iv2.log(msg$iv3, EmbraceLogger.Severity.DEBUG, ex, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T loadObject(@NotNull String name, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        File file = new File((File)this.cacheDir.getValue(), EMBRACE_PREFIX + name);
        try {
            Object object = file;
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileInputStream((File)object3);
            bl3 = false;
            object2 = new InputStreamReader((InputStream)object3, charset);
            bl2 = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            boolean bl4 = false;
            n = 0;
            Throwable throwable = null;
            try {
                BufferedReader bufferedReader = (BufferedReader)object;
                boolean bl5 = false;
                Closeable closeable = (Closeable)new JsonReader((Reader)bufferedReader);
                boolean bl6 = false;
                bl3 = false;
                Throwable throwable2 = null;
                try {
                    void className$iv;
                    void this_$iv;
                    JsonReader jsonreader = (JsonReader)closeable;
                    boolean bl7 = false;
                    jsonreader.setLenient(true);
                    T obj = this.serializer.loadObject(jsonreader, clazz);
                    if (obj != null) {
                        T t = obj;
                        T t2 = t;
                        return t2;
                    }
                    InternalEmbraceLogger internalEmbraceLogger = this.logger;
                    String string2 = TAG;
                    String msg$iv = "Object " + name + " not found";
                    Throwable throwable$iv = null;
                    boolean $i$f$logDeveloper = false;
                    this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                bufferedReader = Unit.INSTANCE;
                return null;
            }
            catch (Throwable bufferedReader) {
                throwable = bufferedReader;
                throw bufferedReader;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (FileNotFoundException ex) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String msg$iv = "Cache file cannot be found " + file.getPath();
            Throwable throwable$iv = null;
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
            return null;
        }
        catch (Exception ex) {
            InternalEmbraceLogger this_$iv = this.logger;
            String msg$iv = "Failed to read cache object " + file.getPath();
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, ex, true);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean deleteFile(@NotNull String name) {
        void className$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        Object msg$iv = "Attempting to delete file from cache: " + name;
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        File file = new File((File)this.cacheDir.getValue(), EMBRACE_PREFIX + name);
        try {
            return file.delete();
        }
        catch (Exception ex) {
            void this_$iv2;
            msg$iv = this.logger;
            String msg$iv2 = "Failed to delete cache object " + file.getPath();
            Throwable throwable$iv2 = null;
            boolean $i$f$logDebug = false;
            this_$iv2.log(msg$iv2, EmbraceLogger.Severity.DEBUG, throwable$iv2, true);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean deleteObject(@NotNull String name) {
        void className$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        Object msg$iv = "Attempting to delete: " + name;
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + (String)msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        File file = new File((File)this.cacheDir.getValue(), EMBRACE_PREFIX + name);
        try {
            return file.delete();
        }
        catch (Exception ex) {
            void this_$iv2;
            msg$iv = this.logger;
            String msg$iv2 = "Failed to delete cache object " + file.getPath();
            Throwable throwable$iv2 = null;
            boolean $i$f$logDebug = false;
            this_$iv2.log(msg$iv2, EmbraceLogger.Severity.DEBUG, throwable$iv2, true);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean deleteObjectsByRegex(@NotNull String regex) {
        Object cache2;
        void className$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        InternalEmbraceLogger internalEmbraceLogger = this.logger;
        String string2 = TAG;
        String msg$iv = "Attempting to delete objects by regex: " + regex;
        Throwable throwable$iv = null;
        int $i$f$logDeveloper3 = 0;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        Pattern pattern = Pattern.compile(regex);
        boolean result2 = false;
        File[] filesInCache = ((File)this.cacheDir.getValue()).listFiles();
        if (filesInCache != null) {
            File[] fileArray = filesInCache;
            int n = fileArray.length;
            for ($i$f$logDeveloper3 = 0; $i$f$logDeveloper3 < n; ++$i$f$logDeveloper3) {
                void className$iv2;
                void this_$iv2;
                String this_$iv3;
                Throwable throwable$iv2;
                String msg$iv2;
                Object object = cache2 = fileArray[$i$f$logDeveloper3];
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cache");
                if (pattern.matcher(((File)object).getName()).find()) {
                    try {
                        result2 = ((File)cache2).delete();
                    }
                    catch (Exception ex) {
                        InternalEmbraceLogger internalEmbraceLogger2 = this.logger;
                        msg$iv2 = "Failed to delete cache object " + ((File)cache2).getPath();
                        throwable$iv2 = null;
                        boolean $i$f$logDebug = false;
                        ((InternalEmbraceLogger)((Object)this_$iv3)).log(msg$iv2, EmbraceLogger.Severity.DEBUG, throwable$iv2, true);
                    }
                    continue;
                }
                InternalEmbraceLogger ex = this.logger;
                this_$iv3 = TAG;
                msg$iv2 = "Objects not found by regex";
                throwable$iv2 = null;
                boolean $i$f$logDeveloper2 = false;
                this_$iv2.log('[' + (String)className$iv2 + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv2, true);
            }
        } else {
            void className$iv3;
            void this_$iv4;
            cache2 = this.logger;
            String $i$f$logDeveloper3 = TAG;
            String msg$iv3 = "There are not files in cache";
            Throwable throwable$iv3 = null;
            boolean $i$f$logDeveloper4 = false;
            this_$iv4.log('[' + (String)className$iv3 + "] " + msg$iv3, EmbraceLogger.Severity.DEVELOPER, throwable$iv3, true);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean moveObject(@NotNull String src, @NotNull String dst) {
        void className$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        File cacheDir2 = (File)this.cacheDir.getValue();
        File srcFile = new File(cacheDir2, EMBRACE_PREFIX + src);
        if (!srcFile.exists()) {
            void className$iv2;
            void this_$iv2;
            InternalEmbraceLogger internalEmbraceLogger = this.logger;
            String string2 = TAG;
            String msg$iv = "Source file doesn't exist: " + src;
            Throwable throwable$iv = null;
            boolean $i$f$logDeveloper = false;
            this_$iv2.log('[' + (String)className$iv2 + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
            return false;
        }
        File dstFile = new File(cacheDir2, EMBRACE_PREFIX + dst);
        InternalEmbraceLogger className$iv2 = this.logger;
        String msg$iv = TAG;
        String msg$iv2 = "Object moved from " + src + " to " + dst;
        Throwable throwable$iv = null;
        boolean $i$f$logDeveloper = false;
        this_$iv.log('[' + (String)className$iv + "] " + msg$iv2, EmbraceLogger.Severity.DEVELOPER, throwable$iv, true);
        return srcFile.renameTo(dstFile);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<String> listFilenamesByPrefix(@NotNull String prefix) {
        List list;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        File cacheDir2 = (File)this.cacheDir.getValue();
        File[] fileArray = cacheDir2.listFiles(new FileFilter(prefix){
            final /* synthetic */ String $prefix;

            public final boolean accept(File file) {
                File file2 = file;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                String string2 = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
                return StringsKt.startsWith$default((String)string2, (String)("emb_" + this.$prefix), (boolean)false, (int)2, null);
            }
            {
                this.$prefix = string2;
            }
        });
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            File[] $this$map$iv = fileArray;
            boolean $i$f$map = false;
            File[] fileArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var8_8 = $this$mapTo$iv$iv;
            int n = ((void)var8_8).length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String string3;
                void file;
                void item$iv$iv;
                void var12_12 = item$iv$iv = var8_8[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = file;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"file");
                Intrinsics.checkNotNullExpressionValue((Object)v1.getName(), (String)"file.name");
                int n2 = EMBRACE_PREFIX.length();
                boolean bl2 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string4.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                collection.add(string2);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    public EmbraceCacheService(final @NotNull Context context2, @NotNull EmbraceSerializer serializer, @NotNull InternalEmbraceLogger logger) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.serializer = serializer;
        this.logger = logger;
        this.cacheDir = LazyKt.lazy((Function0)((Function0)new Function0<File>(){

            public final File invoke() {
                return context2.getCacheDir();
            }
        }));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/embrace/android/embracesdk/comms/delivery/EmbraceCacheService$Companion;", "", "()V", "EMBRACE_PREFIX", "", "TAG", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

