/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.config.local;

import android.util.Base64;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSerializer;
import io.embrace.android.embracesdk.config.local.SdkLocalConfig;
import io.embrace.android.embracesdk.internal.AndroidResourcesService;
import io.embrace.android.embracesdk.internal.ApkToolsConfig;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lio/embrace/android/embracesdk/config/local/LocalConfig;", "", "appId", "", "ndkEnabled", "", "sdkConfig", "Lio/embrace/android/embracesdk/config/local/SdkLocalConfig;", "(Ljava/lang/String;ZLio/embrace/android/embracesdk/config/local/SdkLocalConfig;)V", "getAppId", "()Ljava/lang/String;", "getNdkEnabled", "()Z", "getSdkConfig", "()Lio/embrace/android/embracesdk/config/local/SdkLocalConfig;", "Companion", "embrace-android-sdk_release"})
public final class LocalConfig {
    @NotNull
    private final String appId;
    @SerializedName(value="ndk_enabled")
    private final boolean ndkEnabled;
    @NotNull
    private final SdkLocalConfig sdkConfig;
    @NotNull
    public static final String BUILD_INFO_APP_ID = "emb_app_id";
    private static final String BUILD_INFO_SDK_CONFIG = "emb_sdk_config";
    @NotNull
    public static final String BUILD_INFO_NDK_ENABLED = "emb_ndk_enabled";
    public static final boolean NDK_ENABLED_DEFAULT = false;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getAppId() {
        return this.appId;
    }

    public final boolean getNdkEnabled() {
        return this.ndkEnabled;
    }

    @NotNull
    public final SdkLocalConfig getSdkConfig() {
        return this.sdkConfig;
    }

    public LocalConfig(@NotNull String appId2, boolean ndkEnabled, @NotNull SdkLocalConfig sdkConfig) {
        Intrinsics.checkNotNullParameter((Object)appId2, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)sdkConfig, (String)"sdkConfig");
        this.appId = appId2;
        this.ndkEnabled = ndkEnabled;
        this.sdkConfig = sdkConfig;
    }

    @JvmStatic
    @NotNull
    public static final LocalConfig fromResources(@NotNull AndroidResourcesService resources2, @NotNull String packageName, @Nullable String customAppId, @NotNull EmbraceSerializer serializer) {
        return Companion.fromResources(resources2, packageName, customAppId, serializer);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ*\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/embrace/android/embracesdk/config/local/LocalConfig$Companion;", "", "()V", "BUILD_INFO_APP_ID", "", "BUILD_INFO_NDK_ENABLED", "BUILD_INFO_SDK_CONFIG", "NDK_ENABLED_DEFAULT", "", "buildConfig", "Lio/embrace/android/embracesdk/config/local/LocalConfig;", "appId", "ndkEnabled", "sdkConfigs", "serializer", "Lio/embrace/android/embracesdk/EmbraceSerializer;", "fromResources", "resources", "Lio/embrace/android/embracesdk/internal/AndroidResourcesService;", "packageName", "customAppId", "embrace-android-sdk_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final LocalConfig fromResources(@NotNull AndroidResourcesService resources2, @NotNull String packageName, @Nullable String customAppId, @NotNull EmbraceSerializer serializer) {
            LocalConfig localConfig;
            Intrinsics.checkNotNullParameter((Object)resources2, (String)"resources");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            try {
                String string2;
                String string3 = customAppId;
                if (string3 == null) {
                    string3 = resources2.getString(resources2.getIdentifier(LocalConfig.BUILD_INFO_APP_ID, "string", packageName));
                }
                String appId2 = string3;
                int ndkEnabledJsonId = resources2.getIdentifier(LocalConfig.BUILD_INFO_NDK_ENABLED, "string", packageName);
                boolean ndkEnabled = (ndkEnabledJsonId != 0 ? Boolean.parseBoolean(resources2.getString(ndkEnabledJsonId)) : false) && !ApkToolsConfig.IS_NDK_DISABLED;
                int sdkConfigJsonId = resources2.getIdentifier(LocalConfig.BUILD_INFO_SDK_CONFIG, "string", packageName);
                if (sdkConfigJsonId != 0) {
                    String encodedConfig = resources2.getString(sdkConfigJsonId);
                    byte[] byArray = Base64.decode((String)encodedConfig, (int)0);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.decode(encodedConfig, Base64.DEFAULT)");
                    byte[] byArray2 = byArray;
                    boolean bl = false;
                    string2 = new String(byArray2, Charsets.UTF_8);
                } else {
                    string2 = null;
                }
                String sdkConfigJson = string2;
                localConfig = this.buildConfig(appId2, ndkEnabled, sdkConfigJson, serializer);
            }
            catch (Exception ex) {
                throw (Throwable)new IllegalStateException("Failed to load local config from resources.", ex);
            }
            return localConfig;
        }

        @NotNull
        public final LocalConfig buildConfig(@Nullable String appId2, boolean ndkEnabled, @Nullable String sdkConfigs, @NotNull EmbraceSerializer serializer) {
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            CharSequence charSequence = appId2;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = !(charSequence == null || charSequence.length() == 0);
            bl = false;
            bl2 = false;
            if (!bl3) {
                boolean bl4 = false;
                String string2 = "Embrace AppId cannot be null or empty.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            String enabledStr = ndkEnabled ? "enabled" : "disabled";
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            CharSequence msg$iv = "Native crash capture is " + enabledStr;
            boolean $i$f$logInfo = false;
            companion.log((String)msg$iv, EmbraceLogger.Severity.INFO, null, true);
            SdkLocalConfig configs = null;
            msg$iv = sdkConfigs;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!(msg$iv == null || msg$iv.length() == 0)) {
                try {
                    configs = serializer.fromJson(sdkConfigs, SdkLocalConfig.class);
                }
                catch (Exception ex) {
                    InternalStaticEmbraceLogger.Companion companion2 = InternalStaticEmbraceLogger.Companion;
                    String msg$iv2 = "Failed to parse Embrace config from config json file.";
                    boolean logStacktrace$iv = false;
                    boolean $i$f$logError = false;
                    companion2.log(msg$iv2, EmbraceLogger.Severity.ERROR, ex, logStacktrace$iv);
                }
            }
            if (configs == null) {
                configs = new SdkLocalConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 524287, null);
            }
            return new LocalConfig(appId2, ndkEnabled, configs);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

