/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.gating;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.SessionMessage;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.gating.EventSanitizerFacade;
import io.embrace.android.embracesdk.gating.GatingService;
import io.embrace.android.embracesdk.gating.SessionSanitizerFacade;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/embrace/android/embracesdk/gating/EmbraceGatingService;", "Lio/embrace/android/embracesdk/gating/GatingService;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "(Lio/embrace/android/embracesdk/config/ConfigService;)V", "gateEventMessage", "Lio/embrace/android/embracesdk/EventMessage;", "eventMessage", "gateSessionMessage", "Lio/embrace/android/embracesdk/SessionMessage;", "sessionMessage", "embrace-android-sdk_release"})
public final class EmbraceGatingService
implements GatingService {
    private final ConfigService configService;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SessionMessage gateSessionMessage(@NotNull SessionMessage sessionMessage2) {
        Intrinsics.checkNotNullParameter((Object)sessionMessage2, (String)"sessionMessage");
        Set<String> components = this.configService.getSessionBehavior().getSessionComponents();
        if (components != null && this.configService.getSessionBehavior().isGatingFeatureEnabled()) {
            String msg$iv;
            boolean $i$f$logDeveloper;
            void this_$iv;
            Object object = InternalStaticEmbraceLogger.Companion;
            String msg$iv222 = "Session gating feature enabled. Attempting to sanitize the session message";
            Object throwable$iv = null;
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv222, EmbraceLogger.Severity.DEBUG, (Throwable)throwable$iv, true);
            List<String> list = sessionMessage2.getSession().getErrorLogIds();
            if (list != null) {
                object = list;
                boolean msg$iv222 = false;
                if (!object.isEmpty()) {
                    if (this.configService.getSessionBehavior().shouldSendFullForErrorLog()) {
                        void className$iv;
                        object = InternalStaticEmbraceLogger.Companion;
                        String msg$iv222 = "EmbraceGatingService";
                        throwable$iv = "Error logs detected - Sending full session payload";
                        $i$f$logDeveloper = false;
                        ((InternalStaticEmbraceLogger.Companion)object).log('[' + (String)className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                        return sessionMessage2;
                    }
                }
            }
            if (sessionMessage2.getSession().getCrashReportId() != null) {
                object = InternalStaticEmbraceLogger.Companion;
                String className$iv = "EmbraceGatingService";
                msg$iv = "Crash detected - Sending full session payload";
                $i$f$logDeveloper = false;
                ((InternalStaticEmbraceLogger.Companion)object).log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
                return sessionMessage2;
            }
            return new SessionSanitizerFacade(sessionMessage2, components).getSanitizedMessage();
        }
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String className$iv = "EmbraceGatingService";
        String msg$iv = "Gating feature disabled";
        boolean $i$f$logDeveloper = false;
        companion.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        return sessionMessage2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EventMessage gateEventMessage(@NotNull EventMessage eventMessage) {
        Intrinsics.checkNotNullParameter((Object)eventMessage, (String)"eventMessage");
        Set<String> components = this.configService.getSessionBehavior().getSessionComponents();
        if (components != null && this.configService.getSessionBehavior().isGatingFeatureEnabled()) {
            void this_$iv;
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "Session gating feature enabled. Attempting to sanitize the event message";
            Object throwable$iv = null;
            boolean $i$f$logDebug = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.DEBUG, (Throwable)throwable$iv, true);
            if (this.configService.getSessionBehavior().shouldSendFullMessage(eventMessage)) {
                void msg$iv2;
                void className$iv;
                companion = InternalStaticEmbraceLogger.Companion;
                msg$iv = "EmbraceGatingService";
                throwable$iv = "Crash or error detected - Sending full session payload";
                boolean $i$f$logDeveloper = false;
                companion.log('[' + (String)className$iv + "] " + (String)msg$iv2, EmbraceLogger.Severity.DEVELOPER, null, true);
                return eventMessage;
            }
            return new EventSanitizerFacade(eventMessage, components).getSanitizedMessage();
        }
        InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
        String className$iv = "EmbraceGatingService";
        String msg$iv = "Gating feature disabled";
        boolean $i$f$logDeveloper = false;
        companion.log('[' + className$iv + "] " + msg$iv, EmbraceLogger.Severity.DEVELOPER, null, true);
        return eventMessage;
    }

    public EmbraceGatingService(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        this.configService = configService2;
    }
}

