/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.spans;

import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.config.ConfigListener;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.spans.BufferedRecordCompletedSpan;
import io.embrace.android.embracesdk.internal.spans.EmbraceAttributes;
import io.embrace.android.embracesdk.internal.spans.EmbraceSpan;
import io.embrace.android.embracesdk.internal.spans.EmbraceSpanData;
import io.embrace.android.embracesdk.internal.spans.ErrorCode;
import io.embrace.android.embracesdk.internal.spans.Initializable;
import io.embrace.android.embracesdk.internal.spans.SpansService;
import io.embrace.android.embracesdk.internal.spans.SpansServiceImpl;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000eH\u0016J\b\u0010\u000b\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001fH\u0002JT\u0010'\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00132\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J1\u00100\u001a\u0002H1\"\u0004\b\u0000\u001012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H103H\u0016\u00a2\u0006\u0002\u00104J\u0016\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u0013H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lio/embrace/android/embracesdk/internal/spans/EmbraceSpansService;", "Lio/embrace/android/embracesdk/internal/spans/Initializable;", "Lio/embrace/android/embracesdk/internal/spans/SpansService;", "Lio/embrace/android/embracesdk/config/ConfigListener;", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "(Lio/embrace/android/embracesdk/clock/Clock;)V", "bufferedCalls", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lio/embrace/android/embracesdk/internal/spans/BufferedRecordCompletedSpan;", "currentDelegate", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "sdkInitEndTime", "", "Ljava/lang/Long;", "sdkInitStartTime", "spansEnabled", "completedSpans", "", "Lio/embrace/android/embracesdk/internal/spans/EmbraceSpanData;", "createSpan", "Lio/embrace/android/embracesdk/internal/spans/EmbraceSpan;", "name", "", "type", "Lio/embrace/android/embracesdk/internal/spans/EmbraceAttributes$Type;", "flushSpans", "appTerminationCause", "Lio/embrace/android/embracesdk/internal/spans/EmbraceAttributes$AppTerminationCause;", "initializeService", "", "sdkInitStartTimeNanos", "sdkInitEndTimeNanos", "", "onConfigChange", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "recordBufferedCalls", "recordCompletedSpan", "startTimeNanos", "endTimeNanos", "attributes", "", "events", "Lio/opentelemetry/sdk/trace/data/EventData;", "errorCode", "Lio/embrace/android/embracesdk/internal/spans/ErrorCode;", "recordSpan", "T", "code", "Lkotlin/Function0;", "(Ljava/lang/String;Lio/embrace/android/embracesdk/internal/spans/EmbraceAttributes$Type;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "storeCompletedSpans", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "spans", "Lio/opentelemetry/sdk/trace/data/SpanData;", "embrace-android-sdk_release"})
public final class EmbraceSpansService
implements Initializable,
SpansService,
ConfigListener {
    private final AtomicBoolean initialized;
    private final AtomicBoolean spansEnabled;
    private final ConcurrentLinkedQueue<BufferedRecordCompletedSpan> bufferedCalls;
    private volatile Long sdkInitStartTime;
    private volatile Long sdkInitEndTime;
    private volatile SpansService currentDelegate;
    private final Clock clock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeService(long sdkInitStartTimeNanos, long sdkInitEndTimeNanos) {
        if (!this.initialized.get()) {
            this.sdkInitStartTime = sdkInitStartTimeNanos;
            this.sdkInitEndTime = sdkInitEndTimeNanos;
            AtomicBoolean atomicBoolean = this.spansEnabled;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (atomicBoolean) {
                boolean bl3 = false;
                if (!this.initialized.get() && this.spansEnabled.get()) {
                    this.currentDelegate = new SpansServiceImpl(sdkInitStartTimeNanos, sdkInitEndTimeNanos, this.clock);
                    this.initialized.set(true);
                    this.recordBufferedCalls();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Override
    public boolean initialized() {
        return this.initialized.get();
    }

    @Override
    @Nullable
    public EmbraceSpan createSpan(@NotNull String name, @NotNull EmbraceAttributes.Type type2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return this.currentDelegate.createSpan(name, type2);
    }

    @Override
    public <T> T recordSpan(@NotNull String name, @NotNull EmbraceAttributes.Type type2, @NotNull Function0<? extends T> code) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        return this.currentDelegate.recordSpan(name, type2, code);
    }

    @Override
    public boolean recordCompletedSpan(@NotNull String name, long startTimeNanos, long endTimeNanos, @NotNull EmbraceAttributes.Type type2, @NotNull Map<String, String> attributes, @NotNull List<? extends EventData> events, @Nullable ErrorCode errorCode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (!this.initialized()) {
            this.bufferedCalls.add(new BufferedRecordCompletedSpan(name, startTimeNanos, endTimeNanos, type2, attributes, events, errorCode));
            this.recordBufferedCalls();
            bl = true;
        } else {
            bl = this.currentDelegate.recordCompletedSpan(name, startTimeNanos, endTimeNanos, type2, attributes, events, errorCode);
        }
        return bl;
    }

    @Override
    @NotNull
    public CompletableResultCode storeCompletedSpans(@NotNull List<? extends SpanData> spans2) {
        Intrinsics.checkNotNullParameter(spans2, (String)"spans");
        return this.currentDelegate.storeCompletedSpans(spans2);
    }

    @Override
    @Nullable
    public List<EmbraceSpanData> completedSpans() {
        return this.currentDelegate.completedSpans();
    }

    @Override
    @Nullable
    public List<EmbraceSpanData> flushSpans(@Nullable EmbraceAttributes.AppTerminationCause appTerminationCause) {
        return this.currentDelegate.flushSpans(appTerminationCause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConfigChange(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        if (!this.initialized.get() && configService2.getSpansBehavior().isSpansEnabled()) {
            AtomicBoolean atomicBoolean = this.spansEnabled;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (atomicBoolean) {
                boolean bl3 = false;
                this.spansEnabled.set(true);
                if (!this.initialized.get()) {
                    Long startTime = this.sdkInitStartTime;
                    Long endTime = this.sdkInitEndTime;
                    if (startTime != null && endTime != null) {
                        this.initializeService(startTime, endTime);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recordBufferedCalls() {
        if (this.initialized()) {
            ConcurrentLinkedQueue<BufferedRecordCompletedSpan> concurrentLinkedQueue = this.bufferedCalls;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (concurrentLinkedQueue) {
                Object object;
                boolean bl3 = false;
                do {
                    boolean bl4;
                    BufferedRecordCompletedSpan bufferedRecordCompletedSpan = this.bufferedCalls.poll();
                    if (bufferedRecordCompletedSpan != null) {
                        object = bufferedRecordCompletedSpan;
                        bl4 = false;
                        boolean bl5 = false;
                        Object it = object;
                        boolean bl6 = false;
                        this.currentDelegate.recordCompletedSpan(((BufferedRecordCompletedSpan)it).getName(), ((BufferedRecordCompletedSpan)it).getStartTimeNanos(), ((BufferedRecordCompletedSpan)it).getEndTimeNanos(), ((BufferedRecordCompletedSpan)it).getType(), ((BufferedRecordCompletedSpan)it).getAttributes(), ((BufferedRecordCompletedSpan)it).getEvents(), ((BufferedRecordCompletedSpan)it).getErrorCode());
                    }
                    object = this.bufferedCalls;
                    bl4 = false;
                } while (!object.isEmpty());
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public EmbraceSpansService(@NotNull Clock clock2) {
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        this.clock = clock2;
        this.initialized = new AtomicBoolean(false);
        this.spansEnabled = new AtomicBoolean(false);
        this.bufferedCalls = new ConcurrentLinkedQueue();
        this.currentDelegate = SpansService.Companion.getFeatureDisabledSpansService();
    }
}

