/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.spans;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.clock.Clock;
import io.embrace.android.embracesdk.internal.Systrace;
import io.embrace.android.embracesdk.internal.spans.EmbraceAttributes;
import io.embrace.android.embracesdk.internal.spans.EmbraceExtensionsKt;
import io.embrace.android.embracesdk.internal.spans.EmbraceSpan;
import io.embrace.android.embracesdk.internal.spans.EmbraceSpanData;
import io.embrace.android.embracesdk.internal.spans.EmbraceSpanExporter;
import io.embrace.android.embracesdk.internal.spans.EmbraceSpanImpl;
import io.embrace.android.embracesdk.internal.spans.EmbraceSpanProcessor;
import io.embrace.android.embracesdk.internal.spans.ErrorCode;
import io.embrace.android.embracesdk.internal.spans.SpansService;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0003H\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0!2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016JT\u00100\u001a\u0002012\u0006\u0010$\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%042\f\u00105\u001a\b\u0012\u0004\u0012\u0002060!2\b\u00107\u001a\u0004\u0018\u000108H\u0016J1\u00109\u001a\u0002H:\"\u0004\b\u0000\u0010:2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H:0<H\u0016\u00a2\u0006\u0002\u0010=J\u0016\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0!H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0012\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0012\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0012\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006B"}, d2={"Lio/embrace/android/embracesdk/internal/spans/SpansServiceImpl;", "Lio/embrace/android/embracesdk/internal/spans/SpansService;", "sdkInitStartTimeNanos", "", "sdkInitEndTimeNanos", "clock", "Lio/embrace/android/embracesdk/clock/Clock;", "(JJLio/embrace/android/embracesdk/clock/Clock;)V", "completedSpans", "", "Lio/embrace/android/embracesdk/internal/spans/EmbraceSpanData;", "currentSessionSpan", "Lio/opentelemetry/api/trace/Span;", "openTelemetry", "Lio/opentelemetry/api/OpenTelemetry;", "getOpenTelemetry", "()Lio/opentelemetry/api/OpenTelemetry;", "openTelemetry$delegate", "Lkotlin/Lazy;", "processRootSpan", "getProcessRootSpan", "()Lio/opentelemetry/api/trace/Span;", "processRootSpan$delegate", "sdkTracerProvider", "Lio/opentelemetry/sdk/trace/SdkTracerProvider;", "getSdkTracerProvider", "()Lio/opentelemetry/sdk/trace/SdkTracerProvider;", "sdkTracerProvider$delegate", "tracer", "Lio/opentelemetry/api/trace/Tracer;", "getTracer", "()Lio/opentelemetry/api/trace/Tracer;", "tracer$delegate", "", "createEmbraceSpanBuilder", "Lio/opentelemetry/api/trace/SpanBuilder;", "name", "", "type", "Lio/embrace/android/embracesdk/internal/spans/EmbraceAttributes$Type;", "createKeySpan", "createSessionSpan", "startTimeNanos", "createSpan", "Lio/embrace/android/embracesdk/internal/spans/EmbraceSpan;", "flushSpans", "appTerminationCause", "Lio/embrace/android/embracesdk/internal/spans/EmbraceAttributes$AppTerminationCause;", "recordCompletedSpan", "", "endTimeNanos", "attributes", "", "events", "Lio/opentelemetry/sdk/trace/data/EventData;", "errorCode", "Lio/embrace/android/embracesdk/internal/spans/ErrorCode;", "recordSpan", "T", "code", "Lkotlin/Function0;", "(Ljava/lang/String;Lio/embrace/android/embracesdk/internal/spans/EmbraceAttributes$Type;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "storeCompletedSpans", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "spans", "Lio/opentelemetry/sdk/trace/data/SpanData;", "embrace-android-sdk_release"})
public final class SpansServiceImpl
implements SpansService {
    private final Lazy sdkTracerProvider$delegate;
    private final Lazy openTelemetry$delegate;
    private final Lazy tracer$delegate;
    private final Lazy processRootSpan$delegate;
    private Span currentSessionSpan;
    private final List<EmbraceSpanData> completedSpans;
    private final Clock clock;

    private final SdkTracerProvider getSdkTracerProvider() {
        Lazy lazy = this.sdkTracerProvider$delegate;
        SpansServiceImpl spansServiceImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SdkTracerProvider)lazy.getValue();
    }

    private final OpenTelemetry getOpenTelemetry() {
        Lazy lazy = this.openTelemetry$delegate;
        SpansServiceImpl spansServiceImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (OpenTelemetry)lazy.getValue();
    }

    private final Tracer getTracer() {
        Lazy lazy = this.tracer$delegate;
        SpansServiceImpl spansServiceImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Tracer)lazy.getValue();
    }

    private final Span getProcessRootSpan() {
        Lazy lazy = this.processRootSpan$delegate;
        SpansServiceImpl spansServiceImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Span)lazy.getValue();
    }

    @Override
    @Nullable
    public EmbraceSpan createSpan(@NotNull String name, @NotNull EmbraceAttributes.Type type2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return this.currentSessionSpan.isRecording() ? (EmbraceSpan)new EmbraceSpanImpl(this.createKeySpan(name, type2)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordSpan(@NotNull String name, @NotNull EmbraceAttributes.Type type2, @NotNull Function0<? extends T> code) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        if (this.currentSessionSpan.isRecording()) {
            T this_$iv;
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "Logging span '" + name + '\'';
            Throwable throwable$iv = null;
            boolean $i$f$logDebug = false;
            ((InternalStaticEmbraceLogger.Companion)this_$iv).log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
            Systrace.Companion.start("log-span-" + name);
            try {
                this_$iv = EmbraceExtensionsKt.record(this.createKeySpan(name, type2), code);
            }
            finally {
                Systrace.Companion.end();
            }
            object = this_$iv;
        } else {
            InternalStaticEmbraceLogger.Companion this_$iv = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "Logging span '" + name + "' failed: service not in a state to log. Lambda will still run.";
            Throwable throwable$iv = null;
            boolean $i$f$logWarning = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv, true);
            object = code.invoke();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean recordCompletedSpan(@NotNull String name, long startTimeNanos, long endTimeNanos, @NotNull EmbraceAttributes.Type type2, @NotNull Map<String, String> attributes, @NotNull List<? extends EventData> events, @Nullable ErrorCode errorCode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (startTimeNanos > endTimeNanos) {
            void msg$iv;
            void this_$iv;
            InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
            String string2 = "Logging completed span '" + name + "' failed: start time is after end time";
            Throwable throwable$iv = null;
            boolean $i$f$logWarning = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv, true);
            return false;
        }
        if (this.currentSessionSpan.isRecording()) {
            Object this_$iv = InternalStaticEmbraceLogger.Companion;
            String msg$iv = "Logging completed span '" + name + '\'';
            Throwable throwable$iv = null;
            boolean $i$f$logDebug = false;
            ((InternalStaticEmbraceLogger.Companion)this_$iv).log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
            this_$iv = Systrace.Companion;
            String sectionName$iv = "log-completed-span-" + name;
            boolean $i$f$trace = false;
            Span returnValue$iv = null;
            try {
                ((Systrace.Companion)this_$iv).start(sectionName$iv);
                boolean bl2 = false;
                Span span = this.createKeySpan(name, type2).setStartTimestamp(startTimeNanos, TimeUnit.NANOSECONDS).startSpan();
                Object $this$forEach$iv = attributes;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv;
                boolean bl3 = false;
                Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> it = element$iv = iterator.next();
                    boolean bl4 = false;
                    span.setAttribute(it.getKey(), it.getValue());
                }
                $this$forEach$iv = events;
                $i$f$forEach = false;
                object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    EventData it = (EventData)element$iv;
                    boolean bl5 = false;
                    span.addEvent(it.getName(), it.getAttributes(), it.getEpochNanos(), TimeUnit.NANOSECONDS);
                }
                Span span2 = span;
                Intrinsics.checkNotNullExpressionValue((Object)span2, (String)"span");
                returnValue$iv = EmbraceExtensionsKt.endSpan(span2, errorCode, endTimeNanos);
            }
            catch (Throwable t$iv) {
                throw t$iv;
            }
            finally {
                ((Systrace.Companion)this_$iv).end();
            }
            bl = true;
        } else {
            void msg$iv;
            InternalStaticEmbraceLogger.Companion this_$iv = InternalStaticEmbraceLogger.Companion;
            String sectionName$iv = "Logging completed span '" + name + "' failed: service not in a state to log";
            Throwable throwable$iv = null;
            boolean $i$f$logWarning = false;
            this_$iv.log((String)msg$iv, EmbraceLogger.Severity.WARNING, throwable$iv, true);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableResultCode storeCompletedSpans(@NotNull List<? extends SpanData> spans2) {
        Intrinsics.checkNotNullParameter(spans2, (String)"spans");
        try {
            List<EmbraceSpanData> list = this.completedSpans;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (list) {
                void $this$mapTo$iv$iv;
                boolean bl3 = false;
                Collection collection = this.completedSpans;
                Iterable $this$map$iv = spans2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SpanData spanData = (SpanData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl4 = false;
                    EmbraceSpanData embraceSpanData = new EmbraceSpanData((SpanData)it);
                    collection2.add(embraceSpanData);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                boolean bl5 = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Throwable t) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
            Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"CompletableResultCode.ofFailure()");
            return completableResultCode;
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"CompletableResultCode.ofSuccess()");
        return completableResultCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<EmbraceSpanData> completedSpans() {
        List<EmbraceSpanData> list = this.completedSpans;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            List list2 = CollectionsKt.toList((Iterable)this.completedSpans);
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<EmbraceSpanData> flushSpans(@Nullable EmbraceAttributes.AppTerminationCause appTerminationCause) {
        List<EmbraceSpanData> list = this.completedSpans;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            EmbraceExtensionsKt.endSpan$default(this.currentSessionSpan, null, null, 3, null);
            if (appTerminationCause == null) {
                this.currentSessionSpan = this.createSessionSpan(TimeUnit.MILLISECONDS.toNanos(this.clock.now()));
            } else {
                this.getProcessRootSpan().setAttribute(appTerminationCause.keyName(), appTerminationCause.name());
                EmbraceExtensionsKt.endSpan$default(this.getProcessRootSpan(), null, null, 3, null);
            }
            List flushedSpans = CollectionsKt.toList((Iterable)this.completedSpans);
            this.completedSpans.clear();
            List list2 = flushedSpans;
            return list2;
        }
    }

    private final Span createSessionSpan(long startTimeNanos) {
        Span span = this.createEmbraceSpanBuilder("session-span", EmbraceAttributes.Type.SESSION).setParent(Context.current().with((ImplicitContextKeyed)this.getProcessRootSpan())).setStartTimestamp(startTimeNanos, TimeUnit.NANOSECONDS).startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"createEmbraceSpanBuilder\u2026\n            .startSpan()");
        return span;
    }

    private final SpanBuilder createKeySpan(String name, EmbraceAttributes.Type type2) {
        SpanBuilder spanBuilder = this.createEmbraceSpanBuilder(name, type2).setParent(Context.current().with((ImplicitContextKeyed)this.currentSessionSpan));
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"createEmbraceSpanBuilder\u2026with(currentSessionSpan))");
        return EmbraceExtensionsKt.makeKey(spanBuilder);
    }

    private final SpanBuilder createEmbraceSpanBuilder(String name, EmbraceAttributes.Type type2) {
        SpanBuilder spanBuilder;
        SpanBuilder spanBuilder2 = spanBuilder = type2.getInternal() ? EmbraceExtensionsKt.embraceSpanBuilder(this.getTracer(), name) : this.getTracer().spanBuilder(name);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder2, (String)"spanBuilder");
        return EmbraceExtensionsKt.setType(spanBuilder2, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public SpansServiceImpl(long sdkInitStartTimeNanos, long sdkInitEndTimeNanos, @NotNull Clock clock2) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        this.clock = clock2;
        this.sdkTracerProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SdkTracerProvider>(this){
            final /* synthetic */ SpansServiceImpl this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final SdkTracerProvider invoke() {
                void this_$iv;
                Systrace.Companion.start("spans-service-init");
                Systrace.Companion companion = Systrace.Companion;
                String sectionName$iv = "init-sdk-tracer-provider";
                boolean $i$f$trace = false;
                SdkTracerProvider returnValue$iv = null;
                try {
                    this_$iv.start(sectionName$iv);
                    boolean bl = false;
                    returnValue$iv = SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)new EmbraceSpanProcessor(new EmbraceSpanExporter(this.this$0))).build();
                }
                catch (Throwable t$iv) {
                    throw t$iv;
                }
                finally {
                    this_$iv.end();
                }
                return returnValue$iv;
            }
            {
                this.this$0 = spansServiceImpl;
                super(0);
            }
        }));
        this.openTelemetry$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OpenTelemetrySdk>(this){
            final /* synthetic */ SpansServiceImpl this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final OpenTelemetrySdk invoke() {
                void this_$iv;
                Systrace.Companion companion = Systrace.Companion;
                String sectionName$iv = "init-otel-sdk";
                boolean $i$f$trace = false;
                OpenTelemetrySdk returnValue$iv = null;
                try {
                    this_$iv.start(sectionName$iv);
                    boolean bl = false;
                    returnValue$iv = OpenTelemetrySdk.builder().setTracerProvider(SpansServiceImpl.access$getSdkTracerProvider$p(this.this$0)).build();
                }
                catch (Throwable t$iv) {
                    throw t$iv;
                }
                finally {
                    this_$iv.end();
                }
                return returnValue$iv;
            }
            {
                this.this$0 = spansServiceImpl;
                super(0);
            }
        }));
        this.tracer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Tracer>(this){
            final /* synthetic */ SpansServiceImpl this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final Tracer invoke() {
                void this_$iv;
                Systrace.Companion companion = Systrace.Companion;
                String sectionName$iv = "init-tracer";
                boolean $i$f$trace = false;
                Tracer returnValue$iv = null;
                try {
                    this_$iv.start(sectionName$iv);
                    boolean bl = false;
                    returnValue$iv = SpansServiceImpl.access$getOpenTelemetry$p(this.this$0).getTracer("embrace-sdk", "0.0.1");
                }
                catch (Throwable t$iv) {
                    throw t$iv;
                }
                finally {
                    this_$iv.end();
                }
                return returnValue$iv;
            }
            {
                this.this$0 = spansServiceImpl;
                super(0);
            }
        }));
        this.processRootSpan$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Span>(this, sdkInitStartTimeNanos){
            final /* synthetic */ SpansServiceImpl this$0;
            final /* synthetic */ long $sdkInitStartTimeNanos;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final Span invoke() {
                void this_$iv;
                Systrace.Companion companion = Systrace.Companion;
                String sectionName$iv = "first-span-start";
                boolean $i$f$trace = false;
                Span returnValue$iv = null;
                try {
                    this_$iv.start(sectionName$iv);
                    boolean bl = false;
                    returnValue$iv = SpansServiceImpl.access$createEmbraceSpanBuilder(this.this$0, "process-root-span", EmbraceAttributes.Type.PROCESS).setNoParent().setStartTimestamp(this.$sdkInitStartTimeNanos, TimeUnit.NANOSECONDS).startSpan();
                }
                catch (Throwable t$iv) {
                    throw t$iv;
                }
                finally {
                    this_$iv.end();
                }
                return returnValue$iv;
            }
            {
                this.this$0 = spansServiceImpl;
                this.$sdkInitStartTimeNanos = l;
                super(0);
            }
        }));
        this.currentSessionSpan = this.createSessionSpan(sdkInitStartTimeNanos);
        boolean bl = false;
        this.completedSpans = new ArrayList();
        Systrace.Companion companion = Systrace.Companion;
        String sectionName$iv = "log-sdk-init";
        boolean $i$f$trace = false;
        Boolean returnValue$iv = null;
        try {
            this_$iv.start(sectionName$iv);
            boolean bl2 = false;
            EventData eventData = EventData.create((long)sdkInitStartTimeNanos, (String)"start-time", (Attributes)Attributes.empty());
            Intrinsics.checkNotNullExpressionValue((Object)eventData, (String)"EventData.create(sdkInit\u2026ime\", Attributes.empty())");
            returnValue$iv = SpansService.DefaultImpls.recordCompletedSpan$default(this, "sdk-init", sdkInitStartTimeNanos, sdkInitEndTimeNanos, EmbraceAttributes.Type.SDK_STARTUP, null, CollectionsKt.listOf((Object)eventData), null, 80, null);
        }
        catch (Throwable t$iv) {
            throw t$iv;
        }
        finally {
            this_$iv.end();
        }
        Systrace.Companion.end();
    }

    public static final /* synthetic */ SdkTracerProvider access$getSdkTracerProvider$p(SpansServiceImpl $this) {
        return $this.getSdkTracerProvider();
    }

    public static final /* synthetic */ OpenTelemetry access$getOpenTelemetry$p(SpansServiceImpl $this) {
        return $this.getOpenTelemetry();
    }

    public static final /* synthetic */ SpanBuilder access$createEmbraceSpanBuilder(SpansServiceImpl $this, String name, EmbraceAttributes.Type type2) {
        return $this.createEmbraceSpanBuilder(name, type2);
    }
}

