/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.logging;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.InternalErrorLogger;
import io.embrace.android.embracesdk.internal.ApkToolsConfig;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0086\bJ(\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0087\bJ%\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0087\bJ'\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0087\bJ\u0011\u0010\u0017\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0086\bJ'\u0010\u0018\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0086\bJ\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rJ'\u0010\u001a\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0087\bJ'\u0010\u001b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0086\bJ\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger;", "", "()V", "loggerActions", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger$LoggerAction;", "threshold", "Lio/embrace/android/embracesdk/EmbraceLogger$Severity;", "addLoggerAction", "", "action", "log", "msg", "", "severity", "throwable", "", "logStacktrace", "", "logDebug", "logDeveloper", "className", "logError", "logInfo", "logInfoWithException", "logSDKNotInitialized", "logWarning", "logWarningWithException", "setThreshold", "shouldTriggerLoggerActions", "LoggerAction", "embrace-android-sdk_release"})
public final class InternalEmbraceLogger {
    private final CopyOnWriteArrayList<LoggerAction> loggerActions = new CopyOnWriteArrayList();
    private EmbraceLogger.Severity threshold = EmbraceLogger.Severity.INFO;

    public final void addLoggerAction(@NotNull LoggerAction action) {
        int $i$f$addLoggerAction = 0;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.loggerActions.add(action);
    }

    @JvmOverloads
    public final void logDeveloper(@NotNull String className, @NotNull String msg, @Nullable Throwable throwable) {
        int $i$f$logDeveloper = 0;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log('[' + className + "] " + msg, EmbraceLogger.Severity.DEVELOPER, throwable, true);
    }

    public static /* synthetic */ void logDeveloper$default(InternalEmbraceLogger this_, String className, String msg, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        boolean $i$f$logDeveloper = false;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this_.log('[' + className + "] " + msg, EmbraceLogger.Severity.DEVELOPER, throwable, true);
    }

    @JvmOverloads
    public final void logDeveloper(@NotNull String className, @NotNull String msg) {
        InternalEmbraceLogger.logDeveloper$default(this, className, msg, null, 4, null);
    }

    @JvmOverloads
    public final void logDebug(@NotNull String msg, @Nullable Throwable throwable) {
        int $i$f$logDebug = 0;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log(msg, EmbraceLogger.Severity.DEBUG, throwable, true);
    }

    public static /* synthetic */ void logDebug$default(InternalEmbraceLogger this_, String msg, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        boolean $i$f$logDebug = false;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this_.log(msg, EmbraceLogger.Severity.DEBUG, throwable, true);
    }

    @JvmOverloads
    public final void logDebug(@NotNull String msg) {
        InternalEmbraceLogger.logDebug$default(this, msg, null, 2, null);
    }

    public final void logInfo(@NotNull String msg) {
        int $i$f$logInfo = 0;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log(msg, EmbraceLogger.Severity.INFO, null, true);
    }

    @JvmOverloads
    public final void logWarning(@NotNull String msg, @Nullable Throwable throwable, boolean logStacktrace) {
        int $i$f$logWarning = 0;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log(msg, EmbraceLogger.Severity.WARNING, throwable, logStacktrace);
    }

    public static /* synthetic */ void logWarning$default(InternalEmbraceLogger this_, String msg, Throwable throwable, boolean logStacktrace, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            logStacktrace = false;
        }
        boolean $i$f$logWarning = false;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this_.log(msg, EmbraceLogger.Severity.WARNING, throwable, logStacktrace);
    }

    @JvmOverloads
    public final void logWarning(@NotNull String msg, @Nullable Throwable throwable) {
        InternalEmbraceLogger.logWarning$default(this, msg, throwable, false, 4, null);
    }

    @JvmOverloads
    public final void logWarning(@NotNull String msg) {
        InternalEmbraceLogger.logWarning$default(this, msg, null, false, 6, null);
    }

    @JvmOverloads
    public final void logError(@NotNull String msg, @Nullable Throwable throwable, boolean logStacktrace) {
        int $i$f$logError = 0;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log(msg, EmbraceLogger.Severity.ERROR, throwable, logStacktrace);
    }

    public static /* synthetic */ void logError$default(InternalEmbraceLogger this_, String msg, Throwable throwable, boolean logStacktrace, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            logStacktrace = false;
        }
        boolean $i$f$logError = false;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this_.log(msg, EmbraceLogger.Severity.ERROR, throwable, logStacktrace);
    }

    @JvmOverloads
    public final void logError(@NotNull String msg, @Nullable Throwable throwable) {
        InternalEmbraceLogger.logError$default(this, msg, throwable, false, 4, null);
    }

    @JvmOverloads
    public final void logError(@NotNull String msg) {
        InternalEmbraceLogger.logError$default(this, msg, null, false, 6, null);
    }

    public final void logInfoWithException(@NotNull String msg, @Nullable Throwable throwable, boolean logStacktrace) {
        int $i$f$logInfoWithException = 0;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            throwable2 = new InternalErrorLogger.NotAnException(msg);
        }
        this.log(msg, EmbraceLogger.Severity.INFO, throwable2, logStacktrace);
    }

    public static /* synthetic */ void logInfoWithException$default(InternalEmbraceLogger this_, String msg, Throwable throwable, boolean logStacktrace, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            logStacktrace = false;
        }
        boolean $i$f$logInfoWithException = false;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            throwable2 = new InternalErrorLogger.NotAnException(msg);
        }
        this_.log(msg, EmbraceLogger.Severity.INFO, throwable2, logStacktrace);
    }

    public final void logWarningWithException(@NotNull String msg, @Nullable Throwable throwable, boolean logStacktrace) {
        int $i$f$logWarningWithException = 0;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            throwable2 = new InternalErrorLogger.NotAnException(msg);
        }
        this.log(msg, EmbraceLogger.Severity.WARNING, throwable2, logStacktrace);
    }

    public static /* synthetic */ void logWarningWithException$default(InternalEmbraceLogger this_, String msg, Throwable throwable, boolean logStacktrace, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            logStacktrace = false;
        }
        boolean $i$f$logWarningWithException = false;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            throwable2 = new InternalErrorLogger.NotAnException(msg);
        }
        this_.log(msg, EmbraceLogger.Severity.WARNING, throwable2, logStacktrace);
    }

    public final void logSDKNotInitialized(@NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        String msg = "Embrace SDK is not initialized yet, cannot " + action + '.';
        this.log(msg, EmbraceLogger.Severity.ERROR, new Throwable(msg), true);
    }

    public final void log(@NotNull String msg, @NotNull EmbraceLogger.Severity severity, @Nullable Throwable throwable, boolean logStacktrace) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        if (this.shouldTriggerLoggerActions(severity)) {
            Iterable $this$forEach$iv = this.loggerActions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LoggerAction it = (LoggerAction)element$iv;
                boolean bl = false;
                it.log(msg, severity, throwable, logStacktrace);
            }
        }
    }

    private final boolean shouldTriggerLoggerActions(EmbraceLogger.Severity severity) {
        return ApkToolsConfig.IS_DEVELOPER_LOGGING_ENABLED || severity.compareTo((Enum)this.threshold) >= 0;
    }

    public final void setThreshold(@NotNull EmbraceLogger.Severity severity) {
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        this.threshold = severity;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lio/embrace/android/embracesdk/logging/InternalEmbraceLogger$LoggerAction;", "", "log", "", "msg", "", "severity", "Lio/embrace/android/embracesdk/EmbraceLogger$Severity;", "throwable", "", "logStacktrace", "", "embrace-android-sdk_release"})
    public static interface LoggerAction {
        public void log(@NotNull String var1, @NotNull EmbraceLogger.Severity var2, @Nullable Throwable var3, boolean var4);
    }
}

